/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.util.ArrayList;
import org.drools.RuleBaseConfiguration;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.base.evaluators.Operator;
import org.drools.common.BetaConstraints;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.index.IndexUtil;
import org.drools.core.util.index.LeftTupleIndexHashTable;
import org.drools.core.util.index.LeftTupleList;
import org.drools.core.util.index.RightTupleIndexHashTable;
import org.drools.core.util.index.RightTupleList;
import org.drools.reteoo.BetaMemory;
import org.drools.rule.Declaration;
import org.drools.rule.IndexableConstraint;
import org.drools.rule.MvelConstraintTestUtil;
import org.drools.rule.Pattern;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.junit.Assert;

public abstract class BaseBetaConstraintsTest {
    public static EvaluatorRegistry registry = new EvaluatorRegistry();

    protected BetaNodeFieldConstraint getConstraint(String identifier, Operator operator, String fieldName, Class clazz) {
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        store.setEagerWire(true);
        ClassFieldReader extractor = store.getReader(clazz, fieldName, this.getClass().getClassLoader());
        Declaration declaration = new Declaration(identifier, (InternalReadAccessor)extractor, new Pattern(0, (ObjectType)new ClassObjectType(clazz)));
        String expression = fieldName + " " + operator.getOperatorString() + " " + identifier;
        return new MvelConstraintTestUtil(expression, operator.getOperatorString(), declaration, (InternalReadAccessor)extractor);
    }

    protected void checkBetaConstraints(BetaNodeFieldConstraint[] constraints, Class cls) {
        this.checkBetaConstraints(constraints, cls, (short)0);
    }

    protected void checkBetaConstraints(BetaNodeFieldConstraint[] constraints, Class cls, short betaNodeType) {
        BetaConstraints betaConstraints;
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        int depth = config.getCompositeKeyDepth();
        try {
            betaConstraints = (BetaConstraints)cls.getConstructor(BetaNodeFieldConstraint[].class, RuleBaseConfiguration.class).newInstance(constraints, config);
        }
        catch (Exception e) {
            throw new RuntimeException("could not invoke constructor for " + cls.getName());
        }
        betaConstraints.initIndexes(depth, betaNodeType);
        constraints = betaConstraints.getConstraints();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < constraints.length && list.size() < depth; ++i) {
            if (!((IndexableConstraint)constraints[i]).isIndexable(betaNodeType)) continue;
            list.add(i);
        }
        int[] indexedPositions = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            indexedPositions[i] = i;
        }
        Assert.assertEquals((Object)(indexedPositions.length > 0 ? 1 : 0), (Object)betaConstraints.isIndexed());
        Assert.assertEquals((long)indexedPositions.length, (long)betaConstraints.getIndexCount());
        BetaMemory betaMemory = betaConstraints.createBetaMemory(config, (short)0);
        if (indexedPositions.length > 0) {
            if (((IndexableConstraint)constraints[indexedPositions[0]]).getConstraintType() == IndexUtil.ConstraintType.EQUAL) {
                LeftTupleIndexHashTable tupleHashTable = (LeftTupleIndexHashTable)betaMemory.getLeftTupleMemory();
                Assert.assertTrue((boolean)tupleHashTable.isIndexed());
                AbstractHashTable.Index index = tupleHashTable.getIndex();
                for (int i = 0; i < indexedPositions.length; ++i) {
                    this.checkSameConstraintForIndex((IndexableConstraint)constraints[indexedPositions[i]], index.getFieldIndex(i));
                }
                RightTupleIndexHashTable factHashTable = (RightTupleIndexHashTable)betaMemory.getRightTupleMemory();
                Assert.assertTrue((boolean)factHashTable.isIndexed());
                index = factHashTable.getIndex();
                for (int i = 0; i < indexedPositions.length; ++i) {
                    this.checkSameConstraintForIndex((IndexableConstraint)constraints[indexedPositions[i]], index.getFieldIndex(i));
                }
            }
        } else {
            LeftTupleList tupleHashTable = (LeftTupleList)betaMemory.getLeftTupleMemory();
            Assert.assertFalse((boolean)tupleHashTable.isIndexed());
            RightTupleList factHashTable = (RightTupleList)betaMemory.getRightTupleMemory();
            Assert.assertFalse((boolean)factHashTable.isIndexed());
        }
    }

    protected void checkSameConstraintForIndex(IndexableConstraint constraint, AbstractHashTable.FieldIndex fieldIndex) {
        Assert.assertSame((Object)constraint.getRequiredDeclarations()[0], (Object)fieldIndex.getDeclaration());
        Assert.assertSame((Object)constraint.getFieldExtractor(), (Object)fieldIndex.getExtractor());
    }

    protected BetaNodeFieldConstraint[] convertToConstraints(LinkedList list) {
        BetaNodeFieldConstraint[] array = new BetaNodeFieldConstraint[list.size()];
        int i = 0;
        for (LinkedListEntry entry = (LinkedListEntry)list.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
            array[i++] = (BetaNodeFieldConstraint)entry.getObject();
        }
        return array;
    }
}

