/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.RuleBaseFactory;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.reteoo.ReteooWorkingMemory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LazyTMSEnablingTest {
    private ReteooWorkingMemory wm;
    private TruthMaintenanceSystem tms;

    @Before
    public void setUp() {
        this.wm = (ReteooWorkingMemory)RuleBaseFactory.newRuleBase().newStatefulSession();
        this.tms = this.wm.getTruthMaintenanceSystem();
    }

    @Test
    public void shouldLazilyAdd() throws Exception {
        String fact1 = "logical";
        this.wm.insert((Object)"logical");
        Assert.assertEquals((String)"Shouldn't have anything, since no logical insert was performed.", (long)0L, (long)this.tms.getAssertMap().size());
        String fact2 = "logical";
        this.wm.insertLogical((Object)"logical");
        Assert.assertEquals((String)"Now that a logical insert was done, it should have an element.", (long)1L, (long)this.tms.getAssertMap().size());
        ObjectTypeConf typeConf = this.wm.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.wm.getEntryPoint(), (Object)"logical");
        Assert.assertTrue((String)"Should have enabled TMS", (boolean)typeConf.isTMSEnabled());
    }

    @Test
    public void shouldEnableTMSForSpecificType() throws Exception {
        String stringFact1 = "toto";
        String stringFact2 = "toto";
        String anotherString = "tata";
        Integer intFact1 = 99;
        Integer intFact2 = 99;
        Double doubleFact = 77.8;
        ObjectTypeConf stringTypeConf = this.wm.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.wm.getEntryPoint(), (Object)"toto");
        ObjectTypeConf intTypeConf = this.wm.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.wm.getEntryPoint(), (Object)intFact1);
        this.wm.insert((Object)"toto");
        this.wm.insert((Object)"tata");
        this.wm.insert((Object)intFact1);
        this.wm.insert((Object)doubleFact);
        for (ObjectTypeConf conf : this.wm.getObjectTypeConfigurationRegistry().values()) {
            Assert.assertFalse((String)"TMS shouldn't be enabled for any type, since no logical insert was done.", (boolean)conf.isTMSEnabled());
        }
        this.wm.insertLogical((Object)"toto");
        Assert.assertTrue((String)"Should have enabled TMS for Strings.", (boolean)stringTypeConf.isTMSEnabled());
        Assert.assertFalse((String)"Shouldn't have enabled TMS for Integers.", (boolean)intTypeConf.isTMSEnabled());
        this.wm.insertLogical((Object)intFact2);
        Assert.assertTrue((String)"Now it should have enabled TMS for Integers!.", (boolean)intTypeConf.isTMSEnabled());
    }
}

