/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.DroolsTestCase;
import org.drools.FactException;
import org.drools.RuleBaseFactory;
import org.drools.common.BaseNode;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.definition.rule.Rule;
import org.drools.reteoo.EvalConditionNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockEvalCondition;
import org.drools.reteoo.MockLeftTupleSink;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.EvalCondition;
import org.drools.spi.PropagationContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class EvalConditionNodeTest
extends DroolsTestCase {
    private PropagationContext context;
    private ReteooWorkingMemory workingMemory;
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;

    @Before
    public void setUp() {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        this.context = new PropagationContextImpl(0L, 0, null, null, null);
        this.workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
    }

    @Test
    public void testAttach() throws Exception {
        MockTupleSource source = new MockTupleSource(12);
        EvalConditionNode node = new EvalConditionNode(18, (LeftTupleSource)source, (EvalCondition)new MockEvalCondition(true), this.buildContext);
        Assert.assertEquals((long)18L, (long)node.getId());
        Assert.assertEquals((long)0L, (long)source.getAttached());
        node.attach(this.buildContext);
        Assert.assertEquals((long)1L, (long)source.getAttached());
    }

    @Test
    public void testMemory() {
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase()));
        MockTupleSource source = new MockTupleSource(12);
        EvalConditionNode node = new EvalConditionNode(18, (LeftTupleSource)source, (EvalCondition)new MockEvalCondition(true), this.buildContext);
        EvalConditionNode.EvalMemory memory = (EvalConditionNode.EvalMemory)workingMemory.getNodeMemory((NodeMemory)node);
        Assert.assertNotNull((Object)memory);
    }

    @Test
    public void testAssertedAllowed() throws FactException {
        MockEvalCondition eval = new MockEvalCondition(true);
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheddar");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)sink.getAsserted().size());
    }

    @Test
    public void testAssertedAllowedThenRetract() throws FactException {
        MockEvalCondition eval = new MockEvalCondition(true);
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheddar");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)sink.getAsserted().size());
        node.retractLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)1L, (long)sink.getRetracted().size());
        node.retractLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)sink.getRetracted().size());
    }

    @Test
    public void testAssertedNotAllowed() throws FactException {
        MockEvalCondition eval = new MockEvalCondition(false);
        EvalConditionNode node = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)"cheddar");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (LeftTupleSink)sink, true);
        node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.workingMemory.getNodeMemory((NodeMemory)node);
        Assert.assertEquals((long)0L, (long)sink.getAsserted().size());
        Assert.assertEquals((long)0L, (long)sink.getRetracted().size());
    }

    @Test
    public void testDoRemove() throws FactException {
        MockEvalCondition eval = new MockEvalCondition(true);
        EvalConditionNode parent = new EvalConditionNode(1, (LeftTupleSource)new MockTupleSource(15), (EvalCondition)eval, this.buildContext);
        EvalConditionNode node = new EvalConditionNode(2, (LeftTupleSource)parent, (EvalCondition)eval, this.buildContext);
        parent.addTupleSink((LeftTupleSink)node);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        node.addTupleSink((LeftTupleSink)sink);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)"stilton");
        LeftTupleImpl parentTuple = new LeftTupleImpl((InternalFactHandle)f0, null, true);
        LeftTuple tuple0 = sink.createLeftTuple((LeftTuple)parentTuple, (LeftTupleSink)sink, true);
        node.assertLeftTuple(tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)1L, (long)sink.getAsserted().size());
        RuleRemovalContext removalContext = new RuleRemovalContext((Rule)Mockito.mock(Rule.class));
        InternalWorkingMemory[] workingMemories = new InternalWorkingMemory[]{this.workingMemory};
        node.remove(removalContext, this.ruleBase.getReteooBuilder(), (BaseNode)sink, workingMemories);
    }
}

