/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.Cheese;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.FieldFactory;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.RightTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.MvelConstraintTestUtil;
import org.drools.rule.Pattern;
import org.drools.rule.PredicateConstraint;
import org.drools.runtime.rule.FactHandle;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.drools.spi.PredicateExpression;
import org.drools.spi.Tuple;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FieldConstraintTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testLiteralConstraint() throws IntrospectionException {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("type == \"cheddar\"", FieldFactory.getInstance().getFieldValue((Object)"cheddar"), (InternalReadAccessor)extractor);
        ContextEntry context = constraint.createContextEntry();
        Cheese cheddar = new Cheese("cheddar", 5);
        InternalFactHandle cheddarHandle = (InternalFactHandle)workingMemory.insert((Object)cheddar);
        Assert.assertTrue((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        Cheese stilton = new Cheese("stilton", 5);
        InternalFactHandle stiltonHandle = (InternalFactHandle)workingMemory.insert((Object)stilton);
        Assert.assertFalse((boolean)constraint.isAllowed(stiltonHandle, workingMemory, context));
    }

    @Test
    public void testPrimitiveLiteralConstraint() throws IntrospectionException {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "price", this.getClass().getClassLoader());
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("price == 5", FieldFactory.getInstance().getFieldValue(5), (InternalReadAccessor)extractor);
        ContextEntry context = constraint.createContextEntry();
        Cheese cheddar = new Cheese("cheddar", 5);
        InternalFactHandle cheddarHandle = (InternalFactHandle)workingMemory.insert((Object)cheddar);
        Assert.assertTrue((boolean)constraint.isAllowed(cheddarHandle, workingMemory, context));
        Cheese stilton = new Cheese("stilton", 10);
        InternalFactHandle stiltonHandle = (InternalFactHandle)workingMemory.insert((Object)stilton);
        Assert.assertFalse((boolean)constraint.isAllowed(stiltonHandle, workingMemory, context));
    }

    @Test
    public void testPredicateConstraint() throws IntrospectionException {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        ClassFieldReader priceExtractor = this.store.getReader(Cheese.class, "price", this.getClass().getClassLoader());
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration price1Declaration = new Declaration("price1", (InternalReadAccessor)priceExtractor, pattern);
        pattern = new Pattern(1, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration price2Declaration = new Declaration("price2", (InternalReadAccessor)priceExtractor, pattern);
        PredicateExpression evaluator = new PredicateExpression(){
            private static final long serialVersionUID = 510L;

            public boolean evaluate(Object object, Tuple tuple, Declaration[] previousDeclarations, Declaration[] localDeclarations, WorkingMemory workingMemory, Object context) {
                int price1 = previousDeclarations[0].getIntValue((InternalWorkingMemory)workingMemory, workingMemory.getObject((FactHandle)tuple.get(previousDeclarations[0])));
                int price2 = localDeclarations[0].getIntValue((InternalWorkingMemory)workingMemory, object);
                return price2 == price1 * 2;
            }

            public Object createContext() {
                return null;
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        PredicateConstraint constraint1 = new PredicateConstraint(evaluator, new Declaration[]{price1Declaration}, new Declaration[]{price2Declaration}, new String[0], new String[0]);
        Cheese cheddar0 = new Cheese("cheddar", 5);
        InternalFactHandle f0 = (InternalFactHandle)workingMemory.insert((Object)cheddar0);
        LeftTupleImpl tuple = new LeftTupleImpl(f0, null, true);
        Cheese cheddar1 = new Cheese("cheddar", 10);
        InternalFactHandle f1 = (InternalFactHandle)workingMemory.insert((Object)cheddar1);
        tuple = new LeftTupleImpl((LeftTuple)tuple, new RightTuple(f1, null), null, true);
        PredicateConstraint.PredicateContextEntry context = (PredicateConstraint.PredicateContextEntry)constraint1.createContextEntry();
        context.updateFromTuple(workingMemory, (LeftTuple)tuple);
        Assert.assertTrue((boolean)constraint1.isAllowedCachedLeft((ContextEntry)context, f1));
    }
}

