/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.definition.type.FactField;
import org.drools.factmodel.BuildUtils;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.Trait;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitProxyClassBuilder;
import org.drools.factmodel.traits.TraitRegistry;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.WriteAccessor;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitMapProxyClassBuilderImpl
implements TraitProxyClassBuilder,
Serializable {
    private transient ClassDefinition trait;
    private transient Class<?> proxyBaseClass;

    protected ClassDefinition getTrait() {
        return this.trait;
    }

    @Override
    public void init(ClassDefinition trait, Class<?> baseClass) {
        this.trait = trait;
        this.proxyBaseClass = baseClass;
    }

    private boolean hasImpl(Trait annTrait) {
        return annTrait != null && !annTrait.impl().equals(Trait.NullMixin.class);
    }

    @Override
    public byte[] buildClass(ClassDefinition core) throws IOException, IntrospectionException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        ClassWriter cw = new ClassWriter(0);
        long mask = TraitRegistry.getInstance().getFieldMask(this.getTrait().getName(), core.getDefinedClass().getName());
        String name = TraitFactory.getPropertyWrapperName(this.getTrait(), core);
        String masterName = TraitFactory.getProxyName(this.getTrait(), core);
        String internalWrapper = BuildUtils.getInternalType(name);
        String internalProxy = BuildUtils.getInternalType(masterName);
        String descrCore = Type.getDescriptor(core.getDefinedClass());
        String internalCore = Type.getInternalName(core.getDefinedClass());
        String internalTrait = Type.getInternalName(this.getTrait().getDefinedClass());
        Class mixinClass = null;
        String mixin = null;
        HashSet<Method> mixinMethods = new HashSet<Method>();
        HashMap<String, Method> mixinGetSet = new HashMap<String, Method>();
        try {
            Trait annTrait;
            if (this.getTrait().getDefinedClass() != null && this.hasImpl(annTrait = this.getAnnotation(this.getTrait().getDefinedClass(), Trait.class))) {
                mixinClass = annTrait.impl();
                mixin = mixinClass.getSimpleName().substring(0, 1).toLowerCase() + mixinClass.getSimpleName().substring(1);
                ClassFieldInspector cfi = new ClassFieldInspector(mixinClass);
                for (Method m : mixinClass.getMethods()) {
                    try {
                        this.getTrait().getDefinedClass().getMethod(m.getName(), m.getParameterTypes());
                        if (cfi.getGetterMethods().containsValue(m) || cfi.getSetterMethods().containsValue(m)) {
                            mixinGetSet.put(m.getName(), m);
                            continue;
                        }
                        mixinMethods.add(m);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cw.visit(49, 33, internalProxy, null, Type.getInternalName(this.proxyBaseClass), new String[]{internalTrait, Type.getInternalName(Serializable.class)});
        FieldVisitor fv = cw.visitField(17, "object", descrCore, null, null);
        fv.visitEnd();
        fv = cw.visitField(17, "map", Type.getDescriptor(Map.class), "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        fv.visitEnd();
        if (mixinClass != null) {
            fv = cw.visitField(2, mixin, BuildUtils.getTypeDescriptor(mixinClass.getName()), null, null);
            fv.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(this.proxyBaseClass), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "<init>", "(" + descrCore + Type.getDescriptor(Map.class) + ")V", "(" + descrCore + "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(this.proxyBaseClass), "<init>", "()V");
        if (mixinClass != null) {
            try {
                Class actualArg = this.getPossibleConstructor(mixinClass, this.trait.getDefinedClass());
                mv.visitVarInsn(25, 0);
                mv.visitTypeInsn(187, Type.getInternalName((Class)mixinClass));
                mv.visitInsn(89);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, Type.getInternalName((Class)mixinClass), "<init>", "(" + Type.getDescriptor((Class)actualArg) + ")V");
                mv.visitFieldInsn(181, internalProxy, mixin, Type.getDescriptor((Class)mixinClass));
            }
            catch (NoSuchMethodException nsme) {
                mv.visitVarInsn(25, 0);
                mv.visitTypeInsn(187, Type.getInternalName((Class)mixinClass));
                mv.visitInsn(89);
                mv.visitMethodInsn(183, Type.getInternalName((Class)mixinClass), "<init>", "()V");
                mv.visitFieldInsn(181, internalProxy, mixin, Type.getDescriptor((Class)mixinClass));
            }
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, internalProxy, "object", descrCore);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, internalProxy, "map", Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, internalWrapper);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, internalWrapper, "<init>", "(" + descrCore + Type.getDescriptor(Map.class) + ")V");
        mv.visitFieldInsn(181, internalProxy, "fields", Type.getDescriptor(Map.class));
        mv.visitInsn(177);
        mv.visitMaxs(5, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getCore", "()" + descrCore + "", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "object", descrCore);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getObject", "()" + Type.getDescriptor(Object.class), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "object", descrCore);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "getCore", "()" + Type.getDescriptor(Object.class), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, internalProxy, "getCore", "()" + descrCore);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "writeExternal", "(" + Type.getDescriptor(ObjectOutput.class) + ")V", null, new String[]{Type.getInternalName(IOException.class)});
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, internalProxy, "getObject", "()" + Type.getDescriptor(Object.class));
        mv.visitMethodInsn(185, Type.getInternalName(ObjectOutput.class), "writeObject", "(" + Type.getDescriptor(Object.class) + ")V");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "map", Type.getDescriptor(Map.class));
        mv.visitMethodInsn(185, Type.getInternalName(ObjectOutput.class), "writeObject", "(" + Type.getDescriptor(Object.class) + ")V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName(this.proxyBaseClass), "writeExternal", "(" + Type.getDescriptor(ObjectOutput.class) + ")V");
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "readExternal", "(" + Type.getDescriptor(ObjectInput.class) + ")V", null, new String[]{Type.getInternalName(IOException.class), Type.getInternalName(ClassNotFoundException.class)});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(ObjectInput.class), "readObject", "()" + Type.getDescriptor(Object.class));
        mv.visitTypeInsn(192, internalCore);
        mv.visitFieldInsn(181, internalProxy, "object", descrCore);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(ObjectInput.class), "readObject", "()" + Type.getDescriptor(Object.class));
        mv.visitTypeInsn(192, Type.getInternalName(Map.class));
        mv.visitFieldInsn(181, internalProxy, "map", Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName(this.proxyBaseClass), "readExternal", "(" + Type.getDescriptor(ObjectInput.class) + ")V");
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        int j = 0;
        for (FieldDefinition field : this.trait.getFieldsDefinitions()) {
            boolean isSoftField = TraitRegistry.isSoftField(field, j++, mask);
            if (isSoftField) {
                if (mixinGetSet.containsKey(BuildUtils.getterName(field.getName(), field.getTypeName()))) continue;
                this.buildSoftGetter((ClassVisitor)cw, field.getName(), field.getTypeName(), masterName, core.getName());
                this.buildSoftSetter((ClassVisitor)cw, field.getName(), field.getTypeName(), masterName, core.getName());
                continue;
            }
            fv = cw.visitField(9, field.getName() + "_reader", Type.getDescriptor(InternalReadAccessor.class), null, null);
            fv.visitEnd();
            fv = cw.visitField(9, field.getName() + "_writer", Type.getDescriptor(WriteAccessor.class), null, null);
            fv.visitEnd();
            this.buildHardGetter((ClassVisitor)cw, field, masterName, this.trait, core);
            this.buildHardSetter((ClassVisitor)cw, field, masterName, this.trait, core);
        }
        boolean hasKeys = false;
        for (FactField ff : this.trait.getFields()) {
            if (!ff.isKey()) continue;
            hasKeys = true;
            break;
        }
        if (!hasKeys) {
            this.buildEqualityMethods((ClassVisitor)cw, masterName, core.getClassName());
        } else {
            this.buildKeyedEqualityMethods((ClassVisitor)cw, this.trait, masterName, core.getClassName());
        }
        if (mixinClass != null) {
            this.buildMixinMethods(cw, masterName, mixin, mixinClass, mixinMethods);
            this.buildMixinMethods(cw, masterName, mixin, mixinClass, mixinGetSet.values());
        }
        this.buildCommonMethods(cw, masterName, core.getClassName());
        cw.visitEnd();
        return cw.toByteArray();
    }

    private <K extends Annotation> K getAnnotation(Class klass, Class<K> annotationClass) {
        if (klass.equals(Thing.class)) {
            return null;
        }
        K ann = klass.getAnnotation(annotationClass);
        if (ann == null) {
            for (Class<?> sup : klass.getInterfaces()) {
                ann = this.getAnnotation(sup, annotationClass);
                if (ann == null) continue;
                return ann;
            }
            return null;
        }
        return ann;
    }

    private Class getPossibleConstructor(Class klass, Class arg) throws NoSuchMethodException {
        Constructor<?>[] ctors;
        for (Constructor<?> c : ctors = klass.getConstructors()) {
            Class<?>[] cpars = c.getParameterTypes();
            if (cpars.length != 1 || !cpars[0].isAssignableFrom(arg)) continue;
            return cpars[0];
        }
        throw new NoSuchMethodException("Constructor for " + klass + " using " + arg + " not found ");
    }

    private void buildMixinMethods(ClassWriter cw, String wrapperName, String mixin, Class mixinClass, Collection<Method> mixinMethods) {
        for (Method method : mixinMethods) {
            String signature = TraitFactory.buildSignature(method);
            MethodVisitor mv = cw.visitMethod(1, method.getName(), signature, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, BuildUtils.getInternalType(wrapperName), mixin, Type.getDescriptor((Class)mixinClass));
            int j = 1;
            for (Class<?> arg : method.getParameterTypes()) {
                mv.visitVarInsn(BuildUtils.varType(arg.getName()), j++);
            }
            mv.visitMethodInsn(182, Type.getInternalName((Class)mixinClass), method.getName(), signature);
            mv.visitInsn(BuildUtils.returnType(method.getReturnType().getName()));
            int stack = TraitFactory.getStackSize(method);
            mv.visitMaxs(stack, stack);
            mv.visitEnd();
        }
    }

    private void buildHardGetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition proxy, ClassDefinition core) {
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        String getter = BuildUtils.getterName(fieldName, field.getTypeName());
        MethodVisitor mv = cw.visitMethod(1, getter, "()" + Type.getDescriptor(field.getType()), null, null);
        mv.visitCode();
        TraitFactory.invokeExtractor(mv, masterName, proxy, core, field);
        if (!BuildUtils.isPrimitive(fieldType.getName())) {
            mv.visitTypeInsn(192, Type.getInternalName(fieldType));
        }
        mv.visitInsn(BuildUtils.returnType(field.getTypeName()));
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private void buildHardSetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition trait, ClassDefinition core) {
        String fieldName = field.getName();
        String fieldType = field.getTypeName();
        MethodVisitor mv = cw.visitMethod(1, BuildUtils.setterName(fieldName, fieldType), "(" + Type.getDescriptor(field.getType()) + ")V", null, null);
        mv.visitCode();
        TraitFactory.invokeInjector(mv, masterName, trait, core, field, false, 1);
        mv.visitInsn(177);
        mv.visitMaxs(2 + BuildUtils.sizeOf(fieldType), 1 + BuildUtils.sizeOf(fieldType));
        mv.visitEnd();
    }

    private void buildSoftSetter(ClassVisitor cw, String fieldName, String type, String proxy, String core) {
        String setter = BuildUtils.setterName(fieldName, type);
        MethodVisitor mv = cw.visitMethod(1, setter, "(" + BuildUtils.getTypeDescriptor(type) + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxy), "map", Type.getDescriptor(Map.class));
        mv.visitLdcInsn((Object)fieldName);
        mv.visitVarInsn(BuildUtils.varType(type), 1);
        if (BuildUtils.isPrimitive(type)) {
            TraitFactory.valueOf(mv, type);
        }
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "put", "(" + Type.getDescriptor(Object.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(2 + BuildUtils.sizeOf(type), 1 + BuildUtils.sizeOf(type));
        mv.visitEnd();
    }

    private void buildSoftGetter(ClassVisitor cw, String fieldName, String type, String proxy, String core) {
        String getter = BuildUtils.getterName(fieldName, type);
        MethodVisitor mv = cw.visitMethod(1, getter, "()" + BuildUtils.getTypeDescriptor(type), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxy), "map", Type.getDescriptor(Map.class));
        mv.visitLdcInsn((Object)fieldName);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "get", "(" + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Object.class));
        if (BuildUtils.isPrimitive(type)) {
            mv.visitVarInsn(58, 1);
            mv.visitVarInsn(25, 1);
            Label l0 = new Label();
            mv.visitJumpInsn(198, l0);
            mv.visitVarInsn(25, 1);
            Label l1 = new Label();
            mv.visitJumpInsn(167, l1);
            mv.visitLabel(l0);
            mv.visitInsn(BuildUtils.zero(type));
            TraitFactory.valueOf(mv, type);
            mv.visitLabel(l1);
            TraitFactory.promote(mv, type);
            mv.visitInsn(BuildUtils.returnType(type));
            mv.visitMaxs(2, 2);
        } else {
            mv.visitTypeInsn(192, BuildUtils.getInternalType(type));
            mv.visitInsn(176);
            mv.visitMaxs(2, 1);
        }
        mv.visitEnd();
    }

    public void buildKeyedEqualityMethods(ClassVisitor cw, ClassDefinition trait, String proxy, String core) {
        String proxyType = BuildUtils.getInternalType(proxy);
        this.buildKeyedEquals(cw, trait, proxyType);
        this.buildKeyedHashCode(cw, trait, proxyType);
    }

    public void buildEqualityMethods(ClassVisitor cw, String proxy, String core) {
        String proxyType = BuildUtils.getInternalType(proxy);
        String coreType = BuildUtils.getTypeDescriptor(core);
        MethodVisitor mv = cw.visitMethod(1, "equals", "(" + Type.getDescriptor(Object.class) + ")Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(166, l0);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(199, l1);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", "()" + Type.getDescriptor(Class.class));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", "()" + Type.getDescriptor(Class.class));
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
        Label l2 = new Label();
        mv.visitJumpInsn(154, l2);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, Type.getInternalName(this.proxyBaseClass));
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, proxyType, "getFields", "()" + Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, Type.getInternalName(this.proxyBaseClass), "getFields", "()" + Type.getDescriptor(Map.class));
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
        mv.visitInsn(172);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyType, "object", coreType);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "hashCode", "()I");
        mv.visitVarInsn(54, 1);
        mv.visitIntInsn(16, 31);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(104);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, proxyType, "map", Type.getDescriptor(Map.class));
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "hashCode", "()I");
        mv.visitInsn(96);
        mv.visitVarInsn(54, 1);
        mv.visitLdcInsn((Object)proxy);
        mv.visitMethodInsn(182, Type.getInternalName(String.class), "hashCode", "()I");
        mv.visitVarInsn(21, 1);
        mv.visitInsn(104);
        mv.visitVarInsn(54, 1);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private void buildCommonMethods(ClassWriter cw, String proxy, String core) {
        String proxyType = BuildUtils.getInternalType(proxy);
        MethodVisitor mv = cw.visitMethod(1, "toString", "()" + Type.getDescriptor(String.class), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", "()V");
        mv.visitLdcInsn((Object)("(@" + proxy + ") : "));
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(StringBuilder.class));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, proxyType, "getFields", "()" + Type.getDescriptor(Map.class));
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "entrySet", "()" + Type.getDescriptor(Set.class));
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "toString", "()" + Type.getDescriptor(String.class));
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(StringBuilder.class));
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "toString", "()" + Type.getDescriptor(String.class));
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    protected void buildKeyedEquals(ClassVisitor cw, ClassDefinition classDef, String proxyType) {
        MethodVisitor mv = cw.visitMethod(1, "equals", "(" + Type.getDescriptor(Object.class) + ")Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(166, l0);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(198, l1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", "()" + Type.getDescriptor(Class.class));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", "()" + Type.getDescriptor(Class.class));
        Label l2 = new Label();
        mv.visitJumpInsn(165, l2);
        mv.visitLabel(l1);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, proxyType);
        mv.visitVarInsn(58, 2);
        int x = 2;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            if (!BuildUtils.isPrimitive(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                Label l11 = new Label();
                mv.visitJumpInsn(198, l11);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitMethodInsn(182, BuildUtils.getInternalType(field.getTypeName()), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
                Label l12 = new Label();
                mv.visitJumpInsn(154, l12);
                Label l13 = new Label();
                mv.visitJumpInsn(167, l13);
                mv.visitLabel(l11);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitJumpInsn(198, l12);
                mv.visitLabel(l13);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l12);
                continue;
            }
            if ("double".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "compare", "(DD)I");
                Label l5 = new Label();
                mv.visitJumpInsn(153, l5);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l5);
                x = Math.max(x, 4);
                continue;
            }
            if ("float".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitMethodInsn(184, Type.getInternalName(Float.class), "compare", "(FF)I");
                Label l6 = new Label();
                mv.visitJumpInsn(153, l6);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l6);
                continue;
            }
            if ("long".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitInsn(148);
                Label l8 = new Label();
                mv.visitJumpInsn(153, l8);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l8);
                x = Math.max(x, 4);
                continue;
            }
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
            Label l4 = new Label();
            mv.visitJumpInsn(159, l4);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(l4);
        }
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitMaxs(x, 3);
        mv.visitEnd();
    }

    protected void buildKeyedHashCode(ClassVisitor cw, ClassDefinition classDef, String proxyType) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitIntInsn(16, 31);
        mv.visitVarInsn(54, 1);
        int count = 0;
        int x = 2;
        int y = 2;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            ++count;
            if (!BuildUtils.isPrimitive(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                Label l8 = new Label();
                mv.visitJumpInsn(198, l8);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitMethodInsn(182, BuildUtils.getInternalType(field.getTypeName()), "hashCode", "()I");
                Label l9 = new Label();
                mv.visitJumpInsn(167, l9);
                mv.visitLabel(l8);
                mv.visitInsn(3);
                mv.visitLabel(l9);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                continue;
            }
            if ("double".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitInsn(14);
                mv.visitInsn(151);
                Label l2 = new Label();
                mv.visitJumpInsn(153, l2);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "doubleToLongBits", "(D)J");
                Label l3 = new Label();
                mv.visitJumpInsn(167, l3);
                mv.visitLabel(l2);
                mv.visitInsn(9);
                mv.visitLabel(l3);
                mv.visitVarInsn(55, 2);
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(22, 2);
                mv.visitVarInsn(22, 2);
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                x = Math.max(6, x);
                y = Math.max(4, y);
                continue;
            }
            if ("boolean".equals(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                Label l4 = new Label();
                mv.visitJumpInsn(153, l4);
                mv.visitInsn(4);
                Label l5 = new Label();
                mv.visitJumpInsn(167, l5);
                mv.visitLabel(l4);
                mv.visitInsn(3);
                mv.visitLabel(l5);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                continue;
            }
            if ("float".equals(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitInsn(11);
                mv.visitInsn(149);
                Label l6 = new Label();
                mv.visitJumpInsn(153, l6);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitMethodInsn(184, Type.getInternalName(Float.class), "floatToIntBits", "(F)I");
                Label l7 = new Label();
                mv.visitJumpInsn(167, l7);
                mv.visitLabel(l6);
                mv.visitInsn(3);
                mv.visitLabel(l7);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                x = Math.max(3, x);
                continue;
            }
            if ("long".equals(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                x = Math.max(6, x);
                continue;
            }
            mv.visitIntInsn(16, 31);
            mv.visitVarInsn(21, 1);
            mv.visitInsn(104);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + Type.getDescriptor(field.getType()));
            mv.visitInsn(96);
            mv.visitVarInsn(54, 1);
        }
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        mv.visitMaxs(x, y);
        mv.visitEnd();
    }
}

