/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.drools.reteoo.test.JUnitNodeTestRunner;
import org.drools.reteoo.test.NodeTestCasesSource;
import org.drools.reteoo.test.ReteDslTestEngine;
import org.drools.reteoo.test.dsl.NodeTestCase;
import org.drools.reteoo.test.dsl.NodeTestDef;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=JUnitNodeTestRunner.class)
public class SingleTestCase
implements NodeTestCasesSource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeTestCase> getTestCases() throws Exception {
        String testName = System.getProperty("nodeTestName");
        if (testName == null || testName.trim().length() == 0) {
            throw new IllegalArgumentException("No test defined. Please set the system property 'nodeTestName' with the appropriate test name.");
        }
        NodeTestCase result = new NodeTestCase();
        File base = new File(this.getClass().getResource(".").toURI());
        for (File file : base.listFiles(new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".nodeTestCase");
            }
        })) {
            InputStream is = null;
            try {
                is = new FileInputStream(file);
                NodeTestCase tcase = ReteDslTestEngine.compile(is);
                if (tcase.hasErrors()) {
                    throw new IllegalArgumentException("Error parsing and loading testcase: " + file.getAbsolutePath() + "\n" + tcase.getErrors().toString());
                }
                for (NodeTestDef test : tcase.getTests()) {
                    if (!test.getName().equals(testName)) continue;
                    result.setFileName(file.getName());
                    result.setName(tcase.getName());
                    result.setImports(tcase.getImports());
                    result.setSetup(tcase.getSetup());
                    result.addTest(test);
                    result.setTearDown(tcase.getTearDown());
                    List<NodeTestCase> list = Collections.singletonList(result);
                    return list;
                }
            }
            finally {
                is.close();
            }
        }
        return Collections.singletonList(result);
    }
}

