/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.RuleBaseConfiguration;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.Memory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashMap;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.WindowTupleList;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.rule.BehaviorManager;
import org.drools.rule.ContextEntry;
import org.drools.rule.EntryPoint;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowNode
extends ObjectSource
implements ObjectSinkNode,
NodeMemory {
    private static final long serialVersionUID = 540L;
    private List<AlphaNodeFieldConstraint> constraints;
    private BehaviorManager behavior;
    private EntryPoint entryPoint;
    private ObjectSinkNode previousRightTupleSinkNode;
    private ObjectSinkNode nextRightTupleSinkNode;

    public WindowNode() {
    }

    public WindowNode(int id, List<AlphaNodeFieldConstraint> constraints, List<Behavior> behaviors, ObjectSource objectSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.constraints = new ArrayList<AlphaNodeFieldConstraint>(constraints);
        this.behavior = new BehaviorManager(behaviors);
        this.entryPoint = context.getCurrentEntryPoint();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.constraints = (List)in.readObject();
        this.behavior = (BehaviorManager)in.readObject();
        this.entryPoint = (EntryPoint)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.constraints);
        out.writeObject(this.behavior);
        out.writeObject(this.entryPoint);
    }

    public List<AlphaNodeFieldConstraint> getConstraints() {
        return this.constraints;
    }

    public Behavior[] getBehaviors() {
        return this.behavior.getBehaviors();
    }

    @Override
    public void attach(BuildContext context) {
        this.source.addObjectSink(this);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.source.updateSink(this, propagationContext, workingMemory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        WindowMemory memory = (WindowMemory)workingMemory.getNodeMemory(this);
        memory.gate.lock();
        try {
            int index = 0;
            for (AlphaNodeFieldConstraint constraint : this.constraints) {
                if (constraint.isAllowed(factHandle, workingMemory, memory.context[index++])) continue;
                return;
            }
            if (!this.behavior.assertFact(memory, factHandle, workingMemory)) {
                return;
            }
            WindowTupleList list = new WindowTupleList((EventFactHandle)factHandle, this);
            context.setActiveWindowTupleList(list);
            memory.events.put(factHandle, list);
            this.sink.propagateAssertObject(factHandle, context, workingMemory);
        }
        finally {
            memory.gate.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        WindowMemory memory = (WindowMemory)workingMemory.getNodeMemory(this);
        memory.gate.lock();
        try {
            int index = 0;
            boolean isAllowed = true;
            for (AlphaNodeFieldConstraint constraint : this.constraints) {
                if (constraint.isAllowed(factHandle, workingMemory, memory.context[index++])) continue;
                isAllowed = false;
                break;
            }
            WindowTupleList list = (WindowTupleList)memory.events.get(factHandle);
            if (isAllowed) {
                if (list != null) {
                    context.setActiveWindowTupleList(list);
                    this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
                    context.setActiveWindowTupleList(null);
                } else {
                    list = new WindowTupleList((EventFactHandle)factHandle, this);
                    context.setActiveWindowTupleList(list);
                    memory.events.put(factHandle, list);
                    this.sink.propagateAssertObject(factHandle, context, workingMemory);
                    context.setActiveWindowTupleList(null);
                }
            } else {
                memory.events.remove(factHandle);
            }
        }
        finally {
            memory.gate.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retractObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        WindowMemory memory = (WindowMemory)workingMemory.getNodeMemory(this);
        memory.gate.lock();
        try {
            this.behavior.retractFact(memory, factHandle, workingMemory);
            memory.events.remove(factHandle);
        }
        finally {
            memory.gate.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        WindowMemory memory = (WindowMemory)workingMemory.getNodeMemory(this);
        memory.gate.lock();
        try {
            this.sink.byPassModifyToBetaNode(factHandle, modifyPreviousTuples, context, workingMemory);
        }
        finally {
            memory.gate.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        WindowMemory memory = (WindowMemory)workingMemory.getNodeMemory(this);
        memory.gate.lock();
        try {
            Iterator it = memory.events.iterator();
            try {
                ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
                while (entry != null) {
                    sink.assertObject((InternalFactHandle)entry.getValue(), context, workingMemory);
                    entry = (ObjectHashMap.ObjectEntry)it.next();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            memory.gate.unlock();
        }
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config) {
        WindowMemory memory = new WindowMemory();
        memory.context = new ContextEntry[this.constraints.size()];
        int index = 0;
        for (AlphaNodeFieldConstraint alpha : this.constraints) {
            memory.context[index++] = alpha.createContextEntry();
        }
        memory.behaviorContext = this.behavior.createBehaviorContext();
        memory.gate = new ReentrantLock();
        return memory;
    }

    @Override
    public String toString() {
        return "[WindowNode(" + this.id + ") constraints=" + this.constraints + "]";
    }

    @Override
    public int hashCode() {
        return this.source.hashCode() * 17 + (this.constraints != null ? ((Object)this.constraints).hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof WindowNode)) {
            return false;
        }
        WindowNode other = (WindowNode)object;
        return this.source.equals(other.source) && ((Object)this.constraints).equals(other.constraints) && this.behavior.equals(other.behavior);
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextRightTupleSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextRightTupleSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousRightTupleSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousRightTupleSinkNode = previous;
    }

    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public long calculateDeclaredMask(List<String> settableProperties) {
        throw new UnsupportedOperationException();
    }

    public static class WindowMemory
    implements Externalizable,
    Memory {
        private static final long serialVersionUID = 540L;
        public ObjectHashMap events = new ObjectHashMap();
        public ContextEntry[] context;
        public Object behaviorContext;
        public transient ReentrantLock gate;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = (ContextEntry[])in.readObject();
            this.behaviorContext = in.readObject();
            this.events = (ObjectHashMap)in.readObject();
            this.gate = new ReentrantLock();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
            out.writeObject(this.behaviorContext);
            out.writeObject(this.events);
        }

        public short getNodeType() {
            return 13;
        }
    }
}

