/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.drools.RuntimeDroolsException;
import org.drools.reteoo.test.NodeTestCasesSource;
import org.drools.reteoo.test.ReteDslTestEngine;
import org.drools.reteoo.test.dsl.NodeTestCase;
import org.drools.reteoo.test.dsl.NodeTestDef;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitNodeTestRunner
extends Runner {
    private Description descr;
    private List<NodeTestCase> testCases = new ArrayList<NodeTestCase>();

    public JUnitNodeTestRunner(Class<?> clazz) {
        try {
            NodeTestCasesSource ntsuite = (NodeTestCasesSource)clazz.newInstance();
            this.testCases = ntsuite.getTestCases();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeDroolsException("Error instantiating node test runner: " + e, (Throwable)e);
        }
        this.descr = Description.createSuiteDescription((String)"Node test case suite", (Annotation[])new Annotation[0]);
        for (NodeTestCase tcase : this.testCases) {
            Description tcaseDescr = Description.createSuiteDescription((String)(tcase.getFileName() != null ? tcase.getFileName() : tcase.getName()), (Annotation[])new Annotation[0]);
            tcase.setDescription(tcaseDescr);
            this.descr.addChild(tcaseDescr);
            for (NodeTestDef ntest : tcase.getTests()) {
                Description ntestDescr = Description.createTestDescription(clazz, (String)ntest.getName());
                tcaseDescr.addChild(ntestDescr);
                ntest.setDescription(ntestDescr);
            }
        }
    }

    public Description getDescription() {
        return this.descr;
    }

    public void run(RunNotifier notifier) {
        ReteDslTestEngine tester = new ReteDslTestEngine();
        for (NodeTestCase tcase : this.testCases) {
            tester.run(tcase, notifier);
        }
    }
}

