/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test.dsl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.test.dsl.DSLMock;
import org.drools.reteoo.test.dsl.DslStep;
import org.drools.reteoo.test.dsl.ReteTesterHelper;
import org.drools.reteoo.test.dsl.Step;
import org.drools.spi.PropagationContext;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.matchers.JUnitMatchers;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.verification.VerificationMode;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSinkStep
implements Step {
    public ObjectSinkStep(ReteTesterHelper reteTesterHelper) {
    }

    @Override
    public void execute(Map<String, Object> context, List<String[]> args) {
        if (args.size() == 0) {
            throw new IllegalArgumentException("Cannot parse arguments " + args);
        }
        String[] a = args.get(0);
        String name = a[0].trim();
        String leftInput = a[1].trim();
        ObjectSource objectSource = (ObjectSource)context.get(leftInput);
        ObjectSink mockedSink = (ObjectSink)Mockito.mock(ObjectSink.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{DSLMock.class}));
        objectSource.addObjectSink(mockedSink);
        context.put(name, mockedSink);
    }

    public void process(DslStep step, ObjectSink node, Map<String, Object> context, InternalWorkingMemory wm) {
        try {
            List<String[]> cmds = step.getCommands();
            for (Object[] objectArray : cmds) {
                if (objectArray[0].equals("verify")) {
                    if ("count".equals(objectArray[2])) {
                        this.verifyCount(step, node, wm, (String[])objectArray, context);
                        continue;
                    }
                    if ("exec".equals(objectArray[2])) {
                        this.verifyExec(step, node, wm, (String[])objectArray, context);
                        continue;
                    }
                    if (objectArray.length == 3 || objectArray.length == 4) {
                        this.verifyExpression(step, node, wm, (String[])objectArray, context);
                        continue;
                    }
                    throw new IllegalArgumentException("line " + step.getLine() + ": command '" + (String)objectArray[2] + "' does not exist in " + Arrays.toString(objectArray));
                }
                throw new IllegalArgumentException("line " + step.getLine() + ": command does not exist " + Arrays.toString(objectArray));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("line " + step.getLine() + ": unable to execute step " + step, e);
        }
    }

    private void verifyCount(DslStep step, ObjectSink node, InternalWorkingMemory wm, String[] cmd, Map<String, Object> context) throws AssertionError {
        int times = Integer.valueOf(cmd[3]);
        VerificationMode counter = times >= 0 ? Mockito.times((int)times) : Mockito.atLeastOnce();
        try {
            ArgumentCaptor captor = ArgumentCaptor.forClass(InternalFactHandle.class);
            if ("assert".equals(cmd[1])) {
                ((ObjectSink)Mockito.verify((Object)node, (VerificationMode)counter)).assertObject((InternalFactHandle)captor.capture(), (PropagationContext)Matchers.any(PropagationContext.class), (InternalWorkingMemory)Matchers.same((Object)wm));
            } else if ("modify".equals(cmd[1])) {
                ((ObjectSink)Mockito.verify((Object)node, (VerificationMode)counter)).modifyObject((InternalFactHandle)captor.capture(), (ModifyPreviousTuples)Matchers.any(ModifyPreviousTuples.class), (PropagationContext)Matchers.any(PropagationContext.class), (InternalWorkingMemory)Matchers.same((Object)wm));
            } else {
                throw new IllegalArgumentException("line " + step.getLine() + ": command does not exist " + Arrays.toString(cmd));
            }
            String key = this.getCaptorKey(node, cmd);
            context.put(key, captor);
        }
        catch (MockitoAssertionError e) {
            AssertionError ae = new AssertionError((Object)("line " + step.getLine() + ": verify failed: " + e.getMessage()));
            ((Throwable)((Object)ae)).setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    private String getCaptorKey(ObjectSink node, String[] cmd) {
        return System.identityHashCode(node) + "." + cmd[1] + ".captor";
    }

    private void verifyExpression(DslStep step, ObjectSink node, InternalWorkingMemory wm, String[] cmd, Map<String, Object> context) throws AssertionError {
        String expression;
        String key = this.getCaptorKey(node, cmd);
        ArgumentCaptor captor = (ArgumentCaptor)context.get(key);
        if (captor == null) {
            this.verifyCount(step, node, wm, new String[]{"verify", cmd[1], "count", "-1"}, context);
            captor = (ArgumentCaptor)context.get(key);
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        int i = 0;
        for (InternalFactHandle handle : captor.getAllValues()) {
            vars.put("handle" + i++, handle);
        }
        vars.putAll(context);
        ParserConfiguration pconf = new ParserConfiguration();
        this.addStaticImports(pconf, CoreMatchers.class);
        this.addStaticImports(pconf, JUnitMatchers.class);
        pconf.addImport("Assert", Assert.class);
        ParserContext mvelctx = new ParserContext(pconf);
        if (cmd.length == 3) {
            expression = "Assert.assertTrue( " + cmd[2].replaceAll("h(\\d+)", "Handles[$1]") + " );";
        } else {
            String val = cmd[2].replaceAll("h(\\d+)", "Handles[$1]");
            String matcher = cmd[3].replaceAll("h(\\d+)", "Handles[$1]");
            expression = "Assert.assertThat( " + val + ", " + matcher + " );";
        }
        try {
            Serializable compiled = MVEL.compileExpression((String)expression, (ParserContext)mvelctx);
            MVEL.executeExpression((Object)compiled, vars);
        }
        catch (PropertyAccessException e) {
            String message = e.getCause() instanceof InvocationTargetException ? ((InvocationTargetException)e.getCause()).getTargetException().toString() : e.getMessage();
            Assert.fail((String)("[ERROR] line " + step.getLine() + " - Executing expression: '" + expression + "'\n" + message));
        }
    }

    private void verifyExec(DslStep step, ObjectSink node, InternalWorkingMemory wm, String[] cmd, Map<String, Object> context) throws AssertionError {
        String key = this.getCaptorKey(node, cmd);
        ArgumentCaptor captor = (ArgumentCaptor)context.get(key);
        if (captor == null) {
            this.verifyCount(step, node, wm, new String[]{"verify", cmd[1], "count", "-1"}, context);
            captor = (ArgumentCaptor)context.get(key);
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        int i = 0;
        for (InternalFactHandle handle : captor.getAllValues()) {
            vars.put("handle" + i++, handle);
        }
        vars.putAll(context);
        ParserConfiguration pconf = new ParserConfiguration();
        this.addStaticImports(pconf, CoreMatchers.class);
        this.addStaticImports(pconf, JUnitMatchers.class);
        pconf.addImport("Assert", Assert.class);
        ParserContext mvelctx = new ParserContext(pconf);
        String expression = cmd[3].replaceAll("h(\\d+)", "Handles[$1]");
        try {
            Serializable compiled = MVEL.compileExpression((String)expression, (ParserContext)mvelctx);
            MVEL.executeExpression((Object)compiled, vars);
        }
        catch (PropertyAccessException e) {
            String message = e.getCause() instanceof InvocationTargetException ? ((InvocationTargetException)e.getCause()).getTargetException().toString() : e.getMessage();
            Assert.fail((String)("[ERROR] line " + step.getLine() + " - Executing expression: '" + expression + "'\n" + message));
        }
    }

    private void addStaticImports(ParserConfiguration pconf, Class<?> clazz) {
        for (Method m : clazz.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers())) continue;
            pconf.addImport(m.getName(), m);
        }
    }
}

