/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.index.LeftTupleIndexHashTable;
import org.drools.core.util.index.LeftTupleList;
import org.drools.core.util.index.RightTupleIndexHashTable;
import org.drools.core.util.index.RightTupleList;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.RightTuple;
import org.junit.Assert;
import org.junit.Test;

public class IndexedHashtableIteratorTest {
    @Test
    public void testCanReachAllEntriesInLastTableRowRightTupleIndexHashTable() {
        RightTuple rightTuple;
        int i;
        RightTupleList rtList;
        int numEntries = 3;
        RightTupleList[] table = new RightTupleList[3];
        table[0] = rtList = new RightTupleList();
        for (i = 0; i < numEntries; ++i) {
            rightTuple = new RightTuple();
            rightTuple.setMemory(rtList);
            rtList.add(rightTuple);
        }
        table[2] = rtList = new RightTupleList();
        for (i = 0; i < numEntries; ++i) {
            rightTuple = new RightTuple();
            rightTuple.setMemory(rtList);
            rtList.add(rightTuple);
        }
        rtList = new RightTupleList();
        table[2].setNext((Entry)rtList);
        for (i = 0; i < numEntries; ++i) {
            rightTuple = new RightTuple();
            rightTuple.setMemory(rtList);
            rtList.add(rightTuple);
        }
        RightTupleIndexHashTable.FullFastIterator iter = new RightTupleIndexHashTable.FullFastIterator((Entry[])table);
        ArrayList<RightTuple> list = new ArrayList<RightTuple>();
        RightTuple rightTuple2 = (RightTuple)iter.next(null);
        while (rightTuple2 != null) {
            Assert.assertFalse((boolean)IndexedHashtableIteratorTest.contains(list, rightTuple2));
            list.add(rightTuple2);
            rightTuple2 = (RightTuple)iter.next((Entry)rightTuple2);
        }
        RightTupleIndexHashTable rthTable = new RightTupleIndexHashTable();
        rthTable.init((Entry[])table, 3, numEntries * 3);
        RightTupleIndexHashTable.FieldIndexHashTableFullIterator iter2 = new RightTupleIndexHashTable.FieldIndexHashTableFullIterator((AbstractHashTable)rthTable);
        list = new ArrayList();
        RightTuple rightTuple3 = (RightTuple)iter2.next();
        while (rightTuple3 != null) {
            Assert.assertFalse((boolean)IndexedHashtableIteratorTest.contains(list, rightTuple3));
            list.add(rightTuple3);
            rightTuple3 = (RightTuple)iter2.next();
        }
        Assert.assertEquals((long)(numEntries * 3), (long)list.size());
    }

    @Test
    public void testCanReachAllEntriesInLastTableRowLeftTupleIndexHashTable() {
        LeftTupleImpl leftTuple;
        int i;
        LeftTupleList rtList;
        int numEntries = 3;
        LeftTupleList[] table = new LeftTupleList[3];
        table[0] = rtList = new LeftTupleList();
        for (i = 0; i < numEntries; ++i) {
            leftTuple = new LeftTupleImpl();
            leftTuple.setMemory(rtList);
            rtList.add((LeftTuple)leftTuple);
        }
        table[2] = rtList = new LeftTupleList();
        for (i = 0; i < numEntries; ++i) {
            leftTuple = new LeftTupleImpl();
            leftTuple.setMemory(rtList);
            rtList.add((LeftTuple)leftTuple);
        }
        rtList = new LeftTupleList();
        table[2].setNext((Entry)rtList);
        for (i = 0; i < numEntries; ++i) {
            leftTuple = new LeftTupleImpl();
            leftTuple.setMemory(rtList);
            rtList.add((LeftTuple)leftTuple);
        }
        LeftTupleIndexHashTable.FullFastIterator iter = new LeftTupleIndexHashTable.FullFastIterator((Entry[])table);
        ArrayList<LeftTupleImpl> list = new ArrayList<LeftTupleImpl>();
        LeftTupleImpl leftTuple2 = (LeftTupleImpl)iter.next(null);
        while (leftTuple2 != null) {
            Assert.assertFalse((boolean)IndexedHashtableIteratorTest.contains(list, leftTuple2));
            list.add(leftTuple2);
            leftTuple2 = (LeftTupleImpl)iter.next((Entry)leftTuple2);
        }
        Assert.assertEquals((long)(numEntries * 3), (long)list.size());
        LeftTupleIndexHashTable lthTable = new LeftTupleIndexHashTable();
        lthTable.init((Entry[])table, 3, numEntries * 3);
        LeftTupleIndexHashTable.FieldIndexHashTableFullIterator iter2 = new LeftTupleIndexHashTable.FieldIndexHashTableFullIterator((AbstractHashTable)lthTable);
        list = new ArrayList();
        LeftTupleImpl leftTuple3 = (LeftTupleImpl)iter2.next();
        while (leftTuple3 != null) {
            Assert.assertFalse((boolean)IndexedHashtableIteratorTest.contains(list, leftTuple3));
            list.add(leftTuple3);
            leftTuple3 = (LeftTupleImpl)iter2.next();
        }
        Assert.assertEquals((long)(numEntries * 3), (long)list.size());
    }

    public static boolean contains(List list, Object object) {
        for (Object o : list) {
            if (o != object) continue;
            return true;
        }
        return false;
    }
}

