/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Collection;
import org.drools.KnowledgeBase;
import org.drools.RuleBase;
import org.drools.common.BaseNode;
import org.drools.impl.InternalKnowledgeBase;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.Sink;
import org.drools.runtime.KnowledgeRuntime;

public class ReteDumper {
    private ReteDumper() {
    }

    public static void dumpRete(KnowledgeBase kbase) {
        ReteDumper.dumpRete(((InternalKnowledgeBase)kbase).getRuleBase());
    }

    public static void dumpRete(KnowledgeRuntime session) {
        ReteDumper.dumpRete(((KnowledgeBaseImpl)session.getKnowledgeBase()).getRuleBase());
    }

    public static void dumpRete(RuleBase ruleBase) {
        ReteDumper.dumpRete(((ReteooRuleBase)ruleBase).getRete());
    }

    public static void dumpRete(Rete rete) {
        for (EntryPointNode entryPointNode : rete.getEntryPointNodes().values()) {
            ReteDumper.dumpNode((BaseNode)entryPointNode, "");
        }
    }

    private static void dumpNode(BaseNode node, String ident) {
        EntryPointNode source;
        System.out.println(ident + node);
        ObjectSink[] sinks = null;
        if (node instanceof EntryPointNode) {
            source = (EntryPointNode)node;
            Collection otns = source.getObjectTypeNodes().values();
            sinks = otns.toArray(new Sink[otns.size()]);
        } else if (node instanceof ObjectSource) {
            source = (ObjectSource)node;
            sinks = source.getSinkPropagator().getSinks();
        } else if (node instanceof LeftTupleSource) {
            source = (LeftTupleSource)node;
            sinks = source.getSinkPropagator().getSinks();
        }
        if (sinks != null) {
            for (ObjectSink sink : sinks) {
                if (!(sink instanceof BaseNode)) continue;
                ReteDumper.dumpNode((BaseNode)sink, ident + "    ");
            }
        }
    }
}

