/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import org.drools.WorkingMemory;
import org.drools.common.DefaultAgenda;
import org.drools.factmodel.traits.Trait;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.factmodel.traits.TraitType;
import org.drools.factmodel.traits.Traitable;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.factmodel.traits.TypeHierarchy;
import org.drools.factmodel.traits.TypeWrapper;
import org.drools.rule.Package;
import org.drools.rule.TypeDeclaration;
import org.drools.spi.KnowledgeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitField
implements Serializable,
Externalizable {
    private Object value;
    private boolean isExplicitlySet = false;
    private boolean explicitSetEnabled = true;
    private PriorityQueue<TypeWrapper> rangeTypes;
    private TypeHierarchy<Object> defaultValuesByTraits;
    private Object defaultValueByClass;
    private short position;

    public TraitField() {
    }

    public TraitField(TypeWrapper klass, Object value, Object defaultValue, short pos) {
        this.rangeTypes = new PriorityQueue<TypeWrapper>(1, TypeComparator.instance());
        this.rangeTypes.offer(klass);
        this.defaultValueByClass = defaultValue;
        this.isExplicitlySet = value != null && !value.equals(TraitField.zero(klass.getKlass()));
        this.value = value;
        this.position = pos;
    }

    public Object set(Object value, TypeWrapper klass, WorkingMemory wm) {
        Class base = this.rangeTypes.peek().getKlass();
        if (klass.getKlass() == null) {
            this.value = value;
            return value;
        }
        if (value != null) {
            if (base.isAssignableFrom(klass.getKlass())) {
                this.value = value;
                this.isExplicitlySet |= this.explicitSetEnabled;
            } else if (value instanceof TraitProxy) {
                this.set(((TraitProxy)value).getObject(), klass, wm);
            } else if (value instanceof TraitableBean) {
                this.set(((TraitableBean)value).getTrait(klass.getName()), klass, wm);
            }
        }
        if (value == null) {
            this.value = this.getDefault();
            this.isExplicitlySet = false;
        }
        if (!this.explicitSetEnabled) {
            this.enableExplicitSet();
        }
        this.ensureTypes(base, wm);
        return this.value;
    }

    private void ensureTypes(Class<?> base, WorkingMemory wm) {
        if (this.value != null) {
            Iterator<TypeWrapper> typeIterator = this.rangeTypes.iterator();
            while (typeIterator.hasNext()) {
                boolean hasType;
                Class range = typeIterator.next().getKlass();
                if (range == base || (hasType = this.ensureType(this.value, range, wm))) continue;
                this.manageInconsistentValue(range);
            }
        }
    }

    public Object get() {
        return this.value;
    }

    public Object get(TypeWrapper klass) {
        if (this.value == null) {
            return null;
        }
        if (klass.getKlass() != null && klass.getKlass().isInstance(this.value)) {
            return this.value;
        }
        if (this.value instanceof TraitableBean) {
            return ((TraitableBean)this.value).getTrait(klass.getName());
        }
        if (this.value instanceof TraitProxy) {
            return ((TraitProxy)this.value).getObject();
        }
        if (klass.getKlass() == null) {
            return this.value;
        }
        return null;
    }

    private boolean ensureType(Object value, Class<?> range, WorkingMemory wm) {
        if (range.isInstance(value)) {
            return true;
        }
        TraitableBean obj = null;
        if (value instanceof TraitableBean) {
            obj = (TraitableBean)value;
        } else if (value instanceof TraitProxy) {
            obj = ((TraitProxy)value).getObject();
        }
        if (obj == null) {
            return false;
        }
        if (range.isInstance(obj)) {
            return true;
        }
        if (obj.hasTrait(range.getName())) {
            return true;
        }
        Trait trait = range.getAnnotation(Trait.class);
        if (trait != null && trait.logical()) {
            Object newTrait = this.don(obj, range, false, wm);
            return newTrait != null;
        }
        return false;
    }

    public Object don(TraitType trait, Object defaultValue, TypeWrapper wrapper, boolean logical, WorkingMemory wm) {
        this.disableExplicitSet();
        Class klass = wrapper.getKlass();
        if (defaultValue != null) {
            if (this.defaultValuesByTraits == null) {
                this.defaultValuesByTraits = new TypeHierarchy();
            }
            this.defaultValuesByTraits.addMember(defaultValue, trait.getTypeCode());
            if (this.defaultValuesByTraits.getBottomCode() == null) {
                this.defaultValuesByTraits.setBottomCode((BitSet)trait.getTypeCode().clone());
            } else {
                this.defaultValuesByTraits.getBottomCode().or(trait.getTypeCode());
            }
        }
        try {
            this.rangeTypes.offer(wrapper);
            if (this.value != null && !klass.isInstance(this.value)) {
                if (this.value instanceof TraitableBean) {
                    return this.donTraitable((TraitableBean)this.value, klass, logical, wm);
                }
                if (this.value instanceof TraitProxy) {
                    TraitableBean core = ((TraitProxy)this.value).getObject();
                    return this.donTraitable(core, klass, logical, wm);
                }
                boolean isFullyTraitable = this.inspectForTraitability(this.value, wm);
                if (isFullyTraitable) {
                    TraitProxy proxy = (TraitProxy)this.don(this.value, klass, logical, wm);
                    this.value = proxy.getObject();
                    return proxy;
                }
                this.manageInconsistentValue(klass);
            }
        }
        catch (IllegalStateException ise) {
            throw new UnsupportedOperationException("Unable to apply field traiting, incompatible type.", ise);
        }
        if (!this.isExplicitlySet) {
            return this.getDefault();
        }
        return this.value;
    }

    private boolean inspectForTraitability(Object value, WorkingMemory wm) {
        TypeDeclaration decl;
        Package pack = wm.getRuleBase().getPackage(value.getClass().getPackage().getName());
        if (pack != null && (decl = pack.getTypeDeclaration(value.getClass())) != null) {
            return decl.getTypeClassDef().isFullTraiting();
        }
        Traitable tbl = value.getClass().getAnnotation(Traitable.class);
        return tbl != null && tbl.logical();
    }

    private Object donTraitable(TraitableBean obj, Class<?> klass, boolean logical, WorkingMemory wm) {
        if (klass.isInstance(obj)) {
            return obj;
        }
        if (obj.hasTraits() && obj.hasTrait(klass.getName())) {
            return this.don(obj, klass, logical, wm);
        }
        if (klass.isInterface()) {
            Trait ta = klass.getAnnotation(Trait.class);
            if (ta != null && ta.logical()) {
                return this.don(obj, klass, logical, wm);
            }
            return this.manageInconsistentValue(klass);
        }
        return this.manageInconsistentValue(klass);
    }

    private Object don(Object obj, Class<?> klass, boolean logical, WorkingMemory wm) {
        KnowledgeHelper knowledgeHelper = ((DefaultAgenda)wm.getAgenda()).getKnowledgeHelper();
        return knowledgeHelper.don(obj, klass, logical);
    }

    private Object manageInconsistentValue(Class klass) {
        throw new UnsupportedOperationException("Unable to apply field traiting, incompatible type " + klass + " for current value " + this.value);
    }

    public Object shed(TraitType trait, TypeWrapper rangeWrapper, TypeWrapper asWrapper, WorkingMemory workingMemory) {
        if (this.defaultValuesByTraits != null) {
            this.defaultValuesByTraits.removeMember(trait.getTypeCode());
        }
        this.rangeTypes.remove(rangeWrapper);
        if (!this.isExplicitlySet) {
            this.value = this.getDefault();
        }
        Class klass = asWrapper.getKlass();
        if (this.value == null || klass.isInstance(this.value)) {
            return this.value;
        }
        if (this.value instanceof TraitableBean) {
            return ((TraitableBean)this.value).getTrait(klass.getName());
        }
        if (this.value instanceof TraitProxy) {
            return ((TraitProxy)this.value).getObject().getTrait(klass.getName());
        }
        throw new IllegalStateException("Logical field shed : illegal value for a field : " + this.value + ", class expected " + klass.getName());
    }

    public Object getDefault() {
        if (this.defaultValueByClass != null) {
            return this.defaultValueByClass;
        }
        if (this.defaultValuesByTraits != null && !this.defaultValuesByTraits.isEmpty()) {
            Collection lowerBorder = this.defaultValuesByTraits.upperBorder(this.defaultValuesByTraits.getBottomCode());
            if (lowerBorder.size() > 1) {
                return null;
            }
            return lowerBorder.iterator().next();
        }
        return null;
    }

    public void disableExplicitSet() {
        this.explicitSetEnabled = false;
    }

    public void enableExplicitSet() {
        this.explicitSetEnabled = true;
    }

    public Set<Class<?>> getRangeTypes() {
        HashSet<Class> set = new HashSet<Class>(this.rangeTypes.size());
        for (TypeWrapper type : this.rangeTypes) {
            set.add(type.getKlass());
        }
        return Collections.unmodifiableSet(set);
    }

    public String toString() {
        return "TF{ " + this.value + " }";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.value);
        out.writeBoolean(this.isExplicitlySet);
        out.writeBoolean(this.explicitSetEnabled);
        out.writeObject(this.rangeTypes);
        out.writeObject(this.defaultValuesByTraits);
        out.writeObject(this.defaultValueByClass);
        out.writeShort(this.position);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
        this.isExplicitlySet = in.readBoolean();
        this.explicitSetEnabled = in.readBoolean();
        this.rangeTypes = (PriorityQueue)in.readObject();
        this.defaultValuesByTraits = (TypeHierarchy)in.readObject();
        this.defaultValueByClass = in.readObject();
        this.position = in.readShort();
    }

    public short getPosition() {
        return this.position;
    }

    private static Object zero(Class<?> klass) {
        if (Integer.class == klass) {
            return 0;
        }
        if (Boolean.class == klass) {
            return false;
        }
        if (Float.class == klass) {
            return Float.valueOf(0.0f);
        }
        if (Long.class == klass) {
            return 0L;
        }
        if (Double.class == klass) {
            return 0.0;
        }
        if (Short.class == klass) {
            return (short)0;
        }
        if (Byte.class == klass) {
            return (byte)0;
        }
        if (Character.class == klass) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeComparator
    implements Comparator<TypeWrapper>,
    Serializable {
        private static TypeComparator singleton = new TypeComparator();

        private TypeComparator() {
        }

        public static TypeComparator instance() {
            return singleton;
        }

        @Override
        public int compare(TypeWrapper t1, TypeWrapper t2) {
            boolean trait2;
            Class o2;
            Class o1 = t1.getKlass();
            if (o1 == (o2 = t2.getKlass())) {
                return 0;
            }
            if (o2.isAssignableFrom(o1)) {
                return 1;
            }
            if (o1.isAssignableFrom(o2)) {
                return -1;
            }
            boolean trait1 = o1.isInterface() && o1.getAnnotation(Trait.class) != null;
            boolean bl = trait2 = o2.isInterface() && o2.getAnnotation(Trait.class) != null;
            if (trait1 || trait2) {
                return 1;
            }
            throw new IllegalStateException("Types " + o1.getName() + " and " + o2 + " are incompatible");
        }
    }
}

