/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test.dsl;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.base.ClassObjectType;
import org.drools.common.BetaConstraints;
import org.drools.common.DefaultBetaConstraints;
import org.drools.common.DoubleBetaConstraints;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.QuadroupleBetaConstraints;
import org.drools.common.SingleBetaConstraints;
import org.drools.common.TripleBetaConstraints;
import org.drools.reteoo.ExistsNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockObjectSource;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.test.dsl.ReteTesterHelper;
import org.drools.reteoo.test.dsl.Step;
import org.drools.rule.Declaration;
import org.drools.spi.BetaNodeFieldConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistsNodeStep
implements Step {
    private ReteTesterHelper reteTesterHelper;

    public ExistsNodeStep(ReteTesterHelper reteTesterHelper) {
        this.reteTesterHelper = reteTesterHelper;
    }

    @Override
    public void execute(Map<String, Object> context, List<String[]> args) {
        EmptyBetaConstraints constraints;
        ObjectSource rightObjectSource;
        LeftTupleSource leftTupleSource;
        String name;
        BuildContext buildContext = (BuildContext)context.get("BuildContext");
        if (args.size() != 0) {
            String[] a = args.get(0);
            name = a[0];
            String leftInput = a[1];
            String rightInput = a[2];
            Class cls = null;
            leftTupleSource = leftInput.startsWith("mock") ? new MockTupleSource(buildContext.getNextId()) : (LeftTupleSource)context.get(leftInput);
            if (rightInput.startsWith("mock")) {
                String type = rightInput.substring(5, rightInput.length() - 1);
                try {
                    cls = this.reteTesterHelper.getTypeResolver().resolveType(type);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                rightObjectSource = new MockObjectSource(buildContext.getNextId());
            } else {
                ObjectSource source = rightObjectSource = (ObjectSource)context.get(rightInput);
                while (!(source instanceof ObjectTypeNode)) {
                    source = source.getParentObjectSource();
                }
                cls = ((ClassObjectType)((ObjectTypeNode)source).getObjectType()).getClassType();
            }
            ArrayList<BetaNodeFieldConstraint> list = new ArrayList<BetaNodeFieldConstraint>();
            for (int i = 1; i < args.size(); ++i) {
                a = args.get(i);
                String fieldName = a[0].trim();
                String operator = a[1].trim();
                String var = a[2].trim();
                Declaration declr = (Declaration)context.get(var);
                try {
                    BetaNodeFieldConstraint betaConstraint = this.reteTesterHelper.getBoundVariableConstraint(cls, fieldName, declr, operator);
                    list.add(betaConstraint);
                    continue;
                }
                catch (IntrospectionException e) {
                    throw new IllegalArgumentException();
                }
            }
            switch (list.size()) {
                case 0: {
                    constraints = new EmptyBetaConstraints();
                    break;
                }
                case 1: {
                    constraints = new SingleBetaConstraints((BetaNodeFieldConstraint)list.get(0), buildContext.getRuleBase().getConfiguration());
                    break;
                }
                case 2: {
                    constraints = new DoubleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[2]), buildContext.getRuleBase().getConfiguration());
                    break;
                }
                case 3: {
                    constraints = new TripleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[2]), buildContext.getRuleBase().getConfiguration());
                    break;
                }
                case 4: {
                    constraints = new QuadroupleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[2]), buildContext.getRuleBase().getConfiguration());
                    break;
                }
                default: {
                    constraints = new DefaultBetaConstraints(list.toArray(new BetaNodeFieldConstraint[2]), buildContext.getRuleBase().getConfiguration());
                }
            }
        } else {
            throw new IllegalArgumentException("Cannot arguments " + args);
        }
        ExistsNode existsNode = new ExistsNode(buildContext.getNextId(), leftTupleSource, rightObjectSource, (BetaConstraints)constraints, buildContext);
        existsNode.attach(buildContext);
        context.put(name, existsNode);
    }
}

