/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.FactHandle;
import org.drools.common.ActivationGroupNode;
import org.drools.common.ActivationNode;
import org.drools.common.DefaultAgenda;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalFactHandle;
import org.drools.common.LogicalDependency;
import org.drools.common.QueryElementFactHandle;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.Queueable;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.AgendaGroup;
import org.drools.spi.Consequence;
import org.drools.spi.PropagationContext;
import org.kie.event.rule.ActivationUnMatchListener;

public class AgendaItem
implements Activation,
Queueable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private LeftTuple tuple;
    private int salience;
    private int sequenence;
    private RuleTerminalNode rtn;
    private PropagationContext context;
    private long activationNumber;
    private int index;
    private LinkedList<LogicalDependency> justified;
    private LinkedList<LogicalDependency> blocked;
    private LinkedList<LinkedListEntry<LogicalDependency>> blockers;
    private boolean activated;
    private InternalAgendaGroup agendaGroup;
    private ActivationGroupNode activationGroupNode;
    private ActivationNode activationNode;
    private InternalFactHandle factHandle;
    private transient boolean canceled;
    private boolean matched;
    private ActivationUnMatchListener activationUnMatchListener;

    public AgendaItem() {
    }

    public AgendaItem(long activationNumber, LeftTuple tuple, int salience, PropagationContext context, RuleTerminalNode rtn) {
        this.tuple = tuple;
        this.context = context;
        this.salience = salience;
        this.rtn = rtn;
        this.activationNumber = activationNumber;
        this.index = -1;
        this.matched = true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public PropagationContext getPropagationContext() {
        return this.context;
    }

    public void setPropagationContext(PropagationContext context) {
        this.context = context;
    }

    @Override
    public Rule getRule() {
        return this.rtn.getRule();
    }

    @Override
    public Consequence getConsequence() {
        String consequenceName = this.rtn.getConsequenceName();
        return consequenceName.equals("default") ? this.rtn.getRule().getConsequence() : this.rtn.getRule().getNamedConsequence(consequenceName);
    }

    @Override
    public LeftTuple getTuple() {
        return this.tuple;
    }

    @Override
    public int getSalience() {
        return this.salience;
    }

    public void setSalience(int salience) {
        this.salience = salience;
    }

    public int getSequenence() {
        return this.sequenence;
    }

    public void setSequenence(int sequenence) {
        this.sequenence = sequenence;
    }

    @Override
    public InternalFactHandle getFactHandle() {
        return this.factHandle;
    }

    public void setFactHandle(InternalFactHandle factHandle) {
        this.factHandle = factHandle;
    }

    @Override
    public long getActivationNumber() {
        return this.activationNumber;
    }

    @Override
    public void addBlocked(LogicalDependency dep) {
        if (this.blocked == null) {
            this.blocked = new LinkedList();
        }
        this.blocked.add(dep);
        AgendaItem blocked = (AgendaItem)dep.getJustified();
        if (blocked.blockers == null) {
            blocked.blockers = new LinkedList();
            blocked.blockers.add(dep.getJustifierEntry());
        } else if (dep.getJustifierEntry().getNext() == null && dep.getJustifierEntry().getPrevious() == null && blocked.getBlockers().getFirst() != dep.getJustifierEntry()) {
            blocked.blockers.add(dep.getJustifierEntry());
        }
    }

    public void removeAllBlockersAndBlocked(DefaultAgenda agenda) {
        if (this.blockers != null) {
            for (LinkedListEntry node = this.blockers.getFirst(); node != null; node = (LinkedListEntry)node.getNext()) {
                LogicalDependency dep = node.getObject();
                dep.getJustifier().getBlocked().remove(dep);
            }
        }
        this.blockers = null;
        if (this.blocked != null) {
            LogicalDependency dep = this.blocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.removeBlocked(dep);
                AgendaItem justified = (AgendaItem)dep.getJustified();
                if (justified.getBlockers().isEmpty()) {
                    agenda.getStageActivationsGroup().addActivation(justified);
                }
                dep = tmp;
            }
        }
        this.blocked = null;
    }

    public void removeBlocked(LogicalDependency dep) {
        this.blocked.remove(dep);
        AgendaItem blocked = (AgendaItem)dep.getJustified();
        blocked.blockers.remove(dep.getJustifierEntry());
    }

    @Override
    public void setBlocked(LinkedList<LogicalDependency> justified) {
        this.blocked = justified;
    }

    @Override
    public LinkedList<LogicalDependency> getBlocked() {
        return this.blocked;
    }

    @Override
    public LinkedList<LinkedListEntry<LogicalDependency>> getBlockers() {
        return this.blockers;
    }

    @Override
    public void addLogicalDependency(LogicalDependency node) {
        if (this.justified == null) {
            this.justified = new LinkedList();
        }
        this.justified.add(node);
    }

    @Override
    public LinkedList<LogicalDependency> getLogicalDependencies() {
        return this.justified;
    }

    @Override
    public void setLogicalDependencies(LinkedList<LogicalDependency> justified) {
        this.justified = justified;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public String toString() {
        return "[Activation rule=" + this.rtn.getRule().getName() + ", act#=" + this.activationNumber + ", salience=" + this.salience + ", tuple=" + this.tuple + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AgendaItem)) {
            return false;
        }
        AgendaItem otherItem = (AgendaItem)object;
        return this.rtn.getRule().equals(otherItem.getRule()) && this.tuple.equals(otherItem.getTuple());
    }

    public int hashCode() {
        return this.tuple.hashCode();
    }

    @Override
    public void enqueued(int index) {
        this.index = index;
    }

    @Override
    public void dequeue() {
        if (this.agendaGroup != null) {
            this.agendaGroup.remove(this);
        }
        this.activated = false;
        this.index = -1;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void remove() {
        this.dequeue();
    }

    @Override
    public ActivationGroupNode getActivationGroupNode() {
        return this.activationGroupNode;
    }

    @Override
    public void setActivationGroupNode(ActivationGroupNode activationNode) {
        this.activationGroupNode = activationNode;
    }

    @Override
    public AgendaGroup getAgendaGroup() {
        return this.agendaGroup;
    }

    public void setAgendaGroup(InternalAgendaGroup agendaGroup) {
        this.agendaGroup = agendaGroup;
    }

    @Override
    public ActivationNode getActivationNode() {
        return this.activationNode;
    }

    @Override
    public void setActivationNode(ActivationNode activationNode) {
        this.activationNode = activationNode;
    }

    @Override
    public GroupElement getSubRule() {
        return this.rtn.getSubRule();
    }

    public RuleTerminalNode getRuleTerminalNode() {
        return this.rtn;
    }

    public ActivationUnMatchListener getActivationUnMatchListener() {
        return this.activationUnMatchListener;
    }

    public void setActivationUnMatchListener(ActivationUnMatchListener activationUnMatchListener) {
        this.activationUnMatchListener = activationUnMatchListener;
    }

    public List<FactHandle> getFactHandles() {
        InternalFactHandle[] factHandles = this.tuple.getFactHandles();
        ArrayList<InternalFactHandle> list = new ArrayList<InternalFactHandle>(factHandles.length);
        for (InternalFactHandle factHandle : factHandles) {
            Object o = factHandle.getObject();
            if (o instanceof QueryElementFactHandle) continue;
            list.add(factHandle);
        }
        return Collections.unmodifiableList(list);
    }

    public String toExternalForm() {
        return "[ " + this.getRule().getName() + " active=" + this.activated + " ]";
    }

    public List<Object> getObjects() {
        InternalFactHandle[] factHandles = this.tuple.getFactHandles();
        ArrayList<Object> list = new ArrayList<Object>(factHandles.length);
        for (InternalFactHandle factHandle : factHandles) {
            Object o = factHandle.getObject();
            if (o instanceof QueryElementFactHandle) continue;
            list.add(o);
        }
        return Collections.unmodifiableList(list);
    }

    public Object getDeclarationValue(String variableName) {
        Declaration decl = this.rtn.getSubRule().getOuterDeclarations().get(variableName);
        InternalFactHandle handle = this.tuple.get(decl);
        return decl.getValue(null, handle.getObject());
    }

    public List<String> getDeclarationIDs() {
        Declaration[] declArray = ((RuleTerminalNode)this.tuple.getLeftTupleSink()).getDeclarations();
        ArrayList<String> declarations = new ArrayList<String>();
        for (Declaration decl : declArray) {
            declarations.add(decl.getIdentifier());
        }
        return Collections.unmodifiableList(declarations);
    }

    public boolean isActive() {
        return this.isActivated();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isMatched() {
        return this.matched;
    }

    @Override
    public void setMatched(boolean matched) {
        this.matched = matched;
    }

    @Override
    public boolean isRuleNetworkEvaluatorActivation() {
        return false;
    }
}

