/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.impl;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.drools.SessionConfiguration;
import org.drools.common.ActivationsFilter;
import org.drools.common.DefaultAgenda;
import org.drools.common.DefaultFactHandle;
import org.drools.common.EqualityKey;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.InternalWorkingMemoryEntryPoint;
import org.drools.common.NamedEntryPoint;
import org.drools.common.ObjectStore;
import org.drools.common.PropagationContextImpl;
import org.drools.common.QueryElementFactHandle;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.common.WorkingMemoryAction;
import org.drools.impl.EnvironmentFactory;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.PersisterHelper;
import org.drools.marshalling.impl.ProcessMarshaller;
import org.drools.marshalling.impl.ProcessMarshallerFactory;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.marshalling.impl.TimersInputMarshaller;
import org.drools.reteoo.InitialFactImpl;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.EntryPoint;
import org.drools.spi.Activation;
import org.drools.spi.FactHandleFactory;
import org.drools.spi.GlobalResolver;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleFlowGroup;
import org.drools.time.Trigger;
import org.drools.time.impl.CronTrigger;
import org.drools.time.impl.IntervalTrigger;
import org.drools.time.impl.PointInTimeTrigger;
import org.drools.time.impl.PseudoClockScheduler;
import org.kie.marshalling.ObjectMarshallingStrategy;
import org.kie.runtime.Environment;
import org.kie.runtime.rule.WorkingMemoryEntryPoint;

public class ProtobufInputMarshaller {
    private static ProcessMarshaller processMarshaller = ProtobufInputMarshaller.createProcessMarshaller();

    private static ProcessMarshaller createProcessMarshaller() {
        try {
            return ProcessMarshallerFactory.newProcessMarshaller();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static ReteooStatefulSession readSession(ReteooStatefulSession session, MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        ProtobufMessages.KnowledgeSession _session = ProtobufInputMarshaller.loadAndParseSession(context);
        DefaultAgenda agenda = ProtobufInputMarshaller.resetSession(session, context, _session);
        ProtobufInputMarshaller.readSession(_session, session, agenda, context);
        return session;
    }

    public static ReteooStatefulSession readSession(MarshallerReaderContext context, int id) throws IOException, ClassNotFoundException {
        ReteooStatefulSession session = ProtobufInputMarshaller.readSession(context, id, EnvironmentFactory.newEnvironment(), SessionConfiguration.getDefaultInstance());
        return session;
    }

    public static ReteooStatefulSession readSession(MarshallerReaderContext context, int id, Environment environment, SessionConfiguration config) throws IOException, ClassNotFoundException {
        ProtobufMessages.KnowledgeSession _session = ProtobufInputMarshaller.loadAndParseSession(context);
        ReteooStatefulSession session = ProtobufInputMarshaller.createAndInitializeSession(context, id, environment, config, _session);
        return ProtobufInputMarshaller.readSession(_session, session, (DefaultAgenda)session.getAgenda(), context);
    }

    private static DefaultAgenda resetSession(ReteooStatefulSession session, MarshallerReaderContext context, ProtobufMessages.KnowledgeSession _session) {
        session.reset(_session.getRuleData().getLastId(), _session.getRuleData().getLastRecency(), 0L);
        DefaultAgenda agenda = (DefaultAgenda)session.getAgenda();
        ProtobufInputMarshaller.readAgenda(context, _session.getRuleData(), agenda);
        return agenda;
    }

    private static ReteooStatefulSession createAndInitializeSession(MarshallerReaderContext context, int id, Environment environment, SessionConfiguration config, ProtobufMessages.KnowledgeSession _session) throws IOException {
        FactHandleFactory handleFactory = context.ruleBase.newFactHandleFactory(_session.getRuleData().getLastId(), _session.getRuleData().getLastRecency());
        DefaultFactHandle initialFactHandle = new DefaultFactHandle(_session.getRuleData().getInitialFact().getId(), InitialFactImpl.getInstance(), _session.getRuleData().getInitialFact().getRecency(), null);
        context.handles.put(initialFactHandle.getId(), initialFactHandle);
        DefaultAgenda agenda = context.ruleBase.getConfiguration().getComponentFactory().getAgendaFactory().createAgenda(context.ruleBase, false);
        ProtobufInputMarshaller.readAgenda(context, _session.getRuleData(), agenda);
        ReteooStatefulSession session = new ReteooStatefulSession(id, context.ruleBase, handleFactory, initialFactHandle, 0L, config, agenda, environment);
        new StatefulKnowledgeSessionImpl(session);
        initialFactHandle.setEntryPoint(session.getEntryPoints().get(EntryPoint.DEFAULT.getEntryPointId()));
        return session;
    }

    private static ProtobufMessages.KnowledgeSession loadAndParseSession(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        ExtensionRegistry registry = PersisterHelper.buildRegistry(context, processMarshaller);
        ProtobufMessages.Header _header = PersisterHelper.readFromStreamWithHeader(context, registry);
        return ProtobufMessages.KnowledgeSession.parseFrom(_header.getPayload(), (ExtensionRegistryLite)registry);
    }

    public static ReteooStatefulSession readSession(ProtobufMessages.KnowledgeSession _session, ReteooStatefulSession session, DefaultAgenda agenda, MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        GlobalResolver globalResolver = (GlobalResolver)context.env.get("drools.Globals");
        if (globalResolver != null) {
            session.setGlobalResolver(globalResolver);
        }
        if (session.getTimerService() instanceof PseudoClockScheduler) {
            PseudoClockScheduler clock = (PseudoClockScheduler)session.getTimerService();
            clock.advanceTime(_session.getTime(), TimeUnit.MILLISECONDS);
        }
        for (RuleFlowGroup group : agenda.getRuleFlowGroupsMap().values()) {
            ((RuleFlowGroupImpl)group).setWorkingMemory(session);
        }
        context.wm = session;
        ProtobufInputMarshaller.readNodeMemories(context, _session.getRuleData());
        ProtobufInputMarshaller.readInitialFactHandle(context, _session.getRuleData());
        for (ProtobufMessages.EntryPoint _ep : _session.getRuleData().getEntryPointList()) {
            WorkingMemoryEntryPoint wmep = context.wm.getEntryPoints().get(_ep.getEntryPointId());
            ProtobufInputMarshaller.readFactHandles(context, _ep, ((NamedEntryPoint)wmep).getObjectStore());
            ProtobufInputMarshaller.readTruthMaintenanceSystem(context, wmep, _ep);
        }
        ProtobufInputMarshaller.readActionQueue(context, _session.getRuleData());
        if (processMarshaller != null) {
            if (_session.hasProcessData()) {
                context.parameterObject = _session.getProcessData();
                processMarshaller.readProcessInstances(context);
                context.parameterObject = _session.getProcessData();
                processMarshaller.readWorkItems(context);
                context.parameterObject = _session.getProcessData();
                processMarshaller.readProcessTimers(context);
            }
        } else if (_session.hasProcessData()) {
            throw new IllegalStateException("No process marshaller, unable to unmarshall process data.");
        }
        if (_session.hasTimers()) {
            for (ProtobufMessages.Timers.Timer _timer : _session.getTimers().getTimerList()) {
                ProtobufInputMarshaller.readTimer(context, _timer);
            }
        }
        agenda.setActivationsFilter(null);
        return session;
    }

    private static void readNodeMemories(MarshallerReaderContext context, ProtobufMessages.RuleData _session) {
        for (ProtobufMessages.NodeMemory _node : _session.getNodeMemoryList()) {
            HashMap<TupleKey, Object> memory = null;
            switch (_node.getNodeType()) {
                case ACCUMULATE: {
                    HashMap<TupleKey, Object> map = new HashMap<TupleKey, Object>();
                    for (ProtobufMessages.NodeMemory.AccumulateNodeMemory.AccumulateContext accumulateContext : _node.getAccumulate().getContextList()) {
                        map.put(PersisterHelper.createTupleKey(accumulateContext.getTuple()), accumulateContext.getResultHandle());
                    }
                    memory = map;
                    break;
                }
                case RIA: {
                    HashMap<TupleKey, Object> map = new HashMap();
                    for (ProtobufMessages.NodeMemory.RIANodeMemory.RIAContext rIAContext : _node.getRia().getContextList()) {
                        map.put(PersisterHelper.createTupleKey(rIAContext.getTuple()), rIAContext.getResultHandle());
                    }
                    memory = map;
                    break;
                }
                case FROM: {
                    HashMap<TupleKey, Object> map = new HashMap();
                    for (ProtobufMessages.NodeMemory.FromNodeMemory.FromContext fromContext : _node.getFrom().getContextList()) {
                        map.put(PersisterHelper.createTupleKey(fromContext.getTuple()), new LinkedList<ProtobufMessages.FactHandle>(fromContext.getHandleList()));
                    }
                    memory = map;
                    break;
                }
                case QUERY_ELEMENT: {
                    HashMap<TupleKey, Object> map = new HashMap();
                    for (ProtobufMessages.NodeMemory.QueryElementNodeMemory.QueryContext queryContext : _node.getQueryElement().getContextList()) {
                        map.put(PersisterHelper.createTupleKey(queryContext.getTuple()), new QueryElementContext(queryContext));
                    }
                    memory = map;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown node type " + (Object)((Object)_node.getNodeType()) + " while deserializing session.");
                }
            }
            context.nodeMemories.put(_node.getNodeId(), memory);
        }
    }

    private static void readInitialFactHandle(MarshallerReaderContext context, ProtobufMessages.RuleData _session) {
        int ifhId = context.wm.getInitialFactHandle().getId();
        context.handles.put(ifhId, context.wm.getInitialFactHandle());
        boolean initialFactPropagated = true;
        for (ProtobufMessages.ActionQueue.Action _action : _session.getActionQueue().getActionList()) {
            if (_action.getType() != ProtobufMessages.ActionQueue.ActionType.ASSERT || _action.getAssert().getHandleId() != ifhId) continue;
            initialFactPropagated = false;
            break;
        }
        if (initialFactPropagated) {
            ProtobufInputMarshaller.assertHandleIntoOTN(context, context.wm, context.wm.getInitialFactHandle());
        }
    }

    public static void readAgenda(MarshallerReaderContext context, ProtobufMessages.RuleData _ruleData, DefaultAgenda agenda) {
        ProtobufMessages.Agenda _agenda = _ruleData.getAgenda();
        for (ProtobufMessages.Agenda.AgendaGroup _agendaGroup : _agenda.getAgendaGroupList()) {
            InternalAgendaGroup group = (InternalAgendaGroup)agenda.getAgendaGroup(_agendaGroup.getName(), context.ruleBase);
            group.setActive(_agendaGroup.getIsActive());
            agenda.getAgendaGroupsMap().put(group.getName(), group);
        }
        for (String _groupName : _agenda.getFocusStack().getGroupNameList()) {
            agenda.addAgendaGroupOnStack(agenda.getAgendaGroup(_groupName));
        }
        for (ProtobufMessages.Agenda.RuleFlowGroup _ruleFlowGroup : _agenda.getRuleFlowGroupList()) {
            RuleFlowGroupImpl rfgi = new RuleFlowGroupImpl(_ruleFlowGroup.getName(), _ruleFlowGroup.getIsActive(), _ruleFlowGroup.getIsAutoDeactivate());
            agenda.getRuleFlowGroupsMap().put(_ruleFlowGroup.getName(), rfgi);
            for (ProtobufMessages.Agenda.RuleFlowGroup.NodeInstance _nodeInstance : _ruleFlowGroup.getNodeInstanceList()) {
                rfgi.addNodeInstance(_nodeInstance.getProcessInstanceId(), _nodeInstance.getNodeInstanceId());
            }
        }
        ProtobufInputMarshaller.readActivations(context, _agenda.getActivationList());
        agenda.setActivationsFilter(context.filter);
    }

    public static void readActionQueue(MarshallerReaderContext context, ProtobufMessages.RuleData _session) throws IOException, ClassNotFoundException {
        ReteooWorkingMemory wm = (ReteooWorkingMemory)context.wm;
        Queue<WorkingMemoryAction> actionQueue = wm.getActionQueue();
        for (ProtobufMessages.ActionQueue.Action _action : _session.getActionQueue().getActionList()) {
            actionQueue.offer(PersisterHelper.deserializeWorkingMemoryAction(context, _action));
        }
    }

    public static void readFactHandles(MarshallerReaderContext context, ProtobufMessages.EntryPoint _ep, ObjectStore objectStore) throws IOException, ClassNotFoundException {
        InternalWorkingMemory wm = context.wm;
        WorkingMemoryEntryPoint entryPoint = context.wm.getEntryPoints().get(_ep.getEntryPointId());
        for (ProtobufMessages.FactHandle _handle : _ep.getHandleList()) {
            InternalFactHandle handle = ProtobufInputMarshaller.readFactHandle(context, entryPoint, _handle);
            context.handles.put(handle.getId(), handle);
            if (_handle.getIsJustified()) continue;
            if (handle.getObject() != null) {
                objectStore.addHandle(handle, handle.getObject());
            }
            ProtobufInputMarshaller.assertHandleIntoOTN(context, wm, handle);
        }
    }

    private static void assertHandleIntoOTN(MarshallerReaderContext context, InternalWorkingMemory wm, InternalFactHandle handle) {
        Object object = handle.getObject();
        InternalWorkingMemoryEntryPoint ep = (InternalWorkingMemoryEntryPoint)handle.getEntryPoint();
        ObjectTypeConf typeConf = ((InternalWorkingMemoryEntryPoint)handle.getEntryPoint()).getObjectTypeConfigurationRegistry().getObjectTypeConf(ep.getEntryPoint(), object);
        PropagationContextImpl propagationContext = new PropagationContextImpl(wm.getNextPropagationIdCounter(), 0, null, null, handle, ((DefaultAgenda)wm.getAgenda()).getActiveActivations(), ((DefaultAgenda)wm.getAgenda()).getDormantActivations(), ep.getEntryPoint(), context);
        ep.getEntryPointNode().assertObject(handle, propagationContext, typeConf, wm);
        propagationContext.evaluateActionQueue(wm);
        wm.executeQueuedActions();
    }

    public static InternalFactHandle readFactHandle(MarshallerReaderContext context, WorkingMemoryEntryPoint entryPoint, ProtobufMessages.FactHandle _handle) throws IOException, ClassNotFoundException {
        Object object = null;
        ObjectMarshallingStrategy strategy = null;
        if (_handle.hasStrategyIndex()) {
            strategy = context.usedStrategies.get(_handle.getStrategyIndex());
            object = strategy.unmarshal(context.strategyContexts.get(strategy), (ObjectInputStream)context, _handle.getObject().toByteArray(), context.ruleBase == null ? null : context.ruleBase.getRootClassLoader());
        }
        InternalFactHandle handle = null;
        switch (_handle.getType()) {
            case FACT: {
                handle = new DefaultFactHandle(_handle.getId(), object, _handle.getRecency(), entryPoint);
                break;
            }
            case QUERY: {
                handle = new QueryElementFactHandle(object, _handle.getId(), _handle.getRecency());
                break;
            }
            case EVENT: {
                handle = new EventFactHandle(_handle.getId(), object, _handle.getRecency(), _handle.getTimestamp(), _handle.getDuration(), entryPoint);
                ((EventFactHandle)handle).setExpired(_handle.getIsExpired());
                break;
            }
            default: {
                throw new IllegalStateException("Unable to marshal FactHandle, as type does not exist:" + (Object)((Object)_handle.getType()));
            }
        }
        return handle;
    }

    public static void readTruthMaintenanceSystem(MarshallerReaderContext context, WorkingMemoryEntryPoint wmep, ProtobufMessages.EntryPoint _ep) throws IOException, ClassNotFoundException {
        TruthMaintenanceSystem tms = ((NamedEntryPoint)wmep).getTruthMaintenanceSystem();
        ProtobufMessages.TruthMaintenanceSystem _tms = _ep.getTms();
        for (ProtobufMessages.EqualityKey _key : _tms.getKeyList()) {
            InternalFactHandle handle = context.handles.get(_key.getHandleId());
            ObjectTypeConf typeConf = context.wm.getObjectTypeConfigurationRegistry().getObjectTypeConf(((NamedEntryPoint)handle.getEntryPoint()).getEntryPoint(), handle.getObject());
            if (!typeConf.isTMSEnabled()) {
                typeConf.enableTMS();
            }
            EqualityKey key = new EqualityKey(handle, _key.getStatus());
            handle.setEqualityKey(key);
            if (key.getStatus() == 2) {
                ((NamedEntryPoint)handle.getEntryPoint()).getObjectStore().addHandle(handle, handle.getObject());
                ProtobufInputMarshaller.assertHandleIntoOTN(context, context.wm, handle);
            }
            for (Integer factHandleId : _key.getOtherHandleList()) {
                handle = context.handles.get((int)factHandleId);
                key.addFactHandle(handle);
                handle.setEqualityKey(key);
            }
            tms.put(key);
            ProtobufInputMarshaller.readBeliefSet(context, tms, key, _key.getBeliefSet());
        }
    }

    private static void readBeliefSet(MarshallerReaderContext context, TruthMaintenanceSystem tms, EqualityKey key, ProtobufMessages.BeliefSet _beliefSet) throws IOException, ClassNotFoundException {
        InternalFactHandle handle = context.handles.get(_beliefSet.getHandleId());
        for (ProtobufMessages.LogicalDependency _logicalDependency : _beliefSet.getLogicalDependencyList()) {
            ProtobufMessages.Activation _activation = _logicalDependency.getActivation();
            Activation activation = (Activation)context.filter.getTuplesCache().get(PersisterHelper.createActivationKey(_activation.getPackageName(), _activation.getRuleName(), _activation.getTuple())).getObject();
            Object object = null;
            ObjectMarshallingStrategy strategy = null;
            if (_logicalDependency.hasObjectStrategyIndex()) {
                strategy = context.usedStrategies.get(_logicalDependency.getObjectStrategyIndex());
                object = strategy.unmarshal(context.strategyContexts.get(strategy), (ObjectInputStream)context, _logicalDependency.getObject().toByteArray(), context.ruleBase == null ? null : context.ruleBase.getRootClassLoader());
            }
            Object value = null;
            if (_logicalDependency.hasValueStrategyIndex()) {
                strategy = context.usedStrategies.get(_logicalDependency.getValueStrategyIndex());
                value = strategy.unmarshal(context.strategyContexts.get(strategy), (ObjectInputStream)context, _logicalDependency.getValue().toByteArray(), context.ruleBase == null ? null : context.ruleBase.getRootClassLoader());
            }
            ObjectTypeConf typeConf = context.wm.getObjectTypeConfigurationRegistry().getObjectTypeConf(((NamedEntryPoint)handle.getEntryPoint()).getEntryPoint(), handle.getObject());
            tms.readLogicalDependency(handle, object, value, activation, activation.getPropagationContext(), activation.getRule(), typeConf);
        }
    }

    private static void readActivations(MarshallerReaderContext context, List<ProtobufMessages.Activation> _list) {
        for (ProtobufMessages.Activation _activation : _list) {
            context.filter.getDormantActivationsMap().put(PersisterHelper.createActivationKey(_activation.getPackageName(), _activation.getRuleName(), _activation.getTuple()), _activation);
        }
    }

    public static void readTimer(MarshallerReaderContext inCtx, ProtobufMessages.Timers.Timer _timer) throws IOException, ClassNotFoundException {
        TimersInputMarshaller reader = inCtx.readersByInt.get(_timer.getType().getNumber());
        reader.deserialize(inCtx, _timer);
    }

    public static Trigger readTrigger(MarshallerReaderContext inCtx, ProtobufMessages.Trigger _trigger) {
        switch (_trigger.getType()) {
            case CRON: {
                ProtobufMessages.Trigger.CronTrigger _cron = _trigger.getCron();
                CronTrigger trigger = new CronTrigger();
                trigger.setStartTime(new Date(_cron.getStartTime()));
                if (_cron.hasEndTime()) {
                    trigger.setEndTime(new Date(_cron.getEndTime()));
                }
                trigger.setRepeatLimit(_cron.getRepeatLimit());
                trigger.setRepeatCount(_cron.getRepeatCount());
                trigger.setCronExpression(_cron.getCronExpression());
                if (_cron.hasNextFireTime()) {
                    trigger.setNextFireTime(new Date(_cron.getNextFireTime()));
                }
                String[] calendarNames = new String[_cron.getCalendarNameCount()];
                for (int i = 0; i < calendarNames.length; ++i) {
                    calendarNames[i] = _cron.getCalendarName(i);
                }
                trigger.setCalendarNames(calendarNames);
                return trigger;
            }
            case INTERVAL: {
                ProtobufMessages.Trigger.IntervalTrigger _interval = _trigger.getInterval();
                IntervalTrigger trigger = new IntervalTrigger();
                trigger.setStartTime(new Date(_interval.getStartTime()));
                if (_interval.hasEndTime()) {
                    trigger.setEndTime(new Date(_interval.getEndTime()));
                }
                trigger.setRepeatLimit(_interval.getRepeatLimit());
                trigger.setRepeatCount(_interval.getRepeatCount());
                if (_interval.hasNextFireTime()) {
                    trigger.setNextFireTime(new Date(_interval.getNextFireTime()));
                }
                trigger.setPeriod(_interval.getPeriod());
                String[] calendarNames = new String[_interval.getCalendarNameCount()];
                for (int i = 0; i < calendarNames.length; ++i) {
                    calendarNames[i] = _interval.getCalendarName(i);
                }
                trigger.setCalendarNames(calendarNames);
                return trigger;
            }
            case POINT_IN_TIME: {
                PointInTimeTrigger trigger = new PointInTimeTrigger(_trigger.getPit().getNextFireTime(), null, null);
                return trigger;
            }
        }
        throw new RuntimeException("Unable to deserialize Trigger for type: " + (Object)((Object)_trigger.getType()));
    }

    public static class TupleKey {
        private final int[] tuple;

        public TupleKey(int[] tuple) {
            this.tuple = tuple;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.tuple);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TupleKey other = (TupleKey)obj;
            return Arrays.equals(this.tuple, other.tuple);
        }
    }

    public static class ActivationKey {
        private final String pkgName;
        private final String ruleName;
        private final int[] tuple;

        public ActivationKey(String pkgName, String ruleName, int[] tuple) {
            this.pkgName = pkgName;
            this.ruleName = ruleName;
            this.tuple = tuple;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.pkgName == null ? 0 : this.pkgName.hashCode());
            result = 31 * result + (this.ruleName == null ? 0 : this.ruleName.hashCode());
            result = 31 * result + Arrays.hashCode(this.tuple);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ActivationKey other = (ActivationKey)obj;
            if (this.pkgName == null ? other.pkgName != null : !this.pkgName.equals(other.pkgName)) {
                return false;
            }
            if (this.ruleName == null ? other.ruleName != null : !this.ruleName.equals(other.ruleName)) {
                return false;
            }
            return Arrays.equals(this.tuple, other.tuple);
        }
    }

    public static class PBActivationsFilter
    implements ActivationsFilter {
        private Map<ActivationKey, ProtobufMessages.Activation> dormantActivations = new HashMap<ActivationKey, ProtobufMessages.Activation>();
        private Map<ActivationKey, LeftTuple> tuplesCache = new HashMap<ActivationKey, LeftTuple>();

        public Map<ActivationKey, ProtobufMessages.Activation> getDormantActivationsMap() {
            return this.dormantActivations;
        }

        @Override
        public boolean accept(Activation activation, PropagationContext context, InternalWorkingMemory workingMemory, RuleTerminalNode rtn) {
            ActivationKey key = PersisterHelper.createActivationKey(rtn.getRule().getPackageName(), rtn.getRule().getName(), activation.getTuple());
            this.tuplesCache.put(key, activation.getTuple());
            return !this.dormantActivations.containsKey(key);
        }

        public Map<ActivationKey, LeftTuple> getTuplesCache() {
            return this.tuplesCache;
        }
    }

    public static class QueryElementContext {
        public final ProtobufMessages.FactHandle handle;
        public final LinkedList<ProtobufMessages.FactHandle> results;

        public QueryElementContext(ProtobufMessages.NodeMemory.QueryElementNodeMemory.QueryContext _ctx) {
            this.handle = _ctx.getHandle();
            this.results = new LinkedList<ProtobufMessages.FactHandle>(_ctx.getResultList());
        }
    }
}

