/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.RuntimeDroolsException;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.AfterEvaluatorDefinition;
import org.drools.base.evaluators.BeforeEvaluatorDefinition;
import org.drools.base.evaluators.CoincidesEvaluatorDefinition;
import org.drools.base.evaluators.DuringEvaluatorDefinition;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.common.DisconnectedWorkingMemoryEntryPoint;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.junit.Assert;
import org.junit.Test;
import org.kie.runtime.rule.SessionEntryPoint;

public class TemporalEvaluatorFactoryTest {
    private EvaluatorRegistry registry = new EvaluatorRegistry();

    @Test
    public void testAfter() {
        this.registry.addEvaluatorDefinition(AfterEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 1L, 2L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 4L, 3L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 5L, 2L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{drool, "after", foo, Boolean.TRUE}, {drool, "after", bar, Boolean.FALSE}, {bar, "after", foo, Boolean.TRUE}, {bar, "after", drool, Boolean.FALSE}, {foo, "after", drool, Boolean.FALSE}, {foo, "after", bar, Boolean.FALSE}, {foo, "not after", bar, Boolean.TRUE}, {foo, "not after", drool, Boolean.TRUE}, {bar, "not after", drool, Boolean.TRUE}, {bar, "not after", foo, Boolean.FALSE}, {drool, "not after", foo, Boolean.FALSE}, {drool, "not after", bar, Boolean.TRUE}, {bar, "after[1]", foo, Boolean.TRUE}, {bar, "after[0]", foo, Boolean.TRUE}, {bar, "after[-3]", drool, Boolean.TRUE}, {bar, "after[-4]", drool, Boolean.TRUE}, {drool, "after[2]", foo, Boolean.TRUE}, {drool, "after[1]", foo, Boolean.TRUE}, {drool, "after[-2]", bar, Boolean.TRUE}, {drool, "after[-3]", bar, Boolean.TRUE}, {foo, "after[-6]", drool, Boolean.TRUE}, {foo, "after[-7]", drool, Boolean.TRUE}, {foo, "after[-6]", bar, Boolean.TRUE}, {foo, "after[-7]", bar, Boolean.TRUE}, {bar, "not after[1]", foo, Boolean.FALSE}, {bar, "not after[0]", foo, Boolean.FALSE}, {bar, "not after[-3]", drool, Boolean.FALSE}, {bar, "not after[-4]", drool, Boolean.FALSE}, {drool, "not after[2]", foo, Boolean.FALSE}, {drool, "not after[1]", foo, Boolean.FALSE}, {drool, "not after[-2]", bar, Boolean.FALSE}, {drool, "not after[-3]", bar, Boolean.FALSE}, {foo, "not after[-6]", drool, Boolean.FALSE}, {foo, "not after[-7]", drool, Boolean.FALSE}, {foo, "not after[-6]", bar, Boolean.FALSE}, {foo, "not after[-7]", bar, Boolean.FALSE}, {drool, "after[1,4]", foo, Boolean.TRUE}, {drool, "after[3,6]", foo, Boolean.FALSE}, {drool, "after[-3,1]", bar, Boolean.TRUE}, {drool, "after[-1,3]", bar, Boolean.FALSE}, {bar, "after[1,5]", foo, Boolean.TRUE}, {bar, "after[2,5]", foo, Boolean.FALSE}, {bar, "after[-3,0]", drool, Boolean.TRUE}, {bar, "after[-2,1]", drool, Boolean.FALSE}, {foo, "after[-7,-3]", bar, Boolean.TRUE}, {foo, "after[-5,-1]", bar, Boolean.FALSE}, {foo, "after[-6,-5]", drool, Boolean.TRUE}, {foo, "after[-5,-4]", drool, Boolean.FALSE}, {drool, "not after[1,4]", foo, Boolean.FALSE}, {drool, "not after[3,6]", foo, Boolean.TRUE}, {drool, "not after[-3,1]", bar, Boolean.FALSE}, {drool, "not after[-1,3]", bar, Boolean.TRUE}, {bar, "not after[1,5]", foo, Boolean.FALSE}, {bar, "not after[2,5]", foo, Boolean.TRUE}, {bar, "not after[-3,0]", drool, Boolean.FALSE}, {bar, "not after[-2,1]", drool, Boolean.TRUE}, {foo, "not after[-7,-3]", bar, Boolean.FALSE}, {foo, "not after[-5,-1]", bar, Boolean.TRUE}, {foo, "not after[-6,-5]", drool, Boolean.FALSE}, {foo, "not after[-5,-4]", drool, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    @Test
    public void testBefore() {
        this.registry.addEvaluatorDefinition(BeforeEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 1L, 2L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 2L, 2L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 5L, 3L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{foo, "before", drool, Boolean.TRUE}, {foo, "before", bar, Boolean.FALSE}, {drool, "before", foo, Boolean.FALSE}, {drool, "before", bar, Boolean.FALSE}, {bar, "before", drool, Boolean.TRUE}, {bar, "before", foo, Boolean.FALSE}, {foo, "not before", drool, Boolean.FALSE}, {foo, "not before", bar, Boolean.TRUE}, {drool, "not before", foo, Boolean.TRUE}, {drool, "not before", bar, Boolean.TRUE}, {bar, "not before", drool, Boolean.FALSE}, {bar, "not before", foo, Boolean.TRUE}, {foo, "before[2]", drool, Boolean.TRUE}, {foo, "before[3]", drool, Boolean.FALSE}, {foo, "before[-1]", bar, Boolean.TRUE}, {foo, "before[-2]", bar, Boolean.TRUE}, {bar, "before[1]", drool, Boolean.TRUE}, {bar, "before[2]", drool, Boolean.FALSE}, {bar, "before[-3]", foo, Boolean.TRUE}, {bar, "before[-2]", foo, Boolean.FALSE}, {drool, "before[-6]", bar, Boolean.TRUE}, {drool, "before[-5]", bar, Boolean.FALSE}, {drool, "before[-7]", foo, Boolean.TRUE}, {drool, "before[-8]", foo, Boolean.TRUE}, {foo, "not before[2]", drool, Boolean.FALSE}, {foo, "not before[3]", drool, Boolean.TRUE}, {foo, "not before[-1]", bar, Boolean.FALSE}, {foo, "not before[-2]", bar, Boolean.FALSE}, {bar, "not before[1]", drool, Boolean.FALSE}, {bar, "not before[2]", drool, Boolean.TRUE}, {bar, "not before[-3]", foo, Boolean.FALSE}, {bar, "not before[-2]", foo, Boolean.TRUE}, {drool, "not before[-6]", bar, Boolean.FALSE}, {drool, "not before[-5]", bar, Boolean.TRUE}, {drool, "not before[-7]", foo, Boolean.FALSE}, {drool, "not before[-8]", foo, Boolean.FALSE}, {foo, "before[2,4]", drool, Boolean.TRUE}, {foo, "before[3,4]", drool, Boolean.FALSE}, {foo, "before[-1,1]", bar, Boolean.TRUE}, {foo, "before[0,-2]", bar, Boolean.TRUE}, {bar, "before[0,4]", drool, Boolean.TRUE}, {bar, "before[2,4]", drool, Boolean.FALSE}, {bar, "before[-4,0]", foo, Boolean.TRUE}, {bar, "before[-2,0]", foo, Boolean.FALSE}, {drool, "before[-6,-3]", bar, Boolean.TRUE}, {drool, "before[-5,-3]", bar, Boolean.FALSE}, {drool, "before[-7,-4]", foo, Boolean.TRUE}, {drool, "before[-6,-4]", foo, Boolean.FALSE}, {foo, "not before[2,4]", drool, Boolean.FALSE}, {foo, "not before[3,4]", drool, Boolean.TRUE}, {foo, "not before[-1,1]", bar, Boolean.FALSE}, {foo, "not before[0,-2]", bar, Boolean.FALSE}, {bar, "not before[0,4]", drool, Boolean.FALSE}, {bar, "not before[2,4]", drool, Boolean.TRUE}, {bar, "not before[-4,0]", foo, Boolean.FALSE}, {bar, "not before[-2,0]", foo, Boolean.TRUE}, {drool, "not before[-6,-3]", bar, Boolean.FALSE}, {drool, "not before[-5,-3]", bar, Boolean.TRUE}, {drool, "not before[-7,-4]", foo, Boolean.FALSE}, {drool, "not before[-6,-4]", foo, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    @Test
    public void testCoincides() {
        this.registry.addEvaluatorDefinition(CoincidesEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 2L, 3L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 2L, 3L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 2L, 2L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle mole = new EventFactHandle(1, (Object)"mole", 1L, 1L, 2L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{foo, "coincides", bar, Boolean.TRUE}, {foo, "coincides", drool, Boolean.FALSE}, {foo, "coincides", mole, Boolean.FALSE}, {drool, "coincides", mole, Boolean.FALSE}, {foo, "not coincides", bar, Boolean.FALSE}, {foo, "not coincides", drool, Boolean.TRUE}, {foo, "not coincides", mole, Boolean.TRUE}, {drool, "not coincides", mole, Boolean.TRUE}, {foo, "coincides[1]", bar, Boolean.TRUE}, {foo, "coincides[1]", drool, Boolean.TRUE}, {foo, "coincides[2]", mole, Boolean.TRUE}, {foo, "coincides[1]", mole, Boolean.FALSE}, {drool, "coincides[1]", mole, Boolean.TRUE}, {foo, "not coincides[1]", bar, Boolean.FALSE}, {foo, "not coincides[1]", drool, Boolean.FALSE}, {foo, "not coincides[2]", mole, Boolean.FALSE}, {foo, "not coincides[1]", mole, Boolean.TRUE}, {drool, "not coincides[1]", mole, Boolean.FALSE}, {foo, "coincides[1,2]", bar, Boolean.TRUE}, {foo, "coincides[0,1]", drool, Boolean.TRUE}, {foo, "coincides[1,0]", drool, Boolean.FALSE}, {foo, "coincides[1,2]", mole, Boolean.TRUE}, {foo, "coincides[1,1]", mole, Boolean.FALSE}, {drool, "coincides[1,1]", mole, Boolean.TRUE}, {drool, "coincides[0,1]", mole, Boolean.FALSE}, {foo, "not coincides[1,2]", bar, Boolean.FALSE}, {foo, "not coincides[0,1]", drool, Boolean.FALSE}, {foo, "not coincides[1,0]", drool, Boolean.TRUE}, {foo, "not coincides[1,2]", mole, Boolean.FALSE}, {foo, "not coincides[1,1]", mole, Boolean.TRUE}, {drool, "not coincides[1,1]", mole, Boolean.FALSE}, {drool, "not coincides[0,1]", mole, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    @Test
    public void testDuring() {
        this.registry.addEvaluatorDefinition(DuringEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 2L, 10L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 4L, 7L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 1L, 5L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle mole = new EventFactHandle(1, (Object)"mole", 1L, 7L, 6L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{foo, "during", bar, Boolean.FALSE}, {foo, "during", drool, Boolean.FALSE}, {foo, "during", mole, Boolean.FALSE}, {bar, "during", foo, Boolean.TRUE}, {bar, "during", drool, Boolean.FALSE}, {bar, "during", mole, Boolean.FALSE}, {foo, "not during", bar, Boolean.TRUE}, {foo, "not during", drool, Boolean.TRUE}, {foo, "not during", mole, Boolean.TRUE}, {bar, "not during", foo, Boolean.FALSE}, {bar, "not during", drool, Boolean.TRUE}, {bar, "not during", mole, Boolean.TRUE}, {bar, "during[2]", foo, Boolean.TRUE}, {bar, "during[3]", foo, Boolean.TRUE}, {bar, "during[1]", foo, Boolean.FALSE}, {bar, "not during[2]", foo, Boolean.FALSE}, {bar, "not during[3]", foo, Boolean.FALSE}, {bar, "not during[1]", foo, Boolean.TRUE}, {bar, "during[1, 2]", foo, Boolean.TRUE}, {bar, "during[2, 3]", foo, Boolean.FALSE}, {bar, "during[3, 3]", foo, Boolean.FALSE}, {bar, "not during[1, 2]", foo, Boolean.FALSE}, {bar, "not during[2, 3]", foo, Boolean.TRUE}, {bar, "not during[3, 3]", foo, Boolean.TRUE}, {bar, "during[2, 2, 1, 1]", foo, Boolean.TRUE}, {bar, "during[1, 5, 1, 3]", foo, Boolean.TRUE}, {bar, "during[0, 1, 0, 3]", foo, Boolean.FALSE}, {bar, "not during[2, 2, 1, 1]", foo, Boolean.FALSE}, {bar, "not during[1, 5, 1, 3]", foo, Boolean.FALSE}, {bar, "not during[0, 1, 0, 3]", foo, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    @Test
    public void testIncludes() {
        this.registry.addEvaluatorDefinition(DuringEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 2L, 10L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 4L, 7L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 1L, 5L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle mole = new EventFactHandle(1, (Object)"mole", 1L, 7L, 6L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{bar, "includes", foo, Boolean.FALSE}, {drool, "includes", foo, Boolean.FALSE}, {mole, "includes", foo, Boolean.FALSE}, {foo, "includes", bar, Boolean.TRUE}, {drool, "includes", bar, Boolean.FALSE}, {mole, "includes", bar, Boolean.FALSE}, {bar, "not includes", foo, Boolean.TRUE}, {drool, "not includes", foo, Boolean.TRUE}, {mole, "not includes", foo, Boolean.TRUE}, {foo, "not includes", bar, Boolean.FALSE}, {drool, "not includes", bar, Boolean.TRUE}, {mole, "not includes", bar, Boolean.TRUE}, {foo, "includes[2]", bar, Boolean.TRUE}, {foo, "includes[3]", bar, Boolean.TRUE}, {foo, "includes[1]", bar, Boolean.FALSE}, {foo, "not includes[2]", bar, Boolean.FALSE}, {foo, "not includes[3]", bar, Boolean.FALSE}, {foo, "not includes[1]", bar, Boolean.TRUE}, {foo, "includes[1, 2]", bar, Boolean.TRUE}, {foo, "includes[2, 3]", bar, Boolean.FALSE}, {foo, "includes[3, 3]", bar, Boolean.FALSE}, {foo, "not includes[1, 2]", bar, Boolean.FALSE}, {foo, "not includes[2, 3]", bar, Boolean.TRUE}, {foo, "not includes[3, 3]", bar, Boolean.TRUE}, {foo, "includes[2, 2, 1, 1]", bar, Boolean.TRUE}, {foo, "includes[1, 5, 1, 3]", bar, Boolean.TRUE}, {foo, "includes[0, 1, 0, 3]", bar, Boolean.FALSE}, {foo, "not includes[2, 2, 1, 1]", bar, Boolean.FALSE}, {foo, "not includes[1, 5, 1, 3]", bar, Boolean.FALSE}, {foo, "not includes[0, 1, 0, 3]", bar, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    @Test
    public void testFinishes() {
        this.registry.addEvaluatorDefinition(DuringEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 2L, 10L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 5L, 7L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 2L, 10L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle mole = new EventFactHandle(1, (Object)"mole", 1L, 7L, 6L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{bar, "finishes", foo, Boolean.TRUE}, {drool, "finishes", foo, Boolean.FALSE}, {mole, "finishes", foo, Boolean.FALSE}, {foo, "finishes", bar, Boolean.FALSE}, {bar, "not finishes", foo, Boolean.FALSE}, {drool, "not finishes", foo, Boolean.TRUE}, {mole, "not finishes", foo, Boolean.TRUE}, {foo, "not finishes", bar, Boolean.TRUE}, {bar, "finishes[1]", foo, Boolean.TRUE}, {drool, "finishes[1]", foo, Boolean.FALSE}, {mole, "finishes[1]", foo, Boolean.TRUE}, {foo, "finishes[1]", bar, Boolean.FALSE}, {bar, "not finishes[1]", foo, Boolean.FALSE}, {drool, "not finishes[1]", foo, Boolean.TRUE}, {mole, "not finishes[1]", foo, Boolean.FALSE}, {foo, "not finishes[1]", bar, Boolean.TRUE}, {mole, "finishes[3]", foo, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    @Test
    public void testFinishedBy() {
        this.registry.addEvaluatorDefinition(DuringEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 2L, 10L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 5L, 7L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 2L, 10L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle mole = new EventFactHandle(1, (Object)"mole", 1L, 7L, 6L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{foo, "finishedby", bar, Boolean.TRUE}, {foo, "finishedby", drool, Boolean.FALSE}, {foo, "finishedby", mole, Boolean.FALSE}, {bar, "finishedby", foo, Boolean.FALSE}, {foo, "not finishedby", bar, Boolean.FALSE}, {foo, "not finishedby", drool, Boolean.TRUE}, {foo, "not finishedby", mole, Boolean.TRUE}, {bar, "not finishedby", foo, Boolean.TRUE}, {foo, "finishedby[1]", bar, Boolean.TRUE}, {foo, "finishedby[1]", drool, Boolean.FALSE}, {foo, "finishedby[1]", mole, Boolean.TRUE}, {bar, "finishedby[1]", foo, Boolean.FALSE}, {foo, "not finishedby[1]", bar, Boolean.FALSE}, {foo, "not finishedby[1]", drool, Boolean.TRUE}, {foo, "not finishedby[1]", mole, Boolean.FALSE}, {bar, "not finishedby[1]", foo, Boolean.TRUE}, {foo, "finishedby[3]", mole, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    @Test
    public void testStarts() {
        this.registry.addEvaluatorDefinition(DuringEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 2L, 10L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 2L, 7L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 2L, 10L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle mole = new EventFactHandle(1, (Object)"mole", 1L, 1L, 4L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{bar, "starts", foo, Boolean.TRUE}, {drool, "starts", foo, Boolean.FALSE}, {mole, "starts", foo, Boolean.FALSE}, {foo, "starts", bar, Boolean.FALSE}, {bar, "not starts", foo, Boolean.FALSE}, {drool, "not starts", foo, Boolean.TRUE}, {mole, "not starts", foo, Boolean.TRUE}, {foo, "not starts", bar, Boolean.TRUE}, {bar, "starts[1]", foo, Boolean.TRUE}, {drool, "starts[1]", foo, Boolean.FALSE}, {mole, "starts[1]", foo, Boolean.TRUE}, {foo, "starts[1]", bar, Boolean.FALSE}, {bar, "not starts[1]", foo, Boolean.FALSE}, {drool, "not starts[1]", foo, Boolean.TRUE}, {mole, "not starts[1]", foo, Boolean.FALSE}, {foo, "not starts[1]", bar, Boolean.TRUE}, {mole, "starts[3]", foo, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    @Test
    public void testStartedBy() {
        this.registry.addEvaluatorDefinition(DuringEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 2L, 10L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 2L, 7L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 2L, 10L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle mole = new EventFactHandle(1, (Object)"mole", 1L, 1L, 6L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{foo, "startedby", bar, Boolean.TRUE}, {foo, "startedby", drool, Boolean.FALSE}, {foo, "startedby", mole, Boolean.FALSE}, {bar, "startedby", foo, Boolean.FALSE}, {foo, "not startedby", bar, Boolean.FALSE}, {foo, "not startedby", drool, Boolean.TRUE}, {foo, "not startedby", mole, Boolean.TRUE}, {bar, "not startedby", foo, Boolean.TRUE}, {foo, "startedby[1]", bar, Boolean.TRUE}, {foo, "startedby[1]", drool, Boolean.FALSE}, {foo, "startedby[1]", mole, Boolean.TRUE}, {bar, "startedby[1]", foo, Boolean.FALSE}, {foo, "not startedby[1]", bar, Boolean.FALSE}, {foo, "not startedby[1]", drool, Boolean.TRUE}, {foo, "not startedby[1]", mole, Boolean.FALSE}, {bar, "not startedby[1]", foo, Boolean.TRUE}, {foo, "startedby[3]", mole, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    @Test
    public void testMeets() {
        this.registry.addEvaluatorDefinition(DuringEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 2L, 8L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 10L, 7L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 8L, 5L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle mole = new EventFactHandle(1, (Object)"mole", 1L, 11L, 4L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{foo, "meets", bar, Boolean.TRUE}, {foo, "meets", drool, Boolean.FALSE}, {foo, "meets", mole, Boolean.FALSE}, {foo, "not meets", bar, Boolean.FALSE}, {foo, "not meets", drool, Boolean.TRUE}, {foo, "not meets", mole, Boolean.TRUE}, {foo, "meets[1]", bar, Boolean.TRUE}, {foo, "meets[1]", drool, Boolean.FALSE}, {foo, "meets[1]", mole, Boolean.TRUE}, {foo, "meets[2]", drool, Boolean.TRUE}, {foo, "not meets[1]", bar, Boolean.FALSE}, {foo, "not meets[1]", drool, Boolean.TRUE}, {foo, "not meets[1]", mole, Boolean.FALSE}, {foo, "not meets[2]", drool, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    @Test
    public void testMetBy() {
        this.registry.addEvaluatorDefinition(DuringEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 10L, 8L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 2L, 8L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 5L, 3L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle mole = new EventFactHandle(1, (Object)"mole", 1L, 4L, 7L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{foo, "metby", bar, Boolean.TRUE}, {foo, "metby", drool, Boolean.FALSE}, {foo, "metby", mole, Boolean.FALSE}, {foo, "not metby", bar, Boolean.FALSE}, {foo, "not metby", drool, Boolean.TRUE}, {foo, "not metby", mole, Boolean.TRUE}, {foo, "metby[1]", bar, Boolean.TRUE}, {foo, "metby[1]", drool, Boolean.FALSE}, {foo, "metby[1]", mole, Boolean.TRUE}, {foo, "metby[2]", drool, Boolean.TRUE}, {foo, "not metby[1]", bar, Boolean.FALSE}, {foo, "not metby[1]", drool, Boolean.TRUE}, {foo, "not metby[1]", mole, Boolean.FALSE}, {foo, "not metby[2]", drool, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    @Test
    public void testOverlaps() {
        this.registry.addEvaluatorDefinition(DuringEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 2L, 8L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 7L, 7L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 11L, 5L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle mole = new EventFactHandle(1, (Object)"mole", 1L, 5L, 5L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{foo, "overlaps", bar, Boolean.TRUE}, {foo, "overlaps", drool, Boolean.FALSE}, {foo, "overlaps", mole, Boolean.FALSE}, {foo, "not overlaps", bar, Boolean.FALSE}, {foo, "not overlaps", drool, Boolean.TRUE}, {foo, "not overlaps", mole, Boolean.TRUE}, {foo, "overlaps[3]", bar, Boolean.TRUE}, {foo, "overlaps[3]", drool, Boolean.FALSE}, {foo, "overlaps[3]", mole, Boolean.FALSE}, {foo, "overlaps[2]", bar, Boolean.FALSE}, {foo, "overlaps[6]", mole, Boolean.FALSE}, {foo, "not overlaps[3]", bar, Boolean.FALSE}, {foo, "not overlaps[3]", drool, Boolean.TRUE}, {foo, "not overlaps[3]", mole, Boolean.TRUE}, {foo, "not overlaps[2]", bar, Boolean.TRUE}, {foo, "not overlaps[6]", mole, Boolean.TRUE}, {foo, "overlaps[1,3]", bar, Boolean.TRUE}, {foo, "overlaps[1,3]", drool, Boolean.FALSE}, {foo, "overlaps[1,3]", mole, Boolean.FALSE}, {foo, "overlaps[4,6]", bar, Boolean.FALSE}, {foo, "overlaps[1,8]", mole, Boolean.FALSE}, {foo, "not overlaps[1,3]", bar, Boolean.FALSE}, {foo, "not overlaps[1,3]", drool, Boolean.TRUE}, {foo, "not overlaps[1,3]", mole, Boolean.TRUE}, {foo, "not overlaps[4,6]", bar, Boolean.TRUE}, {foo, "not overlaps[1,8]", mole, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    @Test
    public void testOverlapedBy() {
        this.registry.addEvaluatorDefinition(DuringEvaluatorDefinition.class.getName());
        EventFactHandle foo = new EventFactHandle(1, (Object)"foo", 1L, 7L, 8L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle bar = new EventFactHandle(2, (Object)"bar", 1L, 2L, 8L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle drool = new EventFactHandle(1, (Object)"drool", 1L, 11L, 5L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        EventFactHandle mole = new EventFactHandle(1, (Object)"mole", 1L, 7L, 3L, (SessionEntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        Object[][] data = new Object[][]{{foo, "overlappedby", bar, Boolean.TRUE}, {foo, "overlappedby", drool, Boolean.FALSE}, {foo, "overlappedby", mole, Boolean.FALSE}, {foo, "not overlappedby", bar, Boolean.FALSE}, {foo, "not overlappedby", drool, Boolean.TRUE}, {foo, "not overlappedby", mole, Boolean.TRUE}, {foo, "overlappedby[3]", bar, Boolean.TRUE}, {foo, "overlappedby[3]", drool, Boolean.FALSE}, {foo, "overlappedby[3]", mole, Boolean.FALSE}, {foo, "overlappedby[2]", bar, Boolean.FALSE}, {foo, "overlappedby[6]", mole, Boolean.FALSE}, {foo, "not overlappedby[3]", bar, Boolean.FALSE}, {foo, "not overlappedby[3]", drool, Boolean.TRUE}, {foo, "not overlappedby[3]", mole, Boolean.TRUE}, {foo, "not overlappedby[2]", bar, Boolean.TRUE}, {foo, "not overlappedby[6]", mole, Boolean.TRUE}, {foo, "overlappedby[1,3]", bar, Boolean.TRUE}, {foo, "overlappedby[1,3]", drool, Boolean.FALSE}, {foo, "overlappedby[1,3]", mole, Boolean.FALSE}, {foo, "overlappedby[4,6]", bar, Boolean.FALSE}, {foo, "overlappedby[1,8]", mole, Boolean.FALSE}, {foo, "not overlappedby[1,3]", bar, Boolean.FALSE}, {foo, "not overlappedby[1,3]", drool, Boolean.TRUE}, {foo, "not overlappedby[1,3]", mole, Boolean.TRUE}, {foo, "not overlappedby[4,6]", bar, Boolean.TRUE}, {foo, "not overlappedby[1,8]", mole, Boolean.TRUE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    private void runEvaluatorTest(Object[][] data, ValueType valueType) {
        MockExtractor extractor = new MockExtractor();
        for (int i = 0; i < data.length; ++i) {
            Object[] row = data[i];
            boolean isNegated = ((String)row[1]).startsWith("not ");
            String evaluatorStr = isNegated ? ((String)row[1]).substring(4) : (String)row[1];
            boolean isConstrained = evaluatorStr.endsWith("]");
            String parameters = null;
            if (isConstrained) {
                parameters = evaluatorStr.split("\\[")[1];
                evaluatorStr = evaluatorStr.split("\\[")[0];
                parameters = parameters.split("\\]")[0];
            }
            EvaluatorDefinition evalDef = this.registry.getEvaluatorDefinition(evaluatorStr);
            Assert.assertNotNull((Object)evalDef);
            Evaluator evaluator = evalDef.getEvaluator(valueType, evaluatorStr, isNegated, parameters);
            this.checkEvaluatorMethodWith2Extractors(valueType, extractor, row, evaluator);
            this.checkEvaluatorMethodCachedRight(valueType, extractor, row, evaluator);
            this.checkEvaluatorMethodCachedLeft(valueType, extractor, row, evaluator);
            this.checkEvaluatorMethodWithFieldValue(valueType, extractor, row, evaluator);
            Assert.assertEquals((Object)valueType, (Object)evaluator.getValueType());
        }
    }

    private void checkEvaluatorMethodWith2Extractors(ValueType valueType, InternalReadAccessor extractor, Object[] row, Evaluator evaluator) {
        boolean result = evaluator.evaluate(null, extractor, row[0], extractor, row[2]);
        String message = "The evaluator type: [" + valueType + "] with 2 extractors incorrectly returned " + result + " for [" + row[0] + " " + row[1] + " " + row[2] + "]. It was asserted to return " + row[3];
        if (row[3] == Boolean.TRUE) {
            Assert.assertTrue((String)message, (boolean)result);
        } else {
            Assert.assertFalse((String)message, (boolean)result);
        }
    }

    private void checkEvaluatorMethodCachedRight(ValueType valueType, InternalReadAccessor extractor, Object[] row, Evaluator evaluator) {
        VariableRestriction.VariableContextEntry context = this.getContextEntry(evaluator, extractor, valueType, row);
        boolean result = evaluator.evaluateCachedRight(null, context, row[2]);
        String message = "The evaluator type: [" + valueType + "] with CachedRight incorrectly returned " + result + " for [" + row[0] + " " + row[1] + " " + row[2] + "]. It was asserted to return " + row[3];
        if (row[3] == Boolean.TRUE) {
            Assert.assertTrue((String)message, (boolean)result);
        } else {
            Assert.assertFalse((String)message, (boolean)result);
        }
    }

    private void checkEvaluatorMethodCachedLeft(ValueType valueType, InternalReadAccessor extractor, Object[] row, Evaluator evaluator) {
        VariableRestriction.VariableContextEntry context = this.getContextEntry(evaluator, extractor, valueType, row);
        boolean result = evaluator.evaluateCachedLeft(null, context, row[0]);
        String message = "The evaluator type: [" + valueType + "] with CachedLeft incorrectly returned " + result + " for [" + row[0] + " " + row[1] + " " + row[2] + "]. It was asserted to return " + row[3];
        if (row[3] == Boolean.TRUE) {
            Assert.assertTrue((String)message, (boolean)result);
        } else {
            Assert.assertFalse((String)message, (boolean)result);
        }
    }

    private void checkEvaluatorMethodWithFieldValue(ValueType valueType, InternalReadAccessor extractor, Object[] row, Evaluator evaluator) {
        FieldValue value = FieldFactory.getInstance().getFieldValue(row[2]);
        RuntimeDroolsException exc = null;
        try {
            evaluator.evaluate(null, extractor, row[0], value);
        }
        catch (RuntimeDroolsException e) {
            exc = e;
        }
        Assert.assertNotNull((Object)((Object)exc));
    }

    private VariableRestriction.VariableContextEntry getContextEntry(Evaluator evaluator, InternalReadAccessor extractor, ValueType valueType, Object[] row) {
        Declaration declaration = new Declaration("test", extractor, null);
        ValueType coerced = evaluator.getCoercedValueType();
        if (coerced.isIntegerNumber()) {
            VariableRestriction.LongVariableContextEntry context = new VariableRestriction.LongVariableContextEntry(extractor, declaration, evaluator);
            if (row[2] == null) {
                context.leftNull = true;
            } else {
                context.left = ((Number)row[2]).longValue();
            }
            if (row[0] == null) {
                context.rightNull = true;
            } else {
                context.right = ((Number)row[0]).longValue();
            }
            return context;
        }
        if (coerced.isChar()) {
            VariableRestriction.CharVariableContextEntry context = new VariableRestriction.CharVariableContextEntry(extractor, declaration, evaluator);
            if (row[2] == null) {
                context.leftNull = true;
            } else {
                context.left = ((Character)row[2]).charValue();
            }
            if (row[0] == null) {
                context.rightNull = true;
            } else {
                context.right = ((Character)row[0]).charValue();
            }
            return context;
        }
        if (coerced.isBoolean()) {
            VariableRestriction.BooleanVariableContextEntry context = new VariableRestriction.BooleanVariableContextEntry(extractor, declaration, evaluator);
            if (row[2] == null) {
                context.leftNull = true;
            } else {
                context.left = (Boolean)row[2];
            }
            if (row[0] == null) {
                context.rightNull = true;
            } else {
                context.right = (Boolean)row[0];
            }
            return context;
        }
        if (coerced.isFloatNumber()) {
            VariableRestriction.DoubleVariableContextEntry context = new VariableRestriction.DoubleVariableContextEntry(extractor, declaration, evaluator);
            if (row[2] == null) {
                context.leftNull = true;
            } else {
                context.left = ((Number)row[2]).doubleValue();
            }
            if (row[0] == null) {
                context.rightNull = true;
            } else {
                context.right = ((Number)row[0]).doubleValue();
            }
            return context;
        }
        VariableRestriction.ObjectVariableContextEntry context = new VariableRestriction.ObjectVariableContextEntry(extractor, declaration, evaluator);
        if (row[2] == null) {
            context.leftNull = true;
        } else {
            context.left = row[2];
        }
        if (row[0] == null) {
            context.rightNull = true;
        } else {
            context.right = row[0];
        }
        return context;
    }

    public static class MockExtractor
    implements InternalReadAccessor {
        private static final long serialVersionUID = 510L;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public boolean isSelfReference() {
            return false;
        }

        public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? (Boolean)object : false;
        }

        public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).byteValue() : (byte)0;
        }

        public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Character)object).charValue() : (char)'\u0000';
        }

        public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).doubleValue() : 0.0;
        }

        public Class<?> getExtractToClass() {
            return null;
        }

        public String getExtractToClassName() {
            return null;
        }

        public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).floatValue() : 0.0f;
        }

        public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).intValue() : 0;
        }

        public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).longValue() : 0L;
        }

        public Method getNativeReadMethod() {
            return null;
        }

        public String getNativeReadMethodName() {
            return null;
        }

        public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).shortValue() : (short)0;
        }

        public Object getValue(InternalWorkingMemory workingMemory, Object object) {
            return object;
        }

        public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
            return object == null;
        }

        public ValueType getValueType() {
            return null;
        }

        public int getIndex() {
            return 0;
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean getBooleanValue(Object object) {
            return false;
        }

        public byte getByteValue(Object object) {
            return 0;
        }

        public char getCharValue(Object object) {
            return '\u0000';
        }

        public double getDoubleValue(Object object) {
            return 0.0;
        }

        public float getFloatValue(Object object) {
            return 0.0f;
        }

        public int getHashCode(Object object) {
            return 0;
        }

        public int getIntValue(Object object) {
            return 0;
        }

        public long getLongValue(Object object) {
            return 0L;
        }

        public short getShortValue(Object object) {
            return 0;
        }

        public Object getValue(Object object) {
            return null;
        }

        public boolean isNullValue(Object object) {
            return false;
        }

        public BigDecimal getBigDecimalValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public BigInteger getBigIntegerValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public BigDecimal getBigDecimalValue(Object object) {
            return null;
        }

        public BigInteger getBigIntegerValue(Object object) {
            return null;
        }
    }
}

