/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test.dsl;

import java.util.ArrayList;
import java.util.List;
import org.drools.reteoo.test.dsl.DslStep;
import org.drools.reteoo.test.dsl.NodeTestDef;
import org.junit.runner.Description;

public class NodeTestCase {
    public static final String SUFFIX = ".nodeTestCase";
    private String name;
    private List<String> imports;
    private List<DslStep> setup;
    private List<DslStep> tearDown;
    private List<NodeTestDef> tests;
    private List<String> errors;
    private Description description;
    private String fileName;

    public NodeTestCase() {
        this("");
    }

    public NodeTestCase(String name) {
        this.name = name;
        this.imports = new ArrayList<String>();
        this.setup = new ArrayList<DslStep>();
        this.tearDown = new ArrayList<DslStep>();
        this.tests = new ArrayList<NodeTestDef>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addImport(String clazz) {
        this.imports.add(clazz);
    }

    public List<String> getImports() {
        return this.imports;
    }

    public List<DslStep> getSetup() {
        return this.setup;
    }

    public void addSetupStep(DslStep step) {
        this.setup.add(step);
    }

    public List<DslStep> getTearDown() {
        return this.tearDown;
    }

    public void addTearDownStep(DslStep step) {
        this.tearDown.add(step);
    }

    public List<NodeTestDef> getTests() {
        return this.tests;
    }

    public void addTest(NodeTestDef test) {
        this.tests.add(test);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public void setImports(List<String> imports) {
        this.imports = imports;
    }

    public void setSetup(List<DslStep> setup) {
        this.setup = setup;
    }

    public void setTearDown(List<DslStep> tearDown) {
        this.tearDown = tearDown;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = this.removeSuffix(fileName);
    }

    private String removeSuffix(String name) {
        return name;
    }
}

