/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassObjectType;
import org.drools.base.ValueType;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.MathUtils;
import org.drools.spi.AcceptsClassObjectType;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;

public class GlobalExtractor
implements Externalizable,
AcceptsClassObjectType,
InternalReadAccessor {
    private static final long serialVersionUID = 510L;
    private String identifier;
    private ObjectType objectType;

    public GlobalExtractor() {
    }

    public GlobalExtractor(String identifier, ObjectType objectType) {
        this.identifier = identifier;
        this.objectType = objectType;
    }

    @Override
    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return workingMemory.getGlobal(this.identifier);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.identifier);
        out.writeObject(this.objectType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.identifier = in.readUTF();
        this.objectType = (ObjectType)in.readObject();
    }

    @Override
    public void setClassObjectType(ClassObjectType objectType) {
        this.objectType = objectType;
    }

    public Class getExtractToClass() {
        if (this.objectType instanceof ClassObjectType) {
            return ((ClassObjectType)this.objectType).getClassType();
        }
        return this.objectType.getValueType().getClassType();
    }

    @Override
    public String getExtractToClassName() {
        if (this.objectType instanceof ClassObjectType) {
            return ((ClassObjectType)this.objectType).getClassName();
        }
        return this.objectType.getValueType().getClassType().getName();
    }

    @Override
    public ValueType getValueType() {
        return this.objectType.getValueType();
    }

    @Override
    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isBoolean()) {
            return (Boolean)workingMemory.getGlobal(this.identifier);
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a boolean.");
    }

    @Override
    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)workingMemory.getGlobal(this.identifier)).byteValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a byte.");
    }

    @Override
    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isChar()) {
            return ((Character)workingMemory.getGlobal(this.identifier)).charValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a char.");
    }

    @Override
    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)workingMemory.getGlobal(this.identifier)).doubleValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a double.");
    }

    @Override
    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)workingMemory.getGlobal(this.identifier)).floatValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a float.");
    }

    @Override
    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)workingMemory.getGlobal(this.identifier)).intValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into an int.");
    }

    @Override
    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)workingMemory.getGlobal(this.identifier)).longValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a long.");
    }

    @Override
    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)workingMemory.getGlobal(this.identifier)).shortValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.identifier + "' into a short.");
    }

    @Override
    public BigDecimal getBigDecimalValue(InternalWorkingMemory workingMemory, Object object) {
        return MathUtils.getBigDecimal(this.getValue(workingMemory, object));
    }

    @Override
    public BigInteger getBigIntegerValue(InternalWorkingMemory workingMemory, Object object) {
        return MathUtils.getBigInteger(this.getValue(workingMemory, object));
    }

    @Override
    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNativeReadMethodName() {
        return "getValue";
    }

    @Override
    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        Object value = this.getValue(workingMemory, object);
        return value != null ? value.hashCode() : 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.objectType == null ? 0 : this.objectType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalExtractor other = (GlobalExtractor)obj;
        if (this.objectType == null ? other.objectType != null : !this.objectType.equals(other.objectType)) {
            return false;
        }
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }

    @Override
    public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
        Object value = this.getValue(workingMemory, object);
        return value == null;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean isSelfReference() {
        return false;
    }

    @Override
    public boolean getBooleanValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public byte getByteValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public char getCharValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public double getDoubleValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public float getFloatValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public int getHashCode(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public int getIndex() {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public int getIntValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public long getLongValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public short getShortValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public Object getValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public BigDecimal getBigDecimalValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public BigInteger getBigIntegerValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public boolean isNullValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }
}

