/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.rule.GroupElement;
import org.drools.rule.Package;
import org.junit.Assert;
import org.junit.Test;

public class DroolsObjectIOTest {
    @Test
    public void testFileIO() throws Exception {
        FooBar fooBar1 = new FooBar();
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        new ObjectOutputStream(byteArrayOut).writeObject(fooBar1);
        ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(byteArrayOut.toByteArray());
        FooBar fooBar2 = (FooBar)new ObjectInputStream(byteArrayIn).readObject();
        File testFile = new File("target/test/DroolsObjectIOTest_testFileIO.dat");
        testFile.getParentFile().mkdirs();
        GroupElement testGroupElement = new GroupElement();
        DroolsStreamUtils.streamOut((OutputStream)new FileOutputStream(testFile), (Object)testGroupElement);
        FileInputStream fis = new FileInputStream(testFile);
        GroupElement streamedGroupElement = (GroupElement)DroolsStreamUtils.streamIn((InputStream)new FileInputStream(testFile));
        Assert.assertEquals((Object)streamedGroupElement, (Object)testGroupElement);
    }

    @Test
    public void testObject() throws Exception {
        SerializableObject obj = new ExternalizableObject();
        byte[] buf = DroolsObjectIOTest.serialize(obj);
        Assert.assertEquals((Object)DroolsObjectIOTest.deserialize(buf), (Object)obj);
        obj = new SerializableObject();
        buf = DroolsObjectIOTest.serialize(obj);
        Assert.assertEquals((Object)DroolsObjectIOTest.deserialize(buf), (Object)obj);
    }

    private static Object deserialize(byte[] buf) throws Exception {
        return new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(buf)).readObject();
    }

    private static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)bytes);
        out.writeObject(obj);
        out.flush();
        out.close();
        return bytes.toByteArray();
    }

    private static Object unmarshal(byte[] buf) throws Exception {
        return new ObjectInputStream(new ByteArrayInputStream(buf)).readObject();
    }

    private static byte[] marshal(Object obj) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(obj);
        out.flush();
        out.close();
        return bytes.toByteArray();
    }

    @Test
    public void testStreaming() throws Exception {
        Package pkg = new Package("test");
        byte[] buf = DroolsObjectIOTest.marshal(pkg);
        Assert.assertEquals((Object)DroolsObjectIOTest.unmarshal(buf), (Object)pkg);
        buf = DroolsObjectIOTest.serialize(pkg);
        Assert.assertEquals((Object)DroolsObjectIOTest.deserialize(buf), (Object)pkg);
    }

    public static class ExternalizableObject
    extends SerializableObject
    implements Externalizable {
        public ExternalizableObject() {
            super("ExternalizableObject");
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readInt();
            this.name = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value);
            out.writeObject(this.name);
        }
    }

    public static class SerializableObject
    implements Serializable {
        protected int value = 123;
        protected String name;

        public SerializableObject() {
            this("SerializableObject");
        }

        public SerializableObject(String name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SerializableObject) {
                return this.value == ((SerializableObject)obj).value;
            }
            return false;
        }

        public String toString() {
            return this.name + '|' + this.value;
        }
    }

    private static class FooBar
    implements Serializable {
        private String value = "hello";
    }
}

