/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.Agenda;
import org.drools.Cheese;
import org.drools.DroolsTestCase;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.base.ClassObjectType;
import org.drools.base.DefaultKnowledgeHelper;
import org.drools.beliefsystem.BeliefSet;
import org.drools.common.DefaultFactHandle;
import org.drools.common.EqualityKey;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LogicalDependency;
import org.drools.common.NamedEntryPoint;
import org.drools.common.PropagationContextImpl;
import org.drools.common.SimpleLogicalDependency;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.ObjectHashMap;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockObjectSink;
import org.drools.reteoo.MockRightTupleSink;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleSink;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.EntryPoint;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LogicalAssertionTest
extends DroolsTestCase {
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;

    @Before
    public void setUp() throws Exception {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        this.entryPoint = new EntryPointNode(0, (ObjectSource)this.ruleBase.getRete(), this.buildContext);
        this.entryPoint.attach(this.buildContext);
    }

    @Test
    public void testSingleLogicalRelationship() throws Exception {
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        MockRightTupleSink sink = new MockRightTupleSink();
        Rule rule1 = new Rule("test-rule1");
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), dep.getValue());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = (DefaultFactHandle)workingMemory.insert((Object)"o1");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        String logicalString = new String("logical");
        InternalFactHandle logicalHandle = (InternalFactHandle)workingMemory.insert((Object)logicalString, null, false, true, rule1, (Activation)tuple1.getObject());
        new RightTuple(logicalHandle, (RightTupleSink)sink);
        context1.setFactHandle((FactHandle)handle1);
        node.retractLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        workingMemory.executeQueuedActions();
        this.assertLength(1, sink.getRetracted());
        Object[] values = (Object[])sink.getRetracted().get(0);
        Assert.assertSame((Object)logicalHandle, (Object)((RightTuple)values[0]).getFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        logicalHandle = (InternalFactHandle)workingMemory.insert((Object)logicalString, null, false, true, rule1, (Activation)tuple1.getObject());
        new RightTuple(logicalHandle, (RightTupleSink)sink);
        agenda.fireNextItem(null);
        node.retractLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        workingMemory.executeQueuedActions();
        this.assertLength(2, sink.getRetracted());
        values = (Object[])sink.getRetracted().get(1);
        Assert.assertSame((Object)logicalHandle, (Object)((RightTuple)values[0]).getFactHandle());
    }

    @Test
    public void testEqualsMap() throws Exception {
        Rule rule1 = new Rule("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), dep.getValue());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        String logicalString1 = new String("logical");
        FactHandle logicalHandle1 = workingMemory.insert((Object)logicalString1, null, false, true, rule1, (Activation)tuple1.getObject());
        String logicalString2 = new String("logical");
        FactHandle logicalHandle2 = workingMemory.insert((Object)logicalString2, null, false, true, rule1, (Activation)tuple1.getObject());
        Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        logicalHandle1 = workingMemory.insert((Object)logicalString1);
        logicalHandle2 = workingMemory.insert((Object)logicalString2);
        if (RuleBaseConfiguration.AssertBehaviour.IDENTITY.equals((Object)this.ruleBase.getConfiguration().getAssertBehaviour())) {
            Assert.assertNotSame((Object)logicalHandle1, (Object)logicalHandle2);
        } else {
            Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        }
    }

    @Test
    public void testStatedOverride() throws Exception {
        Rule rule1 = new Rule("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), dep.getValue());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        String logicalString1 = new String("logical");
        FactHandle logicalHandle1 = workingMemory.insert((Object)logicalString1, null, false, true, rule1, (Activation)tuple1.getObject());
        String logicalString2 = new String("logical");
        FactHandle logicalHandle2 = workingMemory.insert((Object)logicalString2);
        node.retractLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        this.assertLength(0, sink.getRetracted());
        Assert.assertSame((Object)logicalHandle2, (Object)logicalHandle1);
        Assert.assertEquals((Object)logicalString1, (Object)workingMemory.getObject((org.kie.runtime.rule.FactHandle)logicalHandle2));
        Assert.assertNotSame((Object)logicalString1, (Object)workingMemory.getObject((org.kie.runtime.rule.FactHandle)logicalHandle2));
        node.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        logicalString2 = new String("logical");
        logicalHandle2 = workingMemory.insert((Object)logicalString2);
        logicalString1 = new String("logical");
        logicalHandle1 = workingMemory.insert((Object)logicalString1, null, false, true, rule1, (Activation)tuple1.getObject());
        Assert.assertNull((Object)logicalHandle1);
        logicalHandle1 = workingMemory.insert((Object)logicalString2, null, false, false, rule1, (Activation)tuple1.getObject());
        Assert.assertSame((Object)logicalHandle2, (Object)logicalHandle1);
        node.retractLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        this.assertLength(0, sink.getRetracted());
        Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        Assert.assertEquals((Object)logicalString1, (Object)workingMemory.getObject((org.kie.runtime.rule.FactHandle)logicalHandle2));
        Assert.assertNotSame((Object)logicalString1, (Object)workingMemory.getObject((org.kie.runtime.rule.FactHandle)logicalHandle2));
    }

    @Test
    public void testRetract() throws Exception {
        Rule rule1 = new Rule("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), dep.getValue());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        String logicalString1 = new String("logical");
        FactHandle logicalHandle1 = workingMemory.insert((Object)logicalString1, null, false, true, rule1, (Activation)tuple1.getObject());
        Rule rule2 = new Rule("test-rule2");
        RuleTerminalNode node2 = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(3), rule2, rule2.getLhs(), 0, this.buildContext);
        rule2.setConsequence(consequence);
        DefaultFactHandle handle2 = new DefaultFactHandle(2, (Object)"cheese");
        LeftTupleImpl tuple2 = new LeftTupleImpl((InternalFactHandle)handle2, null, true);
        node.assertLeftTuple((LeftTuple)tuple2, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        node2.assertLeftTuple((LeftTuple)tuple2, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        String logicalString2 = new String("logical");
        FactHandle logicalHandle2 = workingMemory.insert((Object)logicalString2, null, false, true, rule2, (Activation)tuple2.getObject());
        Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        TruthMaintenanceSystem tms = ((NamedEntryPoint)workingMemory.getWorkingMemoryEntryPoint(EntryPoint.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
        Assert.assertEquals((long)1L, (long)this.getLogicalCount(tms));
        workingMemory.retract((org.kie.runtime.rule.FactHandle)logicalHandle1);
        Assert.assertEquals((long)0L, (long)this.getLogicalCount(tms));
    }

    @Test
    public void testMultipleLogicalRelationships() throws FactException {
        Rule rule1 = new Rule("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockRightTupleSink sink = new MockRightTupleSink();
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), dep.getValue());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        Rule rule2 = new Rule("test-rule2");
        RuleTerminalNode node2 = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule2, rule2.getLhs(), 0, this.buildContext);
        rule2.setConsequence(consequence);
        DefaultFactHandle handle2 = new DefaultFactHandle(2, (Object)"cheese");
        LeftTupleImpl tuple2 = new LeftTupleImpl((InternalFactHandle)handle2, null, true);
        PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node2.assertLeftTuple((LeftTuple)tuple2, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        String logicalString1 = new String("logical");
        InternalFactHandle logicalHandle1 = (InternalFactHandle)workingMemory.insert((Object)logicalString1, (Object)"value1", false, true, rule1, (Activation)tuple1.getObject());
        new RightTuple(logicalHandle1, (RightTupleSink)sink);
        String logicalString2 = new String("logical");
        InternalFactHandle logicalHandle2 = (InternalFactHandle)workingMemory.insert((Object)logicalString2, (Object)"value2", false, true, rule2, (Activation)tuple2.getObject());
        Assert.assertSame((Object)logicalHandle1, (Object)logicalHandle2);
        TruthMaintenanceSystem tms = ((NamedEntryPoint)workingMemory.getWorkingMemoryEntryPoint(EntryPoint.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
        Assert.assertEquals((long)1L, (long)this.getLogicalCount(tms));
        BeliefSet bs = logicalHandle2.getEqualityKey().getBeliefSet();
        Assert.assertEquals((Object)"value1", (Object)((LogicalDependency)((LinkedListEntry)bs.getFirst()).getObject()).getValue());
        Assert.assertEquals((Object)"value2", (Object)((LogicalDependency)((LinkedListEntry)bs.getFirst().getNext()).getObject()).getValue());
        node2.retractLeftTuple((LeftTuple)tuple2, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        workingMemory.executeQueuedActions();
        this.assertLength(0, sink.getRetracted());
        Assert.assertEquals((long)1L, (long)this.getLogicalCount(tms));
        node.retractLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        workingMemory.executeQueuedActions();
        this.assertLength(1, sink.getRetracted());
        Assert.assertEquals((long)0L, (long)this.getLogicalCount(tms));
    }

    @Test
    public void testMultipleAssert() throws Exception {
        Rule rule1 = new Rule("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), dep.getValue());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        String statedString1 = new String("logical");
        FactHandle statedHandle1 = workingMemory.insert((Object)statedString1);
        String statedString2 = new String("logical");
        FactHandle statedHandle2 = workingMemory.insert((Object)statedString2);
        String logicalString3 = new String("logical");
        FactHandle logicalHandle3 = workingMemory.insert((Object)logicalString3, null, false, true, rule1, (Activation)tuple1.getObject());
        Assert.assertNull((Object)logicalHandle3);
        if (RuleBaseConfiguration.AssertBehaviour.IDENTITY.equals((Object)this.ruleBase.getConfiguration().getAssertBehaviour())) {
            workingMemory.retract((org.kie.runtime.rule.FactHandle)statedHandle2);
            logicalHandle3 = workingMemory.insert((Object)logicalString3, null, false, true, rule1, (Activation)tuple1.getObject());
            Assert.assertNull((Object)logicalHandle3);
        }
        workingMemory.retract((org.kie.runtime.rule.FactHandle)statedHandle1);
        logicalHandle3 = workingMemory.insert((Object)logicalString3, null, false, true, rule1, (Activation)tuple1.getObject());
        Assert.assertNotNull((Object)logicalHandle3);
    }

    @Test
    public void testMutableObject() {
        Rule rule1 = new Rule("test-rule1");
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        RuleTerminalNode node = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule1, rule1.getLhs(), 0, this.buildContext);
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Agenda agenda = workingMemory.getAgenda();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                LinkedList list = ((DefaultKnowledgeHelper)knowledgeHelper).getpreviousJustified();
                if (list != null) {
                    for (SimpleLogicalDependency dep = (SimpleLogicalDependency)list.getFirst(); dep != null; dep = (SimpleLogicalDependency)dep.getNext()) {
                        knowledgeHelper.insertLogical(dep.getObject(), dep.getValue());
                    }
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        rule1.setConsequence(consequence);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)"cheese");
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)handle1, null, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, null, null, (InternalFactHandle)new DefaultFactHandle());
        node.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        Cheese cheese = new Cheese("brie", 10);
        FactHandle cheeseHandle = workingMemory.insert((Object)cheese, null, false, true, rule1, (Activation)tuple1.getObject());
        cheese.setType("cheddar");
        cheese.setPrice(20);
        TruthMaintenanceSystem tms = ((NamedEntryPoint)workingMemory.getWorkingMemoryEntryPoint(EntryPoint.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
        Assert.assertEquals((long)1L, (long)this.getLogicalCount(tms));
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        workingMemory.retract((org.kie.runtime.rule.FactHandle)cheeseHandle);
        Assert.assertEquals((long)0L, (long)this.getLogicalCount(tms));
        Assert.assertEquals((long)0L, (long)tms.getEqualityKeyMap().size());
    }

    public int getLogicalCount(TruthMaintenanceSystem tms) {
        ObjectHashMap map = tms.getEqualityKeyMap();
        Iterator it = map.iterator();
        int i = 0;
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            EqualityKey key = (EqualityKey)entry.getKey();
            if (key.getStatus() == 2) {
                ++i;
            }
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
        return i;
    }
}

