/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.drools.Cheese;
import org.drools.DroolsTestCase;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.base.ClassObjectType;
import org.drools.base.ShadowProxy;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.ClassObjectTypeConf;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.MockObjectSink;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.EntryPoint;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReteTest
extends DroolsTestCase {
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;

    @Before
    public void setUp() throws Exception {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        this.entryPoint = new EntryPointNode(0, (ObjectSource)this.ruleBase.getRete(), this.buildContext);
        this.entryPoint.attach(this.buildContext);
    }

    @Test
    public void testObjectTypeNodes() throws Exception {
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(Object.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        ObjectTypeNode stringTypeNode = new ObjectTypeNode(2, this.entryPoint, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        stringTypeNode.attach(this.buildContext);
        List list = rete.getObjectTypeNodes();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(objectTypeNode));
        Assert.assertTrue((boolean)list.contains(stringTypeNode));
    }

    @Test
    public void testCache() throws FactException {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(List.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(Collection.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(ArrayList.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        DefaultFactHandle h1 = new DefaultFactHandle(1, new ArrayList());
        rete.assertObject((InternalFactHandle)h1, (PropagationContext)new PropagationContextImpl(0L, 0, null, null, null), (InternalWorkingMemory)workingMemory);
        h1.setObject(new LinkedList());
        rete.assertObject((InternalFactHandle)h1, (PropagationContext)new PropagationContextImpl(0L, 0, null, null, null), (InternalWorkingMemory)workingMemory);
        ClassObjectTypeConf conf = (ClassObjectTypeConf)workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.entryPoint.getEntryPoint(), new ArrayList());
        this.assertLength(3, conf.getObjectTypeNodes());
        conf = (ClassObjectTypeConf)workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.entryPoint.getEntryPoint(), new ArrayList());
        this.assertLength(3, conf.getObjectTypeNodes());
    }

    @Test
    public void testAssertObject() throws Exception {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(List.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink1 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink1);
        String string = "String";
        DefaultFactHandle h1 = new DefaultFactHandle(1, (Object)"String");
        rete.assertObject((InternalFactHandle)h1, (PropagationContext)new PropagationContextImpl(0L, 0, null, null, null), (InternalWorkingMemory)workingMemory);
        this.assertLength(0, sink1.getAsserted());
        ArrayList list = new ArrayList();
        DefaultFactHandle h2 = new DefaultFactHandle(1, list);
        rete.assertObject((InternalFactHandle)h2, (PropagationContext)new PropagationContextImpl(0L, 0, null, null, null), (InternalWorkingMemory)workingMemory);
        List asserted = sink1.getAsserted();
        this.assertLength(1, asserted);
        Object[] results = (Object[])asserted.get(0);
        Assert.assertSame(list, (Object)((DefaultFactHandle)results[0]).getObject());
    }

    @Test
    public void testAssertObjectWithNoMatchingObjectTypeNode() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Rete rete = this.ruleBase.getRete();
        Assert.assertEquals((long)0L, (long)rete.getObjectTypeNodes().size());
        ArrayList list = new ArrayList();
        workingMemory.insert(list);
        Assert.assertEquals((long)2L, (long)rete.getObjectTypeNodes().size());
    }

    @Test
    public void testHierarchy() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Rete rete = this.ruleBase.getRete();
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        ObjectTypeNode listOtn = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(List.class), this.buildContext);
        listOtn.attach(this.buildContext);
        FactHandle handle = workingMemory.insert(new ArrayList());
        Assert.assertEquals((long)3L, (long)rete.getObjectTypeNodes().size());
        Assert.assertSame((Object)listOtn, rete.getObjectTypeNodes(EntryPoint.DEFAULT).get(new ClassObjectType(List.class)));
        ClassObjectTypeConf arrayConf = (ClassObjectTypeConf)workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.entryPoint.getEntryPoint(), new ArrayList());
        ObjectTypeNode arrayOtn = arrayConf.getConcreteObjectTypeNode();
        Assert.assertEquals((long)2L, (long)arrayConf.getObjectTypeNodes().length);
        List<ObjectTypeNode> nodes = Arrays.asList(arrayConf.getObjectTypeNodes());
        Assert.assertEquals((long)2L, (long)nodes.size());
        Assert.assertTrue((boolean)nodes.contains(arrayOtn));
        Assert.assertTrue((boolean)nodes.contains(listOtn));
        workingMemory.retract((org.kie.runtime.rule.FactHandle)handle);
        MockObjectSink listSink = new MockObjectSink();
        listOtn.addObjectSink((ObjectSink)listSink);
        MockObjectSink arraySink = new MockObjectSink();
        listOtn.addObjectSink((ObjectSink)arraySink);
        workingMemory.insert(new ArrayList());
        Assert.assertEquals((long)1L, (long)listSink.getAsserted().size());
        Assert.assertEquals((long)1L, (long)arraySink.getAsserted().size());
        ObjectTypeNode collectionOtn = new ObjectTypeNode(idGenerator.getNextId(), this.entryPoint, (ObjectType)new ClassObjectType(Collection.class), this.buildContext);
        MockObjectSink collectionSink = new MockObjectSink();
        collectionOtn.addObjectSink((ObjectSink)collectionSink);
        collectionOtn.attach((BuildContext)new TestBuildContext(new InternalWorkingMemory[]{workingMemory}));
        Assert.assertEquals((long)1L, (long)collectionSink.getAsserted().size());
        nodes = Arrays.asList(arrayConf.getObjectTypeNodes());
        Assert.assertEquals((long)3L, (long)nodes.size());
        Assert.assertTrue((boolean)nodes.contains(arrayOtn));
        Assert.assertTrue((boolean)nodes.contains(listOtn));
        Assert.assertTrue((boolean)nodes.contains(collectionOtn));
    }

    @Test
    public void testRetractObject() throws Exception {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(List.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink1 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink1);
        String string = "String";
        DefaultFactHandle h1 = new DefaultFactHandle(1, (Object)"String");
        rete.assertObject((InternalFactHandle)h1, (PropagationContext)new PropagationContextImpl(0L, 0, null, null, null), (InternalWorkingMemory)workingMemory);
        this.assertLength(0, sink1.getAsserted());
        this.assertLength(0, sink1.getRetracted());
        ArrayList list = new ArrayList();
        DefaultFactHandle h2 = new DefaultFactHandle(1, list);
        rete.assertObject((InternalFactHandle)h2, (PropagationContext)new PropagationContextImpl(0L, 0, null, null, null), (InternalWorkingMemory)workingMemory);
        rete.retractObject((InternalFactHandle)h2, (PropagationContext)new PropagationContextImpl(0L, 0, null, null, null), (InternalWorkingMemory)workingMemory);
        List retracted = sink1.getRetracted();
        this.assertLength(1, retracted);
        Object[] results = (Object[])retracted.get(0);
        Assert.assertSame(list, (Object)((DefaultFactHandle)results[0]).getObject());
    }

    @Test
    public void testIsShadowed() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Rete rete = this.ruleBase.getRete();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(Cheese.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink1 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink1);
        Cheese cheese = new Cheese("brie", 15);
        DefaultFactHandle h1 = new DefaultFactHandle(1, (Object)cheese);
        rete.assertObject((InternalFactHandle)h1, (PropagationContext)new PropagationContextImpl(0L, 0, null, null, null), (InternalWorkingMemory)workingMemory);
        Object[] results = (Object[])sink1.getAsserted().get(0);
    }

    @Test
    public void testNotShadowed() {
        Properties properties = new Properties();
        properties.setProperty("drools.shadowProxyExcludes", "org.drools.Cheese");
        RuleBaseConfiguration conf = new RuleBaseConfiguration(properties);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        this.buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)ruleBase);
        Rete rete = ruleBase.getRete();
        EntryPointNode entryPoint = new EntryPointNode(0, (ObjectSource)rete, this.buildContext);
        entryPoint.attach(this.buildContext);
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, entryPoint, (ObjectType)new ClassObjectType(Cheese.class), this.buildContext);
        objectTypeNode.attach();
        MockObjectSink sink1 = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink1);
        Cheese cheese = new Cheese("brie", 15);
        DefaultFactHandle h1 = new DefaultFactHandle(1, (Object)cheese);
        rete.assertObject((InternalFactHandle)h1, (PropagationContext)new PropagationContextImpl(0L, 0, null, null, null), (InternalWorkingMemory)workingMemory);
        Object[] results = (Object[])sink1.getAsserted().get(0);
        Assert.assertFalse((boolean)(((DefaultFactHandle)results[0]).getObject() instanceof ShadowProxy));
    }

    public static class TestBuildContext
    extends BuildContext {
        InternalWorkingMemory[] workingMemories;

        TestBuildContext(InternalWorkingMemory[] workingMemories) {
            super(workingMemories[0] != null ? (InternalRuleBase)workingMemories[0].getRuleBase() : null, null);
            this.workingMemories = workingMemories;
        }

        public InternalWorkingMemory[] getWorkingMemories() {
            return this.workingMemories;
        }
    }
}

