/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.Cheese;
import org.drools.FactHandle;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.base.MapGlobalResolver;
import org.drools.common.EqualityKey;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NamedEntryPoint;
import org.drools.common.RuleBasePartitionId;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.common.WorkingMemoryAction;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.EntryPoint;
import org.drools.spi.GlobalResolver;
import org.junit.Assert;
import org.junit.Test;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.rule.SessionEntryPoint;

public class ReteooWorkingMemoryTest {
    @Test
    public void testBasicWorkingMemoryActions() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)RuleBaseFactory.newRuleBase().newStatefulSession();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)workingMemory.getWorkingMemoryEntryPoint(EntryPoint.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
        String string = "test";
        workingMemory.insert((Object)"test");
        FactHandle fd = workingMemory.insertLogical((Object)"test");
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        EqualityKey key = tms.get((Object)"test");
        Assert.assertSame((Object)fd, (Object)key.getFactHandle());
        Assert.assertEquals((long)1L, (long)key.size());
        workingMemory.update((org.kie.runtime.rule.FactHandle)fd, (Object)"test");
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        key = tms.get((Object)"test");
        Assert.assertSame((Object)fd, (Object)key.getFactHandle());
        Assert.assertEquals((long)1L, (long)key.size());
        workingMemory.retract((org.kie.runtime.rule.FactHandle)fd);
        Assert.assertEquals((long)0L, (long)tms.getEqualityKeyMap().size());
        key = tms.get((Object)"test");
        Assert.assertNull((Object)key);
        fd = workingMemory.insert((Object)"test");
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        key = tms.get((Object)"test");
        Assert.assertSame((Object)fd, (Object)key.getFactHandle());
        Assert.assertEquals((long)1L, (long)key.size());
    }

    @Test
    public void testId() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        Assert.assertEquals((long)0L, (long)workingMemory.getId());
        workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        Assert.assertEquals((long)1L, (long)workingMemory.getId());
    }

    @Test
    public void testGlobalResolver() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("global1", "value1");
        map.put("global2", "value2");
        MapGlobalResolver resolver = new MapGlobalResolver(map);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        workingMemory.setGlobalResolver((GlobalResolver)resolver);
        Assert.assertEquals((Object)"value1", (Object)workingMemory.getGlobal("global1"));
        Assert.assertEquals((Object)"value2", (Object)workingMemory.getGlobal("global2"));
    }

    @Test
    public void testObjectIterator() {
        Object object;
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        StatefulSession session = ruleBase.newStatefulSession();
        session.insert((Object)new Person("bob", 35));
        session.insert((Object)new Cheese("stilton", 35));
        session.insert((Object)new Cheese("brie", 35));
        session.insert((Object)new Person("steve", 55));
        session.insert((Object)new Person("tom", 100));
        int i = 0;
        Iterator it = session.iterateFactHandles();
        while (it.hasNext()) {
            object = it.next();
            if (i++ <= 5) continue;
            Assert.fail((String)"should not iterate for than 3 times");
        }
        i = 0;
        it = session.iterateObjects();
        while (it.hasNext()) {
            object = it.next();
            if (i++ <= 5) continue;
            Assert.fail((String)"should not iterate for than 3 times");
        }
    }

    @Test
    public void testExecuteQueueActions() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ReteooWorkingMemory wm = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        ReentrantAction action = new ReentrantAction();
        wm.queueWorkingMemoryAction((WorkingMemoryAction)action);
        wm.executeQueuedActions();
        Assert.assertEquals((long)2L, (long)action.counter.get());
    }

    @Test
    public void testDifferentEntryPointsOnSameFact() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ReteooRuleBase rbase = (ReteooRuleBase)((KnowledgeBaseImpl)kbase).getRuleBase();
        Rete rete = rbase.getRete();
        EntryPointNode epn = new EntryPointNode(rbase.getReteooBuilder().getIdGenerator().getNextId(), RuleBasePartitionId.MAIN_PARTITION, rbase.getConfiguration().isMultithreadEvaluation(), (ObjectSource)rete, new EntryPoint("xxx"));
        rbase.getRete().addObjectSink((ObjectSink)epn);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.kie.runtime.rule.FactHandle f1 = ksession.insert((Object)"f1");
        SessionEntryPoint ep = ksession.getEntryPoint("xxx");
        try {
            ep.update(f1, (Object)"s1");
            Assert.fail((String)"Should throw an exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ep.retract(f1);
            Assert.fail((String)"Should throw an exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ksession.update(f1, (Object)"s1");
        Assert.assertNotNull((Object)ksession.getObject(f1));
        ksession.retract(f1);
        ksession.retract(f1);
        Assert.assertNull((Object)ksession.getObject(f1));
    }

    private static class FinalAction
    extends ReentrantAction {
        public AtomicInteger counter;

        public FinalAction(AtomicInteger counter) {
            this.counter = counter;
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            this.counter.incrementAndGet();
            workingMemory.executeQueuedActions();
            workingMemory.executeQueuedActions();
        }
    }

    private static class ReentrantAction
    implements WorkingMemoryAction {
        public AtomicInteger counter = new AtomicInteger(0);

        private ReentrantAction() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void write(MarshallerWriteContext context) {
            throw new IllegalStateException("this method should never be called");
        }

        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            throw new IllegalStateException("this method should never be called");
        }

        public void execute(InternalWorkingMemory workingMemory) {
            Assert.assertEquals((long)0L, (long)this.counter.get());
            workingMemory.queueWorkingMemoryAction((WorkingMemoryAction)new FinalAction(this.counter));
            Assert.assertEquals((long)0L, (long)this.counter.get());
            workingMemory.queueWorkingMemoryAction((WorkingMemoryAction)new FinalAction(this.counter));
            Assert.assertEquals((long)0L, (long)this.counter.get());
            workingMemory.executeQueuedActions();
            Assert.assertEquals((long)0L, (long)this.counter.get());
            workingMemory.executeQueuedActions();
            Assert.assertEquals((long)0L, (long)this.counter.get());
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }
    }
}

