/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test.dsl;

import java.beans.IntrospectionException;
import java.util.HashSet;
import java.util.List;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.ClassTypeResolver;
import org.drools.base.DroolsQuery;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.base.evaluators.Operator;
import org.drools.rule.Declaration;
import org.drools.rule.MvelConstraintTestUtil;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;

public class ReteTesterHelper {
    private Package pkg;
    private ClassFieldAccessorStore store;
    private EvaluatorRegistry registry = new EvaluatorRegistry();
    private final ClassTypeResolver typeResolver;

    public ReteTesterHelper() {
        this.pkg = new Package("org.drools.examples.manners");
        this.pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store = this.pkg.getClassFieldAccessorStore();
        this.store.setEagerWire(true);
        this.typeResolver = new ClassTypeResolver(new HashSet(), this.getClass().getClassLoader());
    }

    public Package getPkg() {
        return this.pkg;
    }

    public ClassFieldAccessorStore getStore() {
        return this.store;
    }

    public EvaluatorRegistry getRegistry() {
        return this.registry;
    }

    public ClassTypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public BetaNodeFieldConstraint getBoundVariableConstraint(Class clazz, String fieldName, Declaration declaration, String evaluatorString) throws IntrospectionException {
        ClassFieldReader extractor = this.store.getReader(clazz, fieldName, this.getClass().getClassLoader());
        String expression = fieldName + " " + evaluatorString + " " + declaration.getIdentifier();
        return new MvelConstraintTestUtil(expression, declaration, (InternalReadAccessor)extractor);
    }

    public AlphaNodeFieldConstraint getLiteralConstraint(Pattern pattern, String fieldName, String evaluatorString, String value) throws IntrospectionException {
        Class clazz = ((ClassObjectType)pattern.getObjectType()).getClassType();
        ClassFieldReader extractor = this.store.getReader(clazz, fieldName, this.getClass().getClassLoader());
        FieldValue fieldValue = FieldFactory.getInstance().getFieldValue(value, extractor.getValueType(), null);
        return new MvelConstraintTestUtil(fieldName + evaluatorString + value, fieldValue, (InternalReadAccessor)extractor);
    }

    public Evaluator getEvaluator(Class<?> cls, String operator) {
        if (cls == DroolsQuery.class) {
            cls = Object.class;
        }
        return this.registry.getEvaluator(ValueType.determineValueType(cls), Operator.determineOperator((String)operator, (boolean)false));
    }

    public Pattern getPattern(int index, String type) throws ClassNotFoundException {
        return new Pattern(index, (ObjectType)new ClassObjectType(this.typeResolver.resolveType(type)));
    }

    public void addImports(List<String> imports) {
        this.typeResolver.clearImports();
        for (String importEntry : imports) {
            this.typeResolver.addImport(importEntry);
        }
    }
}

