/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.ArrayList;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalFactHandle;
import org.drools.common.SingleBetaConstraints;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.Iterator;
import org.drools.core.util.index.RightTupleIndexHashTable;
import org.drools.core.util.index.RightTupleList;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.RightTuple;
import org.drools.rule.Declaration;
import org.drools.rule.MvelConstraintTestUtil;
import org.drools.rule.Pattern;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RightTupleIndexHashTableIteratorTest {
    public static EvaluatorRegistry registry = new EvaluatorRegistry();

    @Test
    public void test1() {
        BetaNodeFieldConstraint constraint0 = this.getConstraint("d", Operator.EQUAL, "this", Foo.class);
        BetaNodeFieldConstraint[] constraints = new BetaNodeFieldConstraint[]{constraint0};
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        SingleBetaConstraints betaConstraints = null;
        betaConstraints = new SingleBetaConstraints(constraints, config);
        BetaMemory betaMemory = betaConstraints.createBetaMemory(config, (short)181);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        StatefulSession ss = rb.newStatefulSession();
        InternalFactHandle fh1 = (InternalFactHandle)ss.insert((Object)new Foo("brie", 1));
        InternalFactHandle fh2 = (InternalFactHandle)ss.insert((Object)new Foo("brie", 1));
        InternalFactHandle fh3 = (InternalFactHandle)ss.insert((Object)new Foo("soda", 1));
        InternalFactHandle fh4 = (InternalFactHandle)ss.insert((Object)new Foo("soda", 1));
        InternalFactHandle fh5 = (InternalFactHandle)ss.insert((Object)new Foo("bread", 3));
        InternalFactHandle fh6 = (InternalFactHandle)ss.insert((Object)new Foo("bread", 3));
        InternalFactHandle fh7 = (InternalFactHandle)ss.insert((Object)new Foo("cream", 3));
        InternalFactHandle fh8 = (InternalFactHandle)ss.insert((Object)new Foo("gorda", 15));
        InternalFactHandle fh9 = (InternalFactHandle)ss.insert((Object)new Foo("beer", 16));
        InternalFactHandle fh10 = (InternalFactHandle)ss.insert((Object)new Foo("mars", 0));
        InternalFactHandle fh11 = (InternalFactHandle)ss.insert((Object)new Foo("snicker", 0));
        InternalFactHandle fh12 = (InternalFactHandle)ss.insert((Object)new Foo("snicker", 0));
        InternalFactHandle fh13 = (InternalFactHandle)ss.insert((Object)new Foo("snicker", 0));
        betaMemory.getRightTupleMemory().add(new RightTuple(fh1, null));
        betaMemory.getRightTupleMemory().add(new RightTuple(fh2, null));
        betaMemory.getRightTupleMemory().add(new RightTuple(fh3, null));
        betaMemory.getRightTupleMemory().add(new RightTuple(fh4, null));
        betaMemory.getRightTupleMemory().add(new RightTuple(fh5, null));
        betaMemory.getRightTupleMemory().add(new RightTuple(fh6, null));
        betaMemory.getRightTupleMemory().add(new RightTuple(fh7, null));
        betaMemory.getRightTupleMemory().add(new RightTuple(fh8, null));
        betaMemory.getRightTupleMemory().add(new RightTuple(fh9, null));
        RightTupleIndexHashTable hashTable = (RightTupleIndexHashTable)betaMemory.getRightTupleMemory();
        RightTupleList rightTupleList = new RightTupleList();
        rightTupleList.add(new RightTuple(fh10, null));
        hashTable.getTable()[0] = rightTupleList;
        rightTupleList = new RightTupleList();
        rightTupleList.add(new RightTuple(fh11, null));
        rightTupleList.add(new RightTuple(fh12, null));
        rightTupleList.add(new RightTuple(fh13, null));
        ((RightTupleList)hashTable.getTable()[0]).setNext((Entry)rightTupleList);
        Entry[] table = hashTable.getTable();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < table.length; ++i) {
            if (table[i] == null) continue;
            ArrayList<Integer> entries = new ArrayList<Integer>();
            entries.add(i);
            for (Entry entry = table[i]; entry != null; entry = entry.getNext()) {
                entries.add((Integer)entry);
            }
            list.add(entries.toArray());
        }
        Assert.assertEquals((long)5L, (long)list.size());
        Object[] entries = (Object[])list.get(0);
        Assert.assertEquals((Object)0, (Object)entries[0]);
        Assert.assertEquals((long)3L, (long)entries.length);
        entries = (Object[])list.get(1);
        Assert.assertEquals((Object)102, (Object)entries[0]);
        Assert.assertEquals((long)2L, (long)entries.length);
        entries = (Object[])list.get(2);
        Assert.assertEquals((Object)103, (Object)entries[0]);
        Assert.assertEquals((long)2L, (long)entries.length);
        entries = (Object[])list.get(3);
        Assert.assertEquals((Object)115, (Object)entries[0]);
        Assert.assertEquals((long)3L, (long)entries.length);
        entries = (Object[])list.get(4);
        Assert.assertEquals((Object)117, (Object)entries[0]);
        Assert.assertEquals((long)3L, (long)entries.length);
        list = new ArrayList();
        Iterator it = betaMemory.getRightTupleMemory().iterator();
        RightTuple rightTuple = (RightTuple)it.next();
        while (rightTuple != null) {
            list.add(rightTuple);
            rightTuple = (RightTuple)it.next();
        }
        Assert.assertEquals((long)13L, (long)list.size());
    }

    @Test
    public void testLastBucketInTheTable() {
        Entry[] entries = new Entry[10];
        entries[0] = (Entry)Mockito.mock(RightTupleList.class);
        entries[5] = (Entry)Mockito.mock(RightTupleList.class);
        entries[9] = (Entry)Mockito.mock(RightTupleList.class);
        RightTuple[] tuples = new RightTuple[]{(RightTuple)Mockito.mock(RightTuple.class), (RightTuple)Mockito.mock(RightTuple.class), (RightTuple)Mockito.mock(RightTuple.class)};
        Mockito.when((Object)entries[0].getNext()).thenReturn(null);
        Mockito.when((Object)((RightTupleList)entries[0]).getFirst()).thenReturn((Object)tuples[0]);
        Mockito.when((Object)entries[5].getNext()).thenReturn(null);
        Mockito.when((Object)((RightTupleList)entries[5]).getFirst()).thenReturn((Object)tuples[1]);
        Mockito.when((Object)entries[9].getNext()).thenReturn(null);
        Mockito.when((Object)((RightTupleList)entries[9]).getFirst()).thenReturn((Object)tuples[2]);
        AbstractHashTable table = (AbstractHashTable)Mockito.mock(AbstractHashTable.class);
        Mockito.when((Object)table.getTable()).thenReturn((Object)entries);
        RightTupleIndexHashTable.FieldIndexHashTableFullIterator iterator = new RightTupleIndexHashTable.FieldIndexHashTableFullIterator(table);
        Assert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.sameInstance((Object)tuples[0]));
        Assert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.sameInstance((Object)tuples[1]));
        Assert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.sameInstance((Object)tuples[2]));
        Assert.assertThat((Object)iterator.next(), (Matcher)CoreMatchers.is((Object)null));
    }

    protected BetaNodeFieldConstraint getConstraint(String identifier, Operator operator, String fieldName, Class clazz) {
        ClassFieldAccessorStore store = new ClassFieldAccessorStore();
        store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        store.setEagerWire(true);
        ClassFieldReader extractor = store.getReader(clazz, fieldName, this.getClass().getClassLoader());
        Declaration declaration = new Declaration(identifier, (InternalReadAccessor)extractor, new Pattern(0, (ObjectType)new ClassObjectType(clazz)));
        String expression = fieldName + " " + operator.getOperatorString() + " " + declaration.getIdentifier();
        return new MvelConstraintTestUtil(expression, declaration, (InternalReadAccessor)extractor);
    }

    public static class Foo {
        private String val;
        private int hashCode;

        public Foo(String val, int hashCode) {
            this.val = val;
            this.hashCode = hashCode;
        }

        public String getVal() {
            return this.val;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Foo other = (Foo)obj;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            return !(this.val == null ? other.val != null : !this.val.equals(other.val));
        }
    }
}

