/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.RuleBaseConfiguration;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.ValueType;
import org.drools.common.AbstractRuleBase;
import org.drools.common.BaseNode;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.Memory;
import org.drools.common.MemoryFactory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.UpdateContext;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashSet;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.marshalling.impl.TimersInputMarshaller;
import org.drools.marshalling.impl.TimersOutputMarshaller;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.SegmentMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.compiled.CompiledNetwork;
import org.drools.rule.Declaration;
import org.drools.rule.EntryPoint;
import org.drools.rule.EvalCondition;
import org.drools.spi.Constraint;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.drools.time.Job;
import org.drools.time.JobContext;
import org.drools.time.JobHandle;
import org.drools.time.TimerService;
import org.drools.time.impl.DefaultJobHandle;
import org.drools.time.impl.PointInTimeTrigger;

public class ObjectTypeNode
extends ObjectSource
implements ObjectSink,
Externalizable,
MemoryFactory {
    private static final long serialVersionUID = 510L;
    private ObjectType objectType;
    private boolean objectMemoryEnabled;
    private long expirationOffset = -1L;
    public static final transient ExpireJob job = new ExpireJob();
    private boolean queryNode;
    private CompiledNetwork compiledNetwork;
    private transient boolean dirty;
    private transient int otnIdCounter;

    public int getOtnIdCounter() {
        return this.otnIdCounter;
    }

    public ObjectTypeNode() {
    }

    public ObjectTypeNode(int id, EntryPointNode source, ObjectType objectType, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), source, context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.objectType = objectType;
        this.setObjectMemoryEnabled(context.isObjectTypeNodeMemoryEnabled());
        if (ClassObjectType.DroolsQuery_ObjectType.isAssignableFrom(objectType)) {
            this.queryNode = true;
        }
        this.dirty = true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.objectType = (ObjectType)in.readObject();
        if (this.objectType instanceof ClassObjectType) {
            this.objectType = ((AbstractRuleBase)((DroolsObjectInputStream)in).getRuleBase()).getClassFieldAccessorCache().getClassObjectType((ClassObjectType)this.objectType);
        }
        this.objectMemoryEnabled = in.readBoolean();
        this.expirationOffset = in.readLong();
        this.queryNode = in.readBoolean();
        this.dirty = true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.objectType);
        out.writeBoolean(this.objectMemoryEnabled);
        out.writeLong(this.expirationOffset);
        out.writeBoolean(this.queryNode);
    }

    @Override
    public short getType() {
        return 30;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public long calculateDeclaredMask(List<String> settableProperties) {
        return 0L;
    }

    public boolean isAssignableFrom(ObjectType objectType) {
        return this.objectType.isAssignableFrom(objectType);
    }

    public void setCompiledNetwork(CompiledNetwork compiledNetwork) {
        this.compiledNetwork = compiledNetwork;
        this.compiledNetwork.setObjectTypeNode(this);
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.dirty) {
            this.otnIdCounter = 0;
            ObjectTypeNode.updateTupleSinkId(this, this);
            this.dirty = false;
        }
        if (this.objectMemoryEnabled && (!this.queryNode || ((DroolsQuery)factHandle.getObject()).isOpen())) {
            ObjectTypeNodeMemory memory = (ObjectTypeNodeMemory)workingMemory.getNodeMemory(this);
            memory.memory.add(factHandle, false);
        }
        if (this.compiledNetwork != null) {
            this.compiledNetwork.assertObject(factHandle, context, workingMemory);
        } else {
            this.sink.propagateAssertObject(factHandle, context, workingMemory);
        }
        if (context.getReaderContext() == null && this.objectType.isEvent() && this.expirationOffset >= 0L && this.expirationOffset != Long.MAX_VALUE) {
            ReteooWorkingMemory.WorkingMemoryReteExpireAction expire = new ReteooWorkingMemory.WorkingMemoryReteExpireAction(factHandle, this);
            TimerService clock = workingMemory.getTimerService();
            long nextTimestamp = Math.max(clock.getCurrentTime() + this.expirationOffset, ((EventFactHandle)factHandle).getStartTimestamp() + this.expirationOffset);
            ExpireJobContext jobctx = new ExpireJobContext(expire, workingMemory);
            JobHandle handle = clock.scheduleJob(job, jobctx, new PointInTimeTrigger(nextTimestamp, null, null));
            jobctx.setJobHandle(handle);
        }
    }

    public void retractObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.dirty) {
            this.otnIdCounter = 0;
            ObjectTypeNode.updateTupleSinkId(this, this);
            this.dirty = false;
        }
        if (this.objectMemoryEnabled && (!this.queryNode || ((DroolsQuery)factHandle.getObject()).isOpen())) {
            ObjectTypeNodeMemory memory = (ObjectTypeNodeMemory)workingMemory.getNodeMemory(this);
            memory.memory.remove(factHandle);
        }
        for (RightTuple rightTuple = factHandle.getFirstRightTuple(); rightTuple != null; rightTuple = rightTuple.getHandleNext()) {
            rightTuple.getRightTupleSink().retractRightTuple(rightTuple, context, workingMemory);
        }
        factHandle.clearRightTuples();
        for (LeftTuple leftTuple = factHandle.getFirstLeftTuple(); leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
            ((LeftInputAdapterNode)leftTuple.getLeftTupleSink().getLeftTupleSource()).retractLeftTuple(leftTuple, context, workingMemory);
        }
        factHandle.clearLeftTuples();
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.dirty) {
            this.otnIdCounter = 0;
            ObjectTypeNode.updateTupleSinkId(this, this);
            this.dirty = false;
        }
        context.setObjectType(this.objectType);
        if (this.compiledNetwork != null) {
            this.compiledNetwork.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
        } else {
            this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
        }
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectTypeNodeMemory memory = (ObjectTypeNodeMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.memory.iterator();
        ObjectHashSet.ObjectEntry entry = (ObjectHashSet.ObjectEntry)it.next();
        while (entry != null) {
            sink.assertObject((InternalFactHandle)entry.getValue(), context, workingMemory);
            entry = (ObjectHashSet.ObjectEntry)it.next();
        }
    }

    @Override
    public void attach(BuildContext context) {
        this.source.addObjectSink(this);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            propagationContext.setEntryPoint(((EntryPointNode)this.source).getEntryPoint());
            this.source.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.dirty = true;
    }

    private static void updateTupleSinkId(ObjectTypeNode otn, ObjectSource source) {
        for (ObjectSink sink : source.sink.getSinks()) {
            if (sink instanceof BetaNode) {
                ((BetaNode)sink).setRightInputOtnId(otn.nextOtnId());
                continue;
            }
            if (sink instanceof LeftInputAdapterNode) {
                for (LeftTupleSink liaChildSink : ((LeftInputAdapterNode)sink).getSinkPropagator().getSinks()) {
                    liaChildSink.setLeftInputOtnId(otn.nextOtnId());
                }
                continue;
            }
            if (!(sink instanceof AlphaNode)) continue;
            ObjectTypeNode.updateTupleSinkId(otn, (AlphaNode)sink);
        }
    }

    public int nextOtnId() {
        return this.otnIdCounter++;
    }

    @Override
    public void remove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        this.doRemove(context, builder, node, workingMemories);
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (context.getCleanupAdapter() != null) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                RuleRemovalContext.CleanupAdapter adapter = context.getCleanupAdapter();
                ObjectTypeNodeMemory memory = (ObjectTypeNodeMemory)workingMemory.getNodeMemory(this);
                Iterator it = memory.memory.iterator();
                ObjectHashSet.ObjectEntry entry = (ObjectHashSet.ObjectEntry)it.next();
                while (entry != null) {
                    InternalFactHandle handle = (InternalFactHandle)entry.getValue();
                    for (LeftTuple leftTuple = handle.getFirstLeftTuple(); leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
                        adapter.cleanUp(leftTuple, workingMemory);
                    }
                    entry = (ObjectHashSet.ObjectEntry)it.next();
                }
            }
            context.setCleanupAdapter(null);
        }
        if (!node.isInUse()) {
            this.removeObjectSink((ObjectSink)((Object)node));
        }
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config) {
        return new ObjectTypeNodeMemory();
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemoryEnabled;
    }

    public void setObjectMemoryEnabled(boolean objectMemoryEnabled) {
        this.objectMemoryEnabled = objectMemoryEnabled;
    }

    @Override
    public String toString() {
        return "[ObjectTypeNode(" + this.id + ")::" + ((EntryPointNode)this.source).getEntryPoint() + " objectType=" + this.objectType + " expiration=" + this.expirationOffset + "ms ]";
    }

    @Override
    public int hashCode() {
        return this.objectType.hashCode() ^ this.source.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ObjectTypeNode)) {
            return false;
        }
        ObjectTypeNode other = (ObjectTypeNode)object;
        return this.objectType.equals(other.objectType) && this.source.equals(other.source);
    }

    private boolean usesDeclaration(Constraint[] constraints) {
        boolean usesDecl = false;
        for (int i = 0; !usesDecl && i < constraints.length; ++i) {
            usesDecl = this.usesDeclaration(constraints[i]);
        }
        return usesDecl;
    }

    private boolean usesDeclaration(Constraint constraint) {
        boolean usesDecl = false;
        Declaration[] declarations = constraint.getRequiredDeclarations();
        for (int j = 0; !usesDecl && j < declarations.length; ++j) {
            usesDecl = declarations[j].getPattern().getObjectType() == this.objectType;
        }
        return usesDecl;
    }

    private boolean usesDeclaration(EvalCondition condition) {
        boolean usesDecl = false;
        Declaration[] declarations = condition.getRequiredDeclarations();
        for (int j = 0; !usesDecl && j < declarations.length; ++j) {
            usesDecl = declarations[j].getPattern().getObjectType() == this.objectType;
        }
        return usesDecl;
    }

    public EntryPoint getEntryPoint() {
        return ((EntryPointNode)this.source).getEntryPoint();
    }

    public long getExpirationOffset() {
        return this.expirationOffset;
    }

    public void setExpirationOffset(long expirationOffset) {
        this.expirationOffset = expirationOffset;
        if (!this.objectType.getValueType().equals(ValueType.QUERY_TYPE)) {
            if (this.expirationOffset > 0L) {
                this.setObjectMemoryEnabled(true);
            } else if (this.expirationOffset == 0L) {
                this.setObjectMemoryEnabled(false);
            }
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("This should never get called, as the PropertyReactive first happens at the AlphaNode");
    }

    public static class ObjectTypeNodeMemory
    implements Memory {
        public ObjectHashSet memory = new ObjectHashSet();

        @Override
        public short getNodeType() {
            return 30;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrevious(Memory previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNext(Memory next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getNext() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ExpireJobContextTimerInputMarshaller
    implements TimersInputMarshaller {
        @Override
        public void read(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
            InternalFactHandle factHandle = inCtx.handles.get(inCtx.readInt());
            String entryPointId = inCtx.readUTF();
            EntryPointNode epn = ((ReteooRuleBase)inCtx.wm.getRuleBase()).getRete().getEntryPointNode(new EntryPoint(entryPointId));
            String className = inCtx.readUTF();
            Class cls = ((ReteooRuleBase)inCtx.wm.getRuleBase()).getRootClassLoader().loadClass(className);
            ObjectTypeNode otn = epn.getObjectTypeNodes().get(new ClassObjectType(cls));
            long nextTimeStamp = inCtx.readLong();
            TimerService clock = inCtx.wm.getTimerService();
            ExpireJobContext jobctx = new ExpireJobContext(new ReteooWorkingMemory.WorkingMemoryReteExpireAction(factHandle, otn), inCtx.wm);
            JobHandle handle = clock.scheduleJob(job, jobctx, new PointInTimeTrigger(nextTimeStamp, null, null));
            jobctx.setJobHandle(handle);
        }

        @Override
        public void deserialize(MarshallerReaderContext inCtx, ProtobufMessages.Timers.Timer _timer) throws ClassNotFoundException {
            ProtobufMessages.Timers.ExpireTimer _expire = _timer.getExpire();
            InternalFactHandle factHandle = inCtx.handles.get(_expire.getHandleId());
            EntryPointNode epn = ((ReteooRuleBase)inCtx.wm.getRuleBase()).getRete().getEntryPointNode(new EntryPoint(_expire.getEntryPointId()));
            Class cls = ((ReteooRuleBase)inCtx.wm.getRuleBase()).getRootClassLoader().loadClass(_expire.getClassName());
            ObjectTypeNode otn = epn.getObjectTypeNodes().get(new ClassObjectType(cls));
            TimerService clock = inCtx.wm.getTimerService();
            ExpireJobContext jobctx = new ExpireJobContext(new ReteooWorkingMemory.WorkingMemoryReteExpireAction(factHandle, otn), inCtx.wm);
            JobHandle handle = clock.scheduleJob(job, jobctx, new PointInTimeTrigger(_expire.getNextFireTimestamp(), null, null));
            jobctx.setJobHandle(handle);
        }
    }

    public static class ExpireJobContextTimerOutputMarshaller
    implements TimersOutputMarshaller {
        @Override
        public void write(JobContext jobCtx, MarshallerWriteContext outputCtx) throws IOException {
            outputCtx.writeShort(54);
            ExpireJobContext ejobCtx = (ExpireJobContext)jobCtx;
            ReteooWorkingMemory.WorkingMemoryReteExpireAction expireAction = ejobCtx.getExpireAction();
            outputCtx.writeInt(expireAction.getFactHandle().getId());
            outputCtx.writeUTF(expireAction.getNode().getEntryPoint().getEntryPointId());
            outputCtx.writeUTF(((ClassObjectType)expireAction.getNode().getObjectType()).getClassType().getName());
            DefaultJobHandle jobHandle = (DefaultJobHandle)ejobCtx.getJobHandle();
            PointInTimeTrigger trigger = (PointInTimeTrigger)jobHandle.getTimerJobInstance().getTrigger();
            outputCtx.writeLong(trigger.hasNextFireTime().getTime());
        }

        @Override
        public ProtobufMessages.Timers.Timer serialize(JobContext jobCtx, MarshallerWriteContext outputCtx) {
            ExpireJobContext ejobCtx = (ExpireJobContext)jobCtx;
            ReteooWorkingMemory.WorkingMemoryReteExpireAction expireAction = ejobCtx.getExpireAction();
            DefaultJobHandle jobHandle = (DefaultJobHandle)ejobCtx.getJobHandle();
            PointInTimeTrigger trigger = (PointInTimeTrigger)jobHandle.getTimerJobInstance().getTrigger();
            return ProtobufMessages.Timers.Timer.newBuilder().setType(ProtobufMessages.Timers.TimerType.EXPIRE).setExpire(ProtobufMessages.Timers.ExpireTimer.newBuilder().setHandleId(expireAction.getFactHandle().getId()).setEntryPointId(expireAction.getNode().getEntryPoint().getEntryPointId()).setClassName(((ClassObjectType)expireAction.getNode().getObjectType()).getClassType().getName()).setNextFireTimestamp(trigger.hasNextFireTime().getTime()).build()).build();
        }
    }

    public static class ExpireJobContext
    implements JobContext,
    Externalizable {
        public ReteooWorkingMemory.WorkingMemoryReteExpireAction expireAction;
        public InternalWorkingMemory workingMemory;
        public JobHandle handle;

        public ExpireJobContext(ReteooWorkingMemory.WorkingMemoryReteExpireAction expireAction, InternalWorkingMemory workingMemory) {
            this.expireAction = expireAction;
            this.workingMemory = workingMemory;
        }

        @Override
        public JobHandle getJobHandle() {
            return this.handle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.handle = jobHandle;
        }

        public ReteooWorkingMemory.WorkingMemoryReteExpireAction getExpireAction() {
            return this.expireAction;
        }

        public void setExpireAction(ReteooWorkingMemory.WorkingMemoryReteExpireAction expireAction) {
            this.expireAction = expireAction;
        }

        public InternalWorkingMemory getWorkingMemory() {
            return this.workingMemory;
        }

        public void setWorkingMemory(InternalWorkingMemory workingMemory) {
            this.workingMemory = workingMemory;
        }

        public JobHandle getHandle() {
            return this.handle;
        }

        public void setHandle(JobHandle handle) {
            this.handle = handle;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    public static class ExpireJob
    implements Job {
        @Override
        public void execute(JobContext ctx) {
            ExpireJobContext context = (ExpireJobContext)ctx;
            context.workingMemory.queueWorkingMemoryAction(context.expireAction);
        }
    }
}

