/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.Cheese;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.FieldFactory;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.common.InternalFactHandle;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.rule.MvelConstraintTestUtil;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.Consequence;
import org.drools.spi.Constraint;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ObjectType;
import org.junit.Assert;
import org.junit.Test;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.event.rule.AfterMatchFiredEvent;
import org.kie.event.rule.AgendaEventListener;
import org.kie.event.rule.AgendaGroupPoppedEvent;
import org.kie.event.rule.AgendaGroupPushedEvent;
import org.kie.event.rule.BeforeMatchFiredEvent;
import org.kie.event.rule.MatchCancelledCause;
import org.kie.event.rule.MatchCancelledEvent;
import org.kie.event.rule.MatchCreatedEvent;
import org.kie.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.rule.FactHandle;

public class AgendaEventSupportTest {
    public static EvaluatorRegistry registry = new EvaluatorRegistry();

    @Test
    public void testAgendaEventListener() throws Exception {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Package pkg = new Package("org.drools.test");
        Rule rule = new Rule("test1");
        rule.setAgendaGroup("test group");
        ClassObjectType cheeseObjectType = new ClassObjectType(Cheese.class);
        Pattern pattern = new Pattern(0, (ObjectType)cheeseObjectType);
        pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        pkg.getClassFieldAccessorStore().setEagerWire(true);
        ClassFieldReader extractor = pkg.getClassFieldAccessorStore().getReader(Cheese.class, "type", this.getClass().getClassLoader());
        FieldValue field = FieldFactory.getInstance().getFieldValue((Object)"cheddar");
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("type == \"cheddar\"", field, (InternalReadAccessor)extractor);
        pattern.addConstraint((Constraint)constraint);
        rule.addPattern((RuleConditionElement)pattern);
        rule.setConsequence(new Consequence(){

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return null;
            }
        });
        pkg.addRule(rule);
        ArrayList<KnowledgePackageImp> pkgs = new ArrayList<KnowledgePackageImp>();
        pkgs.add(new KnowledgePackageImp(pkg));
        kbase.addKnowledgePackages(pkgs);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        final ArrayList agendaList = new ArrayList();
        AgendaEventListener agendaEventListener = new AgendaEventListener(){

            public void matchCancelled(MatchCancelledEvent event) {
                Assert.assertNotNull((Object)event.getKieRuntime());
                agendaList.add(event);
            }

            public void matchCreated(MatchCreatedEvent event) {
                Assert.assertNotNull((Object)event.getKieRuntime());
                agendaList.add(event);
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
                Assert.assertNotNull((Object)event.getKieRuntime());
                agendaList.add(event);
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
                Assert.assertNotNull((Object)event.getKieRuntime());
                agendaList.add(event);
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
                Assert.assertNotNull((Object)event.getKieRuntime());
                agendaList.add(event);
            }

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
                Assert.assertNotNull((Object)event.getKieRuntime());
                agendaList.add(event);
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                Assert.assertNotNull((Object)event.getKieRuntime());
                agendaList.add(event);
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                Assert.assertNotNull((Object)event.getKieRuntime());
                agendaList.add(event);
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
                Assert.assertNotNull((Object)event.getKieRuntime());
                agendaList.add(event);
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
                Assert.assertNotNull((Object)event.getKieRuntime());
                agendaList.add(event);
            }
        };
        ksession.addEventListener(agendaEventListener);
        Assert.assertEquals((long)1L, (long)ksession.getAgendaEventListeners().size());
        Cheese cheddar = new Cheese("cheddar", 15);
        FactHandle cheddarHandle = ksession.insert((Object)cheddar);
        Assert.assertEquals((long)1L, (long)agendaList.size());
        MatchCreatedEvent createdEvent = (MatchCreatedEvent)agendaList.get(0);
        Assert.assertSame((Object)cheddarHandle, (Object)createdEvent.getMatch().getFactHandles().toArray()[0]);
        ksession.getAgenda().clear();
        MatchCancelledEvent cancelledEvent = (MatchCancelledEvent)agendaList.get(1);
        Assert.assertEquals((Object)MatchCancelledCause.CLEAR, (Object)cancelledEvent.getCause());
        agendaList.clear();
        cheddar.setPrice(14);
        ksession.update(cheddarHandle, (Object)cheddar);
        Assert.assertEquals((long)1L, (long)agendaList.size());
        createdEvent = (MatchCreatedEvent)agendaList.get(0);
        Assert.assertSame((Object)cheddarHandle, (Object)createdEvent.getMatch().getFactHandles().toArray()[0]);
        agendaList.clear();
        cheddar.setPrice(14);
        ksession.update(cheddarHandle, (Object)cheddar);
        Assert.assertEquals((long)0L, (long)agendaList.size());
        ksession.retract(cheddarHandle);
        Assert.assertEquals((long)1L, (long)agendaList.size());
        cancelledEvent = (MatchCancelledEvent)agendaList.get(0);
        Assert.assertNotNull((Object)((InternalFactHandle)cancelledEvent.getMatch().getFactHandles().toArray()[0]).getObject());
        cheddarHandle = ksession.insert((Object)cheddar);
        agendaList.clear();
        ksession.getAgenda().getAgendaGroup("test group").setFocus();
        Assert.assertEquals((long)1L, (long)agendaList.size());
        AgendaGroupPushedEvent pushedEvent = (AgendaGroupPushedEvent)agendaList.get(0);
        Assert.assertEquals((Object)"test group", (Object)pushedEvent.getAgendaGroup().getName());
        agendaList.clear();
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)agendaList.size());
        BeforeMatchFiredEvent beforeEvent = (BeforeMatchFiredEvent)agendaList.get(0);
        Assert.assertSame((Object)cheddarHandle, (Object)beforeEvent.getMatch().getFactHandles().toArray()[0]);
        AfterMatchFiredEvent afterEvent = (AfterMatchFiredEvent)agendaList.get(1);
        Assert.assertSame((Object)cheddarHandle, (Object)afterEvent.getMatch().getFactHandles().toArray()[0]);
        AgendaGroupPoppedEvent poppedEvent = (AgendaGroupPoppedEvent)agendaList.get(2);
        Assert.assertEquals((Object)"test group", (Object)poppedEvent.getAgendaGroup().getName());
    }
}

