/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.List;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.base.ClassObjectType;
import org.drools.common.BetaConstraints;
import org.drools.common.DefaultFactHandle;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.MemoryFactory;
import org.drools.common.NetworkNode;
import org.drools.common.PropagationContextImpl;
import org.drools.phreak.SegmentUtilities;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ExistsNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockObjectSource;
import org.drools.reteoo.NodeTypeEnums;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RuleMemory;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.GroupElement;
import org.drools.rule.Rule;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.junit.Assert;
import org.junit.Test;
import org.kie.KieBaseConfiguration;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.conf.LRUnlinkingOption;
import org.kie.conf.KieBaseOption;

public class RuleUnlinkingTest {
    ReteooRuleBase ruleBase;
    BuildContext buildContext;
    PropagationContext context;
    LeftInputAdapterNode liaNode;
    BetaNode n1;
    BetaNode n2;
    BetaNode n3;
    BetaNode n4;
    BetaNode n5;
    BetaNode n6;
    BetaNode n7;
    BetaNode n8;
    BetaNode n9;
    BetaNode n10;
    RuleTerminalNode rtn1;
    RuleTerminalNode rtn2;
    RuleTerminalNode rtn3;
    Rule rule1;
    Rule rule2;
    Rule rule3;
    static final int JOIN_NODE = 0;
    static final int EXISTS_NODE = 1;
    static final int NOT_NODE = 2;
    static final int RULE_TERMINAL_NODE = 3;

    private NetworkNode createNetworkNode(int id, int type, LeftTupleSource leftTupleSource, Rule rule) {
        MockObjectSource mockObjectSource = new MockObjectSource(8);
        JoinNode networkNode = null;
        switch (type) {
            case 0: {
                networkNode = new JoinNode(id, leftTupleSource, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), this.buildContext);
                break;
            }
            case 1: {
                networkNode = new ExistsNode(id, leftTupleSource, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), this.buildContext);
                break;
            }
            case 2: {
                networkNode = new NotNode(id, leftTupleSource, (ObjectSource)mockObjectSource, (BetaConstraints)new EmptyBetaConstraints(), this.buildContext);
                break;
            }
            case 3: {
                networkNode = new RuleTerminalNode(id, leftTupleSource, rule, new GroupElement(GroupElement.Type.AND), 0, this.buildContext);
            }
        }
        mockObjectSource.attach();
        if (NodeTypeEnums.isLeftTupleSource(networkNode)) {
            ((LeftTupleSource)networkNode).attach();
        } else {
            ((RuleTerminalNode)networkNode).attach();
        }
        return networkNode;
    }

    public void setUp(int type) {
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)LRUnlinkingOption.ENABLED);
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)((RuleBaseConfiguration)kconf));
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        this.context = new PropagationContextImpl(0L, 0, null, null, null);
        ObjectTypeNode otn = new ObjectTypeNode(2, null, (ObjectType)new ClassObjectType(String.class), this.buildContext);
        this.liaNode = new LeftInputAdapterNode(3, (ObjectSource)otn, this.buildContext);
        this.n1 = (BetaNode)this.createNetworkNode(10, type, (LeftTupleSource)this.liaNode, null);
        this.n2 = (BetaNode)this.createNetworkNode(11, type, (LeftTupleSource)this.n1, null);
        this.n3 = (BetaNode)this.createNetworkNode(12, type, (LeftTupleSource)this.n2, null);
        this.rule1 = new Rule("rule1");
        this.rule1.setActivationListener("agenda");
        this.rtn1 = (RuleTerminalNode)this.createNetworkNode(18, 3, (LeftTupleSource)this.n3, this.rule1);
        this.n4 = (BetaNode)this.createNetworkNode(13, type, (LeftTupleSource)this.n3, null);
        this.n5 = (BetaNode)this.createNetworkNode(14, type, (LeftTupleSource)this.n4, null);
        this.rule2 = new Rule("rule2");
        this.rule2.setActivationListener("agenda");
        this.rtn2 = (RuleTerminalNode)this.createNetworkNode(19, 3, (LeftTupleSource)this.n5, this.rule2);
        this.n6 = (BetaNode)this.createNetworkNode(15, type, (LeftTupleSource)this.n5, null);
        this.n7 = (BetaNode)this.createNetworkNode(16, type, (LeftTupleSource)this.n6, null);
        this.n8 = (BetaNode)this.createNetworkNode(17, type, (LeftTupleSource)this.n7, null);
        this.rule3 = new Rule("rule3");
        this.rule3.setActivationListener("agenda");
        this.rtn3 = (RuleTerminalNode)this.createNetworkNode(20, 3, (LeftTupleSource)this.n8, this.rule3);
        this.liaNode.addAssociation((org.kie.definition.rule.Rule)this.rule1, null);
        this.liaNode.addAssociation((org.kie.definition.rule.Rule)this.rule2, null);
        this.liaNode.addAssociation((org.kie.definition.rule.Rule)this.rule3, null);
        this.n1.addAssociation((org.kie.definition.rule.Rule)this.rule1, null);
        this.n1.addAssociation((org.kie.definition.rule.Rule)this.rule2, null);
        this.n1.addAssociation((org.kie.definition.rule.Rule)this.rule3, null);
        this.n2.addAssociation((org.kie.definition.rule.Rule)this.rule1, null);
        this.n2.addAssociation((org.kie.definition.rule.Rule)this.rule2, null);
        this.n2.addAssociation((org.kie.definition.rule.Rule)this.rule3, null);
        this.n3.addAssociation((org.kie.definition.rule.Rule)this.rule1, null);
        this.n3.addAssociation((org.kie.definition.rule.Rule)this.rule2, null);
        this.n3.addAssociation((org.kie.definition.rule.Rule)this.rule3, null);
        this.n4.addAssociation((org.kie.definition.rule.Rule)this.rule2, null);
        this.n4.addAssociation((org.kie.definition.rule.Rule)this.rule3, null);
        this.n5.addAssociation((org.kie.definition.rule.Rule)this.rule2, null);
        this.n5.addAssociation((org.kie.definition.rule.Rule)this.rule3, null);
        this.n6.addAssociation((org.kie.definition.rule.Rule)this.rule3, null);
        this.n7.addAssociation((org.kie.definition.rule.Rule)this.rule3, null);
        this.n8.addAssociation((org.kie.definition.rule.Rule)this.rule3, null);
    }

    @Test
    public void testRuleSegmentsAllLinkedTestMasks() {
        this.setUp(0);
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)LRUnlinkingOption.ENABLED);
        ReteooWorkingMemory wm = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)((RuleBaseConfiguration)kconf))));
        RuleMemory rs = (RuleMemory)wm.getNodeMemory((MemoryFactory)this.rtn1);
        Assert.assertFalse((boolean)rs.isRuleLinked());
        Assert.assertEquals((long)1L, (long)rs.getAllLinkedMaskTest());
        rs = (RuleMemory)wm.getNodeMemory((MemoryFactory)this.rtn2);
        Assert.assertFalse((boolean)rs.isRuleLinked());
        Assert.assertEquals((long)3L, (long)rs.getAllLinkedMaskTest());
        rs = (RuleMemory)wm.getNodeMemory((MemoryFactory)this.rtn3);
        Assert.assertFalse((boolean)rs.isRuleLinked());
        Assert.assertEquals((long)7L, (long)rs.getAllLinkedMaskTest());
    }

    @Test
    public void testSegmentNodeReferencesToSegments() {
        this.setUp(0);
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)LRUnlinkingOption.ENABLED);
        ReteooWorkingMemory wm = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)((RuleBaseConfiguration)kconf))));
        BetaMemory bm = null;
        RuleMemory rtn1Rs = (RuleMemory)wm.getNodeMemory((MemoryFactory)this.rtn1);
        RuleMemory rtn2Rs = (RuleMemory)wm.getNodeMemory((MemoryFactory)this.rtn2);
        RuleMemory rtn3Rs = (RuleMemory)wm.getNodeMemory((MemoryFactory)this.rtn3);
        bm = RuleUnlinkingTest.createSegmentMemory(this.n1, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)2L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)1L, (long)bm.getSegmentMemory().getSegmentPosMaskBit());
        List list = bm.getSegmentMemory().getRuleMemories();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(rtn1Rs));
        Assert.assertTrue((boolean)list.contains(rtn2Rs));
        Assert.assertTrue((boolean)list.contains(rtn3Rs));
        bm = RuleUnlinkingTest.createSegmentMemory(this.n2, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)4L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)1L, (long)bm.getSegmentMemory().getSegmentPosMaskBit());
        list = bm.getSegmentMemory().getRuleMemories();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(rtn1Rs));
        Assert.assertTrue((boolean)list.contains(rtn2Rs));
        Assert.assertTrue((boolean)list.contains(rtn3Rs));
        bm = RuleUnlinkingTest.createSegmentMemory(this.n3, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)8L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)15L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)1L, (long)bm.getSegmentMemory().getSegmentPosMaskBit());
        list = bm.getSegmentMemory().getRuleMemories();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(rtn1Rs));
        Assert.assertTrue((boolean)list.contains(rtn2Rs));
        Assert.assertTrue((boolean)list.contains(rtn3Rs));
        bm = RuleUnlinkingTest.createSegmentMemory(this.n4, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)1L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)3L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)2L, (long)bm.getSegmentMemory().getSegmentPosMaskBit());
        list = bm.getSegmentMemory().getRuleMemories();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(rtn2Rs));
        Assert.assertTrue((boolean)list.contains(rtn3Rs));
        bm = RuleUnlinkingTest.createSegmentMemory(this.n5, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)2L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)3L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)2L, (long)bm.getSegmentMemory().getSegmentPosMaskBit());
        list = bm.getSegmentMemory().getRuleMemories();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(rtn2Rs));
        Assert.assertTrue((boolean)list.contains(rtn3Rs));
        bm = RuleUnlinkingTest.createSegmentMemory(this.n6, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)1L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)7L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)4L, (long)bm.getSegmentMemory().getSegmentPosMaskBit());
        list = bm.getSegmentMemory().getRuleMemories();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(rtn3Rs));
        bm = RuleUnlinkingTest.createSegmentMemory(this.n7, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)2L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)7L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)4L, (long)bm.getSegmentMemory().getSegmentPosMaskBit());
        list = bm.getSegmentMemory().getRuleMemories();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(rtn3Rs));
        bm = RuleUnlinkingTest.createSegmentMemory(this.n8, (InternalWorkingMemory)wm);
        Assert.assertEquals((long)4L, (long)bm.getNodePosMaskBit());
        Assert.assertEquals((long)7L, (long)bm.getSegmentMemory().getAllLinkedMaskTest());
        Assert.assertEquals((long)4L, (long)bm.getSegmentMemory().getSegmentPosMaskBit());
        list = bm.getSegmentMemory().getRuleMemories();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(rtn3Rs));
    }

    @Test
    public void testRuleSegmentLinking() {
        this.setUp(0);
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)LRUnlinkingOption.ENABLED);
        ReteooWorkingMemory wm = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)((RuleBaseConfiguration)kconf))));
        BetaMemory bm = null;
        RuleMemory rtn1Rs = (RuleMemory)wm.getNodeMemory((MemoryFactory)this.rtn1);
        RuleMemory rtn2Rs = (RuleMemory)wm.getNodeMemory((MemoryFactory)this.rtn2);
        RuleMemory rtn3Rs = (RuleMemory)wm.getNodeMemory((MemoryFactory)this.rtn3);
        DefaultFactHandle f1 = (DefaultFactHandle)wm.insert((Object)"test1");
        SegmentUtilities.createSegmentMemory((LeftTupleSource)this.liaNode, (InternalWorkingMemory)wm);
        this.liaNode.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)wm);
        this.n1.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)wm);
        this.n3.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)wm);
        this.n4.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)wm);
        this.n8.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)wm);
        Assert.assertFalse((boolean)rtn1Rs.isRuleLinked());
        Assert.assertFalse((boolean)rtn2Rs.isRuleLinked());
        Assert.assertFalse((boolean)rtn3Rs.isRuleLinked());
        bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)this.n2);
        Assert.assertFalse((boolean)bm.getSegmentMemory().isSegmentLinked());
        DefaultFactHandle f2 = (DefaultFactHandle)wm.insert((Object)"test2");
        this.n2.assertObject((InternalFactHandle)f2, this.context, (InternalWorkingMemory)wm);
        Assert.assertTrue((boolean)bm.getSegmentMemory().isSegmentLinked());
        Assert.assertTrue((boolean)rtn1Rs.isRuleLinked());
        Assert.assertFalse((boolean)rtn2Rs.isRuleLinked());
        Assert.assertFalse((boolean)rtn3Rs.isRuleLinked());
        bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)this.n5);
        Assert.assertFalse((boolean)bm.getSegmentMemory().isSegmentLinked());
        this.n5.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)wm);
        Assert.assertTrue((boolean)bm.getSegmentMemory().isSegmentLinked());
        Assert.assertTrue((boolean)rtn1Rs.isRuleLinked());
        Assert.assertTrue((boolean)rtn2Rs.isRuleLinked());
        Assert.assertFalse((boolean)rtn3Rs.isRuleLinked());
        this.n6.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)wm);
        this.n7.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)wm);
        Assert.assertTrue((boolean)bm.getSegmentMemory().isSegmentLinked());
        Assert.assertTrue((boolean)rtn1Rs.isRuleLinked());
        Assert.assertTrue((boolean)rtn2Rs.isRuleLinked());
        Assert.assertTrue((boolean)rtn3Rs.isRuleLinked());
        this.n2.retractRightTuple(f2.getFirstRightTuple(), this.context, (InternalWorkingMemory)wm);
        Assert.assertFalse((boolean)rtn1Rs.isRuleLinked());
        Assert.assertFalse((boolean)rtn2Rs.isRuleLinked());
        Assert.assertFalse((boolean)rtn3Rs.isRuleLinked());
    }

    private static BetaMemory createSegmentMemory(BetaNode node, InternalWorkingMemory wm) {
        BetaMemory betaMemory = (BetaMemory)wm.getNodeMemory((MemoryFactory)node);
        if (betaMemory.getSegmentMemory() == null) {
            SegmentUtilities.createSegmentMemory((LeftTupleSource)node, (InternalWorkingMemory)wm);
        }
        return betaMemory;
    }
}

