/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.runtime.process;

import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.kie.command.Context;
import org.kie.runtime.KieSession;
import org.kie.runtime.process.ProcessInstance;

public class GetProcessInstanceCommand
implements GenericCommand<ProcessInstance> {
    private Long processInstanceId;
    private boolean readOnly = false;

    public GetProcessInstanceCommand() {
    }

    public GetProcessInstanceCommand(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public ProcessInstance execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        if (this.processInstanceId == null) {
            return null;
        }
        return ksession.getProcessInstance(this.processInstanceId.longValue(), this.readOnly);
    }

    public String toString() {
        return "session.getProcessInstance(" + this.processInstanceId + ");";
    }
}

