/*
 * Decompiled with CFR 0.152.
 */
package org.drools.phreak;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.base.DroolsQuery;
import org.drools.common.AgendaItem;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LeftTupleSets;
import org.drools.common.Memory;
import org.drools.common.MemoryFactory;
import org.drools.common.NetworkNode;
import org.drools.common.RightTupleSets;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.RightTupleList;
import org.drools.phreak.SegmentPropagator;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ConditionalBranchEvaluator;
import org.drools.reteoo.ConditionalBranchNode;
import org.drools.reteoo.EvalConditionNode;
import org.drools.reteoo.ExistsNode;
import org.drools.reteoo.FromNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSinkPropagator;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.NodeTypeEnums;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.reteoo.RuleMemory;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.SegmentMemory;
import org.drools.rule.Accumulate;
import org.drools.rule.ContextEntry;
import org.drools.rule.EvalCondition;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.DataProvider;
import org.drools.spi.PropagationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleNetworkEvaluatorActivation
extends AgendaItem {
    private static final Logger log = LoggerFactory.getLogger(RuleNetworkEvaluatorActivation.class);
    private RuleMemory rmem;
    private static PhreakJoinNode pJoinNode = new PhreakJoinNode();
    private static PhreakEvalNode pEvalNode = new PhreakEvalNode();
    private static PhreakFromNode pFromNode = new PhreakFromNode();
    private static PhreakNotNode pNotNode = new PhreakNotNode();
    private static PhreakExistsNode pExistsNode = new PhreakExistsNode();
    private static PhreakAccumulateNode pAccNode = new PhreakAccumulateNode();
    private static PhreakRuleTerminalNode pRtnNode = new PhreakRuleTerminalNode();
    private static PhreakBranchNode pBranchNode = new PhreakBranchNode();

    public RuleNetworkEvaluatorActivation() {
    }

    public RuleNetworkEvaluatorActivation(long activationNumber, LeftTuple tuple, int salience, PropagationContext context, RuleMemory rmem, RuleTerminalNode rtn) {
        super(activationNumber, tuple, salience, context, rtn);
        this.rmem = rmem;
    }

    public int evaluateNetwork(InternalWorkingMemory wm) {
        Memory nodeMem;
        NetworkNode node;
        int smemIndex;
        SegmentMemory[] smems = this.rmem.getSegmentMemories();
        SegmentMemory smem = smems[smemIndex = 0];
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)smem.getRootNode();
        if (liaNode == smem.getTipNode()) {
            smem = smems[++smemIndex];
            node = smem.getRootNode();
            nodeMem = smem.getNodeMemories().getFirst();
        } else {
            LeftTupleSinkPropagator sink = liaNode.getSinkPropagator();
            LeftTupleSinkNode firstSink = sink.getFirstLeftTupleSink();
            LeftTupleSinkNode secondSink = firstSink.getNextLeftTupleSinkNode();
            node = sink.size() == 2 ? secondSink : firstSink;
            nodeMem = (Memory)smem.getNodeMemories().getFirst().getNext();
        }
        LeftTupleSets srcTuples = smem.getStagedLeftTuples();
        if (log.isTraceEnabled()) {
            // empty if block
        }
        this.eval((LeftTupleSink)node, nodeMem, smems, smemIndex, srcTuples, null, wm);
        return 0;
    }

    public LeftTupleSets eval(NetworkNode node, Memory nodeMem, SegmentMemory[] smems, int smemIndex, LeftTupleSets trgTuples, LeftTupleSets stagedLeftTuples, InternalWorkingMemory wm) {
        SegmentMemory smem = smems[smemIndex];
        while (true) {
            LeftTupleSets srcTuples = trgTuples;
            if (NodeTypeEnums.isTerminalNode(node)) {
                RuleTerminalNode rtn = this.rmem.getRuleTerminalNode();
                pRtnNode.doNode(rtn, wm, srcTuples);
                return null;
            }
            if (71 == node.getType()) {
                return trgTuples;
            }
            stagedLeftTuples = node == smem.getTipNode() && smem.getFirst() != null ? ((SegmentMemory)smem.getFirst()).getStagedLeftTuples() : null;
            LeftTupleSinkNode sink = ((LeftTupleSource)node).getSinkPropagator().getFirstLeftTupleSink();
            trgTuples = new LeftTupleSets();
            if (NodeTypeEnums.isBetaNode(node)) {
                BetaNode betaNode = (BetaNode)node;
                BetaMemory bm = null;
                AccumulateNode.AccumulateMemory am = null;
                if (211 == node.getType()) {
                    am = (AccumulateNode.AccumulateMemory)nodeMem;
                    bm = am.getBetaMemory();
                } else {
                    bm = (BetaMemory)nodeMem;
                }
                if (betaNode.isRightInputIsRiaNode()) {
                    srcTuples = this.doRiaNode(wm, srcTuples, betaNode, bm);
                }
                switch (node.getType()) {
                    case 181: {
                        pJoinNode.doNode((JoinNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 191: {
                        pNotNode.doNode((NotNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 201: {
                        pExistsNode.doNode((ExistsNode)node, sink, bm, wm, srcTuples, trgTuples, stagedLeftTuples);
                        break;
                    }
                    case 211: {
                        pAccNode.doNode((AccumulateNode)node, sink, am, wm, srcTuples, trgTuples, stagedLeftTuples);
                    }
                }
            } else if (node.getType() == 131) {
                pEvalNode.doNode((EvalConditionNode)node, (EvalConditionNode.EvalMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
            } else if (node.getType() == 151) {
                pFromNode.doNode((FromNode)node, (FromNode.FromMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
            } else {
                pBranchNode.doNode((ConditionalBranchNode)node, (ConditionalBranchNode.ConditionalBranchMemory)nodeMem, sink, wm, srcTuples, trgTuples, stagedLeftTuples);
            }
            if (node != smem.getTipNode()) {
                LeftTupleSinkNode nextSink = sink.getNextLeftTupleSinkNode();
                node = nextSink == null ? sink : nextSink;
                nodeMem = (Memory)nodeMem.getNext();
                continue;
            }
            SegmentPropagator.propagate(smem, trgTuples, wm);
            smem = smems[++smemIndex];
            trgTuples = smem.getStagedLeftTuples();
            node = (LeftTupleSink)smem.getRootNode();
            nodeMem = smem.getNodeMemories().getFirst();
        }
    }

    private LeftTupleSets doRiaNode(InternalWorkingMemory wm, LeftTupleSets srcTuples, BetaNode betaNode, BetaMemory bm) {
        LeftTuple next;
        SegmentMemory subSmem = bm.getSubnetworkSegmentMemory();
        if (betaNode.getLeftTupleSource().getSinkPropagator().size() == 2) {
            LeftTupleSets peerTuples = new LeftTupleSets();
            SegmentPropagator.processPeers(srcTuples, peerTuples, betaNode);
            LeftTupleSets subnetworkStaged = subSmem.getStagedLeftTuples();
            subnetworkStaged.addAll(srcTuples);
            srcTuples.resetAll();
            srcTuples = peerTuples;
        }
        RightInputAdapterNode riaNode = (RightInputAdapterNode)betaNode.getRightInput();
        RightInputAdapterNode.RiaNodeMemory riaNodeMemory = (RightInputAdapterNode.RiaNodeMemory)wm.getNodeMemory((MemoryFactory)((Object)betaNode.getRightInput()));
        LeftTupleSets riaStagedTuples = this.eval((LeftTupleSink)subSmem.getRootNode(), subSmem.getNodeMemories().getFirst(), riaNodeMemory.getRiaRuleMemory().getSegmentMemories(), subSmem.getPos(), subSmem.getStagedLeftTuples(), null, wm);
        LeftTuple leftTuple = riaStagedTuples.getInsertFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            InternalFactHandle handle = riaNode.createFactHandle(leftTuple, leftTuple.getPropagationContext(), wm);
            RightTuple rightTuple = new RightTuple(handle, betaNode);
            leftTuple.setObject(rightTuple);
            bm.getStagedRightTuples().addInsert(rightTuple);
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = riaStagedTuples.getDeleteFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            bm.getStagedRightTuples().addDelete((RightTuple)leftTuple.getObject());
            leftTuple.clearStaged();
            leftTuple = next;
        }
        leftTuple = riaStagedTuples.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            bm.getStagedRightTuples().addUpdate((RightTuple)leftTuple.getObject());
            leftTuple.clearStaged();
            leftTuple = next;
        }
        return srcTuples;
    }

    @Override
    public boolean isRuleNetworkEvaluatorActivation() {
        return true;
    }

    public static LeftTuple deleteLeftChild(LeftTuple childLeftTuple, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        switch (childLeftTuple.getStagedType()) {
            case 1: {
                stagedLeftTuples.removeInsert(childLeftTuple);
                break;
            }
            case 2: {
                stagedLeftTuples.removeUpdate(childLeftTuple);
            }
        }
        LeftTuple next = childLeftTuple.getLeftParentNext();
        trgLeftTuples.addDelete(childLeftTuple);
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return next;
    }

    public static LeftTuple deleteRightChild(LeftTuple childLeftTuple, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        switch (childLeftTuple.getStagedType()) {
            case 1: {
                stagedLeftTuples.removeInsert(childLeftTuple);
                break;
            }
            case 2: {
                stagedLeftTuples.removeUpdate(childLeftTuple);
            }
        }
        LeftTuple next = childLeftTuple.getRightParentNext();
        trgLeftTuples.addDelete(childLeftTuple);
        childLeftTuple.unlinkFromRightParent();
        childLeftTuple.unlinkFromLeftParent();
        return next;
    }

    public static void dpUpdatesReorderLeftMemory(BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets srcLeftTuples) {
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            if (leftTuple.getMemory() != null) {
                ltm.removeAdd(leftTuple);
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple childNext = childLeftTuple.getLeftParentNext();
                    childLeftTuple.reAddRight();
                    childLeftTuple = childNext;
                }
            }
            leftTuple = next;
        }
    }

    public static void dpUpdatesReorderRightMemory(BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets srcLeftTuples) {
        RightTupleMemory rtm = bm.getRightTupleMemory();
        RightTuple rightTuple = srcRightTuples.getUpdateFirst();
        while (rightTuple != null) {
            RightTuple next = rightTuple.getStagedNext();
            if (rightTuple.getMemory() != null) {
                rtm.removeAdd(rightTuple);
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                while (childLeftTuple != null) {
                    LeftTuple childNext = childLeftTuple.getRightParentNext();
                    childLeftTuple.reAddLeft();
                    childLeftTuple = childNext;
                }
            }
            rightTuple = next;
        }
    }

    public static class PhreakRuleTerminalNode {
        public void doNode(RuleTerminalNode rtnNode, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples) {
            if (log.isTraceEnabled()) {
                // empty if block
            }
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(rtnNode, wm, srcLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(rtnNode, wm, srcLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(rtnNode, wm, srcLeftTuples);
            }
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(RuleTerminalNode rtnNode, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples) {
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                rtnNode.assertLeftTuple(leftTuple, leftTuple.getPropagationContext(), wm);
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftUpdates(RuleTerminalNode rtnNode, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples) {
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                rtnNode.modifyLeftTuple(leftTuple, leftTuple.getPropagationContext(), wm);
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftDeletes(RuleTerminalNode rtnNode, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples) {
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                rtnNode.retractLeftTuple(leftTuple, leftTuple.getPropagationContext(), wm);
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }
    }

    public static class PhreakFromNode {
        public void doNode(FromNode fromNode, FromNode.FromMemory fm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(fromNode, fm, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(fromNode, fm, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(fromNode, fm, sink, wm, srcLeftTuples, trgLeftTuples);
            }
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(FromNode fromNode, FromNode.FromMemory fm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemoryEnabled = true;
            BetaMemory bm = fm.getBetaMemory();
            ContextEntry[] context = bm.getContext();
            BetaConstraints betaConstraints = fromNode.getBetaConstraints();
            AlphaNodeFieldConstraint[] alphaConstraints = fromNode.getAlphaConstraints();
            DataProvider dataProvider = fromNode.getDataProvider();
            Class<?> resultClass = fromNode.getResultClass();
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                Object object;
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext propagationContext = leftTuple.getPropagationContext();
                LinkedHashMap<Object, RightTuple> matches = null;
                boolean useLeftMemory = true;
                if (!(tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
                    useLeftMemory = false;
                }
                if (useLeftMemory) {
                    fm.betaMemory.getLeftTupleMemory().add(leftTuple);
                    matches = new LinkedHashMap<Object, RightTuple>();
                    leftTuple.setObject(matches);
                }
                betaConstraints.updateFromTuple(context, wm, leftTuple);
                Iterator it = dataProvider.getResults(leftTuple, wm, propagationContext, fm.providerContext);
                while (it.hasNext()) {
                    Object object2 = it.next();
                    if (!resultClass.isAssignableFrom(object2.getClass())) continue;
                    RightTuple rightTuple = fromNode.createRightTuple(leftTuple, propagationContext, wm, object2);
                    this.checkConstraintsAndPropagate(sink, leftTuple, rightTuple, alphaConstraints, betaConstraints, propagationContext, wm, fm, bm, context, useLeftMemory, trgLeftTuples, null);
                    if (!useLeftMemory) continue;
                    fromNode.addToCreatedHandlesMap(matches, rightTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            betaConstraints.resetTuple(context);
        }

        public void doLeftUpdates(FromNode fromNode, FromNode.FromMemory fm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean tupleMemoryEnabled = true;
            BetaMemory bm = fm.getBetaMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            ContextEntry[] context = bm.getContext();
            BetaConstraints betaConstraints = fromNode.getBetaConstraints();
            AlphaNodeFieldConstraint[] alphaConstraints = fromNode.getAlphaConstraints();
            DataProvider dataProvider = fromNode.getDataProvider();
            Class<?> resultClass = fromNode.getResultClass();
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext propagationContext = leftTuple.getPropagationContext();
                ltm.removeAdd(leftTuple);
                Map previousMatches = (Map)leftTuple.getObject();
                HashMap<Object, RightTuple> newMatches = new HashMap<Object, RightTuple>();
                leftTuple.setObject(newMatches);
                betaConstraints.updateFromTuple(context, wm, leftTuple);
                FastIterator rightIt = LinkedList.fastIterator;
                Iterator it = dataProvider.getResults(leftTuple, wm, propagationContext, fm.providerContext);
                while (it.hasNext()) {
                    Object object = it.next();
                    if (!resultClass.isAssignableFrom(object.getClass())) continue;
                    RightTuple rightTuple = (RightTuple)previousMatches.remove(object);
                    if (rightTuple == null) {
                        rightTuple = fromNode.createRightTuple(leftTuple, propagationContext, wm, object);
                    } else if (rightIt.next(rightTuple) != null) {
                        previousMatches.put(object, (RightTuple)rightIt.next(rightTuple));
                        rightTuple.setNext(null);
                    }
                    this.checkConstraintsAndPropagate(sink, leftTuple, rightTuple, alphaConstraints, betaConstraints, propagationContext, wm, fm, bm, context, tupleMemoryEnabled, trgLeftTuples, null);
                    if (!tupleMemoryEnabled) continue;
                    fromNode.addToCreatedHandlesMap(newMatches, rightTuple);
                }
                Iterator i$ = previousMatches.values().iterator();
                while (i$.hasNext()) {
                    RightTuple rightTuple;
                    RightTuple current = rightTuple = (RightTuple)i$.next();
                    while (current != null) {
                        LeftTuple childLeftTuple = current.getFirstChild();
                        childLeftTuple.unlinkFromLeftParent();
                        childLeftTuple.unlinkFromRightParent();
                        switch (childLeftTuple.getStagedType()) {
                            case 1: {
                                stagedLeftTuples.removeInsert(childLeftTuple);
                                break;
                            }
                            case 2: {
                                stagedLeftTuples.removeUpdate(childLeftTuple);
                            }
                        }
                        childLeftTuple.setPropagationContext(propagationContext);
                        trgLeftTuples.addDelete(childLeftTuple);
                        current = (RightTuple)rightIt.next(current);
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            betaConstraints.resetTuple(context);
        }

        public void doLeftDeletes(FromNode fromNode, FromNode.FromMemory fm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            BetaMemory bm = fm.getBetaMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                ltm.remove(leftTuple);
                Map matches = (Map)leftTuple.getObject();
                if (leftTuple.getFirstChild() != null) {
                    LeftTuple childLeftTuple = leftTuple.getFirstChild();
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                PhreakFromNode.unlinkCreatedHandles(leftTuple);
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public static void unlinkCreatedHandles(LeftTuple leftTuple) {
            Map matches = (Map)leftTuple.getObject();
            FastIterator rightIt = LinkedList.fastIterator;
            Iterator i$ = matches.values().iterator();
            while (i$.hasNext()) {
                RightTuple rightTuple;
                RightTuple current = rightTuple = (RightTuple)i$.next();
                while (current != null) {
                    RightTuple next = (RightTuple)rightIt.next(current);
                    current.unlinkFromRightParent();
                    current = next;
                }
            }
        }

        protected void checkConstraintsAndPropagate(LeftTupleSink sink, LeftTuple leftTuple, RightTuple rightTuple, AlphaNodeFieldConstraint[] alphaConstraints, BetaConstraints betaConstraints, PropagationContext propagationContext, InternalWorkingMemory wm, FromNode.FromMemory fm, BetaMemory bm, ContextEntry[] context, boolean useLeftMemory, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean isAllowed = true;
            if (alphaConstraints != null) {
                int length = alphaConstraints.length;
                for (int i = 0; i < length; ++i) {
                    if (alphaConstraints[i].isAllowed(rightTuple.getFactHandle(), wm, fm.alphaContexts[i])) continue;
                    isAllowed = false;
                    break;
                }
            }
            if (isAllowed && betaConstraints.isAllowedCachedLeft(context, rightTuple.getFactHandle())) {
                if (rightTuple.firstChild == null) {
                    LeftTuple childLeftTuple = sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, useLeftMemory);
                    childLeftTuple.setPropagationContext(propagationContext);
                    trgLeftTuples.addInsert(childLeftTuple);
                } else {
                    LeftTuple childLeftTuple = rightTuple.firstChild;
                    switch (childLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(childLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(childLeftTuple);
                        }
                    }
                    childLeftTuple.setPropagationContext(propagationContext);
                    trgLeftTuples.addUpdate(childLeftTuple);
                }
            } else {
                LeftTuple childLeftTuple = rightTuple.firstChild;
                if (childLeftTuple != null) {
                    switch (childLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(childLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(childLeftTuple);
                        }
                    }
                    childLeftTuple.setPropagationContext(propagationContext);
                    trgLeftTuples.addDelete(childLeftTuple);
                }
            }
        }
    }

    public static class PhreakBranchNode {
        public void doNode(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(branchNode, cbm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(branchNode, cbm, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(branchNode, cbm, sink, wm, srcLeftTuples, trgLeftTuples);
            }
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemoryEnabled = true;
            ConditionalBranchEvaluator branchEvaluator = branchNode.getBranchEvaluator();
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                boolean breaking = false;
                ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = branchEvaluator.evaluate(leftTuple, wm, cbm.context);
                if (conditionalExecution != null) {
                    RuleTerminalNode rtn = (RuleTerminalNode)conditionalExecution.getSink().getFirstLeftTupleSink();
                    LeftTuple branchedLeftTuple = rtn.createLeftTuple(leftTuple, (LeftTupleSink)rtn, tupleMemoryEnabled);
                    leftTuple.setObject(branchedLeftTuple);
                    rtn.assertLeftTuple(branchedLeftTuple, leftTuple.getPropagationContext(), wm);
                    breaking = conditionalExecution.isBreaking();
                }
                if (!breaking) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemoryEnabled));
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftUpdates(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean tupleMemoryEnabled = true;
            ConditionalBranchEvaluator branchEvaluator = branchNode.getBranchEvaluator();
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                LeftTuple rtnLeftTuple = (LeftTuple)leftTuple.getObject();
                LeftTuple mainLeftTuple = leftTuple.getFirstChild();
                RuleTerminalNode oldRtn = null;
                if (rtnLeftTuple != null) {
                    oldRtn = (RuleTerminalNode)rtnLeftTuple.getSink();
                }
                ConditionalBranchEvaluator.ConditionalExecution conditionalExecution = branchEvaluator.evaluate(leftTuple, wm, cbm.context);
                RuleTerminalNode newRtn = null;
                boolean breaking = false;
                if (conditionalExecution != null) {
                    newRtn = (RuleTerminalNode)conditionalExecution.getSink().getFirstLeftTupleSink();
                    breaking = conditionalExecution.isBreaking();
                }
                if (oldRtn != null) {
                    if (newRtn == null) {
                        oldRtn.retractLeftTuple(rtnLeftTuple, rtnLeftTuple.getPropagationContext(), wm);
                    } else if (newRtn == oldRtn) {
                        oldRtn.modifyLeftTuple(rtnLeftTuple, rtnLeftTuple.getPropagationContext(), wm);
                    } else {
                        oldRtn.retractLeftTuple(rtnLeftTuple, rtnLeftTuple.getPropagationContext(), wm);
                        rtnLeftTuple = newRtn.createLeftTuple(leftTuple, (LeftTupleSink)newRtn, tupleMemoryEnabled);
                        leftTuple.setObject(rtnLeftTuple);
                        newRtn.assertLeftTuple(rtnLeftTuple, rtnLeftTuple.getPropagationContext(), wm);
                    }
                } else if (newRtn != null) {
                    rtnLeftTuple = newRtn.createLeftTuple(leftTuple, (LeftTupleSink)newRtn, tupleMemoryEnabled);
                    leftTuple.setObject(rtnLeftTuple);
                    newRtn.assertLeftTuple(rtnLeftTuple, rtnLeftTuple.getPropagationContext(), wm);
                }
                if (mainLeftTuple != null) {
                    switch (mainLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(mainLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(mainLeftTuple);
                        }
                    }
                    if (!breaking) {
                        trgLeftTuples.addUpdate(mainLeftTuple);
                    } else {
                        trgLeftTuples.addDelete(mainLeftTuple);
                    }
                } else if (!breaking) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemoryEnabled));
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftDeletes(ConditionalBranchNode branchNode, ConditionalBranchNode.ConditionalBranchMemory cbm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                LeftTuple rtnLeftTuple = (LeftTuple)leftTuple.getObject();
                LeftTuple mainLeftTuple = leftTuple.getFirstChild();
                if (rtnLeftTuple != null) {
                    RuleTerminalNode rtn = (RuleTerminalNode)rtnLeftTuple.getSink();
                    rtn.retractLeftTuple(rtnLeftTuple, rtnLeftTuple.getPropagationContext(), wm);
                }
                if (mainLeftTuple != null) {
                    switch (mainLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(mainLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(mainLeftTuple);
                        }
                    }
                    trgLeftTuples.addDelete(mainLeftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }
    }

    public static class PhreakEvalNode {
        public void doNode(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(evalNode, em, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(evalNode, em, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(evalNode, em, sink, wm, srcLeftTuples, trgLeftTuples);
            }
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemoryEnabled = true;
            EvalCondition condition = evalNode.getCondition();
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                boolean allowed = condition.isAllowed(leftTuple, wm, em.context);
                if (allowed) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemoryEnabled));
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftUpdates(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean tupleMemoryEnabled = true;
            EvalCondition condition = evalNode.getCondition();
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple childLeftTuple;
                LeftTuple next = leftTuple.getStagedNext();
                boolean wasPropagated = leftTuple.getFirstChild() != null;
                boolean allowed = condition.isAllowed(leftTuple, wm, em.context);
                if (allowed) {
                    if (wasPropagated) {
                        childLeftTuple = leftTuple.getFirstChild();
                        switch (childLeftTuple.getStagedType()) {
                            case 1: {
                                stagedLeftTuples.removeInsert(childLeftTuple);
                                break;
                            }
                            case 2: {
                                stagedLeftTuples.removeUpdate(childLeftTuple);
                            }
                        }
                        trgLeftTuples.addUpdate(childLeftTuple);
                    } else {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemoryEnabled));
                    }
                } else if (wasPropagated) {
                    childLeftTuple = leftTuple.getFirstChild();
                    switch (childLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(childLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(childLeftTuple);
                        }
                    }
                    trgLeftTuples.addDelete(childLeftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doLeftDeletes(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                if (childLeftTuple != null) {
                    switch (childLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(childLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(childLeftTuple);
                        }
                    }
                    trgLeftTuples.addDelete(childLeftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }
    }

    public static class PhreakAccumulateNode {
        public void doNode(AccumulateNode accNode, LeftTupleSink sink, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTuple next;
            boolean useLeftMemory = true;
            RightTupleSets srcRightTuples = am.getBetaMemory().getStagedRightTuples();
            LeftTupleSets tempLeftTuples = new LeftTupleSets();
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(accNode, am, wm, srcLeftTuples, trgLeftTuples);
            }
            if (srcRightTuples.getDeleteFirst() != null) {
                this.doRightDeletes(accNode, am, wm, srcRightTuples, tempLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null || srcRightTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluatorActivation.dpUpdatesReorderLeftMemory(am.getBetaMemory(), wm, srcRightTuples, srcLeftTuples);
                RuleNetworkEvaluatorActivation.dpUpdatesReorderRightMemory(am.getBetaMemory(), wm, srcRightTuples, srcLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(accNode, sink, am, wm, srcLeftTuples, tempLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                this.doRightUpdates(accNode, sink, am, wm, srcRightTuples, tempLeftTuples);
            }
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(accNode, sink, am, wm, srcRightTuples, tempLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(accNode, sink, am, wm, srcLeftTuples, tempLeftTuples);
            }
            Accumulate accumulate = accNode.getAccumulate();
            LeftTuple leftTuple = tempLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                next = leftTuple.getStagedNext();
                this.evaluateResultConstraints(accNode, sink, accumulate, leftTuple, leftTuple.getPropagationContext(), wm, am, (AccumulateNode.AccumulateContext)leftTuple.getObject(), useLeftMemory, trgLeftTuples, stagedLeftTuples);
                leftTuple.clearStaged();
                leftTuple = next;
            }
            leftTuple = tempLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                next = leftTuple.getStagedNext();
                this.evaluateResultConstraints(accNode, sink, accumulate, leftTuple, leftTuple.getPropagationContext(), wm, am, (AccumulateNode.AccumulateContext)leftTuple.getObject(), useLeftMemory, trgLeftTuples, stagedLeftTuples);
                leftTuple.clearStaged();
                leftTuple = next;
            }
            srcRightTuples.resetAll();
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(AccumulateNode accNode, LeftTupleSink sink, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            Accumulate accumulate = accNode.getAccumulate();
            BetaMemory bm = am.getBetaMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = accNode.getRawConstraints();
            FastIterator it = accNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                Object object;
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                AccumulateNode.AccumulateContext accresult = new AccumulateNode.AccumulateContext();
                boolean useLeftMemory = true;
                if (!(tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
                    useLeftMemory = false;
                }
                if (useLeftMemory) {
                    ltm.add(leftTuple);
                    leftTuple.setObject(accresult);
                }
                accresult.context = accumulate.createContext();
                accumulate.init(am.workingMemoryContext, accresult.context, leftTuple, wm);
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                FastIterator rightIt = accNode.getRightIterator(rtm);
                RightTuple rightTuple = accNode.getFirstRightTuple(leftTuple, rtm, context, rightIt);
                while (rightTuple != null) {
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (constraints.isAllowedCachedLeft(contextEntry, handle)) {
                        PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, wm, am, accresult, useLeftMemory);
                    }
                    rightTuple = (RightTuple)rightIt.next(rightTuple);
                }
                leftTuple.clearStaged();
                trgLeftTuples.addInsert(leftTuple);
                constraints.resetTuple(contextEntry);
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightInserts(AccumulateNode accNode, LeftTupleSink sink, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            Accumulate accumulate = accNode.getAccumulate();
            BetaMemory bm = am.getBetaMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = accNode.getRawConstraints();
            FastIterator it = accNode.getLeftIterator(ltm);
            RightTuple rightTuple = srcRightTuples.getInsertFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.add(rightTuple);
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                FastIterator leftIt = accNode.getLeftIterator(ltm);
                LeftTuple leftTuple = accNode.getFirstLeftTuple(rightTuple, ltm, context, leftIt);
                while (leftTuple != null) {
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, wm, am, accctx, tupleMemoryEnabled);
                        if (leftTuple.getStagedType() == 0) {
                            trgLeftTuples.addUpdate(leftTuple);
                        }
                    }
                    leftTuple = (LeftTuple)leftIt.next(leftTuple);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public void doLeftUpdates(AccumulateNode accNode, LeftTupleSink sink, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemory = true;
            BetaMemory bm = am.getBetaMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            Accumulate accumulate = accNode.getAccumulate();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = accNode.getRawConstraints();
            FastIterator rightIt = accNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                PropagationContext context = leftTuple.getPropagationContext();
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                RightTuple rightTuple = accNode.getFirstRightTuple(leftTuple, rtm, context, rightIt);
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                if (childLeftTuple != null && rtm.isIndexed() && !rightIt.isFullIterator() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
                    PhreakAccumulateNode.removePreviousMatchesForLeftTuple(accNode, accumulate, leftTuple, wm, am, accctx, true);
                    childLeftTuple = null;
                }
                if (rightTuple != null) {
                    this.doLeftUpdatesProcessChildren(accNode, am, wm, bm, accumulate, constraints, rightIt, leftTuple, accctx, rightTuple, childLeftTuple);
                }
                leftTuple.clearStaged();
                trgLeftTuples.addUpdate(leftTuple);
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        private void doLeftUpdatesProcessChildren(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, BetaMemory bm, Accumulate accumulate, BetaConstraints constraints, FastIterator rightIt, LeftTuple leftTuple, AccumulateNode.AccumulateContext accctx, RightTuple rightTuple, LeftTuple childLeftTuple) {
            if (childLeftTuple == null) {
                while (rightTuple != null) {
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (constraints.isAllowedCachedLeft(bm.getContext(), handle)) {
                        PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, wm, am, accctx, true);
                    }
                    rightTuple = (RightTuple)rightIt.next(rightTuple);
                }
            } else {
                boolean isDirty = false;
                while (rightTuple != null) {
                    LeftTuple temp;
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (constraints.isAllowedCachedLeft(bm.getContext(), handle)) {
                        if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                            PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, childLeftTuple, null, wm, am, accctx, true);
                        } else {
                            temp = childLeftTuple.getLeftParentNext();
                            childLeftTuple.reAddRight();
                            childLeftTuple = temp;
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                        temp = childLeftTuple.getLeftParentNext();
                        PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, childLeftTuple, wm, am, accctx, false);
                        childLeftTuple = temp;
                        isDirty = !accumulate.supportsReverse();
                    }
                    rightTuple = (RightTuple)rightIt.next(rightTuple);
                }
                if (isDirty) {
                    PhreakAccumulateNode.reaccumulateForLeftTuple(accNode, accumulate, leftTuple, wm, am, accctx);
                }
            }
        }

        public void doRightUpdates(AccumulateNode accNode, LeftTupleSink sink, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemory = true;
            BetaMemory bm = am.getBetaMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = accNode.getRawConstraints();
            Accumulate accumulate = accNode.getAccumulate();
            FastIterator leftIt = accNode.getLeftIterator(ltm);
            RightTuple rightTuple = srcRightTuples.getUpdateFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                PropagationContext context = rightTuple.getPropagationContext();
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                LeftTuple leftTuple = accNode.getFirstLeftTuple(rightTuple, ltm, context, leftIt);
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                if (childLeftTuple != null && ltm.isIndexed() && !leftIt.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
                    PhreakAccumulateNode.removePreviousMatchesForRightTuple(accNode, accumulate, rightTuple, context, wm, am, childLeftTuple, trgLeftTuples);
                    childLeftTuple = null;
                }
                if (leftTuple != null) {
                    if (leftTuple.getStagedType() == 0) {
                        trgLeftTuples.addUpdate(leftTuple);
                    }
                    this.doRightUpdatesProcessChildren(accNode, am, wm, bm, constraints, accumulate, leftIt, rightTuple, childLeftTuple, leftTuple, trgLeftTuples);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        private void doRightUpdatesProcessChildren(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, BetaMemory bm, BetaConstraints constraints, Accumulate accumulate, FastIterator leftIt, RightTuple rightTuple, LeftTuple childLeftTuple, LeftTuple leftTuple, LeftTupleSets trgLeftTuples) {
            if (childLeftTuple == null) {
                while (leftTuple != null) {
                    if (constraints.isAllowedCachedRight(bm.getContext(), leftTuple)) {
                        if (leftTuple.getStagedType() == 0) {
                            trgLeftTuples.addUpdate(leftTuple);
                        }
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, null, wm, am, accctx, true);
                    }
                    leftTuple = (LeftTuple)leftIt.next(leftTuple);
                }
            } else {
                while (leftTuple != null) {
                    if (constraints.isAllowedCachedRight(bm.getContext(), leftTuple)) {
                        if (leftTuple.getStagedType() == 0) {
                            trgLeftTuples.addUpdate(leftTuple);
                        }
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        LeftTuple temp = null;
                        if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                            temp = childLeftTuple.getRightParentNext();
                            PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, childLeftTuple, wm, am, accctx, true);
                            childLeftTuple = temp;
                        }
                        PhreakAccumulateNode.addMatch(accNode, accumulate, leftTuple, rightTuple, null, childLeftTuple, wm, am, accctx, true);
                        if (temp != null) {
                            childLeftTuple = temp;
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        if (leftTuple.getStagedType() == 0) {
                            trgLeftTuples.addUpdate(leftTuple);
                        }
                        LeftTuple temp = childLeftTuple.getRightParentNext();
                        AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                        PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, childLeftTuple, wm, am, accctx, true);
                        childLeftTuple = temp;
                    }
                    leftTuple = (LeftTuple)leftIt.next(leftTuple);
                }
            }
        }

        public void doLeftDeletes(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            BetaMemory bm = am.getBetaMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            Accumulate accumulate = accNode.getAccumulate();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                if (leftTuple.getMemory() != null) {
                    ltm.remove(leftTuple);
                    AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                    leftTuple.setObject(null);
                    PhreakAccumulateNode.removePreviousMatchesForLeftTuple(accNode, accumulate, leftTuple, wm, am, accctx, false);
                    if (accctx.propagated) {
                        trgLeftTuples.addDelete(accctx.resultLeftTuple);
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doRightDeletes(AccumulateNode accNode, AccumulateNode.AccumulateMemory am, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            RightTupleMemory rtm = am.getBetaMemory().getRightTupleMemory();
            Accumulate accumulate = accNode.getAccumulate();
            RightTuple rightTuple = srcRightTuples.getDeleteFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                if (rightTuple.getMemory() != null) {
                    rtm.remove(rightTuple);
                    if (rightTuple.getFirstChild() != null) {
                        LeftTuple match = rightTuple.getFirstChild();
                        while (match != null) {
                            LeftTuple nextLeft = match.getRightParentNext();
                            LeftTuple leftTuple = match.getLeftParent();
                            AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                            PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, match, wm, am, accctx, true);
                            if (leftTuple.getStagedType() == 0) {
                                trgLeftTuples.addUpdate(leftTuple);
                            }
                            match.unlinkFromLeftParent();
                            match = nextLeft;
                        }
                    }
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
        }

        public void evaluateResultConstraints(AccumulateNode accNode, LeftTupleSink sink, Accumulate accumulate, LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, AccumulateNode.AccumulateContext accctx, boolean useLeftMemory, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            Object[] result;
            Object[] resultArray = accumulate.getResult(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
            Object object = result = accumulate.isMultiFunction() ? resultArray : resultArray[0];
            if (result == null) {
                return;
            }
            if (accctx.getResultFactHandle() == null) {
                InternalFactHandle handle = accNode.createResultFactHandle(context, workingMemory, leftTuple, result);
                accctx.setResultFactHandle(handle);
                accctx.setResultLeftTuple(accNode.createLeftTuple(handle, leftTuple, sink));
            } else {
                accctx.getResultFactHandle().setObject(result);
            }
            AlphaNodeFieldConstraint[] resultConstraints = accNode.getResultConstraints();
            BetaConstraints resultBinder = accNode.getResultBinder();
            boolean isAllowed = result != null;
            int length = resultConstraints.length;
            for (int i = 0; isAllowed && i < length; ++i) {
                if (resultConstraints[i].isAllowed(accctx.resultFactHandle, workingMemory, memory.alphaContexts[i])) continue;
                isAllowed = false;
            }
            if (isAllowed) {
                resultBinder.updateFromTuple(memory.resultsContext, workingMemory, leftTuple);
                if (!resultBinder.isAllowedCachedLeft(memory.resultsContext, accctx.getResultFactHandle())) {
                    isAllowed = false;
                }
                resultBinder.resetTuple(memory.resultsContext);
            }
            LeftTuple childLeftTuple = accctx.getResultLeftTuple();
            childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
            if (accctx.propagated) {
                switch (childLeftTuple.getStagedType()) {
                    case 1: {
                        stagedLeftTuples.removeInsert(childLeftTuple);
                        break;
                    }
                    case 2: {
                        stagedLeftTuples.removeUpdate(childLeftTuple);
                    }
                }
                if (isAllowed) {
                    trgLeftTuples.addUpdate(childLeftTuple);
                } else {
                    trgLeftTuples.addDelete(childLeftTuple);
                    accctx.propagated = false;
                }
            } else if (isAllowed) {
                trgLeftTuples.addInsert(childLeftTuple);
                accctx.propagated = true;
            }
        }

        public static void addMatch(AccumulateNode accNode, Accumulate accumulate, LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, InternalWorkingMemory wm, AccumulateNode.AccumulateMemory am, AccumulateNode.AccumulateContext accresult, boolean useLeftMemory) {
            LeftTuple tuple = leftTuple;
            InternalFactHandle handle = rightTuple.getFactHandle();
            if (accNode.isUnwrapRightObject()) {
                tuple = (LeftTuple)handle.getObject();
            }
            accumulate.accumulate(am.workingMemoryContext, accresult.context, tuple, handle, wm);
            if (useLeftMemory) {
                accNode.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, accNode, true);
            }
        }

        public static void removeMatch(AccumulateNode accNode, Accumulate accumulate, RightTuple rightTuple, LeftTuple match, InternalWorkingMemory wm, AccumulateNode.AccumulateMemory am, AccumulateNode.AccumulateContext accctx, boolean reaccumulate) {
            LeftTuple leftTuple = match.getLeftParent();
            match.unlinkFromLeftParent();
            match.unlinkFromRightParent();
            InternalFactHandle handle = rightTuple.getFactHandle();
            LeftTuple tuple = leftTuple;
            if (accNode.isUnwrapRightObject()) {
                tuple = (LeftTuple)handle.getObject();
            }
            if (accumulate.supportsReverse()) {
                accumulate.reverse(am.workingMemoryContext, accctx.context, tuple, handle, wm);
            } else if (reaccumulate) {
                PhreakAccumulateNode.reaccumulateForLeftTuple(accNode, accumulate, leftTuple, wm, am, accctx);
            }
        }

        public static void reaccumulateForLeftTuple(AccumulateNode accNode, Accumulate accumulate, LeftTuple leftTuple, InternalWorkingMemory wm, AccumulateNode.AccumulateMemory am, AccumulateNode.AccumulateContext accctx) {
            accumulate.init(am.workingMemoryContext, accctx.context, leftTuple, wm);
            for (LeftTuple childMatch = leftTuple.getFirstChild(); childMatch != null; childMatch = childMatch.getLeftParentNext()) {
                InternalFactHandle childHandle = childMatch.getRightParent().getFactHandle();
                LeftTuple tuple = leftTuple;
                if (accNode.isUnwrapRightObject()) {
                    tuple = (LeftTuple)childHandle.getObject();
                    childHandle = tuple.getLastHandle();
                }
                accumulate.accumulate(am.workingMemoryContext, accctx.context, tuple, childHandle, wm);
            }
        }

        public static void removePreviousMatchesForRightTuple(AccumulateNode accNode, Accumulate accumulate, RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, LeftTuple firstChild, LeftTupleSets trgLeftTuples) {
            LeftTuple match = firstChild;
            while (match != null) {
                LeftTuple next = match.getRightParentNext();
                LeftTuple leftTuple = match.getLeftParent();
                AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                PhreakAccumulateNode.removeMatch(accNode, accumulate, rightTuple, match, workingMemory, memory, accctx, true);
                if (leftTuple.getStagedType() == 0) {
                    trgLeftTuples.addUpdate(leftTuple);
                }
                match = next;
            }
        }

        public static void removePreviousMatchesForLeftTuple(AccumulateNode accNode, Accumulate accumulate, LeftTuple leftTuple, InternalWorkingMemory workingMemory, AccumulateNode.AccumulateMemory memory, AccumulateNode.AccumulateContext accctx, boolean reInit) {
            LeftTuple match = leftTuple.getFirstChild();
            while (match != null) {
                LeftTuple next = match.getLeftParentNext();
                match.unlinkFromRightParent();
                match.unlinkFromLeftParent();
                match = next;
            }
            if (reInit) {
                accumulate.init(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
            }
        }
    }

    public static class PhreakExistsNode {
        public void doNode(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            RightTupleSets srcRightTuples = bm.getStagedRightTuples();
            if (srcRightTuples.getDeleteFirst() != null) {
                this.doRightDeletes(existsNode, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(existsNode, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null || srcRightTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluatorActivation.dpUpdatesReorderLeftMemory(bm, wm, srcRightTuples, srcLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                this.doRightUpdates(existsNode, sink, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(existsNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(existsNode, sink, bm, wm, srcRightTuples, trgLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(existsNode, sink, bm, wm, srcLeftTuples, trgLeftTuples);
            }
            srcRightTuples.resetAll();
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            FastIterator it = existsNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                Object object;
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                boolean useLeftMemory = true;
                if (!(tupleMemoryEnabled || (object = ((InternalFactHandle)context.getFactHandle()).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
                    useLeftMemory = false;
                }
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                RightTuple rightTuple = existsNode.getFirstRightTuple(leftTuple, rtm, context, it);
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        leftTuple.setBlocker(rightTuple);
                        if (!useLeftMemory) break;
                        rightTuple.addBlocked(leftTuple);
                        break;
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
                if (leftTuple.getBlocker() != null) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                } else if (useLeftMemory) {
                    ltm.add(leftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightInserts(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            FastIterator it = existsNode.getLeftIterator(ltm);
            RightTuple rightTuple = srcRightTuples.getInsertFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.add(rightTuple);
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple leftTuple = existsNode.getFirstLeftTuple(rightTuple, ltm, context, it);
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)it.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                    } else {
                        if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                            leftTuple.setBlocker(rightTuple);
                            rightTuple.addBlocked(leftTuple);
                            ltm.remove(leftTuple);
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                        }
                        leftTuple = temp;
                    }
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public void doLeftUpdates(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean tupleMemory = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            FastIterator rightIt = existsNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple childLeftTuple;
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                RightTuple firstRightTuple = existsNode.getFirstRightTuple(leftTuple, rtm, context, rightIt);
                RightTuple blocker = leftTuple.getBlocker();
                if (blocker == null) {
                    ltm.remove(leftTuple);
                } else if (rtm.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
                    blocker.removeBlocked(leftTuple);
                    blocker = null;
                }
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                if (blocker == null || !constraints.isAllowedCachedLeft(contextEntry, blocker.getFactHandle())) {
                    if (blocker != null) {
                        blocker.removeBlocked(leftTuple);
                    }
                    RightTuple newBlocker = firstRightTuple;
                    while (newBlocker != null) {
                        if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                            leftTuple.setBlocker(newBlocker);
                            newBlocker.addBlocked(leftTuple);
                            break;
                        }
                        newBlocker = (RightTuple)rightIt.next(newBlocker);
                    }
                }
                if (leftTuple.getBlocker() == null) {
                    ltm.add(leftTuple);
                    if (leftTuple.getFirstChild() != null && leftTuple.getFirstChild() != null && (childLeftTuple = leftTuple.getFirstChild()) != null) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                } else if (leftTuple.getFirstChild() == null) {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                } else if (leftTuple.getFirstChild() != null) {
                    for (childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
                        switch (childLeftTuple.getStagedType()) {
                            case 1: {
                                stagedLeftTuples.removeInsert(childLeftTuple);
                                break;
                            }
                            case 2: {
                                stagedLeftTuples.removeUpdate(childLeftTuple);
                            }
                        }
                        trgLeftTuples.addUpdate(childLeftTuple);
                        childLeftTuple.reAddRight();
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightUpdates(ExistsNode existsNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean tupleMemory = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            FastIterator leftIt = existsNode.getLeftIterator(ltm);
            FastIterator rightIt = existsNode.getRightIterator(rtm);
            RightTuple rightTuple = srcRightTuples.getUpdateFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                PropagationContext context = rightTuple.getPropagationContext();
                LeftTuple firstLeftTuple = existsNode.getFirstLeftTuple(rightTuple, ltm, context, leftIt);
                LeftTuple firstBlocked = rightTuple.getBlocked();
                rightTuple.nullBlocked();
                LeftTuple leftTuple = firstLeftTuple;
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)leftIt.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                    }
                    leftTuple = temp;
                }
                if (firstBlocked != null) {
                    boolean useComparisonIndex = rtm.getIndexType().isComparison();
                    RightTuple rootBlocker = useComparisonIndex ? null : (RightTuple)rightIt.next(rightTuple);
                    RightTupleList list = rightTuple.getMemory();
                    rtm.removeAdd(rightTuple);
                    if (!useComparisonIndex && rootBlocker == null && list == rightTuple.getMemory()) {
                        rootBlocker = rightTuple;
                    }
                    LeftTuple leftTuple2 = firstBlocked;
                    while (leftTuple2 != null) {
                        LeftTuple temp = leftTuple2.getBlockedNext();
                        leftTuple2.clearBlocker();
                        if (leftTuple2.getStagedType() == 2) {
                            leftTuple2.setBlocker(rightTuple);
                            rightTuple.addBlocked(leftTuple2);
                            leftTuple2 = temp;
                            continue;
                        }
                        constraints.updateFromTuple(contextEntry, wm, leftTuple2);
                        if (useComparisonIndex) {
                            rootBlocker = existsNode.getFirstRightTuple(leftTuple2, rtm, context, rightIt);
                        }
                        RightTuple newBlocker = rootBlocker;
                        while (newBlocker != null) {
                            if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                                leftTuple2.setBlocker(newBlocker);
                                newBlocker.addBlocked(leftTuple2);
                                break;
                            }
                            newBlocker = (RightTuple)rightIt.next(newBlocker);
                        }
                        if (leftTuple2.getBlocker() == null) {
                            ltm.add(leftTuple2);
                            LeftTuple childLeftTuple = leftTuple2.getFirstChild();
                            if (childLeftTuple != null) {
                                childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                            }
                        }
                        leftTuple2 = temp;
                    }
                } else {
                    rtm.removeAdd(rightTuple);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public void doLeftDeletes(ExistsNode existsNode, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                RightTuple blocker = leftTuple.getBlocker();
                if (blocker == null) {
                    if (leftTuple.getMemory() != null) {
                        ltm.remove(leftTuple);
                    }
                } else {
                    LeftTuple childLeftTuple;
                    if (leftTuple.getFirstChild() != null && (childLeftTuple = leftTuple.getFirstChild()) != null) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                    blocker.removeBlocked(leftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doRightDeletes(ExistsNode existsNode, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean tupleMemory = true;
            RightTupleMemory rtm = bm.getRightTupleMemory();
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = existsNode.getRawConstraints();
            FastIterator it = existsNode.getRightIterator(rtm);
            RightTuple rightTuple = srcRightTuples.getDeleteFirst();
            while (rightTuple != null) {
                RightTuple rootBlocker;
                RightTuple next = rightTuple.getStagedNext();
                boolean useComparisonIndex = rtm.getIndexType().isComparison();
                RightTuple rightTuple2 = rootBlocker = useComparisonIndex ? null : (RightTuple)it.next(rightTuple);
                if (rightTuple.getMemory() != null) {
                    rtm.remove(rightTuple);
                }
                if (rightTuple.getBlocked() != null) {
                    PropagationContext context = rightTuple.getPropagationContext();
                    LeftTuple leftTuple = rightTuple.getBlocked();
                    while (leftTuple != null) {
                        LeftTuple temp = leftTuple.getBlockedNext();
                        leftTuple.clearBlocker();
                        if (leftTuple.getStagedType() == 2) {
                            leftTuple = temp;
                            continue;
                        }
                        constraints.updateFromTuple(contextEntry, wm, leftTuple);
                        if (useComparisonIndex) {
                            rootBlocker = rtm.getFirst(leftTuple, (InternalFactHandle)context.getFactHandle(), it);
                        }
                        RightTuple newBlocker = rootBlocker;
                        while (newBlocker != null) {
                            if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                                leftTuple.setBlocker(newBlocker);
                                newBlocker.addBlocked(leftTuple);
                                break;
                            }
                            newBlocker = (RightTuple)it.next(newBlocker);
                        }
                        if (leftTuple.getBlocker() == null) {
                            ltm.add(leftTuple);
                            LeftTuple childLeftTuple = leftTuple.getFirstChild();
                            if (childLeftTuple != null) {
                                childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                            }
                        }
                        leftTuple = temp;
                    }
                }
                rightTuple.nullBlocked();
                rightTuple.clearStaged();
                rightTuple = next;
            }
        }
    }

    public static class PhreakNotNode {
        public void doNode(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            RightTupleSets srcRightTuples = bm.getStagedRightTuples();
            if (srcRightTuples.getDeleteFirst() != null) {
                this.doRightDeletes(notNode, sink, bm, wm, srcRightTuples, trgLeftTuples);
            }
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(notNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null || srcRightTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluatorActivation.dpUpdatesReorderLeftMemory(bm, wm, srcRightTuples, srcLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                this.doRightUpdates(notNode, sink, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(notNode, sink, bm, wm, srcRightTuples, trgLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(notNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(notNode, sink, bm, wm, srcLeftTuples, trgLeftTuples);
            }
            srcRightTuples.resetAll();
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            FastIterator it = notNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                Object object;
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                boolean useLeftMemory = true;
                if (!(tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
                    useLeftMemory = false;
                }
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                RightTuple rightTuple = notNode.getFirstRightTuple(leftTuple, rtm, context, it);
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        leftTuple.setBlocker(rightTuple);
                        if (!useLeftMemory) break;
                        rightTuple.addBlocked(leftTuple);
                        break;
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
                if (leftTuple.getBlocker() == null) {
                    if (useLeftMemory) {
                        ltm.add(leftTuple);
                    }
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightInserts(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            FastIterator it = notNode.getLeftIterator(ltm);
            LeftTupleSets stagedLeftTuples = null;
            if (!bm.getSegmentMemory().isEmpty()) {
                stagedLeftTuples = ((SegmentMemory)bm.getSegmentMemory().getFirst()).getStagedLeftTuples();
            }
            PhreakNotNode.unlinkNotNodeOnRightInsert(notNode, bm, wm);
            RightTuple rightTuple = srcRightTuples.getInsertFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.add(rightTuple);
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple leftTuple = notNode.getFirstLeftTuple(rightTuple, ltm, context, it);
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)it.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        LeftTuple childLeftTuple = leftTuple.getFirstChild();
                        if (childLeftTuple != null) {
                            childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = temp;
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public static void unlinkNotNodeOnRightInsert(NotNode notNode, BetaMemory bm, InternalWorkingMemory wm) {
            if (bm.getSegmentMemory().isSegmentLinked() && !notNode.isRightInputIsRiaNode() && notNode.isEmptyBetaConstraints()) {
                bm.unlinkNode(wm);
            }
        }

        public void doLeftUpdates(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            FastIterator rightIt = notNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                RightTuple firstRightTuple = notNode.getFirstRightTuple(leftTuple, rtm, context, rightIt);
                RightTuple blocker = leftTuple.getBlocker();
                if (blocker == null) {
                    ltm.remove(leftTuple);
                } else if (rtm.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
                    blocker.removeBlocked(leftTuple);
                    blocker = null;
                }
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                if (blocker == null || !constraints.isAllowedCachedLeft(contextEntry, blocker.getFactHandle())) {
                    if (blocker != null) {
                        blocker.removeBlocked(leftTuple);
                    }
                    RightTuple newBlocker = firstRightTuple;
                    while (newBlocker != null) {
                        if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                            leftTuple.setBlocker(newBlocker);
                            newBlocker.addBlocked(leftTuple);
                            break;
                        }
                        newBlocker = (RightTuple)rightIt.next(newBlocker);
                    }
                    LeftTuple childLeftTuple = leftTuple.getFirstChild();
                    if (leftTuple.getBlocker() != null) {
                        if (leftTuple.getFirstChild() != null) {
                            RuleNetworkEvaluatorActivation.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    } else if (childLeftTuple == null) {
                        ltm.add(leftTuple);
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                    } else {
                        switch (childLeftTuple.getStagedType()) {
                            case 1: {
                                stagedLeftTuples.removeInsert(childLeftTuple);
                                break;
                            }
                            case 2: {
                                stagedLeftTuples.removeUpdate(childLeftTuple);
                            }
                        }
                        ltm.add(leftTuple);
                        trgLeftTuples.addUpdate(childLeftTuple);
                        childLeftTuple.reAddLeft();
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightUpdates(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            FastIterator leftIt = notNode.getLeftIterator(ltm);
            FastIterator rightIt = notNode.getRightIterator(rtm);
            RightTuple rightTuple = srcRightTuples.getUpdateFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                if (ltm == null || ltm.size() == 0 && rightTuple.getBlocked() == null) {
                    rtm.removeAdd(rightTuple);
                    rightTuple.clearStaged();
                    rightTuple = next;
                    continue;
                }
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple firstLeftTuple = notNode.getFirstLeftTuple(rightTuple, ltm, context, leftIt);
                LeftTuple firstBlocked = rightTuple.getBlocked();
                rightTuple.nullBlocked();
                LeftTuple leftTuple = firstLeftTuple;
                while (leftTuple != null) {
                    LeftTuple temp = (LeftTuple)leftIt.next(leftTuple);
                    if (leftTuple.getStagedType() == 2) {
                        leftTuple = temp;
                        continue;
                    }
                    if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        leftTuple.setBlocker(rightTuple);
                        rightTuple.addBlocked(leftTuple);
                        ltm.remove(leftTuple);
                        if (leftTuple.getFirstChild() != null) {
                            RuleNetworkEvaluatorActivation.deleteRightChild(leftTuple.getFirstChild(), trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = temp;
                }
                if (firstBlocked != null) {
                    boolean useComparisonIndex = rtm.getIndexType().isComparison();
                    RightTuple rootBlocker = useComparisonIndex ? null : (RightTuple)rightIt.next(rightTuple);
                    RightTupleList list = rightTuple.getMemory();
                    rtm.removeAdd(rightTuple);
                    if (!useComparisonIndex && rootBlocker == null && list == rightTuple.getMemory()) {
                        rootBlocker = rightTuple;
                    }
                    LeftTuple leftTuple2 = firstBlocked;
                    while (leftTuple2 != null) {
                        LeftTuple temp = leftTuple2.getBlockedNext();
                        leftTuple2.clearBlocker();
                        if (leftTuple2.getStagedType() == 2) {
                            leftTuple2.setBlocker(rightTuple);
                            rightTuple.addBlocked(leftTuple2);
                            leftTuple2 = temp;
                            continue;
                        }
                        constraints.updateFromTuple(contextEntry, wm, leftTuple2);
                        if (useComparisonIndex) {
                            rootBlocker = notNode.getFirstRightTuple(leftTuple2, rtm, context, rightIt);
                        }
                        RightTuple newBlocker = rootBlocker;
                        while (newBlocker != null) {
                            if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                                leftTuple2.setBlocker(newBlocker);
                                newBlocker.addBlocked(leftTuple2);
                                break;
                            }
                            newBlocker = (RightTuple)rightIt.next(newBlocker);
                        }
                        if (leftTuple2.getBlocker() == null) {
                            ltm.add(leftTuple2);
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple2, sink, tupleMemory));
                        }
                        leftTuple2 = temp;
                    }
                } else {
                    rtm.removeAdd(rightTuple);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
            constraints.resetTuple(contextEntry);
        }

        public void doLeftDeletes(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                RightTuple blocker = leftTuple.getBlocker();
                if (blocker == null) {
                    LeftTuple childLeftTuple;
                    if (leftTuple.getMemory() != null) {
                        ltm.remove(leftTuple);
                    }
                    if ((childLeftTuple = leftTuple.getFirstChild()) != null) {
                        RuleNetworkEvaluatorActivation.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                } else {
                    blocker.removeBlocked(leftTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doRightDeletes(NotNode notNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = notNode.getRawConstraints();
            FastIterator it = notNode.getRightIterator(rtm);
            RightTuple rightTuple = srcRightTuples.getDeleteFirst();
            while (rightTuple != null) {
                RightTuple rootBlocker;
                RightTuple next = rightTuple.getStagedNext();
                boolean useComparisonIndex = rtm.getIndexType().isComparison();
                RightTuple rightTuple2 = rootBlocker = useComparisonIndex ? null : (RightTuple)it.next(rightTuple);
                if (rightTuple.getMemory() != null) {
                    rtm.remove(rightTuple);
                }
                if (rightTuple.getBlocked() != null) {
                    PropagationContext context = rightTuple.getPropagationContext();
                    LeftTuple leftTuple = rightTuple.getBlocked();
                    while (leftTuple != null) {
                        LeftTuple temp = leftTuple.getBlockedNext();
                        leftTuple.clearBlocker();
                        if (leftTuple.getStagedType() == 2) {
                            leftTuple = temp;
                            continue;
                        }
                        constraints.updateFromTuple(contextEntry, wm, leftTuple);
                        if (useComparisonIndex) {
                            rootBlocker = rtm.getFirst(leftTuple, (InternalFactHandle)context.getFactHandle(), it);
                        }
                        RightTuple newBlocker = rootBlocker;
                        while (newBlocker != null) {
                            if (constraints.isAllowedCachedLeft(contextEntry, newBlocker.getFactHandle())) {
                                leftTuple.setBlocker(newBlocker);
                                newBlocker.addBlocked(leftTuple);
                                break;
                            }
                            newBlocker = (RightTuple)it.next(newBlocker);
                        }
                        if (leftTuple.getBlocker() == null) {
                            ltm.add(leftTuple);
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, tupleMemory));
                        }
                        leftTuple = temp;
                    }
                }
                rightTuple.nullBlocked();
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }
    }

    public static class PhreakJoinNode {
        public void doNode(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            RightTupleSets srcRightTuples = bm.getStagedRightTuples();
            if (srcRightTuples.getDeleteFirst() != null) {
                this.doRightDeletes(joinNode, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getDeleteFirst() != null) {
                this.doLeftDeletes(joinNode, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null || srcRightTuples.getUpdateFirst() != null) {
                RuleNetworkEvaluatorActivation.dpUpdatesReorderLeftMemory(bm, wm, srcRightTuples, srcLeftTuples);
                RuleNetworkEvaluatorActivation.dpUpdatesReorderRightMemory(bm, wm, srcRightTuples, srcLeftTuples);
            }
            if (srcRightTuples.getUpdateFirst() != null) {
                this.doRightUpdates(joinNode, sink, bm, wm, srcRightTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcLeftTuples.getUpdateFirst() != null) {
                this.doLeftUpdates(joinNode, sink, bm, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
            }
            if (srcRightTuples.getInsertFirst() != null) {
                this.doRightInserts(joinNode, sink, bm, wm, srcRightTuples, trgLeftTuples);
            }
            if (srcLeftTuples.getInsertFirst() != null) {
                this.doLeftInserts(joinNode, sink, bm, wm, srcLeftTuples, trgLeftTuples);
            }
            srcRightTuples.resetAll();
            srcLeftTuples.resetAll();
        }

        public void doLeftInserts(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = joinNode.getRawConstraints();
            FastIterator it = joinNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
            while (leftTuple != null) {
                Object object;
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                boolean useLeftMemory = true;
                if (!(tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
                    useLeftMemory = false;
                }
                if (useLeftMemory) {
                    ltm.add(leftTuple);
                }
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                RightTuple rightTuple = joinNode.getFirstRightTuple(leftTuple, rtm, context, it);
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, tupleMemory));
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public void doRightInserts(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples) {
            boolean tupleMemory = true;
            boolean tupleMemoryEnabled = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = joinNode.getRawConstraints();
            FastIterator it = joinNode.getLeftIterator(ltm);
            RightTuple rightTuple = srcRightTuples.getInsertFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                rtm.add(rightTuple);
                PropagationContext context = rightTuple.getPropagationContext();
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                LeftTuple leftTuple = joinNode.getFirstLeftTuple(rightTuple, ltm, context, it);
                while (leftTuple != null) {
                    if (leftTuple.getStagedType() != 2 && constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, tupleMemory));
                    }
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public void doLeftUpdates(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean tupleMemory = true;
            RightTupleMemory rtm = bm.getRightTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = joinNode.getRawConstraints();
            FastIterator it = joinNode.getRightIterator(rtm);
            LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                PropagationContext context = leftTuple.getPropagationContext();
                constraints.updateFromTuple(contextEntry, wm, leftTuple);
                RightTuple rightTuple = joinNode.getFirstRightTuple(leftTuple, rtm, context, it);
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                if (childLeftTuple != null && rtm.isIndexed() && !it.isFullIterator() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                if (rightTuple != null) {
                    this.doLeftUpdatesProcessChildren(childLeftTuple, leftTuple, rightTuple, stagedLeftTuples, tupleMemory, contextEntry, constraints, sink, it, trgLeftTuples);
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
            constraints.resetTuple(contextEntry);
        }

        public LeftTuple doLeftUpdatesProcessChildren(LeftTuple childLeftTuple, LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSets stagedLeftTuples, boolean tupleMemory, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTupleSink sink, FastIterator it, LeftTupleSets trgLeftTuples) {
            if (childLeftTuple == null) {
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, tupleMemory));
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
            } else {
                while (rightTuple != null) {
                    if (constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                            trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, tupleMemory));
                        } else {
                            switch (childLeftTuple.getStagedType()) {
                                case 1: {
                                    stagedLeftTuples.removeInsert(childLeftTuple);
                                    break;
                                }
                                case 2: {
                                    stagedLeftTuples.removeUpdate(childLeftTuple);
                                }
                            }
                            trgLeftTuples.addUpdate(childLeftTuple);
                            childLeftTuple.reAddRight();
                            childLeftTuple = childLeftTuple.getLeftParentNext();
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                    rightTuple = (RightTuple)it.next(rightTuple);
                }
            }
            return childLeftTuple;
        }

        public void doRightUpdates(JoinNode joinNode, LeftTupleSink sink, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            boolean tupleMemory = true;
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            ContextEntry[] contextEntry = bm.getContext();
            BetaConstraints constraints = joinNode.getRawConstraints();
            FastIterator it = joinNode.getLeftIterator(ltm);
            RightTuple rightTuple = srcRightTuples.getUpdateFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                PropagationContext context = rightTuple.getPropagationContext();
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                LeftTuple leftTuple = joinNode.getFirstLeftTuple(rightTuple, ltm, context, it);
                constraints.updateFromFactHandle(contextEntry, wm, rightTuple.getFactHandle());
                if (childLeftTuple != null && ltm.isIndexed() && !it.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                if (leftTuple != null) {
                    this.doRightUpdatesProcessChildren(childLeftTuple, leftTuple, rightTuple, stagedLeftTuples, tupleMemory, contextEntry, constraints, sink, it, trgLeftTuples);
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
            constraints.resetFactHandle(contextEntry);
        }

        public LeftTuple doRightUpdatesProcessChildren(LeftTuple childLeftTuple, LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSets stagedLeftTuples, boolean tupleMemory, ContextEntry[] contextEntry, BetaConstraints constraints, LeftTupleSink sink, FastIterator it, LeftTupleSets trgLeftTuples) {
            if (childLeftTuple == null) {
                while (leftTuple != null) {
                    if (leftTuple.getStagedType() != 2 && constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                        trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, tupleMemory));
                    }
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
            } else {
                while (leftTuple != null) {
                    if (leftTuple.getStagedType() != 2) {
                        if (constraints.isAllowedCachedRight(contextEntry, leftTuple)) {
                            if (childLeftTuple == null || childLeftTuple.getLeftParent() != leftTuple) {
                                trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, tupleMemory));
                            } else {
                                switch (childLeftTuple.getStagedType()) {
                                    case 1: {
                                        stagedLeftTuples.removeInsert(childLeftTuple);
                                        break;
                                    }
                                    case 2: {
                                        stagedLeftTuples.removeUpdate(childLeftTuple);
                                    }
                                }
                                trgLeftTuples.addUpdate(childLeftTuple);
                                childLeftTuple.reAddLeft();
                                childLeftTuple = childLeftTuple.getRightParentNext();
                            }
                        } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                            childLeftTuple = RuleNetworkEvaluatorActivation.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                        }
                    }
                    leftTuple = (LeftTuple)it.next(leftTuple);
                }
            }
            return childLeftTuple;
        }

        public void doLeftDeletes(JoinNode joinNode, BetaMemory bm, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            LeftTupleMemory ltm = bm.getLeftTupleMemory();
            LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple next = leftTuple.getStagedNext();
                if (leftTuple.getMemory() != null) {
                    ltm.remove(leftTuple);
                }
                if (leftTuple.getFirstChild() != null) {
                    LeftTuple childLeftTuple = leftTuple.getFirstChild();
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }

        public void doRightDeletes(JoinNode joinNode, BetaMemory bm, InternalWorkingMemory wm, RightTupleSets srcRightTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
            RightTupleMemory rtm = bm.getRightTupleMemory();
            RightTuple rightTuple = srcRightTuples.getDeleteFirst();
            while (rightTuple != null) {
                RightTuple next = rightTuple.getStagedNext();
                if (rightTuple.getMemory() != null) {
                    rtm.remove(rightTuple);
                }
                if (rightTuple.getFirstChild() != null) {
                    LeftTuple childLeftTuple = rightTuple.getFirstChild();
                    while (childLeftTuple != null) {
                        childLeftTuple = RuleNetworkEvaluatorActivation.deleteRightChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                    }
                }
                rightTuple.clearStaged();
                rightTuple = next;
            }
        }
    }
}

