/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.RuleBaseFactory;
import org.drools.core.StatefulSession;
import org.drools.core.WorkingMemory;
import org.drools.core.base.DefaultKnowledgeHelper;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.DefaultAgenda;
import org.drools.core.common.LogicalDependency;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.spi.Activation;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.Match;

public class AgendaItemTest {
    @Test
    public void testAddition() {
        ReteooRuleBase rbase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        StatefulSession wm = rbase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)wm.getAgenda();
        AgendaItem item1 = agenda.createAgendaItem(null, 0, null, null);
        AgendaItem item2 = agenda.createAgendaItem(null, 0, null, null);
        AgendaItem item3 = agenda.createAgendaItem(null, 0, null, null);
        DefaultKnowledgeHelper kcontext = new DefaultKnowledgeHelper((WorkingMemory)wm);
        kcontext.setActivation((Activation)item1);
        kcontext.blockMatch((Match)item2);
        kcontext.blockMatch((Match)item3);
        Assert.assertNull((Object)item1.getBlockers());
        Assert.assertEquals((long)2L, (long)item1.getBlocked().size());
        Assert.assertEquals((long)1L, (long)item2.getBlockers().size());
        Assert.assertEquals((long)1L, (long)item3.getBlockers().size());
        kcontext.reset();
        kcontext.setActivation((Activation)item2);
        kcontext.blockMatch((Match)item3);
        Assert.assertEquals((long)2L, (long)item1.getBlocked().size());
        Assert.assertEquals((long)1L, (long)item2.getBlocked().size());
        Assert.assertEquals((long)1L, (long)item2.getBlockers().size());
        Assert.assertEquals((long)2L, (long)item3.getBlockers().size());
    }

    @Test
    public void testRemoval() {
        ReteooRuleBase rbase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        StatefulSession wm = rbase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)wm.getAgenda();
        AgendaItem item1 = agenda.createAgendaItem(null, 0, null, null);
        AgendaItem item2 = agenda.createAgendaItem(null, 0, null, null);
        AgendaItem item3 = agenda.createAgendaItem(null, 0, null, null);
        DefaultKnowledgeHelper kcontext = new DefaultKnowledgeHelper((WorkingMemory)wm);
        kcontext.setActivation((Activation)item1);
        kcontext.blockMatch((Match)item2);
        kcontext.blockMatch((Match)item3);
        kcontext.reset();
        kcontext.setActivation((Activation)item2);
        kcontext.blockMatch((Match)item3);
        item1.removeAllBlockersAndBlocked(agenda);
        Assert.assertEquals((long)0L, (long)item2.getBlockers().size());
        Assert.assertEquals((long)1L, (long)item2.getBlocked().size());
        Assert.assertEquals((long)1L, (long)item3.getBlockers().size());
        Assert.assertNull((Object)item3.getBlocked());
        Assert.assertSame((Object)item2, (Object)((LogicalDependency)item2.getBlocked().getFirst()).getJustifier());
        Assert.assertSame((Object)item3, (Object)((LogicalDependency)item2.getBlocked().getFirst()).getJustified());
        item2.removeAllBlockersAndBlocked(agenda);
        Assert.assertEquals((long)0L, (long)item3.getBlockers().size());
        Assert.assertNull((Object)item3.getBlocked());
        Assert.assertNull((Object)item2.getBlocked());
        Assert.assertNull((Object)item2.getBlocked());
        Assert.assertNull((Object)item1.getBlocked());
        Assert.assertNull((Object)item1.getBlocked());
        kcontext.blockMatch((Match)item3);
        Assert.assertNull((Object)item2.getBlockers());
        Assert.assertEquals((long)1L, (long)item2.getBlocked().size());
        Assert.assertEquals((long)1L, (long)item3.getBlockers().size());
        Assert.assertNull((Object)item3.getBlocked());
        Assert.assertSame((Object)item2, (Object)((LogicalDependency)item2.getBlocked().getFirst()).getJustifier());
        Assert.assertSame((Object)item3, (Object)((LogicalDependency)item2.getBlocked().getFirst()).getJustified());
        item3.removeAllBlockersAndBlocked(agenda);
        Assert.assertNull((Object)item3.getBlockers());
        Assert.assertNull((Object)item3.getBlocked());
        Assert.assertEquals((long)0L, (long)item2.getBlocked().size());
        Assert.assertNull((Object)item2.getBlockers());
        Assert.assertNull((Object)item1.getBlocked());
        Assert.assertNull((Object)item1.getBlocked());
    }

    @Test
    public void testUnblockAll() {
        ReteooRuleBase rbase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        StatefulSession wm = rbase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)wm.getAgenda();
        AgendaItem item1 = agenda.createAgendaItem(null, 0, null, null);
        AgendaItem item2 = agenda.createAgendaItem(null, 0, null, null);
        AgendaItem item3 = agenda.createAgendaItem(null, 0, null, null);
        DefaultKnowledgeHelper kcontext = new DefaultKnowledgeHelper((WorkingMemory)wm);
        kcontext.setActivation((Activation)item1);
        kcontext.blockMatch((Match)item3);
        kcontext.reset();
        kcontext.setActivation((Activation)item2);
        kcontext.blockMatch((Match)item3);
        kcontext.unblockAllMatches((Match)item3);
        Assert.assertEquals((long)0L, (long)item3.getBlockers().size());
        Assert.assertNull((Object)item3.getBlocked());
        Assert.assertEquals((long)0L, (long)item2.getBlocked().size());
        Assert.assertNull((Object)item2.getBlockers());
        Assert.assertEquals((long)0L, (long)item1.getBlocked().size());
        Assert.assertEquals((long)0L, (long)item1.getBlocked().size());
    }

    @Test
    public void testKnowledgeHelperUpdate() {
        ReteooRuleBase rbase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        StatefulSession wm = rbase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)wm.getAgenda();
        AgendaItem item1 = agenda.createAgendaItem(null, 0, null, null);
        AgendaItem item2 = agenda.createAgendaItem(null, 0, null, null);
        AgendaItem item3 = agenda.createAgendaItem(null, 0, null, null);
        AgendaItem item4 = agenda.createAgendaItem(null, 0, null, null);
        DefaultKnowledgeHelper kcontext = new DefaultKnowledgeHelper((WorkingMemory)wm);
        kcontext.setActivation((Activation)item1);
        kcontext.blockMatch((Match)item2);
        kcontext.blockMatch((Match)item3);
        kcontext.reset();
        kcontext.setActivation((Activation)item1);
        kcontext.blockMatch((Match)item4);
        kcontext.cancelRemainingPreviousLogicalDependencies();
        Assert.assertEquals((long)1L, (long)item1.getBlocked().size());
        Assert.assertEquals((Object)item4, (Object)((LogicalDependency)item1.getBlocked().getFirst()).getJustified());
        Assert.assertEquals((long)0L, (long)item2.getBlockers().size());
        Assert.assertEquals((long)0L, (long)item3.getBlockers().size());
        Assert.assertEquals((long)1L, (long)item4.getBlockers().size());
    }
}

