/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.beans.IntrospectionException;
import org.drools.core.FactException;
import org.drools.core.RuleBaseFactory;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.FieldFactory;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextImpl;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.MockObjectSink;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.ReteooWorkingMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.MvelConstraintTestUtil;
import org.drools.core.rule.Rule;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.DroolsTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.rule.FactHandle;

public class AlphaNodeTest
extends DroolsTestCase {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testLiteralConstraintAssertObjectWithoutMemory() throws Exception {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        Rule rule = new Rule("test-rule");
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        MockObjectSource source = new MockObjectSource(buildContext.getNextId());
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        FieldValue field = FieldFactory.getInstance().getFieldValue((Object)"cheddar");
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("type == \"cheddar\"", field, (InternalReadAccessor)extractor);
        AlphaNode alphaNode = new AlphaNode(buildContext.getNextId(), (AlphaNodeFieldConstraint)constraint, (ObjectSource)source, buildContext);
        MockObjectSink sink = new MockObjectSink();
        alphaNode.addObjectSink((ObjectSink)sink);
        Cheese cheddar = new Cheese("cheddar", 5);
        DefaultFactHandle f0 = (DefaultFactHandle)workingMemory.insert((Object)cheddar);
        this.assertLength(0, sink.getAsserted());
        AlphaNode.AlphaMemory memory = (AlphaNode.AlphaMemory)workingMemory.getNodeMemory((MemoryFactory)alphaNode);
        alphaNode.assertObject((InternalFactHandle)f0, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)sink.getAsserted().size());
        Object[] list = (Object[])sink.getAsserted().get(0);
        Assert.assertSame((Object)cheddar, (Object)workingMemory.getObject((FactHandle)((DefaultFactHandle)list[0])));
        Cheese stilton = new Cheese("stilton", 6);
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)stilton);
        alphaNode.assertObject((InternalFactHandle)f1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        this.assertLength(1, sink.getAsserted());
        list = (Object[])sink.getAsserted().get(0);
        Assert.assertSame((Object)cheddar, (Object)workingMemory.getObject((FactHandle)((DefaultFactHandle)list[0])));
    }

    @Test
    public void testReturnValueConstraintAssertObject() throws Exception {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        Rule rule = new Rule("test-rule");
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        MockObjectSource source = new MockObjectSource(buildContext.getNextId());
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        FieldValue field = FieldFactory.getInstance().getFieldValue((Object)"cheddar");
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("type == \"cheddar\"", field, (InternalReadAccessor)extractor);
        AlphaNode alphaNode = new AlphaNode(buildContext.getNextId(), (AlphaNodeFieldConstraint)constraint, (ObjectSource)source, buildContext);
        MockObjectSink sink = new MockObjectSink();
        alphaNode.addObjectSink((ObjectSink)sink);
        Cheese cheddar = new Cheese("cheddar", 5);
        DefaultFactHandle f0 = (DefaultFactHandle)workingMemory.insert((Object)cheddar);
        this.assertLength(0, sink.getAsserted());
        alphaNode.assertObject((InternalFactHandle)f0, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        this.assertLength(1, sink.getAsserted());
        Object[] list = (Object[])sink.getAsserted().get(0);
        Assert.assertSame((Object)cheddar, (Object)workingMemory.getObject((FactHandle)((DefaultFactHandle)list[0])));
        Cheese stilton = new Cheese("stilton", 6);
        f0.setObject((Object)stilton);
        sink.getAsserted().clear();
        alphaNode.assertObject((InternalFactHandle)f0, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        this.assertLength(0, sink.getAsserted());
    }

    @Test
    public void testUpdateSinkWithoutMemory() throws FactException, IntrospectionException {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        Rule rule = new Rule("test-rule");
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        MockObjectSource source = new MockObjectSource(buildContext.getNextId());
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        FieldValue field = FieldFactory.getInstance().getFieldValue((Object)"cheddar");
        MvelConstraintTestUtil constraint = new MvelConstraintTestUtil("type == \"cheddar\"", field, (InternalReadAccessor)extractor);
        AlphaNode alphaNode = new AlphaNode(buildContext.getNextId(), (AlphaNodeFieldConstraint)constraint, (ObjectSource)source, buildContext);
        alphaNode.attach();
        MockObjectSink sink1 = new MockObjectSink();
        alphaNode.addObjectSink((ObjectSink)sink1);
        Cheese cheese = new Cheese("cheddar", 0);
        DefaultFactHandle handle1 = new DefaultFactHandle(1, (Object)cheese);
        source.addFact((InternalFactHandle)handle1);
        alphaNode.assertObject((InternalFactHandle)handle1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Cheese stilton = new Cheese("stilton", 10);
        DefaultFactHandle handle2 = new DefaultFactHandle(2, (Object)stilton);
        source.addFact((InternalFactHandle)handle2);
        alphaNode.assertObject((InternalFactHandle)handle2, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        this.assertLength(1, sink1.getAsserted());
        MockObjectSink sink2 = new MockObjectSink();
        alphaNode.updateSink((ObjectSink)sink2, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        this.assertLength(1, sink1.getAsserted());
        this.assertLength(1, sink2.getAsserted());
        Assert.assertEquals((long)1L, (long)source.getUdated());
    }
}

