/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.Rule;
import org.drools.core.spi.Activation;
import org.drools.core.spi.AgendaGroup;
import org.drools.core.spi.ConflictResolver;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.drools.core.util.Queueable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.rule.FactHandle;

public class BinaryHeapQueueTest {
    private List<Integer[]> perms = new ArrayList<Integer[]>();
    private static final int max = 6;

    private void shuffle(Integer[] a, int lim) {
        if (lim == 0) {
            Integer[] p = (Integer[])a.clone();
            this.perms.add(p);
        } else {
            this.shuffle(a, lim - 1);
            Integer h = a[lim];
            a[lim] = a[lim - 1];
            a[lim - 1] = h;
            this.shuffle(a, lim - 1);
        }
    }

    @Before
    public void setup() {
        System.out.println("Running setup");
        Integer[] a = new Integer[6];
        for (int i = 0; i < 6; ++i) {
            a[i] = i;
        }
        this.shuffle(a, 5);
    }

    @Test
    public void testShuffled() {
        for (Integer[] perm : this.perms) {
            Queueable[] elems;
            Group group = new Group("group");
            for (Integer i : perm) {
                Item item = new Item(group, i);
                group.add(item);
            }
            for (Queueable elem : elems = group.getQueue()) {
                Item item = (Item)elem;
                if (item.getIndex() % 2 != 0) continue;
                group.remove(item);
                group.add(item);
            }
            boolean ok = true;
            StringBuilder sb = new StringBuilder("queue:");
            for (int i = 5; i >= 0; --i) {
                int sal = group.getNext().getSalience();
                sb.append(" ").append(sal);
                if (sal == i) continue;
                ok = false;
            }
            Assert.assertTrue((String)("incorrect order in " + sb.toString()), (boolean)ok);
        }
    }

    public static class ItemConflictResolver
    implements ConflictResolver {
        private static final long serialVersionUID = 1L;
        public static final ItemConflictResolver INSTANCE = new ItemConflictResolver();

        public static ItemConflictResolver getInstance() {
            return INSTANCE;
        }

        public final int compare(Object existing, Object adding) {
            return this.compare((Item)existing, (Item)adding);
        }

        public final int compare(Item existing, Item adding) {
            int s2;
            int s1 = existing.getSalience();
            if (s1 != (s2 = adding.getSalience())) {
                return s1 - s2;
            }
            return (int)(existing.getActivationNumber() - adding.getActivationNumber());
        }

        public int compare(Activation arg0, Activation arg1) {
            return 0;
        }
    }

    public static class Item
    implements Queueable,
    Activation {
        private static int actNo = 1;
        private int index;
        private long activationNumber;
        private Group group;
        private int salience;

        public Item(Group group, int salience) {
            this.group = group;
            this.salience = salience;
            this.activationNumber = actNo++;
        }

        public void dequeue() {
            if (this.group != null) {
                this.group.remove(this);
            }
            this.index = -1;
        }

        public void enqueued(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public int getSalience() {
            return this.salience;
        }

        public long getActivationNumber() {
            return this.activationNumber;
        }

        public void addLogicalDependency(LogicalDependency arg0) {
        }

        public ActivationGroupNode getActivationGroupNode() {
            return null;
        }

        public ActivationNode getActivationNode() {
            return null;
        }

        public AgendaGroup getAgendaGroup() {
            return null;
        }

        public LinkedList getLogicalDependencies() {
            return null;
        }

        public PropagationContext getPropagationContext() {
            return null;
        }

        public Rule getRule() {
            return null;
        }

        public Consequence getConsequence() {
            return null;
        }

        public GroupElement getSubRule() {
            return null;
        }

        public LeftTupleImpl getTuple() {
            return null;
        }

        public boolean isActivated() {
            return false;
        }

        public void remove() {
        }

        public void setActivated(boolean arg0) {
        }

        public void setActivationGroupNode(ActivationGroupNode arg0) {
        }

        public void setActivationNode(ActivationNode arg0) {
        }

        public void setLogicalDependencies(LinkedList<LogicalDependency> arg0) {
        }

        public List<String> getDeclarationIds() {
            return null;
        }

        public Object getDeclarationValue(String arg0) {
            return null;
        }

        public List<? extends FactHandle> getFactHandles() {
            return null;
        }

        public List<Object> getObjects() {
            return null;
        }

        public InternalFactHandle getFactHandle() {
            return null;
        }

        public boolean isAdded() {
            return false;
        }

        public boolean isActive() {
            return this.isActivated();
        }

        public void addBlocked(LogicalDependency node) {
        }

        public LinkedList getBlocked() {
            return null;
        }

        public void setBlocked(LinkedList<LogicalDependency> justified) {
        }

        public void addBlocked(LinkedListNode node) {
        }

        public LinkedList getBlockers() {
            return null;
        }

        public boolean isMatched() {
            return false;
        }

        public void setMatched(boolean matched) {
        }

        public boolean isRuleNetworkEvaluatorActivation() {
            return false;
        }
    }

    public static class IsTuple
    extends BaseMatcher<List<InternalFactHandle>> {
        private final InternalFactHandle[] expected;

        public IsTuple(List<InternalFactHandle> tupleAsList) {
            this.expected = tupleAsList.toArray(new InternalFactHandle[tupleAsList.size()]);
        }

        public IsTuple(InternalFactHandle[] tuple) {
            this.expected = tuple;
        }

        public boolean matches(Object arg) {
            if (arg == null || !arg.getClass().isArray() || !InternalFactHandle.class.isAssignableFrom(arg.getClass().getComponentType())) {
                return false;
            }
            Object[] actual = (InternalFactHandle[])arg;
            return Arrays.equals(this.expected, actual);
        }

        public void describeTo(Description description) {
            description.appendValue((Object)this.expected);
        }

        @Factory
        public static Matcher<List<InternalFactHandle>> isTuple(List<InternalFactHandle> operand) {
            return new IsTuple(operand);
        }

        public static Matcher<? super List<InternalFactHandle>> isTuple(InternalFactHandle ... operands) {
            return new IsTuple(operands);
        }
    }

    public static class Group {
        private static final long serialVersionUID = 510L;
        private String name;
        private BinaryHeapQueue queue;

        public Group() {
        }

        public Group(String name) {
            this.name = name;
            this.queue = new BinaryHeapQueue((Comparator)((Object)ItemConflictResolver.INSTANCE));
        }

        public String getName() {
            return this.name;
        }

        public void clear() {
            this.queue.clear();
        }

        public int size() {
            return this.queue.size();
        }

        public void add(Item item) {
            this.queue.enqueue((Queueable)item);
        }

        public Item getNext() {
            return (Item)this.queue.dequeue();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public String toString() {
            return "AgendaGroup '" + this.name + "'";
        }

        public boolean equal(Object object) {
            if (object == null || !(object instanceof Group)) {
                return false;
            }
            return ((Group)object).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public void remove(Item agendaItem) {
            this.queue.dequeue(agendaItem.getIndex());
        }

        public Queueable[] getQueue() {
            return (Queueable[])this.queue.toArray((Object[])new Queueable[this.size()]);
        }
    }
}

