/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.BeanClassBuilder;
import org.drools.core.factmodel.BuildUtils;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitTypeMap;
import org.mvel2.asm.AnnotationVisitor;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Opcodes;
import org.mvel2.asm.Type;

public class DefaultBeanClassBuilder
implements Opcodes,
BeanClassBuilder,
Serializable {
    protected boolean debug = false;

    public DefaultBeanClassBuilder() {
        this("true".equalsIgnoreCase(System.getProperty("org.drools.classbuilder.debug")));
    }

    public DefaultBeanClassBuilder(boolean debug) {
        this.debug = debug;
    }

    @Override
    public byte[] buildClass(ClassDefinition classDef) throws IOException, IntrospectionException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        ClassWriter cw = new ClassWriter(1);
        this.buildClassHeader((ClassVisitor)cw, classDef);
        this.buildFields(cw, classDef);
        if (classDef.isTraitable()) {
            this.buildDynamicPropertyMap(cw, classDef);
            this.buildTraitMap(cw, classDef);
        }
        this.buildConstructors(cw, classDef);
        this.buildGettersAndSetters(cw, classDef);
        this.buildEqualityMethods(cw, classDef);
        this.buildToString((ClassVisitor)cw, classDef);
        if (classDef.isTraitable()) {
            this.buildSerializationMethods(cw, classDef);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void buildSerializationMethods(ClassWriter cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "writeExternal", "(Ljava/io/ObjectOutput;)V", null, new String[]{"java/io/IOException"});
        mv.visitCode();
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 0);
            this.visitFieldOrGetter(mv, classDef, field);
            mv.visitMethodInsn(185, "java/io/ObjectOutput", BuildUtils.serializationWriterName(field.getTypeName()), "(" + (BuildUtils.isPrimitive(field.getTypeName()) ? BuildUtils.getTypeDescriptor(field.getTypeName()) : "Ljava/lang/Object;") + ")V");
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(classDef.getClassName()), "__$$dynamic_properties_map$$", Type.getDescriptor(Map.class));
        mv.visitMethodInsn(185, "java/io/ObjectOutput", "writeObject", "(Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(classDef.getClassName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitMethodInsn(185, "java/io/ObjectOutput", "writeObject", "(Ljava/lang/Object;)V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "readExternal", "(Ljava/io/ObjectInput;)V", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        mv.visitCode();
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "java/io/ObjectInput", BuildUtils.serializationReaderName(field.getTypeName()), "()" + (BuildUtils.isPrimitive(field.getTypeName()) ? BuildUtils.getTypeDescriptor(field.getTypeName()) : "Ljava/lang/Object;"));
            if (!BuildUtils.isPrimitive(field.getTypeName())) {
                mv.visitTypeInsn(192, BuildUtils.getInternalType(field.getTypeName()));
            }
            mv.visitMethodInsn(182, BuildUtils.getInternalType(classDef.getName()), BuildUtils.setterName(field.getName(), field.getTypeName()), "(" + BuildUtils.getTypeDescriptor(field.getTypeName()) + ")V");
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "java/io/ObjectInput", "readObject", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, "java/util/Map");
        mv.visitFieldInsn(181, BuildUtils.getInternalType(classDef.getClassName()), "__$$dynamic_properties_map$$", Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "java/io/ObjectInput", "readObject", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, "java/util/Map");
        mv.visitFieldInsn(181, BuildUtils.getInternalType(classDef.getClassName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildGettersAndSetters(ClassWriter cw, ClassDefinition classDef) {
        for (FieldDefinition fieldDef : classDef.getFieldsDefinitions()) {
            if (fieldDef.isInherited()) continue;
            this.buildGetMethod((ClassVisitor)cw, classDef, fieldDef);
            this.buildSetMethod((ClassVisitor)cw, classDef, fieldDef);
        }
    }

    protected void buildEqualityMethods(ClassWriter cw, ClassDefinition classDef) {
        boolean hasKey = false;
        for (FieldDefinition fld : classDef.getFieldsDefinitions()) {
            if (!fld.isKey()) continue;
            hasKey = true;
            break;
        }
        if (hasKey) {
            this.buildEquals((ClassVisitor)cw, classDef);
            this.buildHashCode((ClassVisitor)cw, classDef);
        }
    }

    protected void buildFields(ClassWriter cw, ClassDefinition classDef) {
        for (FieldDefinition fieldDef : classDef.getFieldsDefinitions()) {
            if (fieldDef.isInherited()) continue;
            this.buildField((ClassVisitor)cw, fieldDef);
        }
    }

    protected void buildConstructors(ClassWriter cw, ClassDefinition classDef) {
        try {
            this.buildDefaultConstructor((ClassVisitor)cw, classDef);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (classDef.getFieldsDefinitions().size() > 0 && classDef.getFieldsDefinitions().size() < 120) {
            this.buildConstructorWithFields((ClassVisitor)cw, classDef, classDef.getFieldsDefinitions());
        }
        LinkedList<FieldDefinition> keys = new LinkedList<FieldDefinition>();
        for (FieldDefinition fieldDef : classDef.getFieldsDefinitions()) {
            if (!fieldDef.isKey()) continue;
            keys.add(fieldDef);
        }
        if (!keys.isEmpty() && keys.size() != classDef.getFieldsDefinitions().size()) {
            this.buildConstructorWithFields((ClassVisitor)cw, classDef, keys);
        }
    }

    protected void buildTraitMap(ClassWriter cw, ClassDefinition classDef) {
        FieldVisitor fv = cw.visitField(2, "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class), "Ljava/util/Map<Ljava/lang/String;Lorg/drools/core/factmodel/traits/Thing;>;", null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), "()Ljava/util/Map<Ljava/lang/String;Lorg/drools/core/factmodel/traits/Thing;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "_setTraitMap", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Map.class)}), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, BuildUtils.getInternalType(classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "addTrait", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(String.class), Type.getType(Thing.class)}), "(Ljava/lang/String;Lorg/drools/core/factmodel/traits/Thing;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "put", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}));
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getTrait", Type.getMethodDescriptor((Type)Type.getType(Thing.class), (Type[])new Type[]{Type.getType(String.class)}), Type.getMethodDescriptor((Type)Type.getType(Thing.class), (Type[])new Type[]{Type.getType(String.class)}), null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class)}));
        mv.visitTypeInsn(192, Type.getInternalName(Thing.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "hasTrait", Type.getMethodDescriptor((Type)Type.getType(Boolean.TYPE), (Type[])new Type[]{Type.getType(String.class)}), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        Label l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "containsKey", Type.getMethodDescriptor((Type)Type.getType(Boolean.TYPE), (Type[])new Type[]{Type.getType(Object.class)}));
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "removeTrait", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(String.class)}), Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(String.class)}), null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        mv.visitTypeInsn(192, Type.getInternalName(TraitTypeMap.class));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(TraitTypeMap.class), "removeCascade", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(String.class)}));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "removeTrait", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(BitSet.class)}), Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(BitSet.class)}), null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        mv.visitTypeInsn(192, Type.getInternalName(TraitTypeMap.class));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(TraitTypeMap.class), "removeCascade", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(BitSet.class)}));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getTraits", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[0]), "()Ljava/util/Collection<Ljava/lang/String;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "keySet", Type.getMethodDescriptor((Type)Type.getType(Set.class), (Type[])new Type[0]));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "_setBottomTypeCode", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(BitSet.class)}), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitTypeInsn(192, Type.getInternalName(TraitTypeMap.class));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(TraitTypeMap.class), "setBottomCode", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(BitSet.class)}));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getMostSpecificTraits", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[0]), "()Ljava/util/Collection<Lorg/drools/core/factmodel/traits/Thing;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitTypeInsn(192, Type.getInternalName(TraitTypeMap.class));
        mv.visitMethodInsn(182, Type.getInternalName(TraitTypeMap.class), "getMostSpecificTraits", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[0]));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getCurrentTypeCode", Type.getMethodDescriptor((Type)Type.getType(BitSet.class), (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitTypeInsn(192, Type.getInternalName(TraitTypeMap.class));
        mv.visitMethodInsn(182, Type.getInternalName(TraitTypeMap.class), "getCurrentTypeCode", Type.getMethodDescriptor((Type)Type.getType(BitSet.class), (Type[])new Type[0]));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildDynamicPropertyMap(ClassWriter cw, ClassDefinition def) {
        FieldVisitor fv = cw.visitField(2, "__$$dynamic_properties_map$$", Type.getDescriptor(Map.class), "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "_getDynamicProperties", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(def.getName()), "__$$dynamic_properties_map$$", Type.getDescriptor(Map.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "_setDynamicProperties", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Map.class)}), "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, BuildUtils.getInternalType(def.getName()), "__$$dynamic_properties_map$$", Type.getDescriptor(Map.class));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildClassHeader(ClassVisitor cw, ClassDefinition classDef) {
        String[] original = classDef.getInterfaces();
        String[] interfaces = new String[original.length];
        for (int i = 0; i < original.length; ++i) {
            interfaces[i] = BuildUtils.getInternalType(original[i]);
        }
        int classModifiers = 33;
        if (classDef.isAbstrakt()) {
            classModifiers += 1024;
        }
        cw.visit(49, classModifiers, BuildUtils.getInternalType(classDef.getClassName()), null, BuildUtils.getInternalType(classDef.getSuperClass()), interfaces);
        this.buildClassAnnotations(classDef, cw);
        cw.visitSource(classDef.getClassName() + ".java", null);
    }

    protected void buildField(ClassVisitor cw, FieldDefinition fieldDef) {
        FieldVisitor fv = cw.visitField(2, fieldDef.getName(), BuildUtils.getTypeDescriptor(fieldDef.getTypeName()), null, null);
        this.buildFieldAnnotations(fieldDef, fv);
        fv.visitEnd();
    }

    protected void buildDefaultConstructor(ClassVisitor cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        boolean hasObjects = this.defaultConstructorStart(mv, classDef);
        mv.visitInsn(177);
        Label l1 = null;
        if (this.debug) {
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor(classDef.getClassName()), null, l0, l1, 0);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected boolean defaultConstructorStart(MethodVisitor mv, ClassDefinition classDef) {
        mv.visitVarInsn(25, 0);
        String sup = "";
        try {
            sup = Type.getInternalName(Class.forName(classDef.getSuperClass()));
        }
        catch (ClassNotFoundException e) {
            sup = BuildUtils.getInternalType(classDef.getSuperClass());
        }
        mv.visitMethodInsn(183, sup, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        boolean hasObjects = false;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            hasObjects = hasObjects || this.initFieldWithDefaultValue(mv, classDef, field);
        }
        if (classDef.isTraitable()) {
            this.initializeDynamicTypeStructures(mv, classDef);
        }
        return hasObjects;
    }

    protected boolean initFieldWithDefaultValue(MethodVisitor mv, ClassDefinition classDef, FieldDefinition field) {
        if (field.getInitExpr() == null && field.isInherited()) {
            return false;
        }
        Object val = BuildUtils.getDefaultValue(field);
        boolean hasObjects = false;
        if (val != null) {
            mv.visitVarInsn(25, 0);
            if (BuildUtils.isPrimitive(field.getTypeName()) || BuildUtils.isBoxed(field.getTypeName()) || String.class.getName().equals(field.getTypeName())) {
                mv.visitLdcInsn(val);
                if (BuildUtils.isBoxed(field.getTypeName())) {
                    mv.visitMethodInsn(184, BuildUtils.getInternalType(field.getTypeName()), "valueOf", "(" + BuildUtils.unBox(field.getTypeName()) + ")" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                }
            } else {
                hasObjects = true;
                String type = BuildUtils.getInternalType(val.getClass().getName());
                mv.visitTypeInsn(187, type);
                mv.visitInsn(89);
                mv.visitMethodInsn(183, type, "<init>", "()V");
            }
        } else if (field.getInitExpr() != null) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn((Object)field.getInitExpr());
            mv.visitMethodInsn(184, "org/mvel2/MVEL", "eval", "(Ljava/lang/String;)Ljava/lang/Object;");
            mv.visitTypeInsn(192, BuildUtils.getInternalType(field.getTypeName()));
            val = field.getInitExpr();
        }
        if (val != null) {
            if (!field.isInherited()) {
                mv.visitFieldInsn(181, BuildUtils.getInternalType(classDef.getClassName()), field.getName(), BuildUtils.getTypeDescriptor(field.getTypeName()));
            } else {
                mv.visitMethodInsn(182, BuildUtils.getInternalType(classDef.getClassName()), field.getWriteMethod(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType((String)BuildUtils.getTypeDescriptor(field.getTypeName()))}));
            }
        }
        return hasObjects;
    }

    protected void initializeDynamicTypeStructures(MethodVisitor mv, ClassDefinition classDef) {
    }

    protected void buildConstructorWithFields(ClassVisitor cw, ClassDefinition classDef, Collection<FieldDefinition> fieldDefs) {
        Type[] params = new Type[fieldDefs.size()];
        int index = 0;
        for (FieldDefinition field : fieldDefs) {
            params[index++] = Type.getType((String)BuildUtils.getTypeDescriptor(field.getTypeName()));
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])params), null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        this.fieldConstructorStart(mv, classDef, fieldDefs);
        mv.visitInsn(177);
        Label l1 = null;
        if (this.debug) {
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor(classDef.getClassName()), null, l0, l1, 0);
            for (FieldDefinition field : classDef.getFieldsDefinitions()) {
                Label l11 = new Label();
                mv.visitLabel(l11);
                mv.visitLocalVariable(field.getName(), BuildUtils.getTypeDescriptor(field.getTypeName()), null, l0, l1, 0);
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void fieldConstructorStart(MethodVisitor mv, ClassDefinition classDef, Collection<FieldDefinition> fieldDefs) {
        mv.visitVarInsn(25, 0);
        String sup = "";
        try {
            sup = Type.getInternalName(Class.forName(classDef.getSuperClass()));
        }
        catch (ClassNotFoundException e) {
            sup = BuildUtils.getInternalType(classDef.getSuperClass());
        }
        mv.visitMethodInsn(183, sup, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        int index = 1;
        for (FieldDefinition field : fieldDefs) {
            if (this.debug) {
                Label l11 = new Label();
                mv.visitLabel(l11);
            }
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(Type.getType((String)BuildUtils.getTypeDescriptor(field.getTypeName())).getOpcode(21), index++);
            if (field.getTypeName().equals("long") || field.getTypeName().equals("double")) {
                ++index;
            }
            if (!field.isInherited()) {
                mv.visitFieldInsn(181, BuildUtils.getInternalType(classDef.getClassName()), field.getName(), BuildUtils.getTypeDescriptor(field.getTypeName()));
                continue;
            }
            mv.visitMethodInsn(182, BuildUtils.getInternalType(classDef.getClassName()), field.getWriteMethod(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType((String)BuildUtils.getTypeDescriptor(field.getTypeName()))}));
        }
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (fieldDefs.contains(field) || field.getInitExpr() == null || "".equals(field.getInitExpr().trim())) continue;
            this.initFieldWithDefaultValue(mv, classDef, field);
        }
        if (classDef.isTraitable()) {
            this.initializeDynamicTypeStructures(mv, classDef);
        }
    }

    protected void buildSetMethod(ClassVisitor cw, ClassDefinition classDef, FieldDefinition fieldDef) {
        MethodVisitor mv = cw.visitMethod(1, fieldDef.getWriteMethod(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType((String)BuildUtils.getTypeDescriptor(fieldDef.getTypeName()))}), null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(Type.getType((String)BuildUtils.getTypeDescriptor(fieldDef.getTypeName())).getOpcode(21), 1);
        mv.visitFieldInsn(181, BuildUtils.getInternalType(classDef.getClassName()), fieldDef.getName(), BuildUtils.getTypeDescriptor(fieldDef.getTypeName()));
        mv.visitInsn(177);
        Label l1 = null;
        if (this.debug) {
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor(classDef.getClassName()), null, l0, l1, 0);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildGetMethod(ClassVisitor cw, ClassDefinition classDef, FieldDefinition fieldDef) {
        MethodVisitor mv = cw.visitMethod(1, fieldDef.getReadMethod(), Type.getMethodDescriptor((Type)Type.getType((String)BuildUtils.getTypeDescriptor(fieldDef.getTypeName())), (Type[])new Type[0]), null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(classDef.getClassName()), fieldDef.getName(), BuildUtils.getTypeDescriptor(fieldDef.getTypeName()));
        mv.visitInsn(Type.getType((String)BuildUtils.getTypeDescriptor(fieldDef.getTypeName())).getOpcode(172));
        Label l1 = null;
        if (this.debug) {
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor(classDef.getClassName()), null, l0, l1, 0);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildEquals(ClassVisitor cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(166, l1);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 1);
        Label l2 = new Label();
        mv.visitJumpInsn(199, l2);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]));
        Label l3 = new Label();
        mv.visitJumpInsn(165, l3);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l3);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, BuildUtils.getInternalType(classDef.getClassName()));
        mv.visitVarInsn(58, 2);
        int count = 0;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            ++count;
            Label goNext = new Label();
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitVarInsn(25, 2);
                this.visitFieldOrGetter(mv, classDef, field);
                if (field.getTypeName().equals("long")) {
                    mv.visitInsn(148);
                    mv.visitJumpInsn(153, goNext);
                } else if (field.getTypeName().equals("double")) {
                    mv.visitInsn(151);
                    mv.visitJumpInsn(153, goNext);
                } else if (field.getTypeName().equals("float")) {
                    mv.visitInsn(149);
                    mv.visitJumpInsn(153, goNext);
                } else {
                    mv.visitJumpInsn(159, goNext);
                }
                mv.visitInsn(3);
                mv.visitInsn(172);
            } else {
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                Label secondIfPart = new Label();
                mv.visitJumpInsn(199, secondIfPart);
                mv.visitVarInsn(25, 2);
                this.visitFieldOrGetter(mv, classDef, field);
                Label returnFalse = new Label();
                mv.visitJumpInsn(199, returnFalse);
                mv.visitLabel(secondIfPart);
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitJumpInsn(198, goNext);
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitVarInsn(25, 2);
                this.visitFieldOrGetter(mv, classDef, field);
                if (!BuildUtils.isArray(field.getTypeName())) {
                    mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
                } else {
                    mv.visitMethodInsn(184, "java/util/Arrays", "equals", "(" + BuildUtils.arrayType(field.getTypeName()) + BuildUtils.arrayType(field.getTypeName()) + ")Z");
                }
                mv.visitJumpInsn(154, goNext);
                mv.visitLabel(returnFalse);
                mv.visitInsn(3);
                mv.visitInsn(172);
            }
            mv.visitLabel(goNext);
        }
        if (count > 0) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitInsn(172);
        Label lastLabel = null;
        if (this.debug) {
            lastLabel = new Label();
            mv.visitLabel(lastLabel);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor(classDef.getClassName()), null, l0, lastLabel, 0);
            mv.visitLocalVariable("obj", Type.getDescriptor(Object.class), null, l0, lastLabel, 1);
            mv.visitLocalVariable("other", BuildUtils.getTypeDescriptor(classDef.getClassName()), null, l0, lastLabel, 2);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildSystemHashCode(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/System", "identityHashCode", "(Ljava/lang/Object;)I");
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildHashCode(ClassVisitor cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitInsn(4);
        mv.visitVarInsn(54, 1);
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            mv.visitVarInsn(21, 1);
            mv.visitIntInsn(16, 31);
            mv.visitVarInsn(21, 1);
            mv.visitInsn(104);
            mv.visitVarInsn(25, 0);
            this.visitFieldOrGetter(mv, classDef, field);
            if ("boolean".equals(field.getTypeName())) {
                Label blabel1 = new Label();
                mv.visitJumpInsn(153, blabel1);
                mv.visitIntInsn(17, 1231);
                Label blabel2 = new Label();
                mv.visitJumpInsn(167, blabel2);
                mv.visitLabel(blabel1);
                mv.visitIntInsn(17, 1237);
                mv.visitLabel(blabel2);
            } else if ("long".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
            } else if ("float".equals(field.getTypeName())) {
                mv.visitMethodInsn(184, Type.getInternalName(Float.class), "floatToIntBits", "(F)I");
            } else if ("double".equals(field.getTypeName())) {
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "doubleToLongBits", "(D)J");
                mv.visitInsn(92);
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
            } else if (!BuildUtils.isPrimitive(field.getTypeName())) {
                Label olabel1 = new Label();
                mv.visitJumpInsn(199, olabel1);
                mv.visitInsn(3);
                Label olabel2 = new Label();
                mv.visitJumpInsn(167, olabel2);
                mv.visitLabel(olabel1);
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                if (!BuildUtils.isArray(field.getTypeName())) {
                    mv.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I");
                } else {
                    mv.visitMethodInsn(184, "java/util/Arrays", "hashCode", "(" + BuildUtils.arrayType(field.getTypeName()) + ")I");
                }
                mv.visitLabel(olabel2);
            }
            mv.visitInsn(96);
            mv.visitVarInsn(54, 1);
        }
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        Label lastLabel = null;
        if (this.debug) {
            lastLabel = new Label();
            mv.visitLabel(lastLabel);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor(classDef.getClassName()), null, l0, lastLabel, 0);
            mv.visitLocalVariable("hash", Type.getDescriptor(Integer.TYPE), null, l0, lastLabel, 1);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildToString(ClassVisitor cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", "()V");
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(classDef.getClassName()), "getClass", "()Ljava/lang/Class;");
        mv.visitMethodInsn(182, Type.getInternalName(Class.class), "getSimpleName", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        this.appendToStringBuilder(mv, "( ");
        this.buildFieldsToString(classDef, mv, false);
        this.appendToStringBuilder(mv, " )");
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "toString", "()Ljava/lang/String;");
        mv.visitInsn(176);
        Label lastLabel = null;
        if (this.debug) {
            lastLabel = new Label();
            mv.visitLabel(lastLabel);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor(classDef.getClassName()), null, l0, lastLabel, 0);
            mv.visitLocalVariable("buf", Type.getDescriptor(StringBuilder.class), null, l0, lastLabel, 1);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected boolean buildFieldsToString(ClassDefinition classDef, MethodVisitor mv, boolean previous) {
        boolean first = true;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            this.buildFieldToString(field, classDef, mv, first);
            first = false;
        }
        return previous;
    }

    protected void buildFieldToString(FieldDefinition field, ClassDefinition classDef, MethodVisitor mv, boolean first) {
        if (!first) {
            this.appendToStringBuilder(mv, ", ");
        }
        this.appendToStringBuilder(mv, field.getName());
        this.appendToStringBuilder(mv, "=");
        if (field.isRecursive()) {
            this.appendToStringBuilder(mv, field.getTypeName() + " [recursive]");
        } else {
            mv.visitVarInsn(25, 0);
            this.visitFieldOrGetter(mv, classDef, field);
            if (BuildUtils.isPrimitive(field.getTypeName())) {
                String type = field.getTypeName().matches("(byte|short)") ? "int" : field.getTypeName();
                mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType((String)BuildUtils.getTypeDescriptor(type))}));
            } else if (BuildUtils.isArray(field.getTypeName()) && BuildUtils.arrayDimSize(field.getTypeName()) == 1) {
                mv.visitMethodInsn(184, "java/util/Arrays", "toString", "(" + BuildUtils.getTypeDescriptor(BuildUtils.arrayType(field.getTypeName())) + ")Ljava/lang/String;");
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            } else {
                mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType(Object.class)}));
            }
        }
    }

    private void appendToStringBuilder(MethodVisitor mv, String s) {
        mv.visitLdcInsn((Object)s);
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
    }

    protected void buildClassAnnotations(ClassDefinition classDef, ClassVisitor cw) {
        if (classDef.getAnnotations() != null) {
            for (AnnotationDefinition ad : classDef.getAnnotations()) {
                AnnotationVisitor av = cw.visitAnnotation("L" + BuildUtils.getInternalType(ad.getName()) + ";", true);
                for (String key : ad.getValues().keySet()) {
                    AnnotationDefinition.AnnotationPropertyVal apv = ad.getValues().get(key);
                    switch (apv.getValType()) {
                        case STRINGARRAY: {
                            Object[] array;
                            AnnotationVisitor subAv = av.visitArray(apv.getProperty());
                            for (Object o : array = (Object[])apv.getValue()) {
                                subAv.visit(null, o);
                            }
                            subAv.visitEnd();
                            break;
                        }
                        case PRIMARRAY: {
                            av.visit(apv.getProperty(), apv.getValue());
                            break;
                        }
                        case ENUMARRAY: {
                            AnnotationVisitor subEnav = av.visitArray(apv.getProperty());
                            Enum[] enArray = (Enum[])apv.getValue();
                            String aenumType = "L" + BuildUtils.getInternalType(enArray[0].getClass().getName()) + ";";
                            for (Enum enumer : enArray) {
                                subEnav.visitEnum(null, aenumType, enumer.name());
                            }
                            subEnav.visitEnd();
                            break;
                        }
                        case CLASSARRAY: {
                            Class[] klarray;
                            AnnotationVisitor subKlav = av.visitArray(apv.getProperty());
                            for (Class klass : klarray = (Class[])apv.getValue()) {
                                subKlav.visit(null, (Object)Type.getType((String)("L" + BuildUtils.getInternalType(klass.getName()) + ";")));
                            }
                            subKlav.visitEnd();
                            break;
                        }
                        case ENUMERATION: {
                            String enumType = "L" + BuildUtils.getInternalType(apv.getType().getName()) + ";";
                            av.visitEnum(apv.getProperty(), enumType, ((Enum)apv.getValue()).name());
                            break;
                        }
                        case KLASS: {
                            String klassName = BuildUtils.getInternalType(((Class)apv.getValue()).getName());
                            av.visit(apv.getProperty(), (Object)Type.getType((String)("L" + klassName + ";")));
                            break;
                        }
                        case PRIMITIVE: {
                            av.visit(apv.getProperty(), apv.getValue());
                            break;
                        }
                        case STRING: {
                            av.visit(apv.getProperty(), apv.getValue());
                        }
                    }
                }
                av.visitEnd();
            }
        }
    }

    protected void buildFieldAnnotations(FieldDefinition fieldDef, FieldVisitor fv) {
        if (fieldDef.getAnnotations() != null) {
            for (AnnotationDefinition ad : fieldDef.getAnnotations()) {
                AnnotationVisitor av = fv.visitAnnotation("L" + BuildUtils.getInternalType(ad.getName()) + ";", true);
                for (String key : ad.getValues().keySet()) {
                    AnnotationDefinition.AnnotationPropertyVal apv = ad.getValues().get(key);
                    switch (apv.getValType()) {
                        case STRINGARRAY: {
                            Object[] array;
                            AnnotationVisitor subAv = av.visitArray(apv.getProperty());
                            for (Object o : array = (Object[])apv.getValue()) {
                                subAv.visit(null, o);
                            }
                            subAv.visitEnd();
                            break;
                        }
                        case PRIMARRAY: {
                            av.visit(apv.getProperty(), apv.getValue());
                            break;
                        }
                        case ENUMARRAY: {
                            AnnotationVisitor subEnav = av.visitArray(apv.getProperty());
                            Enum[] enArray = (Enum[])apv.getValue();
                            String aenumType = "L" + BuildUtils.getInternalType(enArray[0].getClass().getName()) + ";";
                            for (Enum enumer : enArray) {
                                subEnav.visitEnum(null, aenumType, enumer.name());
                            }
                            subEnav.visitEnd();
                            break;
                        }
                        case CLASSARRAY: {
                            Class[] klarray;
                            AnnotationVisitor subKlav = av.visitArray(apv.getProperty());
                            for (Class klass : klarray = (Class[])apv.getValue()) {
                                subKlav.visit(null, (Object)Type.getType((String)("L" + BuildUtils.getInternalType(klass.getName()) + ";")));
                            }
                            subKlav.visitEnd();
                            break;
                        }
                        case ENUMERATION: {
                            String enumType = "L" + BuildUtils.getInternalType(apv.getType().getName()) + ";";
                            av.visitEnum(apv.getProperty(), enumType, ((Enum)apv.getValue()).name());
                            break;
                        }
                        case KLASS: {
                            String klassName = BuildUtils.getInternalType(((Class)apv.getValue()).getName());
                            av.visit(apv.getProperty(), (Object)Type.getType((String)("L" + klassName + ";")));
                            break;
                        }
                        case PRIMITIVE: {
                            av.visit(apv.getProperty(), apv.getValue());
                            break;
                        }
                        case STRING: {
                            av.visit(apv.getProperty(), apv.getValue());
                        }
                    }
                }
                av.visitEnd();
            }
        }
    }

    protected void visitFieldOrGetter(MethodVisitor mv, ClassDefinition classDef, FieldDefinition field) {
        if (!field.isInherited()) {
            mv.visitFieldInsn(180, BuildUtils.getInternalType(classDef.getClassName()), field.getName(), BuildUtils.getTypeDescriptor(field.getTypeName()));
        } else {
            mv.visitMethodInsn(182, BuildUtils.getInternalType(classDef.getClassName()), field.getReadMethod(), Type.getMethodDescriptor((Type)Type.getType((String)BuildUtils.getTypeDescriptor(field.getTypeName())), (Type[])new Type[0]));
        }
    }
}

