/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.time.Interval;

public class TimeUtils {
    private static final Pattern SIMPLE = Pattern.compile("([+-])?((\\d+)[Dd])?\\s*((\\d+)[Hh])?\\s*((\\d+)[Mm])?\\s*((\\d+)[Ss])?\\s*((\\d+)([Mm][Ss])?)?");
    private static final int SIM_SGN = 1;
    private static final int SIM_DAY = 3;
    private static final int SIM_HOU = 5;
    private static final int SIM_MIN = 7;
    private static final int SIM_SEC = 9;
    private static final int SIM_MS = 11;
    private static final long SEC_MS = 1000L;
    private static final long MIN_MS = 60000L;
    private static final long HOU_MS = 3600000L;
    private static final long DAY_MS = 86400000L;

    public static Interval[][] calculateTemporalDistance(Interval[][] constraintMatrix) {
        Interval[][] result = new Interval[constraintMatrix.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Interval[constraintMatrix[i].length];
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = constraintMatrix[i][j].clone();
            }
        }
        for (int k = 0; k < result.length; ++k) {
            for (int i = 0; i < result.length; ++i) {
                for (int j = 0; j < result.length; ++j) {
                    Interval interval = result[i][k].clone();
                    interval.add(result[k][j]);
                    result[i][j].intersect(interval);
                }
            }
        }
        return result;
    }

    public static long parseTimeString(String time) {
        String trimmed = time.trim();
        long result = 0L;
        if (trimmed.length() > 0) {
            Matcher mat = SIMPLE.matcher(trimmed);
            if (mat.matches()) {
                int days = mat.group(3) != null ? Integer.parseInt(mat.group(3)) : 0;
                int hours = mat.group(5) != null ? Integer.parseInt(mat.group(5)) : 0;
                int min = mat.group(7) != null ? Integer.parseInt(mat.group(7)) : 0;
                int sec = mat.group(9) != null ? Integer.parseInt(mat.group(9)) : 0;
                int ms = mat.group(11) != null ? Integer.parseInt(mat.group(11)) : 0;
                long r = (long)days * 86400000L + (long)hours * 3600000L + (long)min * 60000L + (long)sec * 1000L + (long)ms;
                if (mat.group(1) != null && mat.group(1).equals("-")) {
                    r = -r;
                }
                result = r;
            } else if ("*".equals(trimmed) || "+*".equals(trimmed)) {
                result = Long.MAX_VALUE;
            } else if ("-*".equals(trimmed)) {
                result = Long.MIN_VALUE;
            } else {
                throw new RuntimeDroolsException("Error parsing time string: [ " + time + " ]");
            }
        }
        return result;
    }
}

