/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.CodeSource;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.DialectRuntimeData;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.Package;
import org.drools.core.spi.EvalExpression;
import org.drools.core.spi.Tuple;
import org.junit.Assert;
import org.junit.Test;

public class PackageCompilationDataTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCodeSourceUrl() throws Exception {
        String className = TestEvalExpression.class.getName();
        ReteooRuleBase rb = new ReteooRuleBase("xxx");
        Package pkg = new Package("org.drools");
        pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        JavaDialectRuntimeData data = new JavaDialectRuntimeData();
        data.onAdd(pkg.getDialectRuntimeRegistry(), rb.getRootClassLoader());
        pkg.getDialectRuntimeRegistry().setDialectData("java", (DialectRuntimeData)data);
        rb.addPackage(pkg);
        JavaDialectRuntimeData pcData = (JavaDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("java");
        EvalCondition invoker = new EvalCondition(null);
        pcData.putInvoker(className, (Object)invoker);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(className.replace('.', '/') + ".class");
        try {
            pcData.write(className.replace('.', '/') + ".class", PackageCompilationDataTest.read(is));
        }
        finally {
            is.close();
        }
        pcData.onAdd(pkg.getDialectRuntimeRegistry(), rb.getRootClassLoader());
        pcData.onBeforeExecute();
        Class cls = rb.getRootClassLoader().loadClass("org.drools.core.rule.PackageCompilationDataTest$TestEvalExpression");
        CodeSource codeSource = invoker.getEvalExpression().getClass().getProtectionDomain().getCodeSource();
        Assert.assertNotNull((Object)codeSource.getLocation());
    }

    private static byte[] read(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((len = is.read(b)) > 0) {
            os.write(b, 0, len);
        }
        return os.toByteArray();
    }

    public static class TestEvalExpression
    implements EvalExpression {
        public Object createContext() {
            return null;
        }

        public boolean evaluate(Tuple t, Declaration[] d, WorkingMemory w, Object context) {
            return false;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public Declaration[] getRequiredDeclarations() {
            return null;
        }

        public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        }

        public EvalExpression clone() {
            return this;
        }
    }
}

