/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.drools.core.FactException;
import org.drools.core.FactHandle;
import org.drools.core.WorkingMemory;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.common.AbstractRuleBase;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.DefaultAgenda;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemoryActions;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.SimpleLogicalDependency;
import org.drools.core.common.TraitFactHandle;
import org.drools.core.common.TruthMaintenanceSystemHelper;
import org.drools.core.factmodel.traits.CoreWrapper;
import org.drools.core.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitFactory;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.phreak.RuleNetworkEvaluatorActivation;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.ReteooWorkingMemory;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Rule;
import org.drools.core.spi.Activation;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.HierarchyEncoder;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.Session;
import org.kie.api.runtime.rule.SessionEntryPoint;
import org.kie.internal.event.rule.ActivationUnMatchListener;
import org.kie.internal.runtime.KnowledgeRuntime;

public class DefaultKnowledgeHelper
implements KnowledgeHelper,
Externalizable {
    private static final long serialVersionUID = 510L;
    private Activation activation;
    private Tuple tuple;
    private InternalWorkingMemoryActions workingMemory;
    private IdentityHashMap<Object, FactHandle> identityMap;
    private LinkedList<LogicalDependency> previousJustified;
    private LinkedList<LogicalDependency> previousBlocked;

    public DefaultKnowledgeHelper() {
    }

    public DefaultKnowledgeHelper(WorkingMemory workingMemory) {
        this.workingMemory = (InternalWorkingMemoryActions)workingMemory;
        this.identityMap = null;
    }

    public DefaultKnowledgeHelper(Activation activation, WorkingMemory workingMemory) {
        this.workingMemory = (InternalWorkingMemoryActions)workingMemory;
        this.activation = activation;
        this.identityMap = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.activation = (Activation)in.readObject();
        this.tuple = (Tuple)in.readObject();
        this.workingMemory = (InternalWorkingMemoryActions)in.readObject();
        this.identityMap = (IdentityHashMap)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.activation);
        out.writeObject(this.tuple);
        out.writeObject(this.workingMemory);
        out.writeObject(this.identityMap);
    }

    @Override
    public void setActivation(Activation agendaItem) {
        this.activation = agendaItem;
        this.previousJustified = agendaItem.getLogicalDependencies();
        this.previousBlocked = agendaItem.getBlocked();
        agendaItem.setLogicalDependencies(null);
        agendaItem.setBlocked(null);
        this.tuple = agendaItem.getTuple();
    }

    @Override
    public void reset() {
        this.activation = null;
        this.tuple = null;
        this.identityMap = null;
        this.previousJustified = null;
        this.previousBlocked = null;
    }

    public LinkedList<LogicalDependency> getpreviousJustified() {
        return this.previousJustified;
    }

    public void blockMatch(Match act) {
        AgendaItem targetMatch = (AgendaItem)act;
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (targetMatch != dep.getJustified()) continue;
                this.previousJustified.remove(dep);
                break;
            }
        }
        if (dep == null) {
            dep = new SimpleLogicalDependency(this.activation, targetMatch);
        }
        this.activation.addBlocked(dep);
        if (targetMatch.getBlockers().size() == 1 && targetMatch.isActive()) {
            if (targetMatch.getRuleNetworkEvaluatorActivation() == null) {
                targetMatch.remove();
            } else {
                targetMatch.getRuleNetworkEvaluatorActivation().getLeftTupleList().remove(targetMatch.getTuple());
            }
            if (targetMatch.getActivationGroupNode() != null) {
                targetMatch.getActivationGroupNode().getActivationGroup().removeActivation(targetMatch);
            }
            if (targetMatch.getActivationNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)targetMatch.getActivationNode().getParentContainer();
                ruleFlowGroup.removeActivation(targetMatch);
            }
        }
    }

    public void unblockAllMatches(Match act) {
        AgendaItem targetMatch = (AgendaItem)act;
        boolean wasBlocked = targetMatch.getBlockers() != null && !targetMatch.getBlockers().isEmpty();
        LinkedListEntry entry = targetMatch.getBlockers().getFirst();
        while (entry != null) {
            LinkedListEntry tmp = (LinkedListEntry)entry.getNext();
            LogicalDependency dep = entry.getObject();
            ((AgendaItem)dep.getJustifier()).removeBlocked(dep);
            entry = tmp;
        }
        if (wasBlocked) {
            RuleNetworkEvaluatorActivation ruleNetworkEvaluatorActivation = targetMatch.getRuleNetworkEvaluatorActivation();
            if (ruleNetworkEvaluatorActivation == null) {
                ((DefaultAgenda)this.workingMemory.getAgenda()).getStageActivationsGroup().addActivation(targetMatch);
            } else {
                if (!ruleNetworkEvaluatorActivation.isActivated()) {
                    ((InternalAgenda)this.workingMemory.getAgenda()).addActivation(ruleNetworkEvaluatorActivation);
                }
                targetMatch.getRuleNetworkEvaluatorActivation().getLeftTupleList().add(targetMatch.getTuple());
            }
        }
    }

    @Override
    public FactHandle insert(Object object) {
        return this.insert(object, false);
    }

    @Override
    public FactHandle insert(Object object, boolean dynamic) throws FactException {
        FactHandle handle = this.workingMemory.insert(object, null, dynamic, false, this.activation.getRule(), this.activation);
        if (this.identityMap != null) {
            this.getIdentityMap().put(object, handle);
        }
        return handle;
    }

    @Override
    public void insertLogical(Object object) {
        this.insertLogical(object, false);
    }

    @Override
    public void insertLogical(Object object, boolean dynamic) {
        this.insertLogical(object, null, dynamic);
    }

    public void insertLogical(Object object, Object value) {
        this.insertLogical(object, value, false);
    }

    public void insertLogical(Object object, Object value, boolean dynamic) {
        if (!this.activation.isMatched()) {
            return;
        }
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (!object.equals(((BeliefSet)dep.getJustified()).getFactHandle().getObject())) continue;
                this.previousJustified.remove(dep);
                break;
            }
        }
        if (dep != null) {
            this.activation.addLogicalDependency(dep);
        } else {
            FactHandle handle = this.workingMemory.insert(object, value, dynamic, true, this.activation.getRule(), this.activation);
            if (this.identityMap != null) {
                this.getIdentityMap().put(object, handle);
            }
        }
    }

    @Override
    public void cancelRemainingPreviousLogicalDependencies() {
        LogicalDependency dep;
        if (this.previousJustified != null) {
            for (dep = this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                TruthMaintenanceSystemHelper.removeLogicalDependency(dep, this.activation.getPropagationContext());
            }
        }
        if (this.previousBlocked != null) {
            dep = this.previousBlocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.previousBlocked.remove(dep);
                AgendaItem justified = (AgendaItem)dep.getJustified();
                justified.getBlockers().remove(dep.getJustifierEntry());
                if (justified.getBlockers().isEmpty()) {
                    RuleNetworkEvaluatorActivation ruleNetworkEvaluatorActivation = justified.getRuleNetworkEvaluatorActivation();
                    if (ruleNetworkEvaluatorActivation == null) {
                        ((DefaultAgenda)this.workingMemory.getAgenda()).getStageActivationsGroup().addActivation(justified);
                    } else {
                        if (!ruleNetworkEvaluatorActivation.isActivated()) {
                            ((InternalAgenda)this.workingMemory.getAgenda()).addActivation(ruleNetworkEvaluatorActivation);
                        }
                        ruleNetworkEvaluatorActivation.getLeftTupleList().add(justified.getTuple());
                    }
                }
                dep = tmp;
            }
        }
    }

    public void cancelMatch(Match act) {
        AgendaItem match = (AgendaItem)act;
        match.cancel();
        if (match.isActive()) {
            LeftTuple leftTuple = match.getTuple();
            if (match.getRuleNetworkEvaluatorActivation() != null && leftTuple.getMemory() != null) {
                leftTuple.getMemory().remove(leftTuple);
            }
            leftTuple.getLeftTupleSink().retractLeftTuple(leftTuple, (PropagationContext)act.getPropagationContext(), this.workingMemory);
        }
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        FactHandle handle = null;
        if (this.identityMap != null) {
            handle = this.identityMap.get(object);
        }
        if (handle != null) {
            return handle;
        }
        handle = this.getFactHandleFromWM(object);
        if (handle == null) {
            throw new FactException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        return handle;
    }

    @Override
    public FactHandle getFactHandle(FactHandle handle) {
        Object object = ((InternalFactHandle)handle).getObject();
        if ((handle = this.getFactHandleFromWM(object)) == null) {
            throw new FactException("Update error: handle not found for object: " + object + ". Is it in the working memory?");
        }
        return handle;
    }

    @Override
    public void update(FactHandle handle, Object newObject) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, newObject, Long.MAX_VALUE, Object.class, this.activation);
        if (this.getIdentityMap() != null) {
            this.getIdentityMap().put(newObject, handle);
        }
    }

    @Override
    public void update(FactHandle handle) {
        this.update(handle, Long.MAX_VALUE);
    }

    @Override
    public void update(FactHandle handle, long mask, Class<?> modifiedClass) {
        InternalFactHandle h = (InternalFactHandle)handle;
        ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, ((InternalFactHandle)handle).getObject(), mask, modifiedClass, this.activation);
        if (h.isTrait()) {
            if (((TraitFactHandle)h).isTraitable()) {
                this.updateTraits(h.getObject(), mask, null, modifiedClass);
            } else {
                Thing x = (Thing)h.getObject();
                if (x != x.getCore()) {
                    Object core = x.getCore();
                    InternalFactHandle coreHandle = (InternalFactHandle)this.getFactHandle(core);
                    ((InternalWorkingMemoryEntryPoint)coreHandle.getEntryPoint()).update(coreHandle, core, mask, modifiedClass, this.activation);
                    this.updateTraits(core, mask, x, modifiedClass);
                }
            }
        }
    }

    private void updateTraits(Object object, long mask, Thing originator, Class<?> modifiedClass) {
        TraitableBean txBean = (TraitableBean)object;
        Collection<Thing> px = txBean.getMostSpecificTraits();
        BitSet veto = null;
        if (originator != null) {
            veto = (BitSet)((TraitProxy)((Object)originator)).getTypeCode().clone();
        }
        for (Thing t : px) {
            if (t == originator) continue;
            TraitProxy proxy = (TraitProxy)((Object)t);
            proxy.setTypeFilter(veto);
            InternalFactHandle h = (InternalFactHandle)this.getFactHandle(t);
            ((InternalWorkingMemoryEntryPoint)h.getEntryPoint()).update(h, t, mask, modifiedClass, this.activation);
            proxy.setTypeFilter(null);
            BitSet tc = proxy.getTypeCode();
            if (veto == null) {
                veto = (BitSet)tc.clone();
                continue;
            }
            veto.and(tc);
        }
    }

    @Override
    public void update(Object object) {
        this.update(object, Long.MAX_VALUE, Object.class);
    }

    @Override
    public void update(Object object, long mask, Class<?> modifiedClass) {
        this.update(this.getFactHandle(object), mask, modifiedClass);
    }

    @Override
    public void retract(Object object) {
        this.retract(this.getFactHandle(object));
    }

    @Override
    public void retract(FactHandle handle) {
        ((InternalWorkingMemoryEntryPoint)((InternalFactHandle)handle).getEntryPoint()).delete(handle, this.activation.getRule(), this.activation);
        if (this.identityMap != null) {
            this.getIdentityMap().remove(((InternalFactHandle)handle).getObject());
        }
    }

    @Override
    public Rule getRule() {
        return this.activation.getRule();
    }

    @Override
    public Tuple getTuple() {
        return this.tuple;
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public KnowledgeRuntime getKnowledgeRuntime() {
        return ((ReteooWorkingMemory)this.workingMemory).getKnowledgeRuntime();
    }

    @Override
    public Activation getMatch() {
        return this.activation;
    }

    @Override
    public void setFocus(String focus) {
        this.workingMemory.setFocus(focus);
    }

    @Override
    public Object get(Declaration declaration) {
        InternalWorkingMemoryEntryPoint wmTmp = (InternalWorkingMemoryEntryPoint)this.tuple.get(declaration).getEntryPoint();
        if (wmTmp != null) {
            Object object = declaration.getValue(wmTmp.getInternalWorkingMemory(), this.tuple.get(declaration).getObject());
            if (this.identityMap != null) {
                this.getIdentityMap().put(object, wmTmp.getFactHandleByIdentity(object));
            }
            return object;
        }
        return null;
    }

    @Override
    public Declaration getDeclaration(String identifier) {
        return ((AgendaItem)this.activation).getTerminalNode().getSubRule().getOuterDeclarations().get(identifier);
    }

    @Override
    public void halt() {
        this.workingMemory.halt();
    }

    @Override
    public SessionEntryPoint getEntryPoint(String id) {
        return this.workingMemory.getEntryPoints().get(id);
    }

    @Override
    public Channel getChannel(String id) {
        return this.workingMemory.getChannels().get(id);
    }

    @Override
    public Map<String, SessionEntryPoint> getEntryPoints() {
        return Collections.unmodifiableMap(this.workingMemory.getEntryPoints());
    }

    @Override
    public Map<String, Channel> getChannels() {
        return Collections.unmodifiableMap(this.workingMemory.getChannels());
    }

    @Override
    public IdentityHashMap<Object, FactHandle> getIdentityMap() {
        return this.identityMap;
    }

    @Override
    public void setIdentityMap(IdentityHashMap<Object, FactHandle> identityMap) {
        this.identityMap = identityMap;
    }

    private FactHandle getFactHandleFromWM(Object object) {
        FactHandle handle = null;
        for (SessionEntryPoint sessionEntryPoint : this.workingMemory.getEntryPoints().values()) {
            handle = (FactHandle)sessionEntryPoint.getFactHandle(object);
            if (this.identityMap != null) {
                this.identityMap.put(object, handle);
            }
            if (handle == null) continue;
            break;
        }
        return handle;
    }

    @Override
    public <T> T getContext(Class<T> contextClass) {
        Map<Long, String> nodeInstances;
        String ruleflowGroupName;
        if (ProcessContext.class.equals(contextClass) && (ruleflowGroupName = this.getMatch().getRule().getRuleFlowGroup()) != null && !(nodeInstances = ((InternalRuleFlowGroup)this.workingMemory.getAgenda().getRuleFlowGroup(ruleflowGroupName)).getNodeInstances()).isEmpty()) {
            if (nodeInstances.size() > 1) {
                throw new UnsupportedOperationException("Not supporting multiple node instances for the same ruleflow group");
            }
            Map.Entry<Long, String> entry = nodeInstances.entrySet().iterator().next();
            ProcessInstance processInstance = this.workingMemory.getProcessInstance(entry.getKey());
            org.drools.core.spi.ProcessContext context = new org.drools.core.spi.ProcessContext((KieRuntime)this.workingMemory.getKnowledgeRuntime());
            context.setProcessInstance(processInstance);
            String nodeInstance = entry.getValue();
            String[] nodeInstanceIds = nodeInstance.split(":");
            WorkflowProcessInstance container = (WorkflowProcessInstance)processInstance;
            block0: for (int i = 0; i < nodeInstanceIds.length; ++i) {
                for (NodeInstance subNodeInstance : container.getNodeInstances()) {
                    if (subNodeInstance.getId() != new Long(nodeInstanceIds[i]).longValue()) continue;
                    if (i == nodeInstanceIds.length - 1) {
                        context.setNodeInstance(subNodeInstance);
                        continue block0;
                    }
                    container = (NodeInstanceContainer)subNodeInstance;
                }
            }
            return (T)context;
        }
        return null;
    }

    @Override
    public <T, K> T don(K core, Class<T> trait, boolean logical) {
        try {
            T thing = this.applyTrait(core, trait, logical);
            if (thing == core) {
                return thing;
            }
            return this.doInsertTrait(thing, logical);
        }
        catch (LogicalTypeInconsistencyException ltie) {
            ltie.printStackTrace();
            return null;
        }
    }

    protected <T> T doInsertTrait(T thing, boolean logical) {
        FactHandle fh = this.insert(thing);
        if (logical) {
            AgendaItem agendaItem = (AgendaItem)this.activation;
            RetractTrait newUnMatch = new RetractTrait(fh);
            ActivationUnMatchListener unmatch = agendaItem.getActivationUnMatchListener();
            if (unmatch != null) {
                newUnMatch.setNext((RetractTrait)unmatch);
            }
            agendaItem.setActivationUnMatchListener(newUnMatch);
        }
        return thing;
    }

    public KieRuntime getKieRuntime() {
        return this.getKnowledgeRuntime();
    }

    protected <T, K> T applyTrait(K core, Class<T> trait, boolean logical) throws LogicalTypeInconsistencyException {
        TraitableBean<K, CoreWrapper<K>> inner;
        AbstractRuleBase arb = (AbstractRuleBase)((KnowledgeBaseImpl)this.getKnowledgeRuntime().getKieBase()).getRuleBase();
        TraitFactory builder = arb.getConfiguration().getComponentFactory().getTraitFactory();
        boolean needsWrapping = !(core instanceof TraitableBean);
        TraitableBean<K, CoreWrapper<K>> traitableBean = inner = needsWrapping ? this.asTraitable(core, builder) : (TraitableBean<K, CoreWrapper<K>>)core;
        if (needsWrapping) {
            InternalFactHandle h = (InternalFactHandle)this.getFactHandle(core);
            InternalWorkingMemoryEntryPoint ep = (InternalWorkingMemoryEntryPoint)h.getEntryPoint();
            ObjectTypeConfigurationRegistry reg = ep.getObjectTypeConfigurationRegistry();
            ObjectTypeConf coreConf = reg.getObjectTypeConf(ep.getEntryPoint(), core);
            ObjectTypeConf innerConf = reg.getObjectTypeConf(ep.getEntryPoint(), inner);
            if (coreConf.isTMSEnabled()) {
                innerConf.enableTMS();
            }
        }
        return this.processTraits(core, trait, builder, needsWrapping, inner, logical);
    }

    protected <K> TraitableBean<K, CoreWrapper<K>> asTraitable(K core, TraitFactory builder) {
        CoreWrapper<?> wrapper = builder.getCoreWrapper(core.getClass());
        if (wrapper == null) {
            throw new UnsupportedOperationException("Error: cannot apply a trait to non-traitable class " + core.getClass());
        }
        wrapper.init(core);
        return wrapper;
    }

    protected <T, K> T processTraits(K core, Class<T> trait, TraitFactory builder, boolean needsUpdate, TraitableBean<K, ? extends TraitableBean> inner, boolean logical) throws LogicalTypeInconsistencyException {
        TraitableBean thing;
        if (trait.isAssignableFrom(inner.getClass())) {
            thing = inner;
            inner.addTrait(trait.getName(), (Thing)core);
            needsUpdate = true;
        } else {
            if (inner.hasTrait(trait.getName())) {
                return (T)inner.getTrait(trait.getName());
            }
            thing = builder.getProxy(inner, trait);
        }
        if (needsUpdate) {
            this.update(this.getFactHandle(core), inner);
        }
        if (!inner.hasTrait(Thing.class.getName())) {
            this.don(inner, Thing.class, logical);
        }
        return (T)thing;
    }

    @Override
    public <T, K> T don(Thing<K> core, Class<T> trait, boolean logical) {
        return this.don(core.getCore(), trait, logical);
    }

    @Override
    public <T, K> T don(K core, Class<T> trait) {
        return this.don(core, trait, false);
    }

    @Override
    public <T, K> T don(Thing<K> core, Class<T> trait) {
        return this.don(core.getCore(), trait);
    }

    @Override
    public <T, K> Thing<K> shed(Thing<K> thing, Class<T> trait) {
        return this.shed((TraitableBean)thing.getCore(), trait);
    }

    @Override
    public <T, K, X extends TraitableBean> Thing<K> shed(TraitableBean<K, X> core, Class<T> trait) {
        Collection<Thing<K>> removedTypes;
        if (trait.isAssignableFrom(core.getClass())) {
            core.removeTrait(trait.getName());
            this.update(core);
            return (Thing)((Object)core);
        }
        if (core.hasTrait(trait.getName())) {
            removedTypes = core.removeTrait(trait.getName());
        } else {
            HierarchyEncoder hier = ((ReteooRuleBase)this.workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy();
            BitSet code = hier.getCode(trait.getName());
            removedTypes = core.removeTrait(code);
        }
        for (Thing<K> t : removedTypes) {
            if (((TraitType)((Object)t)).isVirtual()) continue;
            this.retract(t);
        }
        Thing<K> thing = core.getTrait(Thing.class.getName());
        this.update(thing);
        return thing;
    }

    @Override
    public void modify(Object newObject) {
    }

    public static class RetractTrait
    implements ActivationUnMatchListener {
        private FactHandle fh;
        private RetractTrait next;

        public RetractTrait(FactHandle fh) {
            this.fh = fh;
        }

        public void unMatch(Session wm, Match activation) {
            wm.retract((org.kie.api.runtime.rule.FactHandle)this.fh);
            if (this.next != null) {
                this.next.unMatch(wm, activation);
            }
        }

        public FactHandle getFh() {
            return this.fh;
        }

        public void setFh(FactHandle fh) {
            this.fh = fh;
        }

        public RetractTrait getNext() {
            return this.next;
        }

        public void setNext(RetractTrait next) {
            this.next = next;
        }
    }
}

