/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.base.DroolsQuery;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNodeLeftTuple;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.index.RightTupleList;

public class ExistsNode
extends BetaNode {
    private static final long serialVersionUID = 510L;
    static int notAssertObject = 0;
    static int notAssertTuple = 0;

    public ExistsNode() {
    }

    public ExistsNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints joinNodeBinder, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, joinNodeBinder, context);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        ContextEntry[] contextEntry = memory.getContext();
        boolean useLeftMemory = true;
        if (!(this.tupleMemoryEnabled || (object = ((InternalFactHandle)context.getFactHandle()).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        this.constraints.updateFromTuple(contextEntry, workingMemory, leftTuple);
        FastIterator it = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), it);
        while (rightTuple != null) {
            if (this.constraints.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                leftTuple.setBlocker(rightTuple);
                if (!useLeftMemory) break;
                rightTuple.addBlocked(leftTuple);
                break;
            }
            rightTuple = (RightTuple)it.next(rightTuple);
        }
        this.constraints.resetTuple(contextEntry);
        if (leftTuple.getBlocker() != null) {
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, useLeftMemory);
        } else if (useLeftMemory) {
            memory.getLeftTupleMemory().add(leftTuple);
        }
    }

    @Override
    public void assertRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getRightTupleMemory().add(rightTuple);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator it = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, context, it);
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)it.next(leftTuple);
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(leftTuple);
                memory.getLeftTupleMemory().remove(leftTuple);
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
            }
            leftTuple = temp;
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    @Override
    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (this.isUnlinkingEnabled()) {
            ExistsNode.doDeleteRightTuple(rightTuple, workingMemory, memory);
            return;
        }
        RightTupleMemory rtm = memory.getRightTupleMemory();
        if (rightTuple.getBlocked() != null) {
            this.updateLeftTupleToNewBlocker(rightTuple, context, workingMemory, memory, memory.getLeftTupleMemory(), rightTuple.getBlocked(), rtm, false);
            rightTuple.nullBlocked();
        } else {
            rtm.remove(rightTuple);
        }
        this.constraints.resetTuple(memory.getContext());
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        RightTuple blocker = leftTuple.getBlocker();
        if (blocker == null) {
            BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
            memory.getLeftTupleMemory().remove(leftTuple);
        } else {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            blocker.removeBlocked(leftTuple);
        }
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        RightTupleMemory rightMemory = memory.getRightTupleMemory();
        FastIterator rightIt = this.getRightIterator(rightMemory);
        RightTuple firstRightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
        RightTuple blocker = leftTuple.getBlocker();
        if (blocker == null) {
            memory.getLeftTupleMemory().remove(leftTuple);
        } else if (rightMemory.isIndexed() && !rightIt.isFullIterator() && (firstRightTuple == null || firstRightTuple.getMemory() != blocker.getMemory())) {
            blocker.removeBlocked(leftTuple);
            blocker = null;
        }
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        if (blocker == null || !this.constraints.isAllowedCachedLeft(memory.getContext(), blocker.getFactHandle())) {
            if (blocker != null) {
                blocker.removeBlocked(leftTuple);
            }
            FastIterator it = memory.getRightTupleMemory().fastIterator();
            RightTuple newBlocker = firstRightTuple;
            while (newBlocker != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                    leftTuple.setBlocker(newBlocker);
                    newBlocker.addBlocked(leftTuple);
                    break;
                }
                newBlocker = (RightTuple)rightIt.next(newBlocker);
            }
        }
        if (leftTuple.getBlocker() == null) {
            memory.getLeftTupleMemory().add(leftTuple);
            if (leftTuple.getFirstChild() != null) {
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            }
        } else if (leftTuple.getFirstChild() == null) {
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
        } else {
            this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, true);
        }
        this.constraints.resetTuple(memory.getContext());
    }

    @Override
    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (memory.getLeftTupleMemory() == null || memory.getLeftTupleMemory().size() == 0 && rightTuple.getBlocked() == null) {
            memory.getRightTupleMemory().removeAdd(rightTuple);
            return;
        }
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, rightTuple.getFactHandle());
        LeftTupleMemory leftMemory = memory.getLeftTupleMemory();
        FastIterator leftIt = this.getLeftIterator(leftMemory);
        LeftTuple firstLeftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, context, leftIt);
        LeftTuple firstBlocked = rightTuple.getBlocked();
        rightTuple.nullBlocked();
        LeftTuple leftTuple = firstLeftTuple;
        while (leftTuple != null) {
            LeftTuple temp = (LeftTuple)leftIt.next(leftTuple);
            if (this.constraints.isAllowedCachedRight(memory.getContext(), leftTuple)) {
                leftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(leftTuple);
                leftMemory.remove(leftTuple);
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, true);
            }
            leftTuple = temp;
        }
        RightTupleMemory rightTupleMemory = memory.getRightTupleMemory();
        if (firstBlocked != null) {
            this.updateLeftTupleToNewBlocker(rightTuple, context, workingMemory, memory, leftMemory, firstBlocked, rightTupleMemory, true);
        } else {
            rightTupleMemory.removeAdd(rightTuple);
        }
        this.constraints.resetFactHandle(memory.getContext());
        this.constraints.resetTuple(memory.getContext());
    }

    private void updateLeftTupleToNewBlocker(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, BetaMemory memory, LeftTupleMemory leftMemory, LeftTuple firstBlocked, RightTupleMemory rightTupleMemory, boolean removeAdd) {
        boolean resumeFromCurrent = !this.indexedUnificationJoin && !rightTupleMemory.getIndexType().isComparison();
        FastIterator rightIt = null;
        RightTuple rootBlocker = null;
        if (resumeFromCurrent) {
            RightTupleList currentRtm = rightTuple.getMemory();
            rightIt = currentRtm.fastIterator();
            rootBlocker = (RightTuple)rightTuple.getNext();
            if (removeAdd) {
                rightTupleMemory.removeAdd(rightTuple);
            } else {
                rightTupleMemory.remove(rightTuple);
            }
            if (rootBlocker == null && rightTuple.getMemory() == currentRtm) {
                rootBlocker = rightTuple;
            }
        } else {
            rightIt = this.getRightIterator(rightTupleMemory);
            if (removeAdd) {
                rightTupleMemory.removeAdd(rightTuple);
            } else {
                rightTupleMemory.remove(rightTuple);
            }
        }
        LeftTuple leftTuple = firstBlocked;
        while (leftTuple != null) {
            LeftTuple temp = leftTuple.getBlockedNext();
            leftTuple.clearBlocker();
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
            if (!resumeFromCurrent) {
                rootBlocker = this.getFirstRightTuple(leftTuple, rightTupleMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
            }
            RightTuple newBlocker = rootBlocker;
            while (newBlocker != null) {
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), newBlocker.getFactHandle())) {
                    leftTuple.setBlocker(newBlocker);
                    newBlocker.addBlocked(leftTuple);
                    break;
                }
                newBlocker = (RightTuple)rightIt.next(newBlocker);
            }
            if (leftTuple.getBlocker() == null) {
                leftMemory.add(leftTuple);
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            }
            leftTuple = temp;
        }
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.getRightTupleMemory().iterator();
        RightTuple rightTuple = (RightTuple)it.next();
        while (rightTuple != null) {
            for (LeftTuple leftTuple = rightTuple.getBlocked(); leftTuple != null; leftTuple = leftTuple.getBlockedNext()) {
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, sink, context, true), context, workingMemory);
            }
            rightTuple = (RightTuple)it.next();
        }
    }

    @Override
    public String toString() {
        ObjectSource source = this.rightInput;
        while (source != null && source.getClass() != ObjectTypeNode.class) {
            source = source.source;
        }
        return "[ExistsNode(" + this.getId() + ") - " + (source != null ? ((ObjectTypeNode)source).getObjectType() : "<source from a subnetwork>") + "]";
    }

    @Override
    public short getType() {
        return 201;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        return new NotNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new NotNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new NotNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        NotNodeLeftTuple peer = new NotNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }
}

