/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.ArrayList;
import org.drools.core.command.ExecuteCommand;
import org.drools.core.command.GetVariableCommand;
import org.drools.core.command.KnowledgeContextResolveFromContextCommand;
import org.drools.core.command.ResolvingKnowledgeCommandContext;
import org.drools.core.command.SetVariableCommandFromCommand;
import org.drools.core.command.impl.ContextImpl;
import org.drools.core.command.impl.DefaultCommandService;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.QueryCommand;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.runtime.rule.impl.NativeQueryResults;
import org.drools.core.world.impl.WorldImpl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.command.Context;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ExecuteCommandDisconnectedTest {
    private StatefulKnowledgeSession ksession;
    private DefaultCommandService commandService;

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void executeDisconnected() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.ksession = kbase.newStatefulKnowledgeSession();
        ExecutionResultImpl localKresults = new ExecutionResultImpl();
        ResolvingKnowledgeCommandContext kContext = new ResolvingKnowledgeCommandContext((Context)new ContextImpl("ksession", null));
        kContext.set("localResults", (Object)localKresults);
        kContext.set("ksession", (Object)this.ksession);
        this.commandService = new DefaultCommandService((Context)kContext);
        ArrayList<InsertObjectCommand> cmds = new ArrayList<InsertObjectCommand>();
        cmds.add(new InsertObjectCommand((Object)new String("Hi!"), "handle"));
        BatchExecutionCommand batchCmd = CommandFactory.newBatchExecution(cmds, (String)"kresults");
        ExecuteCommand execCmd = new ExecuteCommand((Command)batchCmd, true);
        KnowledgeContextResolveFromContextCommand resolveFromContextCommand = new KnowledgeContextResolveFromContextCommand((Command)execCmd, null, null, "ksession", "localResults");
        ExecutionResults results = (ExecutionResults)this.commandService.execute((Command)resolveFromContextCommand);
        Assert.assertNotNull((Object)results);
        Assert.assertNotNull((Object)results.getFactHandle("handle"));
        Assert.assertTrue((boolean)((DefaultFactHandle)results.getFactHandle("handle")).isDisconnected());
        cmds = new ArrayList();
        cmds.add(new InsertObjectCommand((Object)new String("Hi!"), "handle"));
        batchCmd = CommandFactory.newBatchExecution(cmds, (String)"kresults");
        execCmd = new ExecuteCommand((Command)batchCmd);
        resolveFromContextCommand = new KnowledgeContextResolveFromContextCommand((Command)execCmd, null, null, "ksession", "localResults");
        results = (ExecutionResults)this.commandService.execute((Command)resolveFromContextCommand);
        Assert.assertNotNull((Object)results);
        Assert.assertNotNull((Object)results.getFactHandle("handle"));
        Assert.assertFalse((boolean)((DefaultFactHandle)results.getFactHandle("handle")).isDisconnected());
    }

    @Test
    public void executeCmdContextPropagationCastTest() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.ksession = kbase.newStatefulKnowledgeSession();
        ExecutionResultImpl localKresults = new ExecutionResultImpl();
        WorldImpl worldImpl = new WorldImpl();
        worldImpl.createContext("__TEMP__");
        worldImpl.getContext("__TEMP__").set("__TEMP__", (Object)new ContextImpl("__TEMP__", null));
        ResolvingKnowledgeCommandContext kContext = new ResolvingKnowledgeCommandContext((Context)worldImpl);
        kContext.set("localResults", (Object)localKresults);
        kContext.set("ksession", (Object)this.ksession);
        this.commandService = new DefaultCommandService((Context)kContext);
        ArrayList<SetVariableCommandFromCommand> cmds = new ArrayList<SetVariableCommandFromCommand>();
        QueryCommand queryCommand = new QueryCommand("out", "myQuery", new Object[0]);
        SetVariableCommandFromCommand setVariableCmd = new SetVariableCommandFromCommand("__TEMP__", "query123", (Command)queryCommand);
        cmds.add(setVariableCmd);
        BatchExecutionCommand batchCmd = CommandFactory.newBatchExecution(cmds, (String)"kresults");
        ExecuteCommand execCmd = new ExecuteCommand((Command)batchCmd, true);
        KnowledgeContextResolveFromContextCommand resolveFromContextCommand = new KnowledgeContextResolveFromContextCommand((Command)execCmd, null, null, "ksession", "localResults");
        ExecutionResults results = (ExecutionResults)this.commandService.execute((Command)resolveFromContextCommand);
        Assert.assertNotNull((Object)results);
        GetVariableCommand getVariableCmd = new GetVariableCommand("query123", "__TEMP__");
        resolveFromContextCommand = new KnowledgeContextResolveFromContextCommand((Command)getVariableCmd, null, null, "ksession", "localResults");
        NativeQueryResults queryResults = (NativeQueryResults)this.commandService.execute((Command)resolveFromContextCommand);
        Assert.assertNotNull((Object)queryResults);
        Assert.assertEquals((long)0L, (long)queryResults.size());
    }
}

