/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.core.common.ActivationNode;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleFlowGroupListener;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.spi.Activation;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;

public class RuleFlowGroupImpl
implements InternalRuleFlowGroup {
    private static final long serialVersionUID = 510L;
    private InternalWorkingMemory workingMemory;
    private String name;
    private boolean active = false;
    private boolean autoDeactivate = true;
    private LinkedList<ActivationNode> list;
    private List<RuleFlowGroupListener> listeners;
    private Map<Long, String> nodeInstances = new HashMap<Long, String>();
    private long activatedForRecency;
    private long clearedForRecency;

    public RuleFlowGroupImpl() {
    }

    public RuleFlowGroupImpl(String name) {
        this.name = name;
        this.list = new LinkedList();
    }

    public RuleFlowGroupImpl(String name, boolean active, boolean autoDeactivate) {
        this.name = name;
        this.active = active;
        this.autoDeactivate = autoDeactivate;
        this.list = new LinkedList();
        this.clearedForRecency = -1L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        LinkedList<ActivationNode> linkedList = this.list;
        synchronized (linkedList) {
            if (active) {
                this.setActivatedForRecency(this.workingMemory.getFactHandleFactory().getRecency());
                ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireBeforeRuleFlowGroupActivated(this, this.workingMemory);
                if (this.list.isEmpty()) {
                    if (this.autoDeactivate) {
                        DeactivateCallback action = new DeactivateCallback(this);
                        this.workingMemory.queueWorkingMemoryAction(action);
                    }
                } else {
                    this.triggerActivations();
                }
                ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireAfterRuleFlowGroupActivated(this, this.workingMemory);
            } else {
                ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireBeforeRuleFlowGroupDeactivated(this, this.workingMemory);
                FastIterator it = this.list.fastIterator();
                ActivationNode entry = this.list.getFirst();
                while (entry != null) {
                    Activation activation = entry.getActivation();
                    activation.remove();
                    if (activation.getActivationGroupNode() != null) {
                        activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
                    }
                    entry = (ActivationNode)it.next(entry);
                }
                this.nodeInstances.clear();
                this.notifyRuleFlowGroupListeners();
                ((EventSupport)((Object)this.workingMemory)).getAgendaEventSupport().fireAfterRuleFlowGroupDeactivated(this, this.workingMemory);
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isAutoDeactivate() {
        return this.autoDeactivate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoDeactivate(boolean autoDeactivate) {
        this.autoDeactivate = autoDeactivate;
        LinkedList<ActivationNode> linkedList = this.list;
        synchronized (linkedList) {
            if (autoDeactivate && this.active && this.list.isEmpty()) {
                this.active = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerActivations() {
        LinkedList<ActivationNode> linkedList = this.list;
        synchronized (linkedList) {
            FastIterator it = this.list.fastIterator();
            ActivationNode entry = this.list.getFirst();
            while (entry != null) {
                Activation activation = entry.getActivation();
                activation.getAgendaGroup().add(activation);
                entry = (ActivationNode)it.next(entry);
            }
        }
        ((InternalAgenda)this.workingMemory.getAgenda()).notifyHalt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LinkedList<ActivationNode> linkedList = this.list;
        synchronized (linkedList) {
            this.list.clear();
            this.active = false;
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActivation(Activation activation) {
        assert (activation.getActivationNode() == null);
        ActivationNode node = new ActivationNode(activation, this);
        activation.setActivationNode(node);
        LinkedList<ActivationNode> linkedList = this.list;
        synchronized (linkedList) {
            this.list.add(node);
        }
        if (this.active) {
            activation.getAgendaGroup().add(activation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActivation(Activation activation) {
        LinkedList<ActivationNode> linkedList = this.list;
        synchronized (linkedList) {
            ActivationNode node = activation.getActivationNode();
            this.list.remove(node);
            activation.setActivationNode(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivateIfEmpty() {
        LinkedList<ActivationNode> linkedList = this.list;
        synchronized (linkedList) {
            if (this.active && this.autoDeactivate && this.list.isEmpty()) {
                DeactivateCallback action = new DeactivateCallback(this);
                this.workingMemory.queueWorkingMemoryAction(action);
            }
        }
    }

    @Override
    public void addRuleFlowGroupListener(RuleFlowGroupListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<RuleFlowGroupListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeRuleFlowGroupListener(RuleFlowGroupListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void notifyRuleFlowGroupListeners() {
        if (this.listeners != null) {
            Iterator<RuleFlowGroupListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().ruleFlowGroupDeactivated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        LinkedList<ActivationNode> linkedList = this.list;
        synchronized (linkedList) {
            return this.list.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Activation[] getActivations() {
        LinkedList<ActivationNode> linkedList = this.list;
        synchronized (linkedList) {
            Activation[] activations = new Activation[this.list.size()];
            FastIterator it = this.list.fastIterator();
            int i = 0;
            ActivationNode entry = this.list.getFirst();
            while (entry != null) {
                activations[i++] = entry.getActivation();
                entry = (ActivationNode)it.next(entry);
            }
            return activations;
        }
    }

    @Override
    public Iterator iterator() {
        return this.list.javaUtilIterator();
    }

    @Override
    public void addNodeInstance(Long processInstanceId, String nodeInstanceId) {
        this.nodeInstances.put(processInstanceId, nodeInstanceId);
    }

    @Override
    public void removeNodeInstance(Long processInstanceId, String nodeInstanceId) {
        this.nodeInstances.put(processInstanceId, nodeInstanceId);
    }

    @Override
    public Map<Long, String> getNodeInstances() {
        return this.nodeInstances;
    }

    @Override
    public void setActivatedForRecency(long recency) {
        this.activatedForRecency = recency;
    }

    @Override
    public long getActivatedForRecency() {
        return this.activatedForRecency;
    }

    @Override
    public void setClearedForRecency(long recency) {
        this.clearedForRecency = recency;
    }

    @Override
    public long getClearedForRecency() {
        return this.clearedForRecency;
    }

    public String toString() {
        return "RuleFlowGroup '" + this.name + "'";
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RuleFlowGroupImpl)) {
            return false;
        }
        return ((RuleFlowGroupImpl)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class DeactivateCallback
    implements WorkingMemoryAction {
        private static final long serialVersionUID = 510L;
        private InternalRuleFlowGroup ruleFlowGroup;

        public DeactivateCallback(InternalRuleFlowGroup ruleFlowGroup) {
            this.ruleFlowGroup = ruleFlowGroup;
        }

        public DeactivateCallback(MarshallerReaderContext context) throws IOException {
            this.ruleFlowGroup = (InternalRuleFlowGroup)context.wm.getAgenda().getRuleFlowGroup(context.readUTF());
        }

        public DeactivateCallback(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            this.ruleFlowGroup = (InternalRuleFlowGroup)context.wm.getAgenda().getRuleFlowGroup(_action.getDeactivateCallback().getRuleflowGroup());
        }

        @Override
        public void write(MarshallerWriteContext context) throws IOException {
            context.writeShort(2);
            context.writeUTF(this.ruleFlowGroup.getName());
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.DEACTIVATE_CALLBACK).setDeactivateCallback(ProtobufMessages.ActionQueue.DeactivateCallback.newBuilder().setRuleflowGroup(this.ruleFlowGroup.getName()).build()).build();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.ruleFlowGroup = (InternalRuleFlowGroup)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.ruleFlowGroup);
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            if (this.ruleFlowGroup.isEmpty()) {
                this.ruleFlowGroup.setActive(false);
            }
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }
    }
}

