/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.RuleBaseConfiguration;
import org.drools.core.RuleBaseFactory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextImpl;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockAccumulator;
import org.drools.core.reteoo.MockLeftTupleSink;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.ReteooWorkingMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.Rule;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.DroolsTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.rule.SessionEntryPoint;

@Ignore(value="phreak")
public class AccumulateNodeTest
extends DroolsTestCase {
    Rule rule;
    PropagationContext context;
    ReteooWorkingMemory workingMemory;
    MockObjectSource objectSource;
    MockTupleSource tupleSource;
    MockLeftTupleSink sink;
    BetaNode node;
    BetaMemory memory;
    MockAccumulator accumulator;
    Accumulate accumulate;

    @Before
    public void setUp() throws Exception {
        this.rule = new Rule("test-rule");
        this.context = new PropagationContextImpl(0L, 0, null, null, null);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        this.workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        this.tupleSource = new MockTupleSource(4);
        this.objectSource = new MockObjectSource(4);
        this.sink = new MockLeftTupleSink();
        this.accumulator = new MockAccumulator();
        ClassObjectType srcObjType = new ClassObjectType(String.class);
        Pattern sourcePattern = new Pattern(0, (ObjectType)srcObjType);
        this.accumulate = new Accumulate((RuleConditionElement)sourcePattern, new Declaration[0], new Accumulator[]{this.accumulator}, false);
        this.node = new AccumulateNode(15, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, new AlphaNodeFieldConstraint[0], EmptyBetaConstraints.getInstance(), EmptyBetaConstraints.getInstance(), this.accumulate, false, buildContext);
        this.node.addTupleSink((LeftTupleSink)this.sink);
        this.memory = ((AccumulateNode.AccumulateMemory)this.workingMemory.getNodeMemory((MemoryFactory)this.node)).betaMemory;
        Assert.assertEquals((long)0L, (long)this.memory.getLeftTupleMemory().size());
        Assert.assertEquals((long)0L, (long)this.memory.getRightTupleMemory().size());
    }

    @Test
    public void testUpdateSink() {
        this.node.updateSink((LeftTupleSink)this.sink, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((String)"No tuple should be propagated", (long)0L, (long)this.sink.getAsserted().size());
        this.node.assertLeftTuple((LeftTuple)new LeftTupleImpl(this.workingMemory.getFactHandleFactory().newFactHandle((Object)"cheese", null, null, (SessionEntryPoint)this.workingMemory), null, true), this.context, (InternalWorkingMemory)this.workingMemory);
        this.node.assertLeftTuple((LeftTuple)new LeftTupleImpl(this.workingMemory.getFactHandleFactory().newFactHandle((Object)"other cheese", null, null, (SessionEntryPoint)this.workingMemory), null, true), this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((String)"Two tuples should have been propagated", (long)2L, (long)this.sink.getAsserted().size());
        MockLeftTupleSink otherSink = new MockLeftTupleSink();
        this.node.addTupleSink((LeftTupleSink)otherSink);
        this.node.updateSink((LeftTupleSink)otherSink, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((String)"Two tuples should have been propagated", (long)2L, (long)otherSink.getAsserted().size());
    }

    @Test
    public void testAssertTuple() {
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"cheese", null, null, (SessionEntryPoint)this.workingMemory);
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, null, true);
        this.node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)1L, (long)this.memory.getLeftTupleMemory().size());
        Assert.assertEquals((long)0L, (long)this.memory.getRightTupleMemory().size());
        Assert.assertTrue((String)"An empty matching objects list should be propagated", (boolean)this.accumulator.getMatchingObjects().isEmpty());
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"other cheese", null, null, (SessionEntryPoint)this.workingMemory);
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, null, true);
        this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)this.memory.getLeftTupleMemory().size());
        Assert.assertTrue((String)"An empty matching objects list should be propagated", (boolean)this.accumulator.getMatchingObjects().isEmpty());
        LeftTupleMemory memory = this.memory.getLeftTupleMemory();
        Assert.assertTrue((boolean)memory.contains((LeftTuple)tuple0));
        Assert.assertTrue((boolean)memory.contains((LeftTuple)tuple1));
        Assert.assertEquals((String)"Two tuples should have been propagated", (long)2L, (long)this.sink.getAsserted().size());
    }

    @Test
    public void testAssertTupleWithObjects() {
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"cheese", null, null, (SessionEntryPoint)this.workingMemory);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"other cheese", null, null, (SessionEntryPoint)this.workingMemory);
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, null, true);
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)1L, (long)this.memory.getLeftTupleMemory().size());
        Assert.assertEquals((long)2L, (long)this.memory.getRightTupleMemory().size());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (long)2L, (long)this.accumulator.getMatchingObjects().size());
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, null, true);
        this.node.assertLeftTuple((LeftTuple)tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)2L, (long)this.memory.getLeftTupleMemory().size());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (long)2L, (long)this.accumulator.getMatchingObjects().size());
        LeftTupleMemory memory = this.memory.getLeftTupleMemory();
        Assert.assertTrue((boolean)memory.contains((LeftTuple)tuple0));
        Assert.assertTrue((boolean)memory.contains((LeftTuple)tuple1));
        Assert.assertEquals((String)"Two tuples should have been propagated", (long)2L, (long)this.sink.getAsserted().size());
    }

    @Test
    public void testRetractTuple() {
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"cheese", null, null, null);
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, null, true);
        this.node.assertLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)1L, (long)this.memory.getLeftTupleMemory().size());
        Assert.assertEquals((long)0L, (long)this.memory.getRightTupleMemory().size());
        Assert.assertTrue((String)"An empty matching objects list should be propagated", (boolean)this.accumulator.getMatchingObjects().isEmpty());
        this.node.retractLeftTuple((LeftTuple)tuple0, this.context, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((long)0L, (long)this.memory.getLeftTupleMemory().size());
        Assert.assertEquals((long)1L, (long)this.sink.getRetracted().size());
        Assert.assertEquals((long)1L, (long)this.sink.getAsserted().size());
    }

    @Test
    public void testMemory() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        this.workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        MockObjectSource objectSource = new MockObjectSource(1);
        MockTupleSource tupleSource = new MockTupleSource(1);
        AccumulateNode accumulateNode = new AccumulateNode(2, (LeftTupleSource)tupleSource, (ObjectSource)objectSource, new AlphaNodeFieldConstraint[0], EmptyBetaConstraints.getInstance(), EmptyBetaConstraints.getInstance(), this.accumulate, false, buildContext);
        BetaMemory memory = ((AccumulateNode.AccumulateMemory)this.workingMemory.getNodeMemory((MemoryFactory)accumulateNode)).betaMemory;
        Assert.assertNotNull((Object)memory);
    }

    @Test
    public void testAssertTupleSequentialMode() throws Exception {
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setPhreakEnabled(false);
        conf.setSequential(true);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        buildContext.setTupleMemoryEnabled(false);
        this.node = new AccumulateNode(15, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, new AlphaNodeFieldConstraint[0], EmptyBetaConstraints.getInstance(), EmptyBetaConstraints.getInstance(), this.accumulate, false, buildContext);
        this.node.addTupleSink((LeftTupleSink)this.sink);
        this.workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf)));
        this.memory = ((AccumulateNode.AccumulateMemory)this.workingMemory.getNodeMemory((MemoryFactory)this.node)).betaMemory;
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"cheese", null, null, null);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"other cheese", null, null, null);
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, null, true);
        this.node.assertObject((InternalFactHandle)f0, this.context, (InternalWorkingMemory)this.workingMemory);
        this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.node.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)new PropagationContextImpl(0L, 0, null, null, (InternalFactHandle)f0), (InternalWorkingMemory)this.workingMemory);
        Assert.assertNull((Object)this.memory.getLeftTupleMemory());
        Assert.assertEquals((long)2L, (long)this.memory.getRightTupleMemory().size());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (long)2L, (long)this.accumulator.getMatchingObjects().size());
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, null, true);
        this.node.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)new PropagationContextImpl(0L, 0, null, null, (InternalFactHandle)f1), (InternalWorkingMemory)this.workingMemory);
        Assert.assertNull((Object)this.memory.getLeftTupleMemory());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (long)2L, (long)this.accumulator.getMatchingObjects().size());
        Assert.assertEquals((String)"Two tuples should have been propagated", (long)2L, (long)this.sink.getAsserted().size());
    }
}

