/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.RuleBaseFactory;
import org.drools.core.WorkingMemory;
import org.drools.core.base.SalienceInteger;
import org.drools.core.common.AgendaGroupQueueImpl;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.DefaultAgenda;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContextImpl;
import org.drools.core.event.ActivationCancelledEvent;
import org.drools.core.event.AgendaEventListener;
import org.drools.core.event.DefaultAgendaEventListener;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockTupleSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.ReteooWorkingMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Rule;
import org.drools.core.spi.Activation;
import org.drools.core.spi.ActivationGroup;
import org.drools.core.spi.AgendaFilter;
import org.drools.core.spi.AgendaGroup;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.ConsequenceException;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.RuleFlowGroup;
import org.drools.core.spi.Salience;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.DroolsTestCase;
import org.drools.core.time.impl.DurationTimer;
import org.drools.core.time.impl.Timer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.Session;
import org.kie.internal.event.rule.ActivationUnMatchListener;

public class AgendaTest
extends DroolsTestCase {
    private InternalRuleBase ruleBase;
    private BuildContext buildContext;

    @Before
    public void setUp() throws Exception {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setPhreakEnabled(false);
        this.ruleBase = (InternalRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)config);
        this.buildContext = new BuildContext(this.ruleBase, ((ReteooRuleBase)this.ruleBase).getReteooBuilder().getIdGenerator());
    }

    @Test
    public void testClearAgenda() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Rule rule1 = new Rule("test-rule1");
        Rule rule2 = new Rule("test-rule2");
        RuleTerminalNode node1 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), 0, this.buildContext);
        RuleTerminalNode node2 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(4), rule2, rule2.getLhs(), 0, this.buildContext);
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node1, true);
        RuleTerminalNodeLeftTuple tuple2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(2, (Object)"cheese"), (LeftTupleSink)node2, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, (InternalFactHandle)new DefaultFactHandle());
        rule1.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        rule2.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        rule1.setNoLoop(false);
        rule2.setTimer((Timer)new DurationTimer(5000L));
        node1.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        node2.assertLeftTuple((LeftTuple)tuple2, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)1L, (long)agenda.getScheduledActivations().length);
        agenda.clearAndCancel();
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)0L, (long)agenda.getScheduledActivations().length);
    }

    @Test
    public void testActivationUnMatchListener() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Rule rule1 = new Rule("test-rule1");
        RuleTerminalNode node1 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), 0, this.buildContext);
        Cheese cheese = new Cheese();
        cheese.setPrice(50);
        RuleTerminalNodeLeftTuple tuple = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)cheese), (LeftTupleSink)node1, true);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, (InternalFactHandle)new DefaultFactHandle());
        rule1.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                AgendaItem item = (AgendaItem)knowledgeHelper.getMatch();
                final Cheese cheese = (Cheese)item.getTuple().getHandle().getObject();
                final int oldPrice = cheese.getPrice();
                cheese.setPrice(100);
                item.setActivationUnMatchListener(new ActivationUnMatchListener(){

                    public void unMatch(Session wm, Match activation) {
                        cheese.setPrice(oldPrice);
                    }
                });
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        Assert.assertEquals((long)50L, (long)cheese.getPrice());
        node1.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)100L, (long)cheese.getPrice());
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 1, rule1, null, (InternalFactHandle)new DefaultFactHandle());
        node1.retractLeftTuple((LeftTuple)tuple, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)50L, (long)cheese.getPrice());
    }

    @Test
    public void testFilters() throws Exception {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        final Boolean[] filtered = new Boolean[]{false};
        workingMemory.addEventListener((AgendaEventListener)new DefaultAgendaEventListener(){

            public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
                if (event.getCause() == MatchCancelledCause.FILTER) {
                    filtered[0] = true;
                }
            }
        });
        Rule rule = new Rule("test-rule");
        RuleTerminalNode node = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), 0, this.buildContext);
        final HashMap results = new HashMap();
        rule.setConsequence(new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                results.put("fired", new Boolean(true));
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        });
        RuleTerminalNodeLeftTuple tuple = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node, true);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, rule, null, (InternalFactHandle)new DefaultFactHandle());
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        AgendaFilter filterTrue = new AgendaFilter(){

            public boolean accept(Activation item) {
                return true;
            }
        };
        rule.setNoLoop(false);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        agenda.fireNextItem(filterTrue, 0, -1);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((Object)new Boolean(true), results.get("fired"));
        Assert.assertEquals((Object)false, (Object)filtered[0]);
        agenda.clearAndCancel();
        results.clear();
        AgendaFilter filterFalse = new AgendaFilter(){

            public boolean accept(Activation item) {
                return false;
            }
        };
        rule.setNoLoop(false);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        agenda.fireNextItem(filterFalse, 0, -1);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertNull(results.get("fired"));
        Assert.assertEquals((Object)true, (Object)filtered[0]);
    }

    @Test
    public void testFocusStack() throws ConsequenceException {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        rule0.setConsequence(consequence);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, (InternalFactHandle)new DefaultFactHandle());
        Rule rule1 = new Rule("test-rule1", "agendaGroup1");
        RuleTerminalNode node1 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(4), rule1, rule1.getLhs(), 0, this.buildContext);
        rule1.setConsequence(consequence);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, (InternalFactHandle)new DefaultFactHandle());
        Rule rule2 = new Rule("test-rule2", "agendaGroup2");
        RuleTerminalNode node2 = new RuleTerminalNode(7, (LeftTupleSource)new MockTupleSource(6), rule2, rule2.getLhs(), 0, this.buildContext);
        rule2.setConsequence(consequence);
        PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, rule2, null, (InternalFactHandle)new DefaultFactHandle());
        Rule rule3 = new Rule("test-rule3", "agendaGroup3");
        RuleTerminalNode node3 = new RuleTerminalNode(9, (LeftTupleSource)new MockTupleSource(8), rule3, rule3.getLhs(), 0, this.buildContext);
        rule3.setConsequence(consequence);
        PropagationContextImpl context3 = new PropagationContextImpl(0L, 0, rule3, null, (InternalFactHandle)new DefaultFactHandle());
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node0, true);
        RuleTerminalNodeLeftTuple tuple2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(2, (Object)"cheese"), (LeftTupleSink)node2, true);
        RuleTerminalNodeLeftTuple tuple3 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(3, (Object)"cheese"), (LeftTupleSink)node2, true);
        RuleTerminalNodeLeftTuple tuple4 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(4, (Object)"cheese"), (LeftTupleSink)node3, true);
        RuleTerminalNodeLeftTuple tuple5 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(5, (Object)"cheese"), (LeftTupleSink)node3, true);
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        AgendaGroupQueueImpl agendaGroup1 = new AgendaGroupQueueImpl("agendaGroup1", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup1);
        AgendaGroupQueueImpl agendaGroup2 = new AgendaGroupQueueImpl("agendaGroup2", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup2);
        AgendaGroupQueueImpl agendaGroup3 = new AgendaGroupQueueImpl("agendaGroup3", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup3);
        Assert.assertEquals((long)0L, (long)agenda.focusStackSize());
        node0.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        AgendaGroup main = agenda.getAgendaGroup("MAIN");
        Assert.assertEquals((Object)agenda.getFocus(), (Object)main);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        node2.assertLeftTuple((LeftTuple)tuple2, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)1L, (long)agendaGroup2.size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        node2.assertLeftTuple((LeftTuple)tuple3, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)2L, (long)agendaGroup2.size());
        Assert.assertEquals((long)3L, (long)agenda.agendaSize());
        agenda.setFocus("agendaGroup1");
        agenda.setFocus("agendaGroup2");
        agenda.setFocus("agendaGroup3");
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        node3.assertLeftTuple((LeftTuple)tuple4, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        node3.assertLeftTuple((LeftTuple)tuple5, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)2L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)5L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((Object)agenda.getFocus(), (Object)agendaGroup3);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)4L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((Object)agenda.getFocus(), (Object)agendaGroup3);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)3L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((Object)agendaGroup2, (Object)agenda.getFocus());
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((Object)agenda.getFocus(), (Object)agendaGroup2);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((Object)agenda.getFocus(), (Object)main);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
    }

    @Test
    public void testAutoFocus() throws ConsequenceException {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        AgendaGroupQueueImpl agendaGroup = new AgendaGroupQueueImpl("agendaGroup", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup);
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule = new Rule("test-rule", "agendaGroup");
        RuleTerminalNode node = new RuleTerminalNode(2, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), 0, this.buildContext);
        RuleTerminalNodeLeftTuple tuple = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node, true);
        rule.setConsequence(consequence);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, rule, null, (InternalFactHandle)new DefaultFactHandle());
        rule.setAutoFocus(false);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)agendaGroup.size());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)1L, (long)agendaGroup.size());
        agenda.clearAndCancel();
        Assert.assertEquals((long)0L, (long)agendaGroup.size());
        rule.setAutoFocus(true);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)agendaGroup.size());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)0L, (long)agendaGroup.size());
    }

    @Test
    public void testAgendaGroupLockOnActive() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        AgendaGroupQueueImpl agendaGroup = new AgendaGroupQueueImpl("agendaGroup", this.ruleBase);
        agenda.addAgendaGroup((AgendaGroup)agendaGroup);
        Rule rule = new Rule("test-rule", "agendaGroup");
        RuleTerminalNode node = new RuleTerminalNode(2, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), 0, this.buildContext);
        RuleTerminalNodeLeftTuple tuple = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node, true);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, rule, null, (InternalFactHandle)new DefaultFactHandle());
        rule.setLockOnActive(true);
        ((InternalRuleFlowGroup)agendaGroup).setAutoDeactivate(false);
        agendaGroup.setActive(true);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)agendaGroup.size());
        rule.setLockOnActive(false);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)agendaGroup.size());
        rule.setLockOnActive(true);
        agendaGroup.setActive(false);
        node.assertLeftTuple((LeftTuple)tuple, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)2L, (long)agendaGroup.size());
    }

    @Test
    public void testActivationGroup() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        final ArrayList list = new ArrayList();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                list.add(knowledgeHelper.getRule());
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setActivationGroup("activation-group-0");
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        rule0.setConsequence(consequence);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, (InternalFactHandle)new DefaultFactHandle());
        Rule rule1 = new Rule("test-rule1");
        rule1.setActivationGroup("activation-group-0");
        rule1.setSalience((Salience)new SalienceInteger(10));
        RuleTerminalNode node1 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(4), rule1, rule1.getLhs(), 0, this.buildContext);
        rule1.setConsequence(consequence);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, (InternalFactHandle)new DefaultFactHandle());
        Rule rule2 = new Rule("test-rule2");
        rule2.setSalience((Salience)new SalienceInteger(-5));
        RuleTerminalNode node2 = new RuleTerminalNode(7, (LeftTupleSource)new MockTupleSource(6), rule2, rule2.getLhs(), 0, this.buildContext);
        rule2.setConsequence(consequence);
        PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, rule2, null, (InternalFactHandle)new DefaultFactHandle());
        Rule rule3 = new Rule("test-rule3", "agendaGroup3");
        rule3.setSalience((Salience)new SalienceInteger(-10));
        rule3.setActivationGroup("activation-group-3");
        RuleTerminalNode node3 = new RuleTerminalNode(9, (LeftTupleSource)new MockTupleSource(8), rule3, rule3.getLhs(), 0, this.buildContext);
        rule3.setConsequence(consequence);
        PropagationContextImpl context3 = new PropagationContextImpl(0L, 0, rule3, null, (InternalFactHandle)new DefaultFactHandle());
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node1, true);
        RuleTerminalNodeLeftTuple tuple3 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node1, true);
        RuleTerminalNodeLeftTuple tuple4 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node1, true);
        RuleTerminalNodeLeftTuple tuple5 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node1, true);
        RuleTerminalNodeLeftTuple tuple6 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node1, true);
        RuleTerminalNodeLeftTuple tuple7 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node2, true);
        RuleTerminalNodeLeftTuple tuple8 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node3, true);
        node0.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        ActivationGroup activationGroup0 = agenda.getActivationGroup("activation-group-0");
        Assert.assertEquals((long)1L, (long)activationGroup0.size());
        node0.retractLeftTuple((LeftTuple)tuple1, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)activationGroup0.size());
        node0.assertLeftTuple((LeftTuple)tuple3, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)activationGroup0.size());
        node1.assertLeftTuple((LeftTuple)tuple4, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)2L, (long)activationGroup0.size());
        Assert.assertEquals((long)2L, (long)agenda.focusStackSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)0L, (long)activationGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.focusStackSize());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertSame((Object)rule1, list.get(0));
        list.clear();
        node0.assertLeftTuple((LeftTuple)tuple5, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        node1.assertLeftTuple((LeftTuple)tuple6, (PropagationContext)context1, (InternalWorkingMemory)workingMemory);
        node2.assertLeftTuple((LeftTuple)tuple7, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        node3.assertLeftTuple((LeftTuple)tuple8, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)2L, (long)activationGroup0.size());
        ActivationGroup activationGroup3 = agenda.getActivationGroup("activation-group-3");
        Assert.assertEquals((long)4L, (long)agenda.agendaSize());
        Assert.assertEquals((long)1L, (long)activationGroup3.size());
        agenda.clearAndCancelAgendaGroup("agendaGroup3");
        Assert.assertEquals((long)3L, (long)agenda.agendaSize());
        Assert.assertEquals((long)0L, (long)activationGroup3.size());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        Assert.assertEquals((long)0L, (long)activationGroup0.size());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)rule1, list.get(0));
        Assert.assertEquals((Object)rule2, list.get(1));
    }

    @Test
    public void testRuleFlowGroup() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        final ArrayList list = new ArrayList();
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
                list.add(knowledgeHelper.getRule());
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setAgendaGroup("rule-flow-group-0");
        rule0.setConsequence(consequence);
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        Rule rule1 = new Rule("test-rule1");
        rule1.setAgendaGroup("rule-flow-group-1");
        rule1.setConsequence(consequence);
        RuleTerminalNode node1 = new RuleTerminalNode(4, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), 0, this.buildContext);
        Rule rule2 = new Rule("test-rule2");
        rule2.setAgendaGroup("rule-flow-group-2");
        rule2.setConsequence(consequence);
        rule2.setSalience((Salience)new SalienceInteger(10));
        RuleTerminalNode node2 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(2), rule2, rule2.getLhs(), 0, this.buildContext);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, (InternalFactHandle)new DefaultFactHandle());
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        RuleFlowGroup ruleFlowGroup1 = agenda.getRuleFlowGroup("rule-flow-group-1");
        RuleFlowGroup ruleFlowGroup2 = agenda.getRuleFlowGroup("rule-flow-group-2");
        RuleTerminalNodeLeftTuple tuple0 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node0, true);
        node0.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node1, true);
        node0.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        RuleTerminalNodeLeftTuple tuple2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node2, true);
        node1.assertLeftTuple((LeftTuple)tuple2, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        RuleTerminalNodeLeftTuple tuple3 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node0, true);
        node2.assertLeftTuple((LeftTuple)tuple3, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)1L, (long)ruleFlowGroup1.size());
        Assert.assertEquals((long)1L, (long)ruleFlowGroup2.size());
        Assert.assertEquals((long)4L, (long)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)4L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)3L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        agenda.activateRuleFlowGroup("rule-flow-group-1");
        agenda.activateRuleFlowGroup("rule-flow-group-2");
        Assert.assertEquals((long)1L, (long)ruleFlowGroup1.size());
        Assert.assertEquals((long)1L, (long)ruleFlowGroup2.size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)1L, (long)ruleFlowGroup1.size());
        Assert.assertEquals((long)0L, (long)ruleFlowGroup2.size());
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)ruleFlowGroup1.size());
        Assert.assertEquals((long)0L, (long)ruleFlowGroup2.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
    }

    @Test
    public void testRuleFlowGroup1() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence1 = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule1 = new Rule("test-rule1");
        rule1.setAgendaGroup("rule-flow-group-0");
        rule1.setConsequence(consequence1);
        final RuleTerminalNode node1 = new RuleTerminalNode(4, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), 0, this.buildContext);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule1, null, (InternalFactHandle)new DefaultFactHandle());
        Consequence consequence0 = new Consequence((PropagationContext)context0, workingMemory){
            private static final long serialVersionUID = 510L;
            final /* synthetic */ PropagationContext val$context0;
            final /* synthetic */ ReteooWorkingMemory val$workingMemory;
            {
                this.val$context0 = propagationContext;
                this.val$workingMemory = reteooWorkingMemory;
            }

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
                RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node1, true);
                node1.assertLeftTuple((LeftTuple)tuple1, this.val$context0, (InternalWorkingMemory)this.val$workingMemory);
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setAgendaGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        RuleTerminalNodeLeftTuple tuple0 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node0, true);
        node0.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
    }

    @Test
    public void testRuleFlowGroup2() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence1 = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule1 = new Rule("test-rule1");
        rule1.setAgendaGroup("rule-flow-group-0");
        rule1.setConsequence(consequence1);
        final RuleTerminalNode node1 = new RuleTerminalNode(4, (LeftTupleSource)new MockTupleSource(2), rule1, rule1.getLhs(), 0, this.buildContext);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule1, null, (InternalFactHandle)new DefaultFactHandle());
        final RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node1, true);
        Consequence consequence0 = new Consequence((PropagationContext)context0, workingMemory){
            private static final long serialVersionUID = 510L;
            final /* synthetic */ PropagationContext val$context0;
            final /* synthetic */ ReteooWorkingMemory val$workingMemory;
            {
                this.val$context0 = propagationContext;
                this.val$workingMemory = reteooWorkingMemory;
            }

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
                node1.retractLeftTuple((LeftTuple)tuple1, this.val$context0, (InternalWorkingMemory)this.val$workingMemory);
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setAgendaGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        rule0.setSalience((Salience)new SalienceInteger(10));
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        RuleTerminalNodeLeftTuple tuple0 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node0, true);
        node0.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        node1.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
    }

    @Test
    public void testRuleFlowGroup3() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence0 = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setAgendaGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        RuleTerminalNode node0 = new RuleTerminalNode(1, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, (InternalFactHandle)new DefaultFactHandle());
        RuleTerminalNodeLeftTuple tuple0 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node0, true);
        node0.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node0, true);
        node0.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        agenda.deactivateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)2L, (long)ruleFlowGroup0.size());
    }

    @Test
    public void testRuleFlowGroup4() {
        ReteooBuilder.IdGenerator idGenerator = this.ruleBase.getReteooBuilder().getIdGenerator();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence0 = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setAgendaGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        RuleTerminalNode node0 = new RuleTerminalNode(idGenerator.getNextId(), (LeftTupleSource)new MockTupleSource(idGenerator.getNextId()), rule0, rule0.getLhs(), 0, this.buildContext);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        Assert.assertTrue((boolean)ruleFlowGroup0.isAutoDeactivate());
        ruleFlowGroup0.setAutoDeactivate(false);
        Assert.assertFalse((boolean)ruleFlowGroup0.isAutoDeactivate());
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, (InternalFactHandle)new DefaultFactHandle());
        RuleTerminalNodeLeftTuple tuple0 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node0, true);
        node0.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)context0, workingMemory);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertTrue((boolean)ruleFlowGroup0.isActive());
        ruleFlowGroup0.setAutoDeactivate(true);
        Assert.assertTrue((boolean)ruleFlowGroup0.isAutoDeactivate());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertFalse((boolean)ruleFlowGroup0.isActive());
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node0, true);
        node0.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context0, workingMemory);
        agenda.unstageActivations();
        agenda.activateRuleFlowGroup("rule-flow-group-0");
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
        Assert.assertTrue((boolean)ruleFlowGroup0.isActive());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        workingMemory.executeQueuedActions();
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertFalse((boolean)ruleFlowGroup0.isActive());
        RuleTerminalNodeLeftTuple tuple2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node0, true);
        node0.assertLeftTuple((LeftTuple)tuple2, (PropagationContext)context0, workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)ruleFlowGroup0.size());
    }

    @Test
    public void testRuleFlowGroup5() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        Consequence consequence0 = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory w) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        rule0.setRuleFlowGroup("rule-flow-group-0");
        rule0.setConsequence(consequence0);
        RuleFlowGroup ruleFlowGroup0 = agenda.getRuleFlowGroup("rule-flow-group-0");
        Assert.assertTrue((boolean)ruleFlowGroup0.isAutoDeactivate());
        Assert.assertEquals((long)0L, (long)ruleFlowGroup0.size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
    }

    @Test
    public void testRuleFlowGroupLockOnActive() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        RuleFlowGroup ruleFlowGroup = agenda.getRuleFlowGroup("rule-flow-group-0");
        Rule rule = new Rule("test-rule");
        rule.setAgendaGroup("rule-flow-group-0");
        RuleTerminalNode node = new RuleTerminalNode(2, (LeftTupleSource)new MockTupleSource(2), rule, rule.getLhs(), 0, this.buildContext);
        RuleTerminalNodeLeftTuple tuple1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node, true);
        RuleTerminalNodeLeftTuple tuple2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node, true);
        RuleTerminalNodeLeftTuple tuple3 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node, true);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, rule, null, (InternalFactHandle)new DefaultFactHandle());
        rule.setLockOnActive(true);
        ruleFlowGroup.setAutoDeactivate(false);
        ((InternalRuleFlowGroup)ruleFlowGroup).setActive(true);
        node.assertLeftTuple((LeftTuple)tuple1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)0L, (long)ruleFlowGroup.size());
        rule.setLockOnActive(false);
        node.assertLeftTuple((LeftTuple)tuple2, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)ruleFlowGroup.size());
        rule.setLockOnActive(true);
        ((InternalAgendaGroup)ruleFlowGroup).setActive(false);
        node.assertLeftTuple((LeftTuple)tuple3, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)2L, (long)ruleFlowGroup.size());
    }

    @Test
    public void testSequentialAgenda() {
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setPhreakEnabled(false);
        conf.setSequential(true);
        InternalRuleBase ruleBase = (InternalRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf);
        Consequence consequence = new Consequence(){
            private static final long serialVersionUID = 510L;

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }

            public String getName() {
                return "default";
            }
        };
        Rule rule0 = new Rule("test-rule0");
        RuleTerminalNode node0 = new RuleTerminalNode(3, (LeftTupleSource)new MockTupleSource(2), rule0, rule0.getLhs(), 0, this.buildContext);
        rule0.setConsequence(consequence);
        PropagationContextImpl context0 = new PropagationContextImpl(0L, 0, rule0, null, (InternalFactHandle)new DefaultFactHandle());
        Rule rule1 = new Rule("test-rule1", "agendaGroup1");
        RuleTerminalNode node1 = new RuleTerminalNode(5, (LeftTupleSource)new MockTupleSource(4), rule1, rule1.getLhs(), 0, this.buildContext);
        rule1.setConsequence(consequence);
        PropagationContextImpl context1 = new PropagationContextImpl(0L, 0, rule1, null, (InternalFactHandle)new DefaultFactHandle());
        Rule rule2 = new Rule("test-rule2", "agendaGroup1");
        RuleTerminalNode node2 = new RuleTerminalNode(7, (LeftTupleSource)new MockTupleSource(6), rule2, rule2.getLhs(), 0, this.buildContext);
        rule2.setConsequence(consequence);
        PropagationContextImpl context2 = new PropagationContextImpl(0L, 0, rule2, null, (InternalFactHandle)new DefaultFactHandle());
        Rule rule3 = new Rule("test-rule3", "agendaGroup2");
        RuleTerminalNode node3 = new RuleTerminalNode(9, (LeftTupleSource)new MockTupleSource(8), rule3, rule3.getLhs(), 0, this.buildContext);
        rule3.setConsequence(consequence);
        PropagationContextImpl context3 = new PropagationContextImpl(0L, 0, rule3, null, (InternalFactHandle)new DefaultFactHandle());
        RuleTerminalNodeLeftTuple tuple0 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(1, (Object)"cheese"), (LeftTupleSink)node0, true);
        RuleTerminalNodeLeftTuple tuple2_1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(2, (Object)"cheese"), (LeftTupleSink)node2, true);
        RuleTerminalNodeLeftTuple tuple2_2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(3, (Object)"cheese"), (LeftTupleSink)node2, true);
        RuleTerminalNodeLeftTuple tuple3_1 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(4, (Object)"cheese"), (LeftTupleSink)node3, true);
        RuleTerminalNodeLeftTuple tuple3_2 = new RuleTerminalNodeLeftTuple((InternalFactHandle)new DefaultFactHandle(5, (Object)"cheese"), (LeftTupleSink)node3, true);
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(0, ruleBase);
        DefaultAgenda agenda = (DefaultAgenda)workingMemory.getAgenda();
        AgendaGroup agendaGroup1 = agenda.getAgendaGroup("agendaGroup1");
        AgendaGroup agendaGroup2 = agenda.getAgendaGroup("agendaGroup2");
        Assert.assertEquals((long)0L, (long)agenda.focusStackSize());
        node0.assertLeftTuple((LeftTuple)tuple0, (PropagationContext)context0, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        AgendaGroup main = agenda.getAgendaGroup("MAIN");
        Assert.assertEquals((Object)agenda.getFocus(), (Object)main);
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        node2.assertLeftTuple((LeftTuple)tuple2_1, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)1L, (long)agendaGroup1.size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        node2.assertLeftTuple((LeftTuple)tuple2_2, (PropagationContext)context2, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)2L, (long)agendaGroup1.size());
        Assert.assertEquals((long)3L, (long)agenda.agendaSize());
        agenda.setFocus("agendaGroup1");
        agenda.setFocus("agendaGroup2");
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        node3.assertLeftTuple((LeftTuple)tuple3_1, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        node3.assertLeftTuple((LeftTuple)tuple3_2, (PropagationContext)context3, (InternalWorkingMemory)workingMemory);
        agenda.unstageActivations();
        Assert.assertEquals((long)2L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)5L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((Object)agendaGroup2, (Object)agenda.getFocus());
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)4L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((Object)agendaGroup2, (Object)agenda.getFocus());
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)3L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((Object)agendaGroup1, (Object)agenda.getFocus());
        Assert.assertEquals((long)1L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)2L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((Object)agendaGroup1, (Object)agenda.getFocus());
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)1L, (long)agenda.agendaSize());
        agenda.fireNextItem(null, 0, -1);
        Assert.assertEquals((Object)agenda.getFocus(), (Object)main);
        Assert.assertEquals((long)0L, (long)agenda.getFocus().size());
        Assert.assertEquals((long)0L, (long)agenda.agendaSize());
    }

    @Test
    public void testNullErrorOnGetScheduledActivations() {
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)this.ruleBase.newStatefulSession();
        try {
            ((DefaultAgenda)workingMemory.getAgenda()).getScheduledActivations();
        }
        catch (NullPointerException e) {
            Assert.fail((String)"Exception Should not have been thrown");
        }
    }
}

