/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.drools.core.spi.Activation;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.LongQueueable;
import org.drools.core.util.NaturalComparator;
import org.drools.core.util.Queue;
import org.junit.Test;

public class BinaryHeapPriorityQueueTest {
    @Test
    public void testOptimised() {
        Random random = new Random();
        LinkedList<LongQueueable> items = new LinkedList<LongQueueable>();
        BinaryHeapQueue queue = new BinaryHeapQueue((Comparator)NaturalComparator.INSTANCE, 100000);
        for (int i = 0; i < 100000; ++i) {
            items.add(new LongQueueable((Queue)queue, random.nextLong()));
        }
        long startEnqueue = System.currentTimeMillis();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            queue.enqueue((Activation)i.next());
        }
        long elapsedEnqueue = System.currentTimeMillis() - startEnqueue;
        long startDequeue = System.currentTimeMillis();
        Iterator i2 = items.iterator();
        while (i2.hasNext()) {
            ((Activation)i2.next()).dequeue();
        }
        long elapsedDequeue = System.currentTimeMillis() - startDequeue;
    }

    @Test
    public void testBasic() {
        Random random = new Random();
        LinkedList<LongQueueable> items = new LinkedList<LongQueueable>();
        BinaryHeapQueue queue = new BinaryHeapQueue((Comparator)NaturalComparator.INSTANCE, 100000);
        for (int i = 0; i < 100000; ++i) {
            items.add(new LongQueueable((Queue)queue, random.nextLong()));
        }
        long startEnqueue = System.currentTimeMillis();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            queue.enqueue((Activation)i.next());
        }
        long elapsedEnqueue = System.currentTimeMillis() - startEnqueue;
        long startDequeue = System.currentTimeMillis();
        Iterator i2 = items.iterator();
        while (i2.hasNext()) {
            queue.enqueue((Activation)i2.next());
        }
        long elapsedDequeue = System.currentTimeMillis() - startDequeue;
    }
}

