/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.core.RuleBaseFactory;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.test.ReteDslTestEngine;
import org.drools.core.reteoo.test.dsl.DslStep;
import org.drools.core.reteoo.test.dsl.NodeTestCase;
import org.drools.core.reteoo.test.dsl.NodeTestCaseResult;
import org.drools.core.reteoo.test.dsl.NodeTestDef;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.Person;
import org.drools.core.util.index.LeftTupleList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.notification.RunNotifier;

@Ignore(value="phreak")
public class ReteDslTestEngineTest {
    @Test
    public void testDslCommandBuilder() {
        InputStream stream = this.getClass().getResourceAsStream("DslTestBuilder.testCase");
        Assert.assertNotNull((Object)stream);
        NodeTestCase test = null;
        try {
            test = ReteDslTestEngine.compile(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unexpected Exception: " + e.getMessage()));
        }
        Assert.assertEquals((Object)"Test Case Name", (Object)test.getName());
        this.checkSetup(test);
        Assert.assertEquals((long)0L, (long)test.getTearDown().size());
        List<NodeTestDef> tests = test.getTests();
        Assert.assertEquals((long)2L, (long)tests.size());
        NodeTestDef test1 = tests.get(0);
        Assert.assertEquals((Object)"test 1", (Object)test1.getName());
        Assert.assertEquals((long)22L, (long)test1.getLine());
        DslStep[] steps = test1.getSteps().toArray(new DslStep[0]);
        Assert.assertEquals((long)6L, (long)steps.length);
        int step = 0;
        Assert.assertEquals((Object)"assert", (Object)steps[step].getName());
        Assert.assertEquals((long)1L, (long)steps[step].getCommands().size());
        this.checkCommand(new String[]{"left", "[h0]"}, steps[step].getCommands().get(0));
        step = 1;
        Assert.assertEquals((Object)"col", (Object)steps[step].getName());
        Assert.assertEquals((long)1L, (long)steps[step].getCommands().size());
        this.checkCommand(new String[]{"leftMemory", "[[h0]]"}, steps[step].getCommands().get(0));
        step = 2;
        Assert.assertEquals((Object)"sink", (Object)steps[step].getName());
        Assert.assertEquals((long)2L, (long)steps[step].getCommands().size());
        this.checkCommand(new String[]{"verify", "assert", "count", "1"}, steps[step].getCommands().get(0));
        this.checkCommand(new String[]{"verify", "assert", "tuple0[1]", "is(empty())"}, steps[step].getCommands().get(1));
        test1 = tests.get(1);
        Assert.assertEquals((Object)"another test", (Object)test1.getName());
        Assert.assertEquals((long)38L, (long)test1.getLine());
        steps = test1.getSteps().toArray(new DslStep[0]);
        Assert.assertEquals((long)3L, (long)steps.length);
        step = 0;
        Assert.assertEquals((Object)"assert", (Object)steps[step].getName());
        Assert.assertEquals((long)1L, (long)steps[step].getCommands().size());
        this.checkCommand(new String[]{"left", "[h2]"}, steps[step].getCommands().get(0));
        step = 1;
        Assert.assertEquals((Object)"col", (Object)steps[step].getName());
        Assert.assertEquals((long)1L, (long)steps[step].getCommands().size());
        this.checkCommand(new String[]{"leftMemory", "[[h2]]"}, steps[step].getCommands().get(0));
    }

    private void checkCommand(String[] expected, String[] actual) {
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)actual[i]);
        }
    }

    private void checkSetup(NodeTestCase test) {
        DslStep[] steps = test.getSetup().toArray(new DslStep[0]);
        Assert.assertEquals((long)6L, (long)steps.length);
        int step = 0;
        Assert.assertEquals((Object)"LeftTupleSource", (Object)steps[step].getName());
        Assert.assertEquals((long)7L, (long)steps[step].getLine());
        Assert.assertEquals((long)1L, (long)steps[step].getCommands().size());
        Assert.assertEquals((long)1L, (long)steps[step].getCommands().get(0).length);
        Assert.assertEquals((Object)"left", (Object)steps[step].getCommands().get(0)[0]);
        step = 1;
        Assert.assertEquals((Object)"ObjectSource", (Object)steps[step].getName());
        Assert.assertEquals((long)8L, (long)steps[step].getLine());
        Assert.assertEquals((long)1L, (long)steps[step].getCommands().size());
        Assert.assertEquals((long)1L, (long)steps[step].getCommands().get(0).length);
        Assert.assertEquals((Object)"right", (Object)steps[step].getCommands().get(0)[0]);
        step = 2;
        Assert.assertEquals((Object)"LeftTupleSink", (Object)steps[step].getName());
        Assert.assertEquals((long)9L, (long)steps[step].getLine());
        Assert.assertEquals((long)1L, (long)steps[step].getCommands().size());
        Assert.assertEquals((long)1L, (long)steps[step].getCommands().get(0).length);
        Assert.assertEquals((Object)"sink", (Object)steps[step].getCommands().get(0)[0]);
        step = 3;
        Assert.assertEquals((Object)"CollectNode", (Object)steps[step].getName());
        Assert.assertEquals((long)10L, (long)steps[step].getLine());
        Assert.assertEquals((long)2L, (long)steps[step].getCommands().size());
        Assert.assertEquals((long)4L, (long)steps[step].getCommands().get(0).length);
        Assert.assertEquals((Object)"col", (Object)steps[step].getCommands().get(0)[0]);
        Assert.assertEquals((Object)"left", (Object)steps[step].getCommands().get(0)[1]);
        Assert.assertEquals((Object)"right", (Object)steps[step].getCommands().get(0)[2]);
        Assert.assertEquals((Object)"java.util.ArrayList", (Object)steps[step].getCommands().get(0)[3]);
        Assert.assertEquals((long)4L, (long)steps[step].getCommands().get(1).length);
        Assert.assertEquals((Object)"source", (Object)steps[step].getCommands().get(1)[0]);
        Assert.assertEquals((Object)"type", (Object)steps[step].getCommands().get(1)[1]);
        Assert.assertEquals((Object)"==", (Object)steps[step].getCommands().get(1)[2]);
        Assert.assertEquals((Object)"l1", (Object)steps[step].getCommands().get(1)[3]);
        step = 4;
        Assert.assertEquals((Object)"Binding", (Object)steps[step].getName());
        Assert.assertEquals((long)13L, (long)steps[step].getLine());
        Assert.assertEquals((long)1L, (long)steps[step].getCommands().size());
        Assert.assertEquals((long)4L, (long)steps[step].getCommands().get(0).length);
        Assert.assertEquals((Object)"l1", (Object)steps[step].getCommands().get(0)[0]);
        Assert.assertEquals((Object)"0", (Object)steps[step].getCommands().get(0)[1]);
        Assert.assertEquals((Object)"Person", (Object)steps[step].getCommands().get(0)[2]);
        Assert.assertEquals((Object)"likes", (Object)steps[step].getCommands().get(0)[3]);
        step = 5;
        Assert.assertEquals((Object)"Facts", (Object)steps[step].getName());
        Assert.assertEquals((long)15L, (long)steps[step].getLine());
        Assert.assertEquals((long)1L, (long)steps[step].getCommands().size());
        Assert.assertEquals((long)6L, (long)steps[step].getCommands().get(0).length);
        Assert.assertEquals((Object)"Person('darth', 35, \"brie\")", (Object)steps[step].getCommands().get(0)[0]);
        Assert.assertEquals((Object)"Cheese('brie', 12)", (Object)steps[step].getCommands().get(0)[3]);
    }

    @Test
    public void testObjectTypeNodeStep() throws Exception {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode :\n";
        str = str + "otn1, java.lang.Integer;\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        ObjectTypeNode otn1 = (ObjectTypeNode)result.context.get("otn1");
        Assert.assertNotNull((Object)otn1);
        Assert.assertEquals((Object)new ClassObjectType(Integer.class), (Object)otn1.getObjectType());
    }

    @Test
    public void testLeftInputAdapterNodeStep() throws Exception {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        ObjectTypeNode otn1 = (ObjectTypeNode)result.context.get("otn1");
        LeftInputAdapterNode lian0 = (LeftInputAdapterNode)result.context.get("lian0");
        Assert.assertNotNull((Object)lian0);
        Assert.assertSame((Object)lian0, (Object)otn1.getSinkPropagator().getSinks()[0]);
    }

    @Test
    public void testBindingStep() throws Exception {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Declaration p1 = (Declaration)result.context.get("p1");
        Assert.assertNotNull((Object)p1);
    }

    @Test
    public void testJoinNodeStep() throws Exception {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    intValue, !=, p1;\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        JoinNode join1 = (JoinNode)map.get("join1");
        Assert.assertNotNull((Object)join1);
        ReteooRuleBase rbase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        PropagationContextFactory pctxFactory = rbase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        PropagationContext context = pctxFactory.createPropagationContext(0L, 0, null, null, null);
        AbstractWorkingMemory workingMemory = new AbstractWorkingMemory(1, (InternalRuleBase)rbase);
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((MemoryFactory)join1);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)0);
        LeftTupleImpl tuple0 = new LeftTupleImpl((InternalFactHandle)f0, (LeftTupleSink)join1, true);
        join1.assertLeftTuple((LeftTuple)tuple0, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)1L, (long)memory.getLeftTupleMemory().size());
        Assert.assertEquals((long)0L, (long)memory.getRightTupleMemory().size());
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)0);
        LeftTupleImpl tuple1 = new LeftTupleImpl((InternalFactHandle)f1, (LeftTupleSink)join1, true);
        join1.assertLeftTuple((LeftTuple)tuple1, context, (InternalWorkingMemory)workingMemory);
        Assert.assertEquals((long)2L, (long)memory.getLeftTupleMemory().size());
        LeftTuple leftTuple = ((LeftTupleList)memory.getLeftTupleMemory()).getFirst();
        Assert.assertEquals((Object)tuple0, (Object)leftTuple);
        Assert.assertEquals((Object)tuple1, (Object)leftTuple.getNext());
    }

    @Test
    public void testFactsStep() throws Exception {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "Facts:\n";
        str = str + "    1, 2, 'hello',\n";
        str = str + "    'good bye', new java.util.ArrayList();\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        WorkingMemory wm = (WorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        Assert.assertNotNull((Object)wm);
        Assert.assertNotNull((Object)handles);
        Assert.assertEquals((long)5L, (long)handles.size());
        Assert.assertEquals((Object)1, (Object)((InternalFactHandle)handles.get(0)).getObject());
        Assert.assertEquals((Object)2, (Object)((InternalFactHandle)handles.get(1)).getObject());
        Assert.assertEquals((Object)"hello", (Object)((InternalFactHandle)handles.get(2)).getObject());
        Assert.assertEquals((Object)"good bye", (Object)((InternalFactHandle)handles.get(3)).getObject());
        Assert.assertEquals(new ArrayList(), (Object)((InternalFactHandle)handles.get(4)).getObject());
    }

    @Test
    public void testWithStep() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "Facts:\n";
        str = str + "    1, 2, new org.drools.core.test.model.Person('darth', 35),\n";
        str = str + "    'good bye', new java.util.ArrayList();\n";
        str = str + "With:\n";
        str = str + "    h2, age = 36, city = 'la',\n";
        str = str + "       state = 'ca';\n";
        str = str + "    h4, add( 2 );\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        WorkingMemory wm = (WorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        Assert.assertNotNull((Object)wm);
        Assert.assertNotNull((Object)handles);
        Assert.assertEquals((long)5L, (long)handles.size());
        Person p = new Person("darth", 36);
        p.setAge(36);
        p.setCity("la");
        p.setState("ca");
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(2);
        Assert.assertEquals((Object)1, (Object)((InternalFactHandle)handles.get(0)).getObject());
        Assert.assertEquals((Object)2, (Object)((InternalFactHandle)handles.get(1)).getObject());
        Assert.assertEquals((Object)p, (Object)((InternalFactHandle)handles.get(2)).getObject());
        Assert.assertEquals((Object)"good bye", (Object)((InternalFactHandle)handles.get(3)).getObject());
        Assert.assertEquals(list, (Object)((InternalFactHandle)handles.get(4)).getObject());
    }

    @Test
    public void testBetaNodeAssertOperations() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    intValue, !=, p1;\n";
        str = str + "Facts:\n";
        str = str + "    0, 1, 2, 3;\n";
        str = str + "assert:\n";
        str = str + "    otn2,[h0, h2];\n";
        str = str + "    otn1,[h1, h3];\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        InternalWorkingMemory wm = (InternalWorkingMemory)map.get("WorkingMemory");
        JoinNode join1 = (JoinNode)map.get("join1");
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((MemoryFactory)join1);
        Assert.assertEquals((long)2L, (long)memory.getRightTupleMemory().size());
        Assert.assertEquals((long)2L, (long)memory.getLeftTupleMemory().size());
    }

    @Test
    public void testBetaNodeRetractOperations() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    intValue, !=, p1;\n";
        str = str + "Facts:\n";
        str = str + "    0, 1, 2, 3;\n";
        str = str + "assert:\n";
        str = str + "    otn1,[h1, h3];\n";
        str = str + "    otn2,[h0, h2];\n";
        str = str + "retract:\n";
        str = str + "    otn1,[h1];\n";
        str = str + "    otn2,[h2];\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        InternalWorkingMemory wm = (InternalWorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        JoinNode join1 = (JoinNode)map.get("join1");
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((MemoryFactory)join1);
        Assert.assertEquals((long)1L, (long)memory.getRightTupleMemory().size());
        Assert.assertEquals((long)1L, (long)memory.getLeftTupleMemory().size());
    }

    @Test
    public void testBetaNodeSimpleMemoryChecks() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    intValue, !=, p1;\n";
        str = str + "Facts:\n";
        str = str + "    0, 1, 2, 3;\n";
        str = str + "assert:\n";
        str = str + "    otn1,[h1, h3];\n";
        str = str + "    otn2,[h0, h2];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory,[[h1], [h3]];\n";
        str = str + "    rightMemory,[h0, h2];\n";
        str = str + "retract:\n";
        str = str + "    otn1,[h1];\n";
        str = str + "    otn2,[h2];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory,[ [h3] ];\n";
        str = str + "    rightMemory,[h0];\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        InternalWorkingMemory wm = (InternalWorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        JoinNode join1 = (JoinNode)map.get("join1");
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((MemoryFactory)join1);
        Assert.assertEquals((long)1L, (long)memory.getRightTupleMemory().size());
        Assert.assertEquals((long)1L, (long)memory.getLeftTupleMemory().size());
    }

    @Test
    public void testBetaNodeChainedMemoryChecks() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn3, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    intValue, !=, p1;\n";
        str = str + "JoinNode:\n";
        str = str + "    join2, join1, otn3;\n";
        str = str + "    intValue, !=, p1;\n";
        str = str + "Facts:\n";
        str = str + "    0, 1, 2, 3, 4;\n";
        str = str + "assert:\n";
        str = str + "    otn1, [h1, h3];\n";
        str = str + "    otn2, [h0, h2];\n";
        str = str + "    otn3, [h4];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory, [[h1], [h3]];\n";
        str = str + "    rightMemory, [h0, h2];\n";
        str = str + "join2:\n";
        str = str + "    leftMemory, [[h1, h0], [h3, h0],\n";
        str = str + "                [h1, h2], [h3, h2]];\n";
        str = str + "    rightMemory, [h4];\n";
        str = str + "retract:\n";
        str = str + "    otn1, [h1];\n";
        str = str + "    otn2, [h2];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory, [ [h3] ];\n";
        str = str + "    rightMemory, [h0];\n";
        str = str + "join2:\n";
        str = str + "    leftMemory,  [[h3, h0]];\n";
        str = str + "    rightMemory, [h4];\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        InternalWorkingMemory wm = (InternalWorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        JoinNode join1 = (JoinNode)map.get("join1");
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((MemoryFactory)join1);
        Assert.assertEquals((long)1L, (long)memory.getRightTupleMemory().size());
        Assert.assertEquals((long)1L, (long)memory.getLeftTupleMemory().size());
    }

    @Test
    public void testBetaNodeChainedMemoryWithIndexChecks() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn3, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    intValue, ==, p1;\n";
        str = str + "JoinNode:\n";
        str = str + "    join2, join1, otn3;\n";
        str = str + "    intValue, ==, p1;\n";
        str = str + "Facts:\n";
        str = str + "    new Integer(0), new Integer(0), new Integer(0), 2, 4;\n";
        str = str + "assert:\n";
        str = str + "    otn1, [h1, h3];\n";
        str = str + "    otn2, [h0, h2];\n";
        str = str + "    otn3, [h4];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory, [[h1]];\n";
        str = str + "    leftMemory, [[h3]];\n";
        str = str + "    rightMemory, [h0, h2];\n";
        str = str + "join2:\n";
        str = str + "    leftMemory, [[h1, h0],\n";
        str = str + "                [h1, h2]];\n";
        str = str + "    rightMemory, [h4];\n";
        str = str + "retract:\n";
        str = str + "    otn1, [h2];\n";
        str = str + "    otn2, [h3];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory, [ [h1] ];\n";
        str = str + "    rightMemory, [h0];\n";
        str = str + "join2:\n";
        str = str + "    leftMemory,  [[h1, h0]];\n";
        str = str + "    rightMemory, [h4];\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        InternalWorkingMemory wm = (InternalWorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        JoinNode join1 = (JoinNode)map.get("join1");
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((MemoryFactory)join1);
        Assert.assertEquals((long)1L, (long)memory.getRightTupleMemory().size());
        Assert.assertEquals((long)1L, (long)memory.getLeftTupleMemory().size());
    }

    @Test
    public void testBetaNodeModifyOperations() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, org.drools.core.test.model.Person;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, org.drools.core.test.model.Person;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn3, org.drools.core.test.model.Person;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, org.drools.core.test.model.Person, age;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    age, ==, p1;\n";
        str = str + "JoinNode:\n";
        str = str + "    join2, join1, otn3;\n";
        str = str + "    age, ==, p1;\n";
        str = str + "Facts:\n";
        str = str + "    new org.drools.core.test.model.Person('darth', 35), new org.drools.core.test.model.Person('bobba', 35),\n";
        str = str + "    new org.drools.core.test.model.Person('yoda', 35), new org.drools.core.test.model.Person('luke', 35),\n";
        str = str + "    new org.drools.core.test.model.Person('dave', 36);\n";
        str = str + "assert:\n";
        str = str + "    otn1, [h1, h3, h4];\n";
        str = str + "    otn2, [h0, h2];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory, [[h1], [h3]];\n";
        str = str + "    leftMemory, [[h4]];\n";
        str = str + "    rightMemory, [h0, h2];\n";
        str = str + "join2:\n";
        str = str + "    leftMemory, [[h1, h0], [h3, h0],\n";
        str = str + "                [h1, h2], [h3, h2]];\n";
        str = str + "    rightMemory, [];\n";
        str = str + "With:\n";
        str = str + "    h1, age = 36;\n";
        str = str + "modify:\n";
        str = str + "    otn1, [h1];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory, [[h3]];\n";
        str = str + "    leftMemory, [[h4], [h1]];\n";
        str = str + "    rightMemory, [h0, h2];\n";
        str = str + "join2:\n";
        str = str + "    leftMemory, [[h3, h0],\n";
        str = str + "                [h3, h2]];\n";
        str = str + "    rightMemory, [];\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        InternalWorkingMemory wm = (InternalWorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        JoinNode join1 = (JoinNode)map.get("join1");
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((MemoryFactory)join1);
        Assert.assertEquals((long)2L, (long)memory.getRightTupleMemory().size());
        Assert.assertEquals((long)3L, (long)memory.getLeftTupleMemory().size());
        JoinNode join2 = (JoinNode)map.get("join2");
        memory = (BetaMemory)wm.getNodeMemory((MemoryFactory)join2);
        Assert.assertEquals((long)0L, (long)memory.getRightTupleMemory().size());
        Assert.assertEquals((long)2L, (long)memory.getLeftTupleMemory().size());
    }

    @Test
    public void testNotNodeStep() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn0, org.drools.core.test.model.Person;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn0;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, org.drools.core.test.model.Person;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, org.drools.core.test.model.Person, age;\n";
        str = str + "NotNode:\n";
        str = str + "    not0, lian0, otn1;\n";
        str = str + "    age, !=, p1;\n";
        str = str + "LeftTupleSink:\n";
        str = str + "    sink, not0;\n";
        str = str + "Facts:\n";
        str = str + "    new org.drools.core.test.model.Person('darth', 35), new org.drools.core.test.model.Person('bobba', 35);\n";
        str = str + "assert:\n";
        str = str + "    otn0, [h0];\n";
        str = str + "    otn1, [h1];\n";
        str = str + "sink:\n";
        str = str + "    verify, assertLeft, count, 1;\n";
        str = str + "With:\n";
        str = str + "    h1, age = 36;\n";
        str = str + "modify:\n";
        str = str + "    otn1, [h1];\n";
        str = str + "sink:\n";
        str = str + "    verify, retractLeft, count, 1;\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
    }

    public void testConfigOptions() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "Config:\n";
        str = str + "    drools.phreakEnabled, true;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        BuildContext buildCtx = (BuildContext)map.get("BuildContext");
        Assert.assertTrue((boolean)buildCtx.getRuleBase().getConfiguration().isPhreakEnabled());
    }

    private void print(DslStep[] steps) {
        for (DslStep command : steps) {
            System.out.println(command);
        }
    }

    private NodeTestCaseResult.NodeTestResult executeTest(String str) throws IOException {
        NodeTestCase testCase = ReteDslTestEngine.compile(str);
        if (testCase.hasErrors()) {
            Assert.fail((String)testCase.getErrors().toString());
        }
        ReteDslTestEngine tester = new ReteDslTestEngine();
        NodeTestCaseResult testCaseResult = tester.run(testCase, (RunNotifier)null);
        NodeTestCaseResult.NodeTestResult result = testCaseResult.getResults().get(0);
        if (result.result != NodeTestCaseResult.Result.SUCCESS) {
            Assert.fail((String)result.getMessages());
        }
        return result;
    }
}

