/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.FactHandle;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseFactory;
import org.drools.core.StatefulSession;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.builder.NodeFactory;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.GlobalResolver;
import org.drools.core.test.model.Cheese;
import org.drools.core.test.model.Person;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ReteooWorkingMemoryTest {
    @Test
    public void testBasicWorkingMemoryActions() {
        AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)RuleBaseFactory.newRuleBase().newStatefulSession();
        TruthMaintenanceSystem tms = ((NamedEntryPoint)workingMemory.getWorkingMemoryEntryPoint(EntryPointId.DEFAULT.getEntryPointId())).getTruthMaintenanceSystem();
        String string = "test";
        workingMemory.insert((Object)"test");
        FactHandle fd = workingMemory.insertLogical((Object)"test");
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        EqualityKey key = tms.get((Object)"test");
        Assert.assertSame((Object)fd, (Object)key.getFactHandle());
        Assert.assertEquals((long)1L, (long)key.size());
        workingMemory.update((org.kie.api.runtime.rule.FactHandle)fd, (Object)"test");
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        key = tms.get((Object)"test");
        Assert.assertSame((Object)fd, (Object)key.getFactHandle());
        Assert.assertEquals((long)1L, (long)key.size());
        workingMemory.retract((org.kie.api.runtime.rule.FactHandle)fd);
        Assert.assertEquals((long)0L, (long)tms.getEqualityKeyMap().size());
        key = tms.get((Object)"test");
        Assert.assertNull((Object)key);
        fd = workingMemory.insert((Object)"test");
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        Assert.assertEquals((long)1L, (long)tms.getEqualityKeyMap().size());
        key = tms.get((Object)"test");
        Assert.assertSame((Object)fd, (Object)key.getFactHandle());
        Assert.assertEquals((long)1L, (long)key.size());
    }

    @Test
    public void testId() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        Assert.assertEquals((long)0L, (long)workingMemory.getId());
        workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        Assert.assertEquals((long)1L, (long)workingMemory.getId());
    }

    @Test
    public void testGlobalResolver() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("global1", "value1");
        map.put("global2", "value2");
        MapGlobalResolver resolver = new MapGlobalResolver(map);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)ruleBase.newStatefulSession();
        workingMemory.setGlobalResolver((GlobalResolver)resolver);
        Assert.assertEquals((Object)"value1", (Object)workingMemory.getGlobal("global1"));
        Assert.assertEquals((Object)"value2", (Object)workingMemory.getGlobal("global2"));
    }

    @Test
    public void testObjectIterator() {
        Object object;
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        StatefulSession session = ruleBase.newStatefulSession();
        session.insert((Object)new Person("bob", 35));
        session.insert((Object)new Cheese("stilton", 35));
        session.insert((Object)new Cheese("brie", 35));
        session.insert((Object)new Person("steve", 55));
        session.insert((Object)new Person("tom", 100));
        int i = 0;
        Iterator it = session.iterateFactHandles();
        while (it.hasNext()) {
            object = it.next();
            if (i++ <= 5) continue;
            Assert.fail((String)"should not iterate for than 3 times");
        }
        i = 0;
        it = session.iterateObjects();
        while (it.hasNext()) {
            object = it.next();
            if (i++ <= 5) continue;
            Assert.fail((String)"should not iterate for than 3 times");
        }
    }

    @Test
    public void testExecuteQueueActions() {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        AbstractWorkingMemory wm = (AbstractWorkingMemory)ruleBase.newStatefulSession();
        ReentrantAction action = new ReentrantAction();
        wm.queueWorkingMemoryAction((WorkingMemoryAction)action);
        wm.executeQueuedActions();
        Assert.assertEquals((long)2L, (long)action.counter.get());
    }

    @Test
    public void testDifferentEntryPointsOnSameFact() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        ReteooRuleBase rbase = (ReteooRuleBase)((KnowledgeBaseImpl)kbase).getRuleBase();
        Rete rete = rbase.getRete();
        NodeFactory nFacotry = rbase.getConfiguration().getComponentFactory().getNodeFactoryService();
        EntryPointNode epn = nFacotry.buildEntryPointNode(rbase.getReteooBuilder().getIdGenerator().getNextId(), RuleBasePartitionId.MAIN_PARTITION, rbase.getConfiguration().isMultithreadEvaluation(), (ObjectSource)rete, new EntryPointId("xxx"));
        rbase.getRete().addObjectSink((ObjectSink)epn);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        org.kie.api.runtime.rule.FactHandle f1 = ksession.insert((Object)"f1");
        EntryPoint ep = ksession.getEntryPoint("xxx");
        try {
            ep.update(f1, (Object)"s1");
            Assert.fail((String)"Should throw an exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ep.retract(f1);
            Assert.fail((String)"Should throw an exception");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        ksession.update(f1, (Object)"s1");
        Assert.assertNotNull((Object)ksession.getObject(f1));
        ksession.retract(f1);
        ksession.retract(f1);
        Assert.assertNull((Object)ksession.getObject(f1));
    }

    private static class FinalAction
    extends ReentrantAction {
        public AtomicInteger counter;

        public FinalAction(AtomicInteger counter) {
            this.counter = counter;
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            this.counter.incrementAndGet();
            workingMemory.executeQueuedActions();
            workingMemory.executeQueuedActions();
        }
    }

    private static class ReentrantAction
    implements WorkingMemoryAction {
        public AtomicInteger counter = new AtomicInteger(0);

        private ReentrantAction() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void write(MarshallerWriteContext context) {
            throw new IllegalStateException("this method should never be called");
        }

        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            throw new IllegalStateException("this method should never be called");
        }

        public void execute(InternalWorkingMemory workingMemory) {
            Assert.assertEquals((long)0L, (long)this.counter.get());
            workingMemory.queueWorkingMemoryAction((WorkingMemoryAction)new FinalAction(this.counter));
            Assert.assertEquals((long)0L, (long)this.counter.get());
            workingMemory.queueWorkingMemoryAction((WorkingMemoryAction)new FinalAction(this.counter));
            Assert.assertEquals((long)0L, (long)this.counter.get());
            workingMemory.executeQueuedActions();
            Assert.assertEquals((long)0L, (long)this.counter.get());
            workingMemory.executeQueuedActions();
            Assert.assertEquals((long)0L, (long)this.counter.get());
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }
    }
}

