/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event.rule;

import java.util.ArrayList;
import org.drools.core.test.model.Cheese;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.WorkingMemoryEventListener;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class WorkingMemoryEventSupportTest {
    @Test
    public void testAddRuleRuntimeEventListener() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        final ArrayList wmList = new ArrayList();
        WorkingMemoryEventListener eventListener = new WorkingMemoryEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                wmList.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                wmList.add(event);
            }

            public void objectDeleted(ObjectDeletedEvent event) {
                wmList.add(event);
            }
        };
        ksession.addEventListener(eventListener);
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 17);
        FactHandle stiltonHandle = ksession.insert((Object)stilton);
        ObjectInsertedEvent oae = (ObjectInsertedEvent)wmList.get(0);
        Assert.assertSame((Object)stiltonHandle, (Object)oae.getFactHandle());
        ksession.update(stiltonHandle, (Object)stilton);
        ObjectUpdatedEvent ome = (ObjectUpdatedEvent)wmList.get(1);
        Assert.assertSame((Object)stiltonHandle, (Object)ome.getFactHandle());
        ksession.retract(stiltonHandle);
        ObjectDeletedEvent ore = (ObjectDeletedEvent)wmList.get(2);
        Assert.assertSame((Object)stiltonHandle, (Object)ore.getFactHandle());
        ksession.insert((Object)cheddar);
    }

    @Test
    public void testRemoveRuleRuntimeEventListener() {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        final ArrayList wmList = new ArrayList();
        WorkingMemoryEventListener eventListener = new WorkingMemoryEventListener(){

            public void objectInserted(ObjectInsertedEvent event) {
                wmList.add(event);
            }

            public void objectUpdated(ObjectUpdatedEvent event) {
                wmList.add(event);
            }

            public void objectDeleted(ObjectDeletedEvent event) {
                wmList.add(event);
            }
        };
        ksession.addEventListener(eventListener);
        ksession.removeEventListener(eventListener);
        Cheese stilton = new Cheese("stilton", 15);
        Cheese cheddar = new Cheese("cheddar", 17);
        FactHandle stiltonHandle = ksession.insert((Object)stilton);
        Assert.assertTrue((boolean)wmList.isEmpty());
        ksession.update(stiltonHandle, (Object)stilton);
        Assert.assertTrue((boolean)wmList.isEmpty());
        ksession.retract(stiltonHandle);
        Assert.assertTrue((boolean)wmList.isEmpty());
        ksession.insert((Object)cheddar);
        Assert.assertTrue((boolean)wmList.isEmpty());
    }
}

