/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.RuleBaseFactory;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ValueType;
import org.drools.core.base.field.LongFieldImpl;
import org.drools.core.base.field.ObjectFieldImpl;
import org.drools.core.common.DisconnectedWorkingMemoryEntryPoint;
import org.drools.core.common.EmptyBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MockObjectSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.NodeSet;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.ReteooFactHandleFactory;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.MvelConstraintTestUtil;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.PropagationContext;
import org.drools.core.test.model.Cheese;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.rule.EntryPoint;

public class CompositeObjectSinkAdapterTest {
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    public int la;
    public int blah;

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
    }

    @Test
    public void testBeta() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        MockBetaNode beta = new MockBetaNode(this.buildContext.getNextId(), (LeftTupleSource)new MockBetaNode(), new MockObjectSource(), this.buildContext);
        ad.addObjectSink((ObjectSink)beta);
        Assert.assertEquals((long)1L, (long)ad.getSinks().length);
        Assert.assertEquals((Object)((Object)beta), (Object)ad.getSinks()[0]);
        Assert.assertEquals((long)1L, (long)ad.otherSinks.size());
        Assert.assertEquals((Object)((Object)beta), (Object)ad.otherSinks.getFirst());
        Assert.assertNull((Object)ad.hashableSinks);
        Assert.assertNull((Object)ad.hashedFieldIndexes);
        Assert.assertNull((Object)ad.hashedSinkMap);
        ad.removeObjectSink((ObjectSink)beta);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertEquals((long)0L, (long)ad.getSinks().length);
    }

    @Test
    public void testAlphaWithPredicate() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)new PredicateConstraint(null, null), null, this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertEquals((long)1L, (long)ad.getSinks().length);
        Assert.assertEquals((long)1L, (long)ad.otherSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.otherSinks.getFirst());
        ad.removeObjectSink((ObjectSink)al);
        Assert.assertEquals((long)0L, (long)ad.getSinks().length);
        Assert.assertNull((Object)ad.otherSinks);
    }

    @Test
    public void testSingleAlpha() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        MvelConstraintTestUtil lit = new MvelConstraintTestUtil("type == \"stilton\"", (FieldValue)new ObjectFieldImpl((Object)"stilton"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(0), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertNotNull((Object)ad.hashedFieldIndexes);
        Assert.assertEquals((long)1L, (long)ad.hashableSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        ad.removeObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertNull((Object)ad.hashableSinks);
    }

    @Test
    public void testDoubleAlphaWithBeta() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        MvelConstraintTestUtil lit = new MvelConstraintTestUtil("type == \"stilton\"", (FieldValue)new ObjectFieldImpl((Object)"stilton"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(0), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertNotNull((Object)ad.hashedFieldIndexes);
        Assert.assertEquals((long)1L, (long)ad.hashableSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        MvelConstraintTestUtil lit2 = new MvelConstraintTestUtil("type == \"cheddar\"", (FieldValue)new ObjectFieldImpl((Object)"cheddar"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        Assert.assertEquals((Object)al2, (Object)ad.getSinks()[1]);
        MockBetaNode beta = new MockBetaNode(this.buildContext.getNextId(), (LeftTupleSource)new MockBetaNode(), new MockObjectSource(), this.buildContext);
        ad.addObjectSink((ObjectSink)beta);
        Assert.assertNotNull((Object)ad.otherSinks);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        Assert.assertEquals((long)1L, (long)ad.otherSinks.size());
        Assert.assertEquals((Object)((Object)beta), (Object)ad.otherSinks.getFirst());
        ad.removeObjectSink((ObjectSink)beta);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
    }

    @Test
    public void testTripleAlpha() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        MvelConstraintTestUtil lit = new MvelConstraintTestUtil("type == \"stilton\"", (FieldValue)new ObjectFieldImpl((Object)"stilton"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertNotNull((Object)ad.hashedFieldIndexes);
        Assert.assertEquals((long)1L, (long)ad.hashableSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        MvelConstraintTestUtil lit2 = new MvelConstraintTestUtil("type == \"cheddar\"", (FieldValue)new ObjectFieldImpl((Object)"cheddar"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.hashedSinkMap);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        MvelConstraintTestUtil lit3 = new MvelConstraintTestUtil("type == \"stinky\"", (FieldValue)new ObjectFieldImpl((Object)"stinky"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)ad.hashedSinkMap);
        Assert.assertNull((Object)ad.hashableSinks);
        ad.removeObjectSink((ObjectSink)al2);
        Assert.assertNotNull((Object)ad.hashableSinks);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        Assert.assertNull((Object)ad.hashedSinkMap);
    }

    @Test
    public void testTripleAlphaCharacterConstraint() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "charType", this.getClass().getClassLoader());
        MvelConstraintTestUtil lit = new MvelConstraintTestUtil("charType == 65", (FieldValue)new LongFieldImpl(65L), (InternalReadAccessor)extractor);
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertNotNull((Object)ad.hashedFieldIndexes);
        Assert.assertEquals((long)1L, (long)ad.hashableSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        MvelConstraintTestUtil lit2 = new MvelConstraintTestUtil("charType == 66", (FieldValue)new LongFieldImpl(66L), (InternalReadAccessor)extractor);
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.hashedSinkMap);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        MvelConstraintTestUtil lit3 = new MvelConstraintTestUtil("charType == 67", (FieldValue)new LongFieldImpl(67L), (InternalReadAccessor)extractor);
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)ad.hashedSinkMap);
        Assert.assertNull((Object)ad.hashableSinks);
        Cheese cheese = new Cheese();
        cheese.setCharType('B');
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        ObjectSink sink = (ObjectSink)ad.hashedSinkMap.get((Object)hashKey);
        Assert.assertSame((Object)al2, (Object)sink);
        cheese.setCharType('X');
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        sink = (ObjectSink)ad.hashedSinkMap.get((Object)hashKey);
        Assert.assertNull((Object)sink);
        ad.removeObjectSink((ObjectSink)al2);
        Assert.assertNotNull((Object)ad.hashableSinks);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        Assert.assertNull((Object)ad.hashedSinkMap);
    }

    @Test
    public void testTripleAlphaObjectCharacterConstraint() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "charObjectType", this.getClass().getClassLoader());
        MvelConstraintTestUtil lit = new MvelConstraintTestUtil("charObjectType == 65", (FieldValue)new LongFieldImpl(65L), (InternalReadAccessor)extractor);
        AlphaNode al = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al);
        Assert.assertNull((Object)ad.otherSinks);
        Assert.assertNotNull((Object)ad.hashedFieldIndexes);
        Assert.assertEquals((long)1L, (long)ad.hashableSinks.size());
        Assert.assertEquals((Object)al, (Object)ad.getSinks()[0]);
        MvelConstraintTestUtil lit2 = new MvelConstraintTestUtil("charObjectType == 66", (FieldValue)new LongFieldImpl(66L), (InternalReadAccessor)extractor);
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al2);
        Assert.assertNull((Object)ad.hashedSinkMap);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        MvelConstraintTestUtil lit3 = new MvelConstraintTestUtil("charObjectType == 67", (FieldValue)new LongFieldImpl(67L), (InternalReadAccessor)extractor);
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al3);
        Assert.assertNotNull((Object)ad.hashedSinkMap);
        Assert.assertNull((Object)ad.hashableSinks);
        Cheese cheese = new Cheese();
        cheese.setCharObjectType(Character.valueOf('B'));
        CompositeObjectSinkAdapter.HashKey hashKey = new CompositeObjectSinkAdapter.HashKey();
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        ObjectSink sink = (ObjectSink)ad.hashedSinkMap.get((Object)hashKey);
        Assert.assertSame((Object)al2, (Object)sink);
        cheese.setCharObjectType(Character.valueOf('X'));
        hashKey.setValue(extractor.getIndex(), (Object)cheese, (InternalReadAccessor)extractor);
        sink = (ObjectSink)ad.hashedSinkMap.get((Object)hashKey);
        Assert.assertNull((Object)sink);
        ad.removeObjectSink((ObjectSink)al2);
        Assert.assertNotNull((Object)ad.hashableSinks);
        Assert.assertEquals((long)2L, (long)ad.hashableSinks.size());
        Assert.assertNull((Object)ad.hashedSinkMap);
    }

    @Test
    public void testPropagationWithNullValue() {
        CompositeObjectSinkAdapter ad = new CompositeObjectSinkAdapter();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", this.getClass().getClassLoader());
        MvelConstraintTestUtil lit1 = new MvelConstraintTestUtil("type == \"stilton\"", (FieldValue)new ObjectFieldImpl((Object)"stilton"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al1 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit1, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        MvelConstraintTestUtil lit2 = new MvelConstraintTestUtil("type == \"brie\"", (FieldValue)new ObjectFieldImpl((Object)"brie"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al2 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit2, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        MvelConstraintTestUtil lit3 = new MvelConstraintTestUtil("type == \"muzzarela\"", (FieldValue)new ObjectFieldImpl((Object)"muzzarela"), (InternalReadAccessor)new MockExtractor());
        AlphaNode al3 = new AlphaNode(this.buildContext.getNextId(), (AlphaNodeFieldConstraint)lit3, (ObjectSource)new MockObjectSource(this.buildContext.getNextId()), this.buildContext);
        ad.addObjectSink((ObjectSink)al1);
        ad.addObjectSink((ObjectSink)al2);
        ad.addObjectSink((ObjectSink)al3);
        InternalFactHandle handle = new ReteooFactHandleFactory().newFactHandle((Object)new Cheese(), null, null, (EntryPoint)new DisconnectedWorkingMemoryEntryPoint("DEFAULT"));
        try {
            ad.propagateAssertObject(handle, null, null);
        }
        catch (RuntimeException e) {
            Assert.fail((String)("Not supposed to throw any exception: " + e.getMessage()));
        }
    }

    public static class MockBetaNode
    extends BetaNode {
        public MockBetaNode() {
        }

        protected void doCollectAncestors(NodeSet nodeSet) {
        }

        protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        }

        MockBetaNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BuildContext buildContext) {
            super(id, RuleBasePartitionId.MAIN_PARTITION, false, leftInput, rightInput, EmptyBetaConstraints.getInstance(), buildContext);
        }

        MockBetaNode(int id, LeftTupleSource leftInput, ObjectSource rightInput) {
            super(id, RuleBasePartitionId.MAIN_PARTITION, false, leftInput, rightInput, EmptyBetaConstraints.getInstance(), null);
        }

        public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void assertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void retractLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        }

        public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public short getType() {
            return 0;
        }

        public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(factHandle, sink, leftTupleMemoryEnabled);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(leftTuple, sink, pctx, leftTupleMemoryEnabled);
        }

        public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
            return new LeftTupleImpl(factHandle, leftTuple, sink);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
            return new LeftTupleImpl(leftTuple, rightTuple, sink);
        }

        public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
            return new LeftTupleImpl(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
        }

        public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
            return super.createMemory(config, wm);
        }

        public void assertRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        }

        public LeftTuple createPeer(LeftTuple original) {
            return null;
        }
    }

    public static class MockExtractor
    implements InternalReadAccessor {
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public int getIndex() {
            return 0;
        }

        public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
            return '\u0000';
        }

        public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0;
        }

        public Class getExtractToClass() {
            return null;
        }

        public String getExtractToClassName() {
            return null;
        }

        public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
            return 0.0f;
        }

        public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
            return 0L;
        }

        public Method getNativeReadMethod() {
            return null;
        }

        public String getNativeReadMethodName() {
            return null;
        }

        public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public Object getValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public boolean isNullValue(Object object, InternalWorkingMemory workingMemory) {
            return false;
        }

        public ValueType getValueType() {
            return ValueType.STRING_TYPE;
        }

        public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
            return false;
        }

        public boolean getBooleanValue(Object object) {
            return false;
        }

        public byte getByteValue(Object object) {
            return 0;
        }

        public char getCharValue(Object object) {
            return '\u0000';
        }

        public double getDoubleValue(Object object) {
            return 0.0;
        }

        public float getFloatValue(Object object) {
            return 0.0f;
        }

        public int getHashCode(Object object) {
            return 0;
        }

        public int getIntValue(Object object) {
            return 0;
        }

        public long getLongValue(Object object) {
            return 0L;
        }

        public short getShortValue(Object object) {
            return 0;
        }

        public Object getValue(Object object) {
            return null;
        }

        public boolean isNullValue(Object object) {
            return false;
        }

        public boolean isSelfReference() {
            return false;
        }

        public BigDecimal getBigDecimalValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public BigInteger getBigIntegerValue(InternalWorkingMemory workingMemory, Object object) {
            return null;
        }

        public BigDecimal getBigDecimalValue(Object object) {
            return null;
        }

        public BigInteger getBigIntegerValue(Object object) {
            return null;
        }
    }
}

