/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.drools.core.RuleBaseFactory;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.MockObjectSink;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.ObjectType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertyChangeListenerTest {
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;
    private EntryPointNode entryPoint;

    @Before
    public void setUp() throws Exception {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
        this.entryPoint = new EntryPointNode(0, (ObjectSource)this.ruleBase.getRete(), this.buildContext);
        this.entryPoint.attach(this.buildContext);
    }

    @Test
    public void test1() {
        AbstractWorkingMemory workingMemory = (AbstractWorkingMemory)this.ruleBase.newStatefulSession();
        ObjectTypeNode objectTypeNode = new ObjectTypeNode(1, this.entryPoint, (ObjectType)new ClassObjectType(State.class), this.buildContext);
        objectTypeNode.attach(this.buildContext);
        MockObjectSink sink = new MockObjectSink();
        objectTypeNode.addObjectSink((ObjectSink)sink);
        State a = new State("go");
        workingMemory.insert((Object)a, true);
        Assert.assertEquals((long)1L, (long)sink.getAsserted().size());
        a.setState("stop");
    }

    public static class State {
        private final PropertyChangeSupport changes = new PropertyChangeSupport(this);
        private String state;

        public State(String state) {
            this.state = state;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String newState) {
            String oldState = this.state;
            this.state = newState;
            this.changes.firePropertyChange("state", oldState, newState);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.changes.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.changes.removePropertyChangeListener(l);
        }
    }
}

