/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.drools.core.base.ClassObjectType;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.GroupElementFactory;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.InvalidRuleException;
import org.drools.core.rule.LogicTransformer;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.ObjectType;
import org.drools.core.test.model.DroolsTestCase;
import org.drools.core.util.DroolsStreamUtils;
import org.junit.Assert;
import org.junit.Test;

public class LogicTransformerTest
extends DroolsTestCase {
    @Test
    public void testSingleOrAndOrTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        GroupElement or = GroupElementFactory.newOrInstance();
        or.addChild((RuleConditionElement)a);
        or.addChild((RuleConditionElement)b);
        GroupElement parent = GroupElementFactory.newAndInstance();
        parent.addChild((RuleConditionElement)or);
        parent.addChild((RuleConditionElement)c);
        LogicTransformer.getInstance().applyOrTransformation(parent);
        this.assertLength(2, parent.getChildren());
        Assert.assertEquals(GroupElement.class, ((RuleConditionElement)parent.getChildren().get(0)).getClass());
        Assert.assertEquals(GroupElement.class, ((RuleConditionElement)parent.getChildren().get(1)).getClass());
        GroupElement and1 = (GroupElement)parent.getChildren().get(0);
        Assert.assertTrue((boolean)and1.isAnd());
        Assert.assertEquals((Object)a, and1.getChildren().get(0));
        Assert.assertEquals((Object)c, and1.getChildren().get(1));
        GroupElement and2 = (GroupElement)parent.getChildren().get(1);
        Assert.assertEquals((Object)b, and2.getChildren().get(0));
        Assert.assertEquals((Object)c, and2.getChildren().get(1));
    }

    @Test
    public void testMultipleOrAndOrTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        Pattern e = new Pattern(4, (ObjectType)type, "e");
        Pattern f = new Pattern(5, (ObjectType)type, "f");
        GroupElement parent = GroupElementFactory.newAndInstance();
        GroupElement or = GroupElementFactory.newOrInstance();
        or.addChild((RuleConditionElement)a);
        or.addChild((RuleConditionElement)b);
        parent.addChild((RuleConditionElement)or);
        parent.addChild((RuleConditionElement)c);
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)d);
        or2.addChild((RuleConditionElement)e);
        parent.addChild((RuleConditionElement)or2);
        GroupElement not = GroupElementFactory.newNotInstance();
        not.addChild((RuleConditionElement)f);
        parent.addChild((RuleConditionElement)not);
        LogicTransformer.getInstance().applyOrTransformation(parent);
        Assert.assertEquals((Object)GroupElement.Type.OR, (Object)parent.getType());
        this.assertLength(4, parent.getChildren());
        Assert.assertEquals(GroupElement.class, ((RuleConditionElement)parent.getChildren().get(0)).getClass());
        Assert.assertEquals(GroupElement.class, ((RuleConditionElement)parent.getChildren().get(1)).getClass());
        Assert.assertEquals(GroupElement.class, ((RuleConditionElement)parent.getChildren().get(2)).getClass());
        Assert.assertEquals(GroupElement.class, ((RuleConditionElement)parent.getChildren().get(3)).getClass());
        GroupElement and1 = (GroupElement)parent.getChildren().get(0);
        Assert.assertTrue((boolean)and1.isAnd());
        this.assertLength(4, and1.getChildren());
        Assert.assertEquals((Object)a, and1.getChildren().get(0));
        Assert.assertEquals((Object)c, and1.getChildren().get(1));
        Assert.assertEquals((Object)d, and1.getChildren().get(2));
        Assert.assertEquals((Object)not, and1.getChildren().get(3));
        and1 = (GroupElement)parent.getChildren().get(1);
        Assert.assertTrue((boolean)and1.isAnd());
        this.assertLength(4, and1.getChildren());
        Assert.assertEquals((Object)a, and1.getChildren().get(0));
        Assert.assertEquals((Object)c, and1.getChildren().get(1));
        Assert.assertEquals((Object)e, and1.getChildren().get(2));
        Assert.assertEquals((Object)not, and1.getChildren().get(3));
        and1 = (GroupElement)parent.getChildren().get(2);
        Assert.assertTrue((boolean)and1.isAnd());
        this.assertLength(4, and1.getChildren());
        Assert.assertEquals((Object)b, and1.getChildren().get(0));
        Assert.assertEquals((Object)c, and1.getChildren().get(1));
        Assert.assertEquals((Object)d, and1.getChildren().get(2));
        Assert.assertEquals((Object)not, and1.getChildren().get(3));
        and1 = (GroupElement)parent.getChildren().get(3);
        Assert.assertTrue((boolean)and1.isAnd());
        this.assertLength(4, and1.getChildren());
        Assert.assertEquals((Object)b, and1.getChildren().get(0));
        Assert.assertEquals((Object)c, and1.getChildren().get(1));
        Assert.assertEquals((Object)e, and1.getChildren().get(2));
        Assert.assertEquals((Object)not, and1.getChildren().get(3));
    }

    @Test
    public void testNotOrTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        GroupElement parent = GroupElementFactory.newNotInstance();
        GroupElement or = GroupElementFactory.newOrInstance();
        parent.addChild((RuleConditionElement)or);
        or.addChild((RuleConditionElement)a);
        or.addChild((RuleConditionElement)b);
        LogicTransformer.getInstance().applyOrTransformation(parent);
        Assert.assertTrue((boolean)parent.isAnd());
        Assert.assertEquals((long)2L, (long)parent.getChildren().size());
        GroupElement b1 = (GroupElement)parent.getChildren().get(0);
        GroupElement b2 = (GroupElement)parent.getChildren().get(1);
        Assert.assertTrue((boolean)b1.isNot());
        Assert.assertTrue((boolean)b2.isNot());
        Assert.assertEquals((long)1L, (long)b1.getChildren().size());
        Assert.assertEquals((Object)a, b1.getChildren().get(0));
        Assert.assertEquals((long)1L, (long)b2.getChildren().size());
        Assert.assertEquals((Object)b, b2.getChildren().get(0));
    }

    @Test
    public void testNotExistsTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        GroupElement not = GroupElementFactory.newNotInstance();
        GroupElement exists = GroupElementFactory.newExistsInstance();
        GroupElement and = GroupElementFactory.newAndInstance();
        not.addChild((RuleConditionElement)exists);
        exists.addChild((RuleConditionElement)and);
        and.addChild((RuleConditionElement)a);
        and.addChild((RuleConditionElement)b);
        GroupElement[] transformed = LogicTransformer.getInstance().transform(not);
        GroupElement wrapper = transformed[0];
        GroupElement notR = (GroupElement)wrapper.getChildren().get(0);
        Assert.assertTrue((boolean)notR.isNot());
        Assert.assertEquals((long)1L, (long)notR.getChildren().size());
        Assert.assertTrue((boolean)(notR.getChildren().get(0) instanceof GroupElement));
        GroupElement andR = (GroupElement)notR.getChildren().get(0);
        Assert.assertTrue((boolean)andR.isAnd());
        Assert.assertEquals((long)2L, (long)andR.getChildren().size());
        Assert.assertTrue((boolean)(andR.getChildren().get(0) instanceof Pattern));
        Assert.assertTrue((boolean)(andR.getChildren().get(1) instanceof Pattern));
        Pattern a1 = (Pattern)andR.getChildren().get(0);
        Pattern b1 = (Pattern)andR.getChildren().get(1);
        Assert.assertEquals((Object)a, (Object)a1);
        Assert.assertEquals((Object)b, (Object)b1);
    }

    @Test
    public void testExistOrTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        GroupElement parent = GroupElementFactory.newExistsInstance();
        GroupElement or = GroupElementFactory.newOrInstance();
        parent.addChild((RuleConditionElement)or);
        or.addChild((RuleConditionElement)a);
        or.addChild((RuleConditionElement)b);
        LogicTransformer.getInstance().applyOrTransformation(parent);
        Assert.assertTrue((boolean)parent.isOr());
        Assert.assertEquals((long)2L, (long)parent.getChildren().size());
        GroupElement b1 = (GroupElement)parent.getChildren().get(0);
        GroupElement b2 = (GroupElement)parent.getChildren().get(1);
        Assert.assertTrue((boolean)b1.isExists());
        Assert.assertTrue((boolean)b2.isExists());
        Assert.assertEquals((long)1L, (long)b1.getChildren().size());
        Assert.assertEquals((Object)a, b1.getChildren().get(0));
        Assert.assertEquals((long)1L, (long)b2.getChildren().size());
        Assert.assertEquals((Object)b, b2.getChildren().get(0));
    }

    @Test
    public void testEliminateEmptyBranchesAndDuplications() throws InvalidRuleException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)a);
        and1.addChild((RuleConditionElement)b);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)c);
        and2.addChild((RuleConditionElement)d);
        and1.addChild((RuleConditionElement)and2);
        GroupElement or = GroupElementFactory.newOrInstance();
        and1.addChild((RuleConditionElement)or);
        Object[] result = LogicTransformer.getInstance().transform(and1);
        this.assertLength(1, result);
        this.assertLength(4, result[0].getChildren());
        Assert.assertEquals((Object)a, result[0].getChildren().get(0));
        Assert.assertEquals((Object)b, result[0].getChildren().get(1));
        Assert.assertEquals((Object)c, result[0].getChildren().get(2));
        Assert.assertEquals((Object)d, result[0].getChildren().get(3));
    }

    @Test
    public void testProcessTree() throws IOException, ClassNotFoundException, InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        Pattern e = new Pattern(4, (ObjectType)type, "e");
        Pattern g = new Pattern(5, (ObjectType)type, "g");
        Pattern h = new Pattern(6, (ObjectType)type, "h");
        Pattern i = new Pattern(7, (ObjectType)type, "i");
        GroupElement and1 = GroupElementFactory.newAndInstance();
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)a);
        and1.addChild((RuleConditionElement)and2);
        and2.addChild((RuleConditionElement)b);
        GroupElement not1 = GroupElementFactory.newNotInstance();
        GroupElement not2 = GroupElementFactory.newNotInstance();
        not1.addChild((RuleConditionElement)not2);
        not2.addChild((RuleConditionElement)c);
        and2.addChild((RuleConditionElement)not1);
        and1.addChild((RuleConditionElement)d);
        GroupElement and3 = GroupElementFactory.newAndInstance();
        and3.addChild((RuleConditionElement)e);
        GroupElement or1 = GroupElementFactory.newOrInstance();
        and3.addChild((RuleConditionElement)or1);
        GroupElement exist1 = GroupElementFactory.newExistsInstance();
        exist1.addChild((RuleConditionElement)g);
        or1.addChild((RuleConditionElement)h);
        or1.addChild((RuleConditionElement)exist1);
        GroupElement not3 = GroupElementFactory.newNotInstance();
        not3.addChild((RuleConditionElement)i);
        GroupElement root = GroupElementFactory.newAndInstance();
        root.addChild((RuleConditionElement)and1);
        root.addChild((RuleConditionElement)and3);
        root.addChild((RuleConditionElement)not3);
        GroupElement[] result = LogicTransformer.getInstance().transform(root);
        File testFile = new File("target/test/LogicTransformerTest_correct_processTree1.dat");
        testFile.getParentFile().mkdirs();
        DroolsStreamUtils.streamOut((OutputStream)new FileOutputStream(testFile), (Object)result);
        GroupElement[] correctResultRoot = (GroupElement[])DroolsStreamUtils.streamIn((InputStream)new FileInputStream(testFile));
        for (int j = 0; j < correctResultRoot.length; ++j) {
            Assert.assertEquals((Object)correctResultRoot[j], (Object)result[j]);
        }
    }

    @Test
    public void testCloneable() {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        Pattern e = new Pattern(4, (ObjectType)type, "e");
        Pattern f = new Pattern(5, (ObjectType)type, "f");
        Pattern g = new Pattern(6, (ObjectType)type, "g");
        Pattern h = new Pattern(7, (ObjectType)type, "h");
        GroupElement and = GroupElementFactory.newAndInstance();
        and.addChild((RuleConditionElement)a);
        and.addChild((RuleConditionElement)b);
        GroupElement or = GroupElementFactory.newOrInstance();
        or.addChild((RuleConditionElement)c);
        or.addChild((RuleConditionElement)d);
        and.addChild((RuleConditionElement)or);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)e);
        and2.addChild((RuleConditionElement)f);
        or.addChild((RuleConditionElement)and2);
        GroupElement not = GroupElementFactory.newNotInstance();
        and.addChild((RuleConditionElement)not);
        GroupElement or2 = GroupElementFactory.newOrInstance();
        not.addChild((RuleConditionElement)or2);
        or2.addChild((RuleConditionElement)g);
        or2.addChild((RuleConditionElement)h);
        GroupElement cloned = and.clone();
        Assert.assertEquals((Object)and, (Object)cloned);
    }

    @Test
    public void testTransform() throws IOException, ClassNotFoundException, InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        Pattern e = new Pattern(4, (ObjectType)type, "e");
        Pattern f = new Pattern(5, (ObjectType)type, "f");
        Pattern g = new Pattern(6, (ObjectType)type, "g");
        Pattern h = new Pattern(7, (ObjectType)type, "h");
        GroupElement and = GroupElementFactory.newAndInstance();
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)a);
        GroupElement or1 = GroupElementFactory.newOrInstance();
        or1.addChild((RuleConditionElement)b);
        or1.addChild((RuleConditionElement)c);
        and1.addChild((RuleConditionElement)or1);
        and.addChild((RuleConditionElement)and1);
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)d);
        or2.addChild((RuleConditionElement)e);
        and.addChild((RuleConditionElement)or2);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        GroupElement not1 = GroupElementFactory.newNotInstance();
        not1.addChild((RuleConditionElement)f);
        GroupElement or3 = GroupElementFactory.newOrInstance();
        or3.addChild((RuleConditionElement)g);
        GroupElement not2 = GroupElementFactory.newNotInstance();
        not2.addChild((RuleConditionElement)h);
        or3.addChild((RuleConditionElement)not2);
        and2.addChild((RuleConditionElement)not1);
        and2.addChild((RuleConditionElement)or3);
        and.addChild((RuleConditionElement)and2);
        GroupElement[] ands = LogicTransformer.getInstance().transform(and);
        File testFile = new File("target/test/LogicTransformerTest_correct_transform1.dat");
        testFile.getParentFile().mkdirs();
        DroolsStreamUtils.streamOut((OutputStream)new FileOutputStream(testFile), (Object)ands);
        GroupElement[] correctResultAnds = (GroupElement[])DroolsStreamUtils.streamIn((InputStream)new FileInputStream(testFile));
        for (int j = 0; j < ands.length; ++j) {
            Assert.assertEquals((Object)correctResultAnds[j], (Object)ands[j]);
        }
    }
}

