/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.drools.core.ClockType;
import org.drools.core.SessionConfiguration;
import org.drools.core.StatefulSession;
import org.drools.core.WorkingMemory;
import org.drools.core.base.EnabledBoolean;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Rule;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.junit.Assert;
import org.junit.Test;

public class RuleTest {
    @Test
    public void testDateEffective() {
        StatefulSession wm = new ReteooRuleBase("x", null).newStatefulSession();
        Rule rule = new Rule("myrule");
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
        Calendar earlier = Calendar.getInstance();
        earlier.setTimeInMillis(10L);
        rule.setDateEffective(earlier);
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
        Calendar later = Calendar.getInstance();
        later.setTimeInMillis(later.getTimeInMillis() + 100000000L);
        Assert.assertTrue((boolean)later.after(Calendar.getInstance()));
        rule.setDateEffective(later);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
    }

    @Test
    public void testDateExpires() throws Exception {
        StatefulSession wm = new ReteooRuleBase("x", null).newStatefulSession();
        Rule rule = new Rule("myrule");
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
        Calendar earlier = Calendar.getInstance();
        earlier.setTimeInMillis(10L);
        rule.setDateExpires(earlier);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
        Calendar later = Calendar.getInstance();
        later.setTimeInMillis(later.getTimeInMillis() + 100000000L);
        rule.setDateExpires(later);
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
    }

    @Test
    public void testDateEffectiveExpires() {
        StatefulSession wm = new ReteooRuleBase("x", null).newStatefulSession();
        Rule rule = new Rule("myrule");
        Calendar past = Calendar.getInstance();
        past.setTimeInMillis(10L);
        Calendar future = Calendar.getInstance();
        future.setTimeInMillis(future.getTimeInMillis() + 100000000L);
        rule.setDateEffective(past);
        rule.setDateExpires(future);
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
        rule.setDateExpires(past);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
        rule.setDateExpires(future);
        rule.setDateEffective(future);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
    }

    @Test
    public void testRuleEnabled() {
        StatefulSession wm = new ReteooRuleBase("x", null).newStatefulSession();
        Rule rule = new Rule("myrule");
        rule.setEnabled(EnabledBoolean.ENABLED_FALSE);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
        Calendar past = Calendar.getInstance();
        past.setTimeInMillis(10L);
        rule.setDateEffective(past);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
        rule.setEnabled(EnabledBoolean.ENABLED_TRUE);
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
    }

    @Test
    public void testTimeMachine() {
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulSession wm = new ReteooRuleBase("x", null).newStatefulSession(conf, null);
        Calendar future = Calendar.getInstance();
        ((PseudoClockScheduler)wm.getSessionClock()).setStartupTime(future.getTimeInMillis());
        Rule rule = new Rule("myrule");
        rule.setEnabled(EnabledBoolean.ENABLED_TRUE);
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
        future.setTimeInMillis(future.getTimeInMillis() + 100000000L);
        rule.setDateEffective(future);
        Assert.assertFalse((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
        ((PseudoClockScheduler)wm.getSessionClock()).advanceTime(1000000000000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)rule.isEffective(null, new RuleTerminalNode(), (WorkingMemory)wm));
    }
}

