/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.ReteooWorkingMemoryInterface;
import org.drools.core.util.StringUtils;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.Context;

@XmlAccessorType(value=XmlAccessType.NONE)
public class InsertObjectCommand
implements GenericCommand<FactHandle>,
IdentifiableResult {
    private static final long serialVersionUID = 510L;
    @XmlElement
    @XmlJavaTypeAdapter(value=JaxbUnknownAdapter.class)
    private Object object;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;
    @XmlAttribute(name="return-object")
    private boolean returnObject = true;
    @XmlAttribute(name="entry-point")
    private String entryPoint = "DEFAULT";
    @XmlAttribute(name="disconnected")
    private boolean disconnected = false;

    public InsertObjectCommand() {
    }

    public InsertObjectCommand(Object object) {
        this.object = object;
    }

    public InsertObjectCommand(Object object, boolean disconnected) {
        this.object = object;
        this.disconnected = disconnected;
    }

    public InsertObjectCommand(Object object, String outIdentifier) {
        this.object = object;
        this.outIdentifier = outIdentifier;
    }

    @Override
    public FactHandle execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        FactHandle factHandle = StringUtils.isEmpty(this.entryPoint) ? ksession.insert(this.object) : ksession.getEntryPoint(this.entryPoint).insert(this.object);
        ReteooWorkingMemoryInterface session = ((StatefulKnowledgeSessionImpl)ksession).session;
        if (this.outIdentifier != null) {
            if (this.returnObject) {
                session.getExecutionResult().getResults().put(this.outIdentifier, this.object);
            }
            session.getExecutionResult().getFactHandles().put(this.outIdentifier, factHandle);
        }
        if (this.disconnected) {
            DefaultFactHandle disconnectedHandle = ((DefaultFactHandle)factHandle).clone();
            disconnectedHandle.disconnect();
            return disconnectedHandle;
        }
        return factHandle;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public boolean isReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(boolean returnObject) {
        this.returnObject = returnObject;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String entryPoint) {
        if (entryPoint == null) {
            entryPoint = "DEFAULT";
        }
        this.entryPoint = entryPoint;
    }

    public String toString() {
        return "session.entryPoints(" + (this.entryPoint == null ? "DEFAULT" : this.entryPoint) + ").insert(" + this.object + ");";
    }
}

